/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biosystemsa25;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.ExameRequisicaoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.ExameRequisicaoFilhoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.RequisicaoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.ThreadMostraProgressoImportacao;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceArquivoListener {
    private InterfaceConfiguracao configuracao;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private List<RequisicaoArquivo> requisicoesArquivos;
    private ThreadBuscaResultados threadBuscaResultados;
    private ThreadMostraProgressoImportacao threadMostraProgressoImportacao;
    private boolean curva = false;
    public static int registroAtual = 0;
    public static int totalRegistros = 0;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
        this.requisicoesArquivos = new ArrayList<RequisicaoArquivo>();
        if (this.configuracao.getBuscaAutomaticaResultados()) {
            this.threadBuscaResultados = new ThreadBuscaResultados(this.configuracao.getTempoBuscaResultados());
            this.threadBuscaResultados.start();
        }
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        this.buscarResultados(inicio, termino, false);
    }

    public void buscarResultados(Date inicio, Date termino, boolean thread) {
        File file = new File(this.DIRETORIO_IMPORTACAO);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".txt".toUpperCase());
            }
        };
        File[] files = file.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                int cont;
                if (Funcoes.objectIsNull(this.threadMostraProgressoImportacao) && !thread) {
                    this.threadMostraProgressoImportacao = new ThreadMostraProgressoImportacao();
                    this.threadMostraProgressoImportacao.start();
                }
                if (!Funcoes.objectIsNull(this.threadMostraProgressoImportacao) && !thread) {
                    this.threadMostraProgressoImportacao.inicializar();
                }
                long tam = f.length();
                for (cont = 1; cont < 3; ++cont) {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e) {
                        Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel iniciar a importa\u00e7\u00e3o de resultados.\nMensagem: " + e.getMessage(), 1);
                    }
                    File fTemp = new File(f.getAbsolutePath());
                    if (tam != fTemp.length()) {
                        fTemp = null;
                        continue;
                    }
                    fTemp = null;
                    break;
                }
                if (cont == 3) continue;
                try {
                    String texto = StringUtil.lerArquivoTexto(f);
                    this.parse(texto);
                    registroAtual = 0;
                    totalRegistros = 0;
                    String dir = this.DIRETORIO_IMPORTACAO;
                    dir = !dir.endsWith("/") ? dir + "/importados/" : dir + "importados/";
                    File pasta = new File(dir);
                    if (!pasta.exists()) {
                        pasta.mkdir();
                    }
                    File novoArquivo = new File(dir + Funcoes.formataData("yyyyMMdd_HHmmss", new Date()) + "_" + f.getName());
                    StringUtil.escreverArquivoTexto(dir + Funcoes.formataData("yyyyMMdd_HHmmss", new Date()) + "_copia_" + f.getName(), texto);
                    if (f.renameTo(novoArquivo)) continue;
                    f.delete();
                }
                catch (Exception e) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel importar os resultados, verifique o diret\u00f3rio de importa\u00e7\u00e3o de resultados.\nMensagem: " + e.getMessage(), 1);
                }
            }
        }
        if (!Funcoes.objectIsNull(this.threadMostraProgressoImportacao)) {
            this.threadMostraProgressoImportacao.finalizar();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, mapaParametros, "");
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros, String tuboFilho) {
        ArrayList<String> examesFilho = new ArrayList<String>();
        if (acao.equalsIgnoreCase("C")) {
            return null;
        }
        Statement st = Conexao.getStatement();
        try {
            ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = null;
            RequisicaoArquivo requisicaoArquivo = null;
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(mapaParametros.get("codigoApoiado"));
                requisicaoArquivo = new RequisicaoArquivo(fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, descritorCodigoEtiqueta);
            } else {
                requisicaoArquivo = new RequisicaoArquivo(fil_codigo, req_codigo, !Funcoes.textoVazio(tuboFilho) ? tuboFilho : rec_codigo, mco_codigo, int_codigo);
            }
            for (String exame : exames.split(" ", 0)) {
                examesMateriais.add(new ExameMaterial(exame, new Integer(mco_codigo)));
            }
            for (ExameMaterial exame : examesMateriais) {
                Object material;
                ExameRequisicaoArquivo exameaArquivo = new ExameRequisicaoArquivo(exame.getNomeExame());
                String[] exms = exame.getString().toString().split(" ");
                ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exms, mco_codigo);
                exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
                Object alternativos = null;
                if (!exa_listaCurva.isEmpty()) {
                    alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, null, false, examesFilho);
                }
                if (examesFilho != null && examesFilho.size() > 0) {
                    ExameMaterial[] sample_id = new StringBuilder();
                    this.curva = true;
                    int rec_Filho = 0;
                    if (!Funcoes.textoVazio(tuboFilho)) {
                        rec_Filho = Integer.valueOf(tuboFilho);
                    }
                    for (String key : alternativosCurva.keySet()) {
                        ExameMaterial exameMatCurva = alternativosCurva.get(key).get(0);
                        ExameMaterial[] exameFilho = BDUtil.getExamesLIS(fil_codigo, int_codigo, exameMatCurva.getString());
                        material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameFilho[0].getNomeExame(), mco_codigo, int_codigo);
                        ExameRequisicaoFilhoArquivo exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(exameMatCurva.getString(), (String)material, key);
                        exameaArquivo.addExameFilho(exameFilhoArquivo);
                    }
                } else if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.getString(), mco_codigo)) {
                    ExameMaterial[] exameMaterialFilhos;
                    for (ExameMaterial exameFilho : exameMaterialFilhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exame.getString(), mco_codigo)) {
                        ExameRequisicaoFilhoArquivo exameFilhoArquivo = null;
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                            for (String req : requisicoes) {
                                if (!BDUtil.existeExame(fil_codigo, int_codigo, req, exame.getString(), exame.getCodigoMaterial(), rec_codigo)) continue;
                                String codigoAlternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), int_codigo);
                                if (Funcoes.textoVazio(codigoAlternativo)) {
                                    this.fireExcecaoEncontrada(fil_codigo + req + rec_codigo + " - Nenhum exame enviado pois os exames n\u00e3o se encontram configurados.");
                                    return null;
                                }
                                String material2 = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), int_codigo);
                                String rec_kodigo = BDUtil.getExameDesmembradoTubo(fil_codigo, req, rec_codigo, int_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(codigoAlternativo, material2, rec_kodigo);
                            }
                        } else {
                            String codigoAlternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), int_codigo);
                            if (Funcoes.textoVazio(codigoAlternativo)) {
                                this.fireExcecaoEncontrada(exameFilho.getNomeExame() + " - Nenhum exame enviado pois os exames n\u00e3o se encontram configurados.");
                                return null;
                            }
                            material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), int_codigo);
                            String rec_kodigo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(codigoAlternativo, (String)material, rec_kodigo);
                        }
                        if (exameFilhoArquivo == null || exameFilhoArquivo.getTubo() == null) {
                            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o com algum exame configurado incorretamente verifique %s %s %s [%s] ", fil_codigo, req_codigo, rec_codigo, exameFilho.getNomeExame()));
                            continue;
                        }
                        exameaArquivo.addExameFilho(exameFilhoArquivo);
                    }
                } else {
                    String codigoAlternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exame.getNomeExame(), mco_codigo, int_codigo);
                    if (Funcoes.textoVazio(codigoAlternativo)) {
                        this.fireExcecaoEncontrada(exame.getNomeExame() + " - Nenhum exame enviado pois os exames n\u00e3o se encontram configurados.");
                        return null;
                    }
                    String material3 = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame.getNomeExame(), mco_codigo, int_codigo);
                    ExameRequisicaoFilhoArquivo exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(codigoAlternativo, material3, Funcoes.textoVazio(tuboFilho) ? rec_codigo : tuboFilho);
                    exameaArquivo.addExameFilho(exameFilhoArquivo);
                }
                requisicaoArquivo.addExame(exameaArquivo);
            }
            this.requisicoesArquivos.add(requisicaoArquivo);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    public List<RequisicaoArquivo> getRequisicoesArquivos() {
        return this.requisicoesArquivos;
    }

    public String enviarArquivo() {
        try {
            if (this.requisicoesArquivos.isEmpty()) {
                return "";
            }
            Statement st = Conexao.getStatement();
            String arquivo = "import.txt";
            arquivo = this.DIRETORIO_EXPORTACAO + "/" + arquivo;
            PortaFILE p = (PortaFILE)this.getPortaCOM();
            p.createFile(arquivo, true);
            for (RequisicaoArquivo requisicaoArquivo : this.requisicoesArquivos) {
                String fil_codigo = requisicaoArquivo.getFilCodigo();
                String req_codigo = requisicaoArquivo.getReqCodigo();
                String mco_codigo = requisicaoArquivo.getMcoCodigo();
                String rec_codigo = requisicaoArquivo.getRecCodigo();
                String int_codigo = requisicaoArquivo.getIntCodigo();
                p.write(!Funcoes.textoVazio(requisicaoArquivo.getTexto()) ? requisicaoArquivo.getTexto() + p.LINE : requisicaoArquivo.getTexto());
                for (ExameRequisicaoArquivo exame : requisicaoArquivo.getExames()) {
                    String exaCodigo = exame.getExaCodigo();
                    if (!exame.getExamesFilhos().isEmpty()) {
                        for (ExameRequisicaoFilhoArquivo exameReqFilho : exame.getExamesFilhos()) {
                            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                            for (String req : requisicoes) {
                                this.atualizarSituacaoExame(st, fil_codigo, req, exameReqFilho.getTubo(), exaCodigo, mco_codigo, int_codigo, null, 1);
                            }
                        }
                        continue;
                    }
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exaCodigo, mco_codigo, int_codigo, null, 1);
                }
            }
            p.closeFile();
            this.requisicoesArquivos.clear();
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso", 0, 10000);
            this.fireAtualizarTabela();
            return "Arquivo criado com sucesso";
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
            return "Erro ao criar arquivo";
        }
    }

    @Override
    public String parse(String message) {
        String[] linhas = message.split("\n");
        totalRegistros = linhas.length;
        for (String s : linhas) {
            ++registroAtual;
            String[] linha = s.split("\t");
            String req_codigo = linha[0];
            String emi_alternativo = "";
            if (linha.length > 1) {
                emi_alternativo = linha[1];
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            }
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                continue;
            }
            try {
                String rec_codigo;
                Statement st = Conexao.getStatement();
                DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
                if (descritorCodigoEtiqueta == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para etiqueta: " + req_codigo);
                    continue;
                }
                String fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()), emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                String resultado = linha[3];
                resultado = resultado.replaceAll(",", "\\.");
                resultado = this.arrendondaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
                resultado = resultado.replaceAll("\\.", ",");
                this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultado);
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Funcoes.objectIsNull(this.threadMostraProgressoImportacao)) {
                    this.threadMostraProgressoImportacao.finalizar();
                }
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                if (!Funcoes.objectIsNull(this.threadMostraProgressoImportacao)) {
                    this.threadMostraProgressoImportacao.finalizar();
                }
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
        }
        if (!Funcoes.objectIsNull(this.threadMostraProgressoImportacao)) {
            this.threadMostraProgressoImportacao.resetaRegistroExibido();
        }
        return "Resultados recebidos com sucesso";
    }

    class ThreadBuscaResultados
    extends Thread {
        private int tempo;

        public ThreadBuscaResultados(int tempo) {
            this.tempo = tempo;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.tempo * 60000);
                        System.out.println("Buscando...");
                        InterfaceListener.this.buscarResultados(null, null, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

