/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biosystemsa25;

import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.DadosEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ExameLote
extends JDialog
implements ActionListener {
    private static String PARAMETRO_MOSTRAR_INDIVIDUAL = "a25.exameLote.MostrarIndividual";
    private ArrayList exames;
    private int indexRequisicao;
    private int indexTubo;
    private int indexNomePaciente;
    private int indexExame;
    private int indexContador;
    private AbstractInterfaceamento equipamento;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private TTextField textRequisicao = ComponenteFactory.novoTTextField(12, 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textContador = ComponenteFactory.novoTTextField(5, 1);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new GridBagLayout());
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private JCheckBox checkBoxAdicionarAuto = ComponenteFactory.novoJCheckBox("Adicionar Auto.", this);
    private JCheckBox checkMostrarIndividual = ComponenteFactory.novoJCheckBox("Mostrar Exames Individualmente", this);
    private ArrayList<Object[]> dadosAdicionados = new ArrayList();
    private int indexInterface;
    private boolean localizaExameCurva;
    private List<String> tuboAdicionadosNaGrid = new ArrayList<String>();
    private int indexMaterial;

    public ExameLote(JFrame parent, ArrayList exames, int indexRequisicao, int indexTubo, int indexNomePaciente, int indexExame, int indexContador, AbstractInterfaceamento equipamento, int indexMaterial, int indexInterface, boolean localizaExameCurva) {
        super(parent);
        this.equipamento = equipamento;
        this.checkBoxAdicionarAuto.setSelected(true);
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexTubo = indexTubo;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexContador = indexContador;
        this.indexMaterial = indexMaterial;
        this.indexInterface = indexInterface;
        this.localizaExameCurva = localizaExameCurva;
        this.montaTela();
    }

    public ExameLote(JFrame parent, ArrayList exames, int indexRequisicao, int indexTubo, int indexNomePaciente, int indexExame, int indexContador, AbstractInterfaceamento equipamento) {
        super(parent);
        this.equipamento = equipamento;
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexTubo = indexTubo;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexContador = indexContador;
        this.montaTela();
    }

    private void montaTela() {
        this.setPreferredSize(new Dimension(500, 350));
        this.setTitle("Lote");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.checkBoxAdicionarAuto.setSelected(true);
        String sMostrar = ParametrosUsuarios.getValor(PARAMETRO_MOSTRAR_INDIVIDUAL);
        if (!Funcoes.textoVazio(sMostrar) && sMostrar.equalsIgnoreCase("true")) {
            this.checkMostrarIndividual.setSelected(true);
        }
        this.tableModel.setColumnSize(new int[]{90, 0, 80}, this.tableRequisicao);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        if (this.equipamento.isContadorEnvio()) {
            ++c.gridx;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            this.panelRoot.add((Component)new JLabel("Contador"), c);
        }
        this.textRequisicao.setPreferredSize(new Dimension(100, 20));
        this.textRequisicao.setMinimumSize(new Dimension(100, 20));
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        this.panelRoot.add((Component)this.textRequisicao, c);
        this.textNomePaciente.setPreferredSize(new Dimension(90, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(90, 20));
        this.textNomePaciente.setEnabled(false);
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        if (this.equipamento.isContadorEnvio()) {
            this.textContador.setPreferredSize(new Dimension(65, 20));
            this.textContador.setMinimumSize(new Dimension(65, 20));
            ++c.gridx;
            c.gridy = 1;
            c.fill = 0;
            c.weightx = 0.0;
            this.panelRoot.add((Component)this.textContador, c);
        }
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.panelRoot.add((Component)this.scrollTable, c);
        GridBagConstraints cb = new GridBagConstraints();
        cb.gridx = 0;
        cb.gridy = 0;
        cb.anchor = 17;
        cb.weightx = 1.0;
        this.panelButton.add((Component)this.checkBoxAdicionarAuto, cb);
        ++cb.gridx;
        this.panelButton.add((Component)this.checkMostrarIndividual, cb);
        cb.weightx = 0.0;
        ++cb.gridx;
        this.panelButton.add((Component)this.buttonEnviar, cb);
        ++cb.gridx;
        this.panelButton.add((Component)this.buttonCancelar, cb);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.textRequisicao.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean requisicaoOk = ExameLote.this.validaRequisicao(false);
                if (requisicaoOk && ExameLote.this.checkBoxAdicionarAuto.isSelected()) {
                    ExameLote.this.addRequisicao();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.tableRequisicao.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (ExameLote.this.tableRequisicao.getSelectedRowCount() > 0) {
                    if (e.getKeyCode() == 127) {
                        ExameLote.this.removerRequisicao(ExameLote.this.tableRequisicao.getSelectedRow());
                        ExameLote.this.populateTable();
                    } else if (e.getKeyCode() == 32 && !ExameLote.this.mostrarExamesIndividualmente()) {
                        ExameLote.this.editaRequisicao();
                    }
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.dadosAdicionados.clear();
            this.fechar();
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar) {
            if (this.validarLote()) {
                this.fechar();
            }
        } else if (e.getSource() == this.checkMostrarIndividual) {
            this.populateTable();
        }
    }

    private void fechar() {
        ParametrosUsuarios.setValor(PARAMETRO_MOSTRAR_INDIVIDUAL, this.mostrarExamesIndividualmente() ? "true" : "false");
        this.setVisible(false);
    }

    private void addRequisicao() {
        this.validaRequisicao(true);
        if (this.dadosAdicionados.size() == 0) {
            Funcoes.mensagem(this, "Exame n\u00e3o localizado ou j\u00e1 enviado.", 5);
        }
        this.populateTable();
        this.textRequisicao.setText("");
        this.textNomePaciente.setText("");
        ScreenUtil.requisitarFoco(this.textRequisicao);
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private boolean validaRequisicao(boolean adicionaLista) {
        if (this.codigoDoTuboEstaVazio()) {
            return false;
        }
        boolean achou = false;
        DadosEtiqueta etiquetaGeral = this.criarDadosEtiqueta();
        if (this.contadorFoiAdicionado()) {
            Funcoes.mensagem(this, "Contador j\u00e1 adicionado!", 5);
            return false;
        }
        String novaFilialRequisicao = etiquetaGeral.getFilialRequisicao();
        for (int indiceLinha = 0; indiceLinha < this.exames.size(); ++indiceLinha) {
            Object[] linha = this.getLinhas(indiceLinha);
            String recipiente = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            String exames = linha[this.indexExame].toString();
            boolean ehCurva = false;
            ArrayList<BDExame> examesFilho = new ArrayList<BDExame>();
            if (!novaFilialRequisicao.equalsIgnoreCase(this.getFilialRequisicao(linha)) && !novaFilialRequisicao.equalsIgnoreCase(this.getRequisicao(linha))) continue;
            for (String exame : exames.split(" ")) {
                if (this.localizaExameCurva && this.indexInterface > -1 && this.indexMaterial > -1) {
                    try {
                        examesFilho.addAll(this.getExamesFilho(etiquetaGeral.getRecipiente(), linha, recipiente, exame));
                        if (!examesFilho.isEmpty()) {
                            ehCurva = BDUtil.isExameCurva(this.getFilial(linha), this.getInterfaceamento(linha), exame, linha[this.indexMaterial].toString());
                            exames = exames.replaceAll(exame, "");
                            exames = exames.replaceAll("  ", " ");
                            exames = exames.trim();
                        }
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                    }
                }
                boolean jaAdicionada = false;
                for (int indiceLinhaAdicionada = 0; indiceLinhaAdicionada < this.dadosAdicionados.size(); ++indiceLinhaAdicionada) {
                    DadosEtiqueta etiquetaAdicionado = this.criarDadosEtiquetaAdicionado(indiceLinhaAdicionada);
                    if (!this.localizaExameCurva || !ehCurva) continue;
                    if (this.tuboAdicionadosNaGrid.contains(etiquetaAdicionado.getTubo())) {
                        jaAdicionada = false;
                        achou = true;
                        continue;
                    }
                    if (!this.dadosAdicionadosSaoEquivalentes(linha, recipiente, exame, etiquetaAdicionado)) continue;
                    jaAdicionada = true;
                    achou = true;
                }
                if (!jaAdicionada) {
                    this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                    if (adicionaLista) {
                        if (this.localizaExameCurva && ehCurva) {
                            String etiqueta = novaFilialRequisicao + etiquetaGeral.getRecipiente();
                            Object[] linhaNew = (Object[])linha.clone();
                            int contador = 0;
                            for (int indiceFilho = 0; indiceFilho < examesFilho.size(); ++indiceFilho) {
                                String codExame = new String(((BDExame)examesFilho.get(indiceFilho)).getExame());
                                linhaNew[this.indexExame] = codExame.toString();
                                String tuboAux = ((BDExame)examesFilho.get(indiceFilho)).getRecipienteFilho() != null ? ((BDExame)examesFilho.get(indiceFilho)).getRecipienteFilho() : etiquetaGeral.getRecipiente();
                                linhaNew[this.indexTubo] = tuboAux;
                                linhaNew[this.indexMaterial] = ((BDExame)examesFilho.get(indiceFilho)).getMaterial();
                                linhaNew[linhaNew.length - 1] = ehCurva;
                                Object[] linhaNew2 = new Object[linhaNew.length + 1];
                                System.arraycopy(linhaNew, 0, linhaNew2, 0, linhaNew.length);
                                linhaNew2[linhaNew2.length - 1] = novaFilialRequisicao + tuboAux;
                                try {
                                    Integer[] requisicoes = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, this.getRequisicao(linha), true);
                                    String recipienteFilho = ((BDExame)examesFilho.get(indiceFilho)).getRecipienteFilho() != null ? ((BDExame)examesFilho.get(indiceFilho)).getRecipienteFilho() : linhaNew[this.indexTubo].toString();
                                    Integer situacaoExame = BDUtil.getExmSituacaoFilho(etiquetaGeral.getFilial(), this.getInterfaceamento(linha), requisicoes, ((BDExame)examesFilho.get(indiceFilho)).getExame(), ((BDExame)examesFilho.get(indiceFilho)).getMaterial(), recipienteFilho);
                                    if (this.mostrarExamesIndividualmente() && this.existeExameParaAgrupar(linhaNew2, codExame.toString())) {
                                        if (this.foiAdicionado(linhaNew2)) continue;
                                        this.atualizarLinha(linhaNew2, codExame.toString());
                                        continue;
                                    }
                                    this.podeAdicionarGrid(novaFilialRequisicao, contador, tuboAux, linhaNew2, situacaoExame, recipienteFilho);
                                    continue;
                                }
                                catch (SQLException e) {
                                    ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                                }
                            }
                        } else {
                            Object[] novaLinha = ArraysUtil.concatenar((Object[])linha.clone(), new Object[]{this.getTextoDigitado()});
                            novaLinha[novaLinha.length - 1] = ehCurva;
                            novaLinha[this.indexExame] = exame;
                            if (!this.mostrarExamesIndividualmente() && this.existeExameParaAgrupar(novaLinha, exame)) {
                                this.atualizarLinha(novaLinha, exame);
                            } else if (this.tamanhoDoTuboEhValido()) {
                                if (etiquetaGeral.getRecipiente().equalsIgnoreCase(recipiente) && !this.foiAdicionado(novaLinha, exame)) {
                                    this.adicionarNaGrid(novaFilialRequisicao, novaLinha, exame);
                                }
                            } else if (!this.foiAdicionado(novaLinha, exame)) {
                                this.adicionarNaGrid(novaFilialRequisicao, novaLinha, exame);
                            }
                        }
                    }
                    achou = true;
                }
                examesFilho.clear();
                ehCurva = false;
            }
        }
        if (!achou) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada!", 5);
            this.textRequisicao.setText("");
            this.textNomePaciente.setText("");
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        return achou;
    }

    private void podeAdicionarGrid(String novaFilialRequisicao, int contador, String tuboAux, Object[] linhaNew2, Integer situacaoExame, String recipienteFilho) {
        if (situacaoExame == 0 && tuboAux.equalsIgnoreCase(recipienteFilho) && !this.foiAdicionado(linhaNew2)) {
            this.adicionarNaGrid(novaFilialRequisicao, contador, tuboAux, linhaNew2);
        }
    }

    private boolean exameEstaAgrupado(String exame) {
        for (Object[] dadosLinha : this.dadosAdicionados) {
            if (!this.getExame(dadosLinha).contains(exame)) continue;
            return true;
        }
        return false;
    }

    private void atualizarLinha(Object[] linhaNew2, String exame) {
        for (Object[] dadosLinha : this.dadosAdicionados) {
            if (!this.getRecipiente(dadosLinha).equalsIgnoreCase(this.getRecipiente(linhaNew2)) || !this.getFilialRequisicao(dadosLinha).equalsIgnoreCase(this.getFilialRequisicao(linhaNew2)) || !this.getPaciente(dadosLinha).equalsIgnoreCase(this.getPaciente(linhaNew2))) continue;
            dadosLinha[this.indexExame] = new String(dadosLinha[this.indexExame].toString() + " " + exame);
        }
    }

    private boolean mostrarExamesIndividualmente() {
        return this.checkMostrarIndividual.isSelected();
    }

    private boolean existeExameParaAgrupar(Object[] linha, String exame) {
        for (Object[] dadosLinha : this.dadosAdicionados) {
            if (!this.getRecipiente(dadosLinha).equalsIgnoreCase(this.getRecipiente(linha)) || !this.getFilialRequisicao(dadosLinha).equalsIgnoreCase(this.getFilialRequisicao(linha)) || !this.getPaciente(dadosLinha).equalsIgnoreCase(this.getPaciente(linha))) continue;
            return true;
        }
        return false;
    }

    private void adicionarNaGrid(String novaFilialRequisicao, int contador, String tuboAux, Object[] linhaNew2) {
        if (!this.foiAdicionado(linhaNew2)) {
            this.dadosAdicionados.add(contador, linhaNew2);
            this.tuboAdicionadosNaGrid.add(novaFilialRequisicao + this.preencherZeroRecipiente(tuboAux));
            ++contador;
        }
    }

    private void adicionarNaGrid(String novaFilialRequisicao, Object[] linha, String exame) {
        String codigoRequisicao = Integer.valueOf(this.getRequisicao(linha)).toString();
        String requisicaoDigitado = this.getTextoDigitado();
        if (requisicaoDigitado.length() >= ParametrosGerais.getDigitosTuboRequisicao()) {
            requisicaoDigitado = Integer.valueOf(this.getTextoDigitado().substring(ParametrosGerais.getDigitosTuboFilial())).toString();
        }
        Object[] novaLinha = ArraysUtil.concatenar((Object[])linha.clone(), new Object[]{this.getTextoDigitado()});
        Object tuboDaLinha = novaLinha[novaLinha.length - 1];
        if (!this.foiAdicionado(novaLinha) && tuboDaLinha != null && !this.foiAdicionado(novaLinha)) {
            this.dadosAdicionados.add(novaLinha);
            this.tuboAdicionadosNaGrid.add(novaFilialRequisicao + this.preencherZeroRecipiente(this.getTextoDigitado()));
        }
    }

    private boolean foiAdicionado(Object[] outra) {
        for (Object[] linha : this.dadosAdicionados) {
            if (!this.getExame(linha).contains(this.getExame(outra)) || !this.getFilial(linha).equalsIgnoreCase(this.getFilial(outra)) || !this.getRequisicao(linha).equalsIgnoreCase(this.getRequisicao(outra)) || !this.getRecipiente(linha).equalsIgnoreCase(this.getRecipiente(outra)) || !this.getMaterial(linha).equalsIgnoreCase(this.getMaterial(outra)) || !this.getPaciente(linha).equalsIgnoreCase(this.getPaciente(outra))) continue;
            return true;
        }
        return false;
    }

    private boolean foiAdicionado(Object[] outra, String exame) {
        for (Object[] linha : this.dadosAdicionados) {
            if (!this.getExame(linha).contains(exame) || !this.getFilial(linha).equalsIgnoreCase(this.getFilial(outra)) || !this.getRequisicao(linha).equalsIgnoreCase(this.getRequisicao(outra)) || !this.getRecipiente(linha).equalsIgnoreCase(this.getRecipiente(outra)) || !this.getMaterial(linha).equalsIgnoreCase(this.getMaterial(outra)) || !this.getPaciente(linha).equalsIgnoreCase(this.getPaciente(outra))) continue;
            return true;
        }
        return false;
    }

    private String preencherZeroRecipiente(String tuboAux) {
        return Funcoes.preencheZero(tuboAux, ParametrosGerais.getDigitosTuboTubo());
    }

    private String preencherZeroRequisicao(String tuboAux) {
        return Funcoes.preencheZero(tuboAux, ParametrosGerais.getDigitosTuboRequisicao());
    }

    private boolean dadosAdicionadosSaoEquivalentes(Object[] linhaGeral, String recipienteGeral, String exameGeral, DadosEtiqueta etiquetaAdicionado) {
        return this.getFilialRequisicao(linhaGeral).equals(etiquetaAdicionado.getFilialRequisicao()) && recipienteGeral.equals(etiquetaAdicionado.getRecipiente()) && etiquetaAdicionado.getExame().equalsIgnoreCase(exameGeral);
    }

    private DadosEtiqueta criarDadosEtiquetaAdicionado(int indiceLinhaAdicionada) {
        Object[] exameRequisicaoAdicionada = this.dadosAdicionados.get(indiceLinhaAdicionada);
        String filialRequisicaoAdicionada = "";
        if (exameRequisicaoAdicionada[this.indexRequisicao] != null) {
            filialRequisicaoAdicionada = this.getFilialRequisicao(exameRequisicaoAdicionada);
        }
        String recipienteAdicionado = "";
        String exameAdicionado = "";
        if (exameRequisicaoAdicionada[this.indexTubo] != null) {
            recipienteAdicionado = Funcoes.preencheZero(exameRequisicaoAdicionada[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            exameAdicionado = exameRequisicaoAdicionada[this.indexExame].toString();
        }
        DadosEtiqueta etiquetaAdicionado = new DadosEtiqueta(filialRequisicaoAdicionada, exameAdicionado, recipienteAdicionado);
        return etiquetaAdicionado;
    }

    private boolean contadorFoiAdicionado() {
        if (this.equipamento.isContadorEnvio() && this.dadosAdicionados.size() > 0) {
            for (int i = 0; i < this.dadosAdicionados.size(); ++i) {
                Object[] req = this.dadosAdicionados.get(i);
                String cont = req[this.indexContador].toString();
                if (!this.textContador.getText().equalsIgnoreCase(cont)) continue;
                return true;
            }
        }
        return false;
    }

    private DadosEtiqueta criarDadosEtiqueta() {
        DadosEtiqueta etiqueta = new DadosEtiqueta(Variaveis.filialPadrao, this.getTextoDigitado());
        if (this.tamanhoDoTuboEhValido()) {
            String filialRequisicao = this.getTextoDigitado().substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String recipiente = this.getTextoDigitado().substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao(), this.getTextoDigitado().length());
            etiqueta = new DadosEtiqueta(filialRequisicao, "", recipiente);
        } else if (this.tamanhoDoTuboEhFilialRequisicao()) {
            etiqueta = new DadosEtiqueta(this.getFilialDoTubo(), this.getRequisicaoDoTubo());
        } else if (this.tamanhoDoTuboEhRequisicao()) {
            etiqueta = new DadosEtiqueta(this.preecherZeroFilial(Variaveis.filialPadrao), this.preencherZeroRequisicao(this.getTextoDigitado()));
        } else {
            String filial = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            String requisicao = etiqueta.getLenghtRequisicao() > ParametrosGerais.getDigitosTuboRequisicao() ? etiqueta.getRequisicao().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) : Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            etiqueta = new DadosEtiqueta(filial, requisicao);
        }
        return etiqueta;
    }

    private String preecherZeroFilial(String tuboAux) {
        return Funcoes.preencheZero(tuboAux, ParametrosGerais.getDigitosTuboFilial());
    }

    private boolean tamanhoDoTuboEhRequisicao() {
        return this.getLenghtDoTubo() <= this.getLenghtDaRequisicaoNaConfiguracao();
    }

    private boolean tamanhoDoTuboEhFilialRequisicao() {
        return this.getLenghtDoTubo() == this.getLenghtDaFilialRequisicaoNaConfiguracao();
    }

    private List<BDExame> getExamesFilho(String tubo, Object[] linha, String rec, String exame) throws SQLException {
        ArrayList<BDExame> examesFilho = new ArrayList<BDExame>();
        if (this.tamanhoDoTuboEhValido()) {
            examesFilho.addAll(this.getExamesFilho(this.getFilial(linha), this.getInterfaceamento(linha), this.getRequisicao(linha), exame, linha[this.indexMaterial].toString(), rec));
        } else {
            examesFilho.addAll(this.getExamesFilho(this.getFilial(linha), this.getInterfaceamento(linha), this.getRequisicao(linha), exame, linha[this.indexMaterial].toString(), rec));
        }
        examesFilho.addAll(this.validaCurvaRequisicaoFilha(linha, rec, exame, examesFilho));
        return examesFilho;
    }

    private List<BDExame> validaCurvaRequisicaoFilha(Object[] linha, String rec, String exame, List<BDExame> examesFilho) throws SQLException {
        Integer[] requisicoes;
        ArrayList<BDExame> examesFilhoDesm = new ArrayList<BDExame>();
        if (examesFilho.isEmpty() && (requisicoes = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, this.getRequisicao(linha), false)) != null) {
            for (Integer req : requisicoes) {
                List<BDExame> exames = this.getExamesFilho(this.getFilial(linha), this.getInterfaceamento(linha), req.toString(), exame, linha[this.indexMaterial].toString(), rec);
                if (exames.isEmpty()) continue;
                examesFilhoDesm.addAll(exames);
                return examesFilhoDesm;
            }
        }
        return examesFilhoDesm;
    }

    private String getInterfaceamento(Object[] linha) {
        return linha[this.indexInterface].toString();
    }

    private String getRequisicao(Object[] linha) {
        return this.getFilialRequisicao(linha).substring(ParametrosGerais.getDigitosTuboFilial());
    }

    private String getFilial(Object[] linha) {
        return this.getFilialRequisicao(linha).substring(0, ParametrosGerais.getDigitosTuboFilial());
    }

    private String getFilialRequisicao(Object[] linha) {
        return linha[this.indexRequisicao].toString();
    }

    private String getFilialDoTubo() {
        return this.getTextoDigitado().substring(0, ParametrosGerais.getDigitosTuboFilial());
    }

    private String getRequisicaoDoTubo() {
        return this.getTextoDigitado().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
    }

    private String getExame(Object[] linha) {
        return linha[this.indexExame].toString();
    }

    private String getRecipiente(Object[] linha) {
        return this.preencherZeroRecipiente(linha[this.indexTubo].toString());
    }

    private String getMaterial(Object[] linha) {
        return linha[this.indexMaterial].toString();
    }

    private String getPaciente(Object[] linha) {
        return linha[this.indexNomePaciente].toString();
    }

    private Object[] getLinhas(int i) {
        return (Object[])this.exames.get(i);
    }

    private boolean codigoDoTuboEstaVazio() {
        return Funcoes.textoVazio(this.getTextoDigitado());
    }

    private boolean tamanhoDoTuboEhValido() {
        return this.getLenghtDoTubo() == this.getLenghtDoTuboNaConfiguracao();
    }

    private int getLenghtDoTuboNaConfiguracao() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    private int getLenghtDaFilialRequisicaoNaConfiguracao() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
    }

    private int getLenghtDaRequisicaoNaConfiguracao() {
        return ParametrosGerais.getDigitosTuboRequisicao();
    }

    private int getLenghtDoTubo() {
        return this.getTextoDigitado().length();
    }

    private String getRecipienteDoTubo() {
        Integer tamanhoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        if (tamanhoTubo <= this.textRequisicao.getText().length()) {
            return this.textRequisicao.getText().substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        }
        return this.textRequisicao.getText();
    }

    private String getTextoDigitado() {
        return this.textRequisicao.getText();
    }

    private List<BDExame> getExamesFilho(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        return BDUtil.getDesmExamesFilhosX(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo);
    }

    private void populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        for (int i = 0; i < this.dadosAdicionados.size(); ++i) {
            Object[] o = this.dadosAdicionados.get(i);
            if (!this.mostrarExamesIndividualmente()) {
                Object[] line = new String[]{this.getFilialRequisicao(o), o[this.indexNomePaciente].toString(), this.getExame(o)};
                this.tableModel.addLine(line);
            } else {
                String[] exames;
                for (String e : exames = this.getExame(o).split(" ")) {
                    Object[] line = new String[]{this.getFilialRequisicao(o), o[this.indexNomePaciente].toString(), e};
                    this.tableModel.addLine(line);
                }
            }
            this.tableRequisicao.scrollRectToVisible(this.tableRequisicao.getCellRect(this.tableModel.getRowCount() - 1, 0, false));
            this.tableRequisicao.setRowSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
        }
        this.tableRequisicao.setModel(this.tableModel);
    }

    public ArrayList getRequisicoes() {
        return this.dadosAdicionados;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equipamento.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equipamento.examesPendentes).getExames();
        for (int i = 0; i < this.dadosAdicionados.size(); ++i) {
            int contador;
            int tubo;
            Object[] req = this.dadosAdicionados.get(i);
            int requisicao = Integer.parseInt(this.getFilialRequisicao(req));
            int row = this.validaExisteExame(requisicao, tubo = Integer.parseInt(req[this.indexTubo].toString()));
            if (row < 0 || req[this.indexContador] == null || !this.validaExisteExamePendente(contador = Integer.parseInt(req[this.indexContador].toString()), pendentes)) continue;
            Funcoes.mensagem(this, "O contador " + contador + " j\u00e1 esta cadastrado\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao, int tubo) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = this.getLinhas(i);
            int requisicaoExame = Integer.parseInt(this.getFilialRequisicao(exame));
            int tuboExame = Integer.parseInt(exame[this.indexTubo].toString());
            if (requisicao != requisicaoExame || tubo != tuboExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(int contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            Object[] pendente = (Object[])pendentes.get(i);
            int contadorExame = Integer.parseInt(pendente[this.indexContador].toString());
            if (contador != contadorExame) continue;
            return true;
        }
        return false;
    }

    private void editaRequisicao() {
        if (this.equipamento.isContadorEnvio() && !this.mostrarExamesIndividualmente()) {
            int row = this.tableRequisicao.getSelectedRow();
            Object[] req = this.dadosAdicionados.get(row);
            this.textRequisicao.setText(this.getFilialRequisicao(req));
            this.textNomePaciente.setText(req[this.indexNomePaciente].toString());
            this.textContador.setText(req[this.indexContador].toString());
            this.textContador.grabFocus();
        }
    }

    private void removerRequisicao(int row) {
        if (!this.mostrarExamesIndividualmente()) {
            this.dadosAdicionados.remove(row);
        } else {
            String requisicao = this.tableRequisicao.getValueAt(row, 0).toString();
            for (int i = 0; i < this.dadosAdicionados.size(); ++i) {
                Object[] req = this.dadosAdicionados.get(i);
                String reqCodigo = this.getFilialRequisicao(req);
                if (!requisicao.equals(reqCodigo)) continue;
                String[] exames = this.getExame(req).split(" ");
                if (exames.length == 1) {
                    this.dadosAdicionados.remove(i);
                    continue;
                }
                String exameRemover = this.tableRequisicao.getValueAt(row, 2).toString();
                StringBuilder exas = new StringBuilder();
                for (String e : exames) {
                    if (e.equals(exameRemover)) continue;
                    exas.append(e).append(" ");
                }
                if (exas.toString().trim().length() == 0) {
                    this.dadosAdicionados.remove(i);
                    continue;
                }
                req[this.indexExame] = exas.toString().trim();
            }
        }
    }
}

