/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biosystemsa25;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        String reqSelecionada = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Multiguia"));
        ArrayList requisicaoExames = (ArrayList)this.getRequisicaoExames(row, this.exames).clone();
        if (requisicaoExames.size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
            this.selecionaLinhaExame(reqSelecionada, requisicaoExames, tela);
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                    this.selecionaLinhaExame(reqSelecionada, requisicaoExames, tela);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String exames = " ";
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames = exames + exame[1] + " ";
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames = exames + exaPronto + " ";
                linhas.add(j);
            }
        }
        if (exames.trim().length() > 0) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String[] exas = exames.trim().split(" ");
                Statement st = Conexao.getStatement();
                for (String e : exas) {
                    ExameMaterial[] exaPai;
                    BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, e, mco_codigo, rec_codigo, 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e, mco_codigo, rec_codigo, 3);
                    if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, e, mco_codigo)) continue;
                    for (ExameMaterial ePai : exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, e, mco_codigo)) {
                        BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, ePai.getNomeExame(), mco_codigo, rec_codigo, 3);
                    }
                }
                st.close();
                Conexao.arquivaSQL();
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void selecionaLinhaExame(String reqSelecionada, ArrayList<Object[]> requisicaoExames, SelecionaExame tela) {
        if (!requisicaoExames.isEmpty()) {
            String exameSelecionado = (String)requisicaoExames.get(this.obterLinhaRepeticao(tela))[this.getColIndice("Exame")];
            for (int i = 0; i < this.tabelaExames.getRowCount(); ++i) {
                Object[] linha = this.tabelaExames.getRow(i);
                String exameTabela = (String)linha[this.getColIndice("Exame")];
                String reqExameTabela = (String)linha[this.getColIndice("Multiguia")];
                if (!exameSelecionado.equalsIgnoreCase(exameTabela) || !reqSelecionada.equalsIgnoreCase(reqExameTabela)) continue;
                this.tabelaExames.setRowSelectionInterval(i, i);
                this.tabelaExames.scrollRectToVisible(this.tabelaExames.getCellRect(i, 0, true));
                break;
            }
        }
    }

    @Override
    public void estornarRepeticao() {
        try {
            int row = this.tabelaExames.getSelectedRow();
            Statement st = Conexao.getStatement();
            if (row >= 0) {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 2);
                BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 2);
                Conexao.arquivaSQL();
                this.reloadLinha(row);
                this.validaBotoes(row);
            }
            st.close();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
                ErrorLogger.mostraMensagem(this.parent, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reloadExames();
        }
    }

    public int obterLinhaRepeticao(SelecionaExame tela) {
        return tela.retornaLinhaSelecionadaTabelaExamesRepetir();
    }
}

