/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biossays240plus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private String reqCodigo;
    private String codigoFilial;
    private String recCodigo;

    @Override
    protected void trataOrderRecord(String orderRecord) throws Exception {
        if (!(this.exame_atual == null || Funcoes.textoVazio(this.codigoFilial) || Funcoes.textoVazio(this.reqCodigo) || Funcoes.textoVazio(this.recCodigo))) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> orderFields = ASTMStandard.parseDefaultOrderRecord(orderRecord);
        this.exame_atual.put(ACTION_CODE, orderFields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, orderFields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)orderFields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        Map<Integer, String> sysSampleId = this.equip.parseOrderSystemSID(instSID);
        String reqCodigoOrder = (String)orderFields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(reqCodigoOrder);
        if (reqCodigoOrder == null || reqCodigoOrder.equals("")) {
            reqCodigoOrder = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(reqCodigoOrder) && reqCodigoOrder.contains("^")) {
            reqCodigoOrder = StringUtil.limpaString(reqCodigoOrder, new String[]{"^"});
        }
        try {
            Long.parseLong(reqCodigoOrder);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(reqCodigoOrder);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        reqCodigoOrder = Funcoes.preencheZero(reqCodigoOrder, qtde);
        String rackId = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rackPos = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rackId != null ? rackId + (rackPos != null ? "-" + rackPos : "") : rackPos);
        String filCodigo = reqCodigoOrder.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String recCodigo = reqCodigoOrder.substring(reqCodigoOrder.length() - ParametrosGerais.getDigitosTuboTubo());
        reqCodigoOrder = reqCodigoOrder.substring(ParametrosGerais.getDigitosTuboFilial(), reqCodigoOrder.length() - ParametrosGerais.getDigitosTuboTubo());
        if (etiqueta != null) {
            filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            reqCodigoOrder = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        this.reqCodigo = reqCodigoOrder;
        this.codigoFilial = filCodigo;
        this.recCodigo = recCodigo;
        this.exame_atual.put(FIL_CODIGO, filCodigo);
        this.exame_atual.put(REC_CODIGO, recCodigo);
        this.exame_atual.put(REQ_CODIGO, reqCodigoOrder);
    }

    @Override
    protected void trataResultRecord(String resultRecord) throws SQLException {
        String flags;
        if (this.exame_atual == null) {
            return;
        }
        Hashtable resultFields = ASTMStandard.parseDefaultResultRecord(resultRecord);
        String filCodigo = this.codigoFilial;
        String reqCodigo = this.reqCodigo;
        String recCodigo = this.recCodigo;
        String exaCodigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mcoCodigo = (String)this.exame_atual.get(MCO_CODIGO);
        String resultado = (String)resultFields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        if (resultado.charAt(resultado.length() - 1) == '^') {
            resultado = resultado.substring(0, resultado.length() - 1);
        }
        Map<Integer, String> components = this.equip.parseResultTestIDField((String)resultFields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String emiAlternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        String intCodigo = this.equip.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
        if (Funcoes.textoVazio(filCodigo) || Funcoes.textoVazio(reqCodigo) || Funcoes.textoVazio(recCodigo)) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo filial " + emiAlternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
            return;
        }
        if (intCodigo == null) {
            intCodigo = this.equip.getIntCodigo(filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial());
        }
        if (intCodigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
            return;
        }
        this.exame_atual.put(INT_CODIGO, intCodigo);
        this.exame_atual.put(FIL_CODIGO, filCodigo);
        this.exame_atual.put(REC_CODIGO, recCodigo);
        this.exame_atual.put(REQ_CODIGO, reqCodigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        exaCodigo = exame.getNomeExame();
        mcoCodigo = exame.getCodigoMaterial();
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exaCodigo, mcoCodigo, recCodigo);
        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        this.exame_atual.put(campo, resultado);
        if (this.exame_atual != null) {
            try {
                String filial = (String)this.exame_atual.get(FIL_CODIGO);
                String requisicao = (String)this.exame_atual.get(REQ_CODIGO);
                String tubo = (String)this.exame_atual.get(REC_CODIGO);
                this.exame_atual.put(FIL_CODIGO, filial);
                this.exame_atual.put(REQ_CODIGO, requisicao);
                this.exame_atual.put(REC_CODIGO, tubo);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder(e.getMessage());
                msg.append("\n").append("Erro ao receber resultado ");
                msg.append("\n").append(filCodigo).append(" ").append(reqCodigo).append(" ").append(recCodigo);
                msg.append("\n").append(resultRecord);
                ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
            }
        }
        if ((flags = (String)resultFields.get(ASTMStandard.RESULT_FIELD_CAUSE_OF_ABNORMALITY)) != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        try {
            this.salvaExame(this.exame_atual);
            this.exame_atual.remove(campo);
            this.equip.fireAtualizarTabela();
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder(e.getMessage());
            msg.append("\n").append("Erro ao salvar resultado ");
            msg.append("\n").append(filCodigo).append(" ").append(reqCodigo).append(" ").append(recCodigo).append(" ").append(exame.getNomeExame());
            msg.append("\n").append(resultRecord);
            ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
        }
    }

    @Override
    public void recordFound(String recordFound) throws Exception {
        String recordType = ASTMStandard.getRecordTypeIdentifier(recordFound = recordFound.substring(0, recordFound.length() - 1));
        if (recordType != null) {
            if (recordType.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(recordFound);
                return;
            }
            if (recordType.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        if (!(Funcoes.textoVazio(this.codigoFilial) || Funcoes.textoVazio(this.reqCodigo) || Funcoes.textoVazio(this.recCodigo))) {
            this.salvaExame(this.exame_atual);
        }
        this.reqCodigo = "";
        this.codigoFilial = "";
        this.recCodigo = "";
    }
}

