/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biocon;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected final String NOME_EXAME = "URI";
    protected int MAX_PATIENT_NAME_CHARS = 25;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    public boolean exr_codigoapoiado = false;
    private static String sNUL = "[NUL]";
    private static String sSOH = "[SOH]";
    private static String sSTX = "[STX]";
    private static String sETX = "[ETX]";
    private static String sEOT = "[EOT]";
    private static String sENQ = "[ENQ]";
    private static String sACK = "[ACK]";
    private static String sLF = "[LF]";
    private static String sSB = "[SB]";
    private static String sCR = "[CR]";
    private static String sDLE = "[DLE]";
    private static String sDC1 = "[D1C]";
    private static String sNAK = "[NAK]";
    private static String sSYN = "[SYN]";
    private static String sETB = "[ETB]";
    private static String sCAN = "[CAN]";
    private static String sEB = "[EB]";
    private static String sSP = "[SP]";
    private static String sDEL = "[DEL]";
    private static String sLINE = "[LINE]";
    private static String sFD = "[FD]";
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected String frame;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    Map<String, String> camposDecimais = new HashMap<String, String>();

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.camposDecimais.put("URO", "URO2");
        this.camposDecimais.put("GLI", "GLU2");
        this.camposDecimais.put("BIL", "BIL2");
        this.camposDecimais.put("CET", "KET2");
        this.camposDecimais.put("DEN", "SG2");
        this.camposDecimais.put("SAN", "BLD2");
        this.camposDecimais.put("p.H", "PH2");
        this.camposDecimais.put("PRO", "PRO2");
        this.camposDecimais.put("NIT", "NIT2");
        this.camposDecimais.put("LEU", "LEU2");
    }

    @Override
    public String getMsgEnd() {
        return "~" + LINE;
    }

    @Override
    public String getMsgStart() {
        return "~";
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        ArrayList<String> campos = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, new String(new char[]{'\r', '\n'}));
        while (tokenizer.hasMoreElements()) {
            campos.add(tokenizer.nextToken());
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (int campo = 0; campo < campos.size(); ++campo) {
            if (campo >= 2 && !this.ehComecoDaLinha((String)campos.get(campo))) {
                String linha = (String)campos.get(campo - 1) + (String)campos.get(campo);
                fields.add(linha);
                continue;
            }
            fields.add((String)campos.get(campo));
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private boolean ehComecoDaLinha(String field) {
        return field.startsWith("Nome") || field.startsWith("\u00c1rea") || field.startsWith("URINE") || field.startsWith("SAN") || field.startsWith("BIL") || field.startsWith("URI") || field.startsWith("CET") || field.startsWith("PRO") || field.startsWith("NIT") || field.startsWith("GLI") || field.startsWith("pH") || field.startsWith("DEN") || field.startsWith("LEU") || field.startsWith("(SN=") || field.startsWith("ID") || field.startsWith("OP") || field.startsWith("BLD") || field.startsWith("KET") || field.startsWith("S.G") || field.startsWith("GLU") || field.startsWith("URO");
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String[] codigoJalis;
            String NAME = "Name:";
            String SEX = "Sex:";
            String WARD = "Ward:";
            String AGE = "Age:";
            String ID2 = "ID(";
            String SN = "SN";
            String OP = "OP(";
            String URINE = "URINE";
            String NOME = "Nome:";
            String AREA = "\u00c1rea:";
            String IDA = "Ida:";
            int INDEX_COPIA = 5;
            boolean pesquisar = true;
            String mask = "mm/dd/yy hh:mm:ss";
            String dataHora = "";
            String id = "";
            String requisicao = "";
            ArrayList<String> listaExames = new ArrayList<String>();
            for (int i = 0; i < fields.size(); ++i) {
                String valor = fields.get(i);
                if (valor.contains("/") && valor.contains(":")) {
                    dataHora = valor.substring(0, mask.length());
                    continue;
                }
                if (valor.indexOf("ID(") > -1) {
                    requisicao = valor.replace("ID(", "").replace(")", "").replace(" ", "");
                    if (!Funcoes.textoVazio(requisicao)) continue;
                    requisicao = valor.trim();
                    continue;
                }
                if (valor.indexOf("Name:") > -1 || valor.indexOf("Sex:") > -1 || valor.indexOf("Ward:") > -1 || valor.indexOf("Age:") > -1 || valor.indexOf("Nome:") > -1 || valor.indexOf("\u00c1rea:") > -1 || valor.indexOf("Ida:") > -1 || valor.indexOf("SN") > -1 || valor.indexOf("OP(") > -1 || valor.indexOf("URINE") > -1) continue;
                listaExames.add(valor);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos %s ", requisicao));
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            while (Integer.valueOf(this.fil_codigo) == 0) {
                requisicao = requisicao.substring(1);
                this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
                this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
                this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            }
            HashMap<String, Object> urina = new HashMap<String, Object>();
            urina.put("ID", requisicao.trim());
            for (String s : listaExames) {
                if (Funcoes.textoVazio(s)) continue;
                String campo = s.substring(0, 5).trim();
                String resultado = s.substring(campo.length() + 1, s.length()).trim();
                String campoTraduzido = campo;
                if (campo.equals("GLU")) {
                    campoTraduzido = "GLI";
                } else if (campo.equals("KET")) {
                    campoTraduzido = "CET";
                } else if (campo.equals("S.G")) {
                    campoTraduzido = "DEN";
                } else if (campo.equals("BLD")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                } else if (campo.equals("URI")) {
                    campoTraduzido = "URO";
                } else if (campo.equals("URO")) {
                    campoTraduzido = "URO";
                }
                String resultadoDecimal = resultado.replaceAll("[a-zA-Z\\/<>+-]", "");
                if (Funcoes.isNumeric(resultadoDecimal.trim()) && this.camposDecimais.containsKey(campoTraduzido)) {
                    urina.put(this.camposDecimais.get(campoTraduzido), resultadoDecimal.replace('.', ',').trim());
                }
                urina.put(campoTraduzido, resultado);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada("Nenhum exame localizado nos dados recebidos");
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                this.fil_codigo = codigoJalis[0];
                this.req_codigo = codigoJalis[1];
                this.rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public void encerrarTransmissao() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                }
            };
            SwingUtilities.invokeLater(run);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.equipamento.arruma("~[STX][LINE]~Dez/18/2019[SP]18:07:07[SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("Name:[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]Sex:[SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("Ward:[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]Age:[SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("URINE[SP]10[SP][SP][SP][SP](00018)[SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("BLD[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("BIL[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("URO[SP][SP][SP][SP]norm[SP][SP][SP][SP]0.1mg/dl[SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("KET[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("PRO[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("NIT[SP][SP][SP][SP][SP][SP][SP]+[SP][SP][SP][SP][SP][SP][SP][SP]pos[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("GLU[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("pH[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]6.0[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("S.G[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]1.020[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("LEU[SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("(SN=32190384)[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("ID([SP]010007516011)[SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("OP(00000000)LOT(00000000)~[LINE]"));
        this.parse(buf.toString());
    }

    private static String parseStringToConstant(String command) {
        if (command.equalsIgnoreCase(sNUL)) {
            return String.valueOf('\u0000');
        }
        if (command.equalsIgnoreCase(sSOH)) {
            return String.valueOf('\u0001');
        }
        if (command.equalsIgnoreCase(sSTX)) {
            return String.valueOf('\u0002');
        }
        if (command.equalsIgnoreCase(sETX)) {
            return String.valueOf('\u0003');
        }
        if (command.equalsIgnoreCase(sEOT)) {
            return String.valueOf('\u0004');
        }
        if (command.equalsIgnoreCase(sENQ)) {
            return String.valueOf('\u0005');
        }
        if (command.equalsIgnoreCase(sACK)) {
            return String.valueOf('\u0006');
        }
        if (command.equalsIgnoreCase(sLF)) {
            return String.valueOf('\n');
        }
        if (command.equalsIgnoreCase(sSB)) {
            return String.valueOf('\u000b');
        }
        if (command.equalsIgnoreCase(sCR)) {
            return String.valueOf('\r');
        }
        if (command.equalsIgnoreCase(sDLE)) {
            return String.valueOf('\u0010');
        }
        if (command.equalsIgnoreCase(sDC1)) {
            return String.valueOf('\u0011');
        }
        if (command.equalsIgnoreCase(sNAK)) {
            return String.valueOf('\u0015');
        }
        if (command.equalsIgnoreCase(sSYN)) {
            return String.valueOf('\u0016');
        }
        if (command.equalsIgnoreCase(sETB)) {
            return String.valueOf('\u0017');
        }
        if (command.equalsIgnoreCase(sCAN)) {
            return String.valueOf('\u0018');
        }
        if (command.equalsIgnoreCase(sEB)) {
            return String.valueOf('\u001c');
        }
        if (command.equalsIgnoreCase(sSP)) {
            return String.valueOf(' ');
        }
        if (command.equalsIgnoreCase(sDEL)) {
            return String.valueOf('\u007f');
        }
        if (command.equalsIgnoreCase(sLINE)) {
            return String.valueOf(LINE);
        }
        if (command.equalsIgnoreCase(sFD)) {
            return String.valueOf('\u00fd');
        }
        return "";
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

