/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bf6900;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.bf6900.MessageOrrO02;
import jalis.laboratorio.interfaceamento.interfaces.bf6900.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_PNG_BASE64 = "^Image^PNG^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();

    public InterfaceListener() {
        super("BF-6900");
        this.parametros.put("2006^V_WBC", "leucocitos");
        this.parametros.put("2007^V_NEU_p", "neutrofilo_percentual");
        this.parametros.put("2012^V_NEU_c", "neutrofilo_contagem");
        this.parametros.put("2008^V_LYM_p", "linfocitos_tipicos_percentual");
        this.parametros.put("2013^V_LYM_c", "linfocitos_tipicos_contagem");
        this.parametros.put("2009^V_MON_p", "monocitos_percentual");
        this.parametros.put("2014^V_MON_c", "monocitos_contagem");
        this.parametros.put("2010^V_EOS_p", "eosinofilos_percentual");
        this.parametros.put("2015^V_EOS_c", "eosinofilos_contagem");
        this.parametros.put("2011^V_BAS_p", "basofilos_percentual");
        this.parametros.put("2016^V_BAS_c", "basofilos_contagem");
        this.parametros.put("2017^V_RBC", "hemacias");
        this.parametros.put("2018^V_HGB", "hgb");
        this.parametros.put("2019^V_MCV", "vcm");
        this.parametros.put("2020^V_HCT", "hct");
        this.parametros.put("2021^V_MCH", "hcm");
        this.parametros.put("2022^V_MCHC", "mchc");
        this.parametros.put("2023^V_RDW_SD", "rdw_sd");
        this.parametros.put("2024^V_RDW_CV", "rdw_cv");
        this.parametros.put("2025^V_PLT", "plaquetas");
        this.parametros.put("2026^V_MPV", "vpm");
        this.parametros.put("2027^V_PCT", "pct");
        this.parametros.put("2028^V_PDW", "pdw");
        this.parametros.put("2029^V_P_LCR", "plaquetas_lcr");
        this.parametros.put("2030^V_P_LCC", "plaquetas_lcc");
        this.parametros.put("2101^V_RBCScattergram.PNG", "bf6900_histograma_rbc");
        this.parametros.put("2102^V_PLTScattergram.PNG", "bf6900_histograma_plt");
        this.parametros.put("2033^V_BASOScattergram.PNG", "bf6900_histograma_baos");
        this.parametros.put("2034^V_DIFFScattergram.PNG", "bf6900_histograma_diff");
        this.warning.put("13101^Leucocytosis^99MRC", "Leucocytosis");
        this.warning.put("13102^Leucopenia^99MRC", "Leucopenia");
        this.warning.put("13103^Neutrophilia^99MRC", "Neutrophilia");
        this.warning.put("13104^Neutropenia^99MRC", "Neutropenia");
        this.warning.put("13110^Neutrophilia^99MRC", "Neutrophilia");
        this.warning.put("13111^Neutropenia^99MRC", "Neutropenia");
        this.warning.put("13105^Lymphocytosis^99MRC", "Lymphocytosis");
        this.warning.put("13106^Lymphopenia^99MRC", "Lymphopenia");
        this.warning.put("13107^Monocytosis^99MRC^", "Monocytosis");
        this.warning.put("13108^Eosinophilia^99MRC", "Eosinophilia");
        this.warning.put("13109^Basophilia^99MRC", "Basophilia");
        this.warning.put("13113^Increased Mid Cells^99MRC", "Increased Mid Cells");
        this.warning.put("13112^Decreased Mid Cells^99MRC", "Decreased Mid Cells");
        this.warning.put("13001^Background/Aspiration Abn.^99MRC", "Background/Aspiration Abn");
        this.warning.put("13005^Abnormal WBC Channel^99MRC", "Abnormal WBC Channel");
        this.warning.put("13006^Abnormal DIFF Channel^99MRC", "Abnormal DIFF Channel");
        this.warning.put("13202^RBC Clump?^99MRC", "RBC Clump?");
        this.warning.put("13203^Iron Deficiency?^99MRC", "Iron Deficiency?");
        this.warning.put("13205^Abnormal RBC Channel^99MRC", "Abnormal RBC Channel");
        this.warning.put("13206^Abnormal HGB Channel^99MRC", "Abnormal HBG Channel");
        this.warning.put("13701^CRP Increased^99MRC", "CRP Increased");
        this.warning.put("13702^HS-CRP Increased^99MRC", "HS-CRP Increased");
        this.warning.put("13601^Abnormal CRP Channel^99MRC", "Abnormal CRP Channel");
        this.warning.put("34525-6^rstRBC^LN", "rstRBC");
        this.warning.put("17790-7^WBC Left Shift?^LN", "WBC Left Shift");
        this.warning.put("34165-1^ImmGranulocytes?^LN", "IMM Granulocytes");
        this.warning.put("15192-8^Atypical Lymphs?^LN", "Atypical Lymphs");
        this.warning.put("13002^WBC Abnormal^99MRC", "WBC Abnormal");
        this.warning.put("13003^WBC Abnormal scattergram^99MRC", "WBC Abnormal scattergram");
        this.warning.put("13004^WBC Abnormal histogram^99MRC", "WBC Abnormal histogram");
        this.warning.put("15150-6^Anisocytosis^LN", "Anisocytosis");
        this.warning.put("15198-5^Macrocytes^LN", "Macrocytes");
        this.warning.put("15199-3^Microcytes^LN", "Mycrocytes");
        this.warning.put("15180-3^Hypochromia^LN", "Hypochromia");
        this.warning.put("13301^Erythrocytosis^99MRC", "Erythrocytosis");
        this.warning.put("13302^Anemia^99MRC", "Anemia");
        this.warning.put("10379-6^RBC Dual Pop^LN", "RBC Dual Pop");
        this.warning.put("13201^RBC Abnormal distribution^99MRC", "RBC Abnormal distribution");
        this.warning.put("13204^HGB Interfere^99MRC", "HGB Interfere");
        this.warning.put("13501^Thrombocytos is^99MRC", "Thrombocytosis");
        this.warning.put("13502^Thrombopenia^99MRC", "Thrombopenia");
        this.warning.put("13401^PLT Abnormal Distribution^99MRC", "PLT Abnormal Distribution");
        this.warning.put("7796-6^Platelet Clump?^LN", "Platelet Clump?");
        this.parametros.putAll(this.warning);
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (Funcoes.objectIsNull(nasc)) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                String emiAlternativo;
                String intCodigo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                if (Funcoes.textoVazio(intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo = "HEMOG"))) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (Funcoes.objectIsNull(exame)) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                for (String p : this.parametros.keySet()) {
                    jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (obx == null) continue;
                    if (!Funcoes.objectIsNull((Object)obx.getAbnormalFlag()) && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, listaWarning);
                    resultado = resultado.length() > IMAGE_PNG_BASE64.length() && obx.getObservationId().contains("PNG") ? this.convertImg(reqCodigo, resultado, "png") : (resultado.length() > IMAGE_BMP_BASE64.length() && obx.getObservationId().contains("BMP") ? this.convertImg(reqCodigo, resultado, "bmp") : resultado.replace('.', ','));
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra com etiqueta fora do padr\u00e3o da conf. do Jalis %s", tuboId));
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String convertImg(String reqCodigo, String resultado, String extensaoArquivo) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        File img = File.createTempFile("bf6900" + reqCodigo + "_" + new Date().getTime(), "." + extensaoArquivo);
        ImageIO.write((RenderedImage)image, extensaoArquivo, img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private void retornaAlerta(String campo, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx buscaObxPeloObservationID(List<jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx> listObx, String observationID) {
        for (jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block18: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (!Funcoes.textoVazio(tuboId) && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String[] idade = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
                    String tipoIdade = "Y";
                    if (idade != null && idade.length > 1) {
                        tipoIdade = idade[1].equals("A") ? "Y" : idade[1];
                    }
                    String pacNasc = idade[0] + "^" + tipoIdade;
                    BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = exameMaterial.getNomeExame();
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo);
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName(pacNome.replace(" ", "^"));
                        orrO02.getPid().setSex("||||||||||||||||||||||" + pacNasc);
                        orrO02.getPid().setDataOfBirth("|" + pacSexo);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("2001^MODE");
                        obx.setObservationValue("0");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("2002^MODE_EX");
                        obx.setObservationValue("0");
                        obx.setObserveResultStatus("");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(3);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("2003^Ref");
                        obx.setObservationValue("0");
                        obx.setObserveResultStatus("");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.STRING);
                        obx.setObservationId("2004^Note");
                        obx.setObservationValue("test");
                        obx.setObserveResultStatus("");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block18;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("BF-6900");
            mensagem.getMsh().setSendingFacility("Dirui");
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UTF-8");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message) && !Funcoes.textoVazio(message = this.removerLogInvalidoNoInicio(message))) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    private String removerLogInvalidoNoInicio(String message) {
        return message.substring(message.indexOf(String.valueOf('\u000b') + "MSH"), message.length());
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessage(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            this.fireExcecaoEncontrada("Erro ao efeturar o parse da mensagem");
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        String tubo = Funcoes.showDigitacao(null, "BF6900", "Informe o tubo. (fil+req+tubo):", "010051449701");
        if (!tubo.trim().isEmpty()) {
            if (Funcoes.showPerguntaOpcoes(null, "Informe o tipo de Opera\u00e7\u00e3o", new String[]{"Query", "Resultado"}) == 0) {
                this.query(tubo);
            } else {
                this.resultado(tubo);
            }
        }
    }

    private void query(String tubo) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SB]MSH|^~&|BF-6900|20180613001|LIS||20110613153408||ORM^O01|4|P|2.3.1||||||UTF-8").append("[CR]");
        buffer.append("ORC|RF||").append(tubo).append("||IP").append("[CR]");
        buffer.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buffer.toString()));
    }

    public void resultado(String tubo) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SB]MSH|^~&|20170214||LIS||20240917154654||ORU^R01|5|P|2.3.1||||||UTF-8[CR]");
        buffer.append("PID|1|||||||U|||||||||||||||||||||||1^Y[CR]");
        buffer.append("PV1|1|||||||||||||||||||[CR]");
        buffer.append("OBR|1|" + tubo + "|123456789123|1001^CountResults||20240917154545|20240917154548|||||||20240917154545||||||admin||||||||[CR]");
        buffer.append("OBX|1|IS|2001^MODE||3||||||F||[CR]");
        buffer.append("OBX|2|IS|2002^MODE_EX||1||||||F||[CR]");
        buffer.append("OBX|3|IS|2003^Ref||0||||||F||[CR]");
        buffer.append("OBX|4|IS|2004^Note||||||||F||[CR]");
        buffer.append("OBX|5|NM|2006^V_WBC||5.38|10^3/uL|4.00-10.00||||F||[CR]");
        buffer.append("OBX|6|NM|2007^V_NEU_p||47.2|%|50.0-70.0||||F||[CR]");
        buffer.append("OBX|7|NM|2008^V_LYM_p||48.3|%|20.0-40.0||||F||[CR]");
        buffer.append("OBX|8|NM|2009^V_MON_p||2.9|%|3.0-8.0||||F||[CR]");
        buffer.append("OBX|9|NM|2010^V_EOS_p||0.9|%|0.5-5.0||||F||[CR]");
        buffer.append("OBX|10|NM|2011^V_BAS_p||0.7|%|0.0-1.0||||F||[CR]");
        buffer.append("OBX|11|NM|2012^V_NEU_c||2.53|10^3/uL|2.00-7.00||||F||[CR]");
        buffer.append("OBX|12|NM|2013^V_LYM_c||2.60|10^3/uL|0.80-4.00||||F||[CR]");
        buffer.append("OBX|13|NM|2014^V_MON_c||0.16|10^3/uL|0.12-0.80||||F||[CR]");
        buffer.append("OBX|14|NM|2015^V_EOS_c||0.05|10^3/uL|0.02-0.50||||F||[CR]");
        buffer.append("OBX|15|NM|2016^V_BAS_c||0.04|10^3/uL|0.00-0.10||||F||[CR]");
        buffer.append("OBX|16|NM|2017^V_RBC||4.21|10^6/uL|3.50-5.50||||F||[CR]");
        buffer.append("OBX|17|NM|2018^V_HGB||13.1|g/dL|11.0-16.0||||F||[CR]");
        buffer.append("OBX|18|NM|2019^V_MCV||89.5|fL|80.0-100.0||||F||[CR]");
        buffer.append("OBX|19|NM|2020^V_HCT||37.7|%|35.0-50.0||||F||[CR]");
        buffer.append("OBX|20|NM|2021^V_MCH||31.1|pg|27.0-34.0||||F||[CR]");
        buffer.append("OBX|21|NM|2022^V_MCHC||34.7|g/dL|32.0-36.0||||F||[CR]");
        buffer.append("OBX|22|NM|2023^V_RDW_SD||52.0|fL|35.0-56.0||||F||[CR]");
        buffer.append("OBX|23|NM|2024^V_RDW_CV||12.0|%|11.0-16.0||||F||[CR]");
        buffer.append("OBX|24|NM|2025^V_PLT||273|10^3/uL|100-300||||F||[CR]");
        buffer.append("OBX|25|NM|2026^V_MPV||10.8|fL|7.0-13.0||||F||[CR]");
        buffer.append("OBX|26|NM|2027^V_PCT||0.295|%|0.100-0.280||||F||[CR]");
        buffer.append("OBX|27|NM|2028^V_PDW||13.9|fL|15.0-18.0||||F||[CR]");
        buffer.append("OBX|28|NM|2029^V_P_LCR||31.4|%|13.0-43.0||||F||[CR]");
        buffer.append("OBX|29|NM|2030^V_P_LCC||86|10^9/L|13-129||||F||[CR]");
        buffer.append("OBX|30|ED|2101^V_RBCScattergram.PNG||iVBORw0KGgoAAAANSUhEUgAAAK8AAABkCAIAAAB/3/dVAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAABLDAAASwwFyLQTKAAAD+ElEQVR4nO3cv0sbYRzH8SfF4REcnkCECB0MtEO2DnbQzYMORuwfoDhJp2ChZGq1S6uLhAqibjoIV6G73ezSokMgFApaqHgOhQtYyEEFDxSuQ+hdiL+S3HPPLz+vycupeeLz9ntnBlPkZnPv5kaGRgghnu85R87G5obz07l61r/0nRNnY3Pj8Pth85ezDCu+LFqj1kBmwDvz7I/22vLaLU8H0vW0HAdBkEqlGh83NtvettN96cJEoVqp5vP52u9aeNa/9BtnrWfW3te93OOcV/MaZxlj1Uq19qe2ur5aO6lRRimhol4UcBIEQfjxzuedhaWF8NB13ZkXMzeePXULE4XwcGFp4eDXAQLQy4P2P7Xu1WnfDdtLCaW0Xq+HDxTGCvaWTfyYywOhWq8UN7HGrNyjXLVSbX5weGi49KpE++j483F7297/th+eyj3MOUfOlW8DSrtjNpRmS/W/9fOLc3vLnn8z37zfhJDe3t50fzrdnyaXZOTpSHYwG56ilPqXmAyaa7lvKK+XWZbNvZ2r/qi23AS03Dfsftktr5TDQ9d1i7PF5NcLPN0xG/wz36t5i+8X/TN/9cPqLZ/pnDgsw8LDvcqeNWrxWSOI0u5d5NT01NT0VPNfDYQQSinLMJZl1qg1PjZ+WInebygvlwsThdLrUiMRymj+SZ7jukGEW/7CLM4W3VOXZVl4NgiCIAjOL85d1y2vlFtuSSenJ4+d4+A/+5Mt5BUAP801cMEyLDuYpaytdx44PzfExL2GDp4aNcjWwbtPYiAIiZSrASRSsQaMB1ni1sDrNgMFSBRuooqzAWRRtAaMCikUrQGkUKIGTAJFKFEDKAI1QETdGnD5EE/dGkA8+TVgBqhDfg2gDtQAEaVrwEVEMKVrAMFQA0RQA0RUrwG3DiJJrgGbrRTVZwOIpEENmB/CaFADCKNHDRgPYuhRA4iBGiCiTQ24WAigTQ0ggMwaOv11x3hIGmYDRDSrAeMhUZrVQBBEkvSrgSCIxGhZAyRE1xowHpKgaw2QBI1rwHjgTuMaCILgTVoNvDYSQXCk92wAvkyoAeOBFxNqAF5QA0QMqQEXCy7k1IDNU5Mhs4GgMB7MqQHiQw0QMaoGXCxiMqoGiMm0GjAe4pBQAzZMWabNBojDwBowe7pmYA3QNTNrwHjojpk1QHdE14DfWpUZOxuQXReMrYEgiM6ZXAN0yvAaMB46IrQGKXuDINpn+GyAjtyLGjAe2nQvaiAIoj3iapC+H9IXoL77MhsaEMTtBNWgzjYEKi1GNT0CnkPBn/7VJaUkrEI5idegYArXirlOM2K6pgb8w98umPFDaG06CMx4XQAAAAAAAAAAAAAAAAAAoLt/vnEmaAF1MEQAAAAASUVORK5CYII=||||||F||[CR]");
        buffer.append("OBX|31|ED|2102^V_PLTScattergram.PNG||iVBORw0KGgoAAAANSUhEUgAAAK8AAABkCAIAAAB/3/dVAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAABLDAAASwwFyLQTKAAADdUlEQVR4nO3dv0sbYRjA8TfFwUAH8ycEWqgBty46Bjp2qP+CtIujtEvsUpxKcOyWdijBobMd06FjwSzFDBZTsJBsySDoULgOB5c0xlzu8v543ve+HxwuRJM3d9977nSxpO7XeNfYebqjlLq9ve3/7rc+tno/e8lTw/6w9amVfHPzuLn5ZHPmFfZe7Q3/DBe8BURZm3kcRVGpVIq34xTaJ+3Kw0r9ef3sx1ltq9b/1Y+f6q53p3+w873T6/WUUs3jZvtzu9vtKqXG12MLnwGmRFGUbJ9+PT16f5Q8PL84P3h9MPepaaPRaPfFrtFFwpAHy3/r4GpQqVTMLQXOLV3Dmqo+rg6uBiYXA8dm7xtmbG9vN942yuVy/Vld/VXtk7adZcGJlNlQXi/HV4fWh1ZtqzYec1cYspTZ0PnWOXxzaGcpcC6lhgU2Njaqj6rx9s31zXDI3xW8l+F3ihn7L/cvLy7jr/YX7idCNP33BkPvYPj1kV/+K0V20f8bJYtvjaXkv1JkdHckMCTEsVbDXAQhi50aFhx1ghAkcw3G7zKLRNrOtDAbUj+xsF1SYG7vGxIEIYLpGjjMPhEyGxTdSCCnBrhntIaspzvjwTFmAyak1cB4cElaDYogHDJXAwfVPwJng6IkV2TWADfE1sB4cMBQDRxLL4mdDYqk7JNcA2wTXgPjwSrhNcAqEzXoPaEZD/YwGzDhRQ2MB0u8qAGWaK/B0HnMeLCB2YAJj2pgPBjnUQ0wzq8aGA9m6a2Bo+U3v2aDIjijvKsBBvlYA+PBFB9rUARhiMYaOELe83Q2KOIzwd8aoJ/XNTAeNPO6BmimqwZXpynjQacAZgNBaBNADdAmjBoYD3qEUYMiCC2CqQEaaKlByHkpZBkeC2w2EMRKAqtBEcQqwqsB+QVZA+Mhp9VrkLnrZa5KuiBnQ4wgMgu4BkUQWYVdgyKITFaswYt97cUiRQh+NsQIYikFqUERxDKKU4NSKqKJxQpVQ4wg7rVKDf7uVobEfAWcDQmamFXkGmI0MbHmegFCJEGUXK7Ctdw1hHo+FToLZsN9ipgFNaSanoKBl5GvhlAvE6kyfXBp6USpS2I2mHM3HVd9RFMbi9ZADTbN7SN13uRuKPMIpwb5DP33lzmRza1h8dtLuxwinzlXjdnHUVTYO0QAAAAAAAAAAAAAgCj/AFjjyqOc5wLAAAAAAElFTkSuQmCC||||||F||[CR]");
        buffer.append("OBX|32|ED|2033^V_BASOScattergram.PNG||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||||||F||[CR]");
        buffer.append("OBX|33|ED|2034^V_DIFFScattergram.PNG||iVBORw0KGgoAAAANSUhEUgAAAK8AAACvCAIAAAAE8BkiAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAABLDAAASwwFyLQTKAAAL1klEQVR4nO2dT2gbVx7H3yw+TCCHMXRBBhc6IRdBA6ugw1o0F0MOa8hCVHxITBbSSQNtctl1u4e16MGrdKGxL61LwTAbSJgYtsQ5LNLFVDlskRcarIUtdiFQBVqQIAsyODCCBGYPk86M3j+NRnL0e6PfB2FGb96Mnud99X2/90czhPTieR5BJpVfjbsACCCmJPtWVlfazbZ9x+buzeVz5dVy7VFt/fZ6ND2TyZRWS4W5gq7rrXbL3rTv37svOn8hXyCEdF92W+1W7VFte2tbUoAgv099t37rr7ck6cigyNRQyBcaekO01/rQmv71dOkvpfUv1kk3TN9+uN3pdD7600eu65qm2X3eFZ3Br0Jnyzmhn8ieydqb9tKlpXd//66oAIV8gUyR7a9fKab5tClPR4YlGjdUqpXyZ2VuNv2k3jnq5PK5/Sf7xUvFyA7ieV4un4vzWdT5c7/NuS/c4mJRlEFUHkk5kYFIGDcUF4vNp83G44Zz17GuWuGOl6Tb7WbPZBOcs/HvRu1ftYULC8mKhAyPrKWQYF2xnLsOIeT+1v3SJ6XMbKb9c5sQQl6S0icle9O+ef1mZaeyvb198J+D+Kc9+P4g97bMV+byc8t/XPa3qzvVg+8P5OnIQCTxBvO0WThXcLYcMkV8h7CuhPawfnvdNE37rn32N2f3vttb+XQl/pm7L4VBhs/MzMzZubP+a2Zmpm86MhBJvOHyHy7rU3rrp1aQYrxh3PpbGMa3f27bX9n2V3bxYtH5h3Nr9RbpU8uvMGfNdrstybD9z+3Sn0vx05GBSOIN1hXr2vVrM2/O+K9T2VPmrDn3zhybs96o61O6YRhxTmu8YSz8bqH2qJagSMhI6OMNhmGYp01/233uttvt+fPz08a0fc+Oft2rO9Wl95Z2v901DMN8y2z80CBdop/Ub354s91uH7YPhec/aWRmMyemTmRz2fJqufm0ad/jD28gr4E+3nDj/Rs/PvnRfzlfO4QQ66r14OEDyvmdO87S4pKu69OZ6epO1XM913XdI7d4oVi8XOSf2j//BzdaP7X2D/bXPlur7dQK5wox2xTkONCo957naRqdOCiGYeiG3n3ePfyf0BUQBcBZq0kGZ62QEFQDEoJqQEJQDUgIqgEJQTUgIagGJATVgISgGpAQVAMSgmpAQlANSAiqAQlBNSAhqAYkBNWAhKAakBBUAxKCakBCUA1ICKoBCUE1ICGoBiQE1YCEoBqQEFQDEoJqQEJQDSNF8R+xohpGyrC/bh8zqIYB8ZiNFIFqGBCN2UgRqIakeAJ7SJNn4N08+sBenhRdMPSG2Pi1rvW+Jb1NhuLKQDXEhg0U2LrX1BYEqqEXeUMQ3dZ+0QcbQKgsiB4wbniF6DIEde8xOvB696YAVIOM6GADVfHsXwXBliIelA7YGEL75a8XaUHYw2GDaoiB11vNhBmR9HiJ0YiSPRAkqAYpVL1y61JjrCI6XknFFrBHMFEN/fCYr3i0sqn69noP4bYpgEE19EMyuERFBlrEJzT1pEBQDTSi2YcATSCC4Fg2vIgzbAUDVEMvfWuOOzxFNSVeRCWiUAMkqAaGaP8w/vx1cBQVW5AYfgOGhM+8Sz+UDrjdyyjUMEPffgTIqAK9QQo1nNC3uyhZ8UDtgicFknI1JB5lj8YBbPWzQSK3mdB696owvZnqlkL+SCZRwM85T+92336mF8kW/1MAkGo1yBE156S3RrnfaUkM4fWaAaUk2EywGuRQgiDi5oM6ivRmJpEU8GpIddzQF/k0o2h6gjX/qAhEAxIqxA2TrQa2RjWBCKLf7GjMyJ3aFg1WojeoB3cESesNKUi89kI1UqSGUa3aYtclcCesRYudRAPVhMkJjxSpIcqQyuDWomhNLBEvcfCYvbBtQ001cCs7Orrgb/vZEitD6w0jiCBQIOI1TlRnBLYxcFBvlWy0wENW/6uTCBK5o9Ts8hZ2AJtK4fZTYKKeGgKoknP/kZj/najy2Mr2BIfI5aIKUNQwaDGC/CMvv/zrLvcMwtQ9jKsbFyhqiE9UB/4r+al6N7gOQdU6NzP3zAo1EAHqqSEgbisQI5s8OCD9UrjKUPG6qqQG1gmOtfAxDYMIbECd6xqikhpiEj9yHCiDyAZUvn5qjjcQnjGIEK1yoI6WjAtJuouE9xMa9hD245RAMW+I35WQZxDt5KZL6l5eClYiwFFMDSzJBqDiqIEbE3A7FIpfwhD11MCORSY5yRBHDeQrQ37iMaNs3OBDVb98IaQE7polUTNB7Qrihpj5qU+EjBrewA0XxlVyFS5YQkCrgS0b5NKmALhqkEtBbhKv55+SDEFCvah9gKuGOAzTghzT/63y5VRBDSNZxIDwULBPwe04oDiOAwW8Qc6Qk9pIFOXVEJPJ+C8HRcGWQjrMExclBn9eO0qqgVuVWL/Do6QayAgnibDJkDD2uCHxx2O1Dg84b5D8ekW+gkTeUqBWkgDcG7BSjxXQ3hBnHljpeQDojN0bfCSFkC8kQIYBnDf4SBxCtAt7mKMHjjcMuqIdGT1A1OATXYsaRxyAip4OQKkhINlCVGRQgMYNAX59y++5RlAWIwK6GtjFzKpNUpQTHOMBkTfklsLr3eD+sAU2SZQxTiCrgUQUELyV/JQBGRQoLQX3l4zUdrSx8N9ynwyiEFBaBBHj9Ya+XUqPeesJlIQkAIo3+IgmMD2BZ0Rv9u6pcStn0AC9Bz33Vs5US0GYdGRIYHkDVcfs/b9F3Uvq4TGoj9EAv08h72RCLH0/4MSSEFsKdvyRRL73VAYqHfAwlBANTKnBqYFb69wlLSkLHXyH0IjmEW9c+gAXN7ANf5zZS8BPA+kz/hg0ExrRfBGM0SroD/Y8T0t8h5Rjg1rVwtWHxjQxyKDA8oYoot6E3CqwTzEMgNTAdi+j6fJOJpUN7SEZgNQgegYpVbWShdSih4mIDoSAHzcA6WTC6lNw44OBrpPEG2AaxtgjxyiAvIEws5FxrlDw/NLoEwxfC6otVogBrD4FNRMRfxYKOxQjAZY3BLBSkFQzZQ9IYmCpITqIJBl5FB2oKP4zd4LtMZYEUBTp9fYOgkQ5WuwIAyzREHK84SQgb9B4wwx9DyEgpCCPKJWJN8FFkQMNJsqNQQnPGOMcFQsgbyDMAJT8IvVtI6BcYylwpECgqYGIF8pGhxPY8AI5Fsa+Zpq7Wjr+D2lADPAmBcj4dMi41CAZhE4wPo2MBmDrIsvMBiFQlFFWqLOQEABqKEf+juvTJxRwUeS4KY27AJAA4A1cJvorOzagqgEy6VUqqmGSwbhheNAbkDSC3oCEoBqQEFQDEpICNaQ3iBs7GEVOMinwhuNj4l1nUr2hLH0b86jUMalqQAjBlgKJgmoYiLQ3DRQT01Jw61VU2RMmgoCJUQPCYZJbikn9xscHvWGSmWRvQGhQDUgIqkFtVlZXKtXKwoWFaOLa52uVamXunTkqcy6fq1Qryx8vU+mZTGZjc2Pvv3v02TFuUItKtdJ61qrv1oMU87TZOeq4rlu8WKQyb/x9o/5dvdPpEL0nvb5br1Qr8+fn6bOjGtSiUq2sfb7WOepk3876KeVPyxubG61nLUoN+km9c9TJ5XP7T/aLlyK7dOJ5Xi6fI9hSpIDOYcfZcqzrFiGETBHrqmVv2my24mKx+bTZeNxw7jrWVSvc8ZJ0u93smSzn1OgNalGpVlZWV3L5XOtZi+ikeLG419gjhLDe8E3tGz9iME+b7gs3M5sJdi1/vOy+cOu7dfSGNNB43Gg+bV5evGx9YH25+SWbwTxtFs4VnC2HTBHfIawroT2s3143TdO+yzgKeoNa+N5ACLHet/YP9jtHHf2kThhvWFld8XrZf7LPng29ISU4W87h4eHaF2vd5112r3XFunb92sybM/7rVPaUOWuyXVBAdwhEhqH7vFuYK3B3zZ+fnzam7Xs2ieikulNdem9p99tdwzDMt8zGDw3SRW+YAKyr1oOHD0ivZTh3nKXFJV3XpzPT1Z2q53qu68K6QyAyLgzD0A2dTsUocpLBlgIJ4bQUYykHgiAIgiAIohL/B7UmTHg2CcWYAAAAAElFTkSuQmCC||||||F||[CR]");
        buffer.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buffer.toString()));
    }
}

