/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.best2000;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.interfaces.elisysquattro.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.elisysquattro.RecordParser {
    public RecordParser(InterfaceListener interfaceListener) {
        super(interfaceListener);
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type;
        if (Funcoes.isNumeric(String.valueOf(record.charAt(0)))) {
            record = record.substring(1, record.length() - 1);
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(record)) != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        this.equip.getClass();
        if (result_status.equals("F")) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        this.exame_atual.put("resultado_quantitativo", resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }
}

