/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.best2000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.best2000.DadosEnviados;
import jalis.laboratorio.interfaceamento.interfaces.best2000.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.elisysquattro.InterfaceListener {
    private boolean enviarTudo = false;
    private boolean enviandoTudo = false;
    private StringBuilder buf = new StringBuilder();
    private ArrayList<DadosEnviados> dadosEnviados = new ArrayList();
    private ThreadRecebimento threadRecebimento = null;
    private ArrayList<String> mensagens = new ArrayList();
    private boolean query = false;
    private String resultados;

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this);
        this.threadRecebimento.setPriority(10);
        this.threadRecebimento.start();
        this.addListaRecebimento("");
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
        this.limpaLogArquivos(dia);
        this.resultados = String.format("%s%sRESULTADOS-%s.lis", System.getProperty("user.home"), System.getProperty("file.separator"), dia);
        this.TIME_TX = 30000;
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
        super.setPortaCOM(portaCOM);
    }

    private void limpaLogArquivos(final String dia) {
        File file = new File(System.getProperty("user.home"));
        File[] afile = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("RESULTADOS") && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        if (acao.equalsIgnoreCase("R")) {
            return this.parseFile();
        }
        if (!this.enviarTudo) {
            return super.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
        }
        try {
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            DadosEnviados dado = new DadosEnviados(fil_codigo, int_codigo);
            if (!this.dadosEnviados.contains(dado)) {
                this.dadosEnviados.add(dado);
            }
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            String sobrenome = null;
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            String pac_datanasc = Funcoes.formataData("yyyyMMdd", BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo));
            String t = ASTMStandard.getDefaultPatientRecord(1, codigo.toString(), codigo.toString(), nome, sobrenome, pac_sexo, pac_datanasc, "");
            if (!Funcoes.textoVazio(rackposition) && !rackposition.startsWith("\\^")) {
                rackposition = "^" + rackposition;
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                this.tx_list.add(t);
                for (ExameMaterial exameMaterial : alternativos) {
                    t = ASTMStandard.getDefaultOrderRecord(++seq, codigo.toString(), rackposition, new ExameMaterial[]{exameMaterial}, null, null, "R", "", tipo_amostra, "X");
                    this.tx_list.add(t);
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = ASTMStandard.getDefaultPatientRecord(1, sample_id.append(tubo).toString(), sample_id.toString(), nome, sobrenome, pac_sexo, pac_datanasc, "");
                    this.tx_list.add(t);
                    t = ASTMStandard.getDefaultOrderRecord(++seq, sample_id.toString(), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", "", tipo_amostra, "X");
                    this.tx_list.add(t);
                }
            }
            InfoExameRequisicao exame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            exame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            exame.setTuboPai(this.rec_tuboPai);
            exame.setInterface(int_codigo);
            exame.setCurva(this.curva);
            this.examesEnviados.add(exame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (starting_range.trim().equalsIgnoreCase("ALL")) {
                this.hostQuery = true;
                this.enviarTudo = true;
                return;
            }
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Etiqueta solicitada fora do padr\u00e3o definido nas configura\u00e7\u00f5es do Jalis");
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Best : Host Query Response");
        }
    }

    @Override
    public String parse(String message) {
        try {
            if (Funcoes.textoVazio(message)) {
                return "";
            }
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    if (!Funcoes.textoVazio(last)) {
                        message = last.substring(0, last.length() - 1) + message;
                    }
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        this.rx_list.add(s);
                    }
                    if (message.endsWith(String.valueOf('\r') + '\u0017')) {
                        this.rx_list.add("");
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                StringBuilder log = new StringBuilder();
                for (int i = 0; i < this.rx_list.size(); ++i) {
                    log.append(this.parseMessage((String)this.rx_list.get(i))).append('\n');
                }
                StringUtil.escreverArquivoTexto(this.resultados, log.toString(), true);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    protected void limpaDadosRequisicao() {
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.request_received = false;
    }

    public String parseFile() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", System.getProperty("user.home"));
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Resultado do Best", "lis"));
            if (chooser.showOpenDialog(null) == 0) {
                String[] buf;
                String arquivo = StringUtil.lerArquivoTexto(chooser.getSelectedFile());
                for (String s : buf = arquivo.split(String.format("[%s]", Character.valueOf('\n')))) {
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "Error ao receber resultado pelo arquivo\n" + e.getMessage(), e.getStackTrace());
        }
        return "Retorno recebido";
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("") && message.length() > 5) {
                this.addMessage(message);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            ex.printStackTrace();
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void prepararParaReceber() throws Exception {
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    private synchronized void addMessage(String message) throws IOException {
        this.getPortaCOM().write(String.valueOf('\u0006'));
        if (message.indexOf(this.getMiddleFrameEnd()) > -1) {
            this.mensagens.add(message);
        } else if (message.indexOf(this.getFinalFrameEnd()) > -1) {
            this.mensagens.add(message);
            for (String s : this.mensagens) {
                this.addListaRecebimento(s);
            }
            this.restartThreadRecebimento();
            this.mensagens.clear();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        if (this.hostQuery && this.enviarTudo) {
            this.hostQuery = false;
            this.tx_list.clear();
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            for (int i = 0; i < this.getAba(0).getTabela().getRowCount(); ++i) {
                this.getAba(0).transmiteExames(i);
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            this.buf.setLength(0);
            for (String frame : this.tx_list) {
                this.buf.append(frame);
            }
            this.tx_list.clear();
        }
        super.tratarEndOfTX();
        if (this.enviarTudo) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.enviarTudo) {
            this.enviandoTudo = true;
            this.enviarTudo = false;
            this.tx_list.add(this.buf.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.buf.setLength(0);
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
        }
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.enviandoTudo) {
            if (this.dadosEnviados != null && !this.dadosEnviados.isEmpty()) {
                Statement st = Conexao.getStatement();
                for (DadosEnviados dado : this.dadosEnviados) {
                    BDUtil.setExmSituacao(st, 1, 0, dado.intCodigo, dado.filCodigo);
                }
            }
        } else {
            super.encerrarTransmissao();
        }
    }
}

