/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.beckmancx5;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char LB = '\u0001';
    public static final char LBO = '\u0002';
    private boolean lastAck = false;
    private boolean inicioRack = false;
    private boolean rackIniciada = false;
    private static final String EOT_SOH = String.format("%c%c", Character.valueOf('\u0004'), Character.valueOf('\u0001'));
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private Requisicao ultimaRequisicao = null;
    private List<Object[]> requisicoesQuery = new LinkedList<Object[]>();
    private boolean hostQuery = false;
    private boolean confirmacaoHostQuery = false;
    private boolean curva = false;
    private String tuboPai;
    private String ultimoFrame = "";
    private int countTx = 0;
    private PanelAbaAbstrata abaRack = null;

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (!message.equals("")) {
                if (message.length() == 1) {
                    char c = message.charAt(0);
                    if (c == '\u0003' || c == '\u0004' || c == '\u0006' || c == '\u0001' || c == '\u0015') {
                        this.getPortaCOM().clearInputString();
                        this.handShakeCharReceived(c);
                    }
                    return;
                }
                if (message.length() >= 2) {
                    char c1 = message.charAt(message.length() - 2);
                    char c2 = message.charAt(message.length() - 1);
                    if (c1 == '\u0004' && c2 == '\u0001') {
                        this.getPortaCOM().clearInputString();
                        this.handShakeCharReceived(c2);
                        return;
                    }
                }
                if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                    this.getPortaCOM().write(this.lastAck ? String.valueOf('\u0003') : String.valueOf('\u0006'));
                    this.lastAck = !this.lastAck;
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0001': {
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                            InterfaceListener.this.lastAck = true;
                            break;
                        }
                        case '\u0003': 
                        case '\u0006': {
                            if (InterfaceListener.this.inicioRack && !InterfaceListener.this.hostQuery) {
                                if (!InterfaceListener.this.rackIniciada) {
                                    InterfaceListener.this.rackIniciada = true;
                                    InterfaceListener.this.enviarProximaRequisicao(InterfaceListener.this.abaRack);
                                    break;
                                }
                                InterfaceListener.this.rackIniciada = false;
                                InterfaceListener.this.inicioRack = false;
                                InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0004'));
                                break;
                            }
                            if (!InterfaceListener.this.requisicoesQuery.isEmpty() && c == '\u0006') {
                                InterfaceListener.this.enviaRequisicaoQuery((Object[])InterfaceListener.this.requisicoesQuery.remove(0));
                                break;
                            }
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0004'));
                            break;
                        }
                        case '\u0015': {
                            if (InterfaceListener.this.inicioRack) {
                                InterfaceListener.this.rackIniciada = false;
                            }
                            if (!InterfaceListener.this.hostQuery || InterfaceListener.this.inicioRack || InterfaceListener.this.countTx >= 3) break;
                            InterfaceListener.this.getPortaCOM().write(InterfaceListener.this.ultimoFrame);
                            InterfaceListener.this.countTx++;
                            break;
                        }
                        case '\u0004': {
                            if (InterfaceListener.this.confirmacaoHostQuery && !InterfaceListener.this.requisicoesQuery.isEmpty()) {
                                InterfaceListener.this.getPortaCOM().write(EOT_SOH);
                                break;
                            }
                            InterfaceListener.this.iniciarTransmissaoRack(InterfaceListener.this.abaRack);
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return "[";
    }

    public void iniciarTransmissaoRack(PanelAbaAbstrata abaRack) throws IOException, InterruptedException {
        this.inicioRack = true;
        this.rackIniciada = false;
        this.abaRack = abaRack;
        this.getPortaCOM().write(EOT_SOH);
    }

    @Override
    public String parse(String message) {
        try {
            Statement st = Conexao.getStatement();
            int idx = message.indexOf("]");
            String checksum = message.substring(idx + 1, message.length());
            message = message.substring(1, idx);
            ArrayList<String> fields = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(message, ",");
            while (tokenizer.hasMoreElements()) {
                fields.add(tokenizer.nextToken());
            }
            if (fields != null && fields.size() > 0) {
                String device = (String)fields.remove(0);
                int stream = Integer.parseInt((String)fields.remove(0));
                int function = Integer.parseInt((String)fields.remove(0));
                if (stream == 701 && function == 2) {
                    if (this.ultimaRequisicao != null) {
                        int erro = Integer.parseInt(((String)fields.remove(0)).trim());
                        if (erro > 0) {
                            if (erro == 1) {
                                this.fireExcecaoEncontrada("(Code 1) Erro de sintaxe");
                            } else if (erro == 2) {
                                this.fireExcecaoEncontrada("(Code 2) Ocupado");
                            } else if (erro == 3) {
                                this.fireExcecaoEncontrada("(Code 3) Pedido inv\u00e1lido");
                            } else if (erro == 4) {
                                this.fireExcecaoEncontrada("(Code 4) INVALID ORDAC REQUEST");
                            } else if (erro == 5) {
                                this.fireExcecaoEncontrada("(Code 5) Combina\u00e7\u00e3o programada inv\u00e1lida");
                            } else if (erro == 6) {
                                this.fireExcecaoEncontrada("(Code 6) Controle n\u00e3o configurado");
                            } else if (erro == 7) {
                                this.fireExcecaoEncontrada("(Code 7) Apenas setor calibrador");
                            } else if (erro == 8) {
                                this.fireExcecaoEncontrada("(Code 8) Incompatibilidade no modo");
                            } else if (erro == 9) {
                                this.fireExcecaoEncontrada("(Code 9) Erro no aparelho de interface");
                            } else if (erro == 10) {
                                this.fireExcecaoEncontrada("(Code 10) Amostra pronta");
                            } else if (erro == 11) {
                                this.fireExcecaoEncontrada("(Code 11) Tipo de material incompat\u00edvel");
                            } else if (erro == 12) {
                                this.fireExcecaoEncontrada("(Code 12) Tipo de teste incompat\u00edvel (verifique o alternativo)");
                            } else if (erro == 13) {
                                this.fireExcecaoEncontrada("(Code 13) Nome do paciente incompat\u00edvel");
                            } else if (erro >= 14) {
                                this.fireExcecaoEncontrada(String.format("(Code %s) Erro n\u00e3o previsto", String.valueOf(erro)));
                            }
                            return "";
                        }
                        String acession = (String)fields.remove(0);
                        StringBuilder rack = new StringBuilder();
                        rack.append(StringUtil.preencheString(this.ultimaRequisicao.getSector(), 2, '0', 1));
                        rack.append(",");
                        rack.append(StringUtil.preencheString(this.ultimaRequisicao.getCup(), 2, '0', 1));
                        rack.append(",");
                        if (acession.trim().length() > 14) {
                            acession = acession.substring(0, 14);
                        }
                        rack.append(acession);
                        for (String e : this.ultimaRequisicao.getExames()) {
                            this.atualizarSituacaoExame(st, this.ultimaRequisicao.getFil_codigo(), this.ultimaRequisicao.getReq_codigo(), this.ultimaRequisicao.getRec_codigo(), e, this.ultimaRequisicao.getMco_codigo(), this.ultimaRequisicao.getInt_codigo(), !this.ultimaRequisicao.isCurva() ? rack.toString() : null, this.ultimaRequisicao.getSituacao() == 2 ? 3 : 1, this.ultimaRequisicao.isCurva());
                        }
                        Conexao.arquivaSQL();
                        this.confirmacaoHostQuery = !this.requisicoesQuery.isEmpty();
                    }
                } else if (stream == 701 && function == 6) {
                    this.responderRequest(fields);
                } else if (stream == 702 && function == 3) {
                    fields.remove(0);
                    fields.remove(0);
                    String acession = (String)fields.remove(0);
                    fields.remove(0);
                    String sector = (String)fields.remove(0);
                    String cup = (String)fields.remove(0);
                    String sampleId = ((String)fields.remove(0)).trim();
                    String emi_alternativo = ((String)fields.remove(0)).trim();
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    String resultado = (String)fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    String req_codigo = "";
                    String fil_codigo = "";
                    String rec_codigo = "";
                    String rack = sector + "," + cup + "," + acession;
                    req_codigo = this.getRequisicaoRack(rack);
                    if (Funcoes.textoVazio(req_codigo)) {
                        req_codigo = sampleId;
                    }
                    if (Funcoes.textoVazio(req_codigo) || req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
                        return "Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo;
                    }
                    DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
                    if (descritorCodigoEtiqueta == null) {
                        fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                        rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                        req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                    } else {
                        fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        return "Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo;
                    }
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    } else {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        dados.put(campo, this.arrumaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo));
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                    }
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            return "";
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    private void responderRequest(List<String> fields) throws IOException, SQLException {
        for (String field : fields) {
            this.hostQuery = true;
            String sampleId = field.trim();
            if (Funcoes.textoVazio(sampleId)) continue;
            int tamConf = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (sampleId.length() != tamConf) {
                this.fireExcecaoEncontrada(String.format("Solicita\u00e7\u00e3o recebida do aparelho para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: %s tamanho recebido: %s Tamanho conf.: %s ", sampleId, String.valueOf(sampleId.length()), String.valueOf(tamConf)));
                continue;
            }
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(sampleId);
            String fil_codigo = "";
            String req_codigo = "";
            String rec_codigo = "";
            if (descritorCodigoEtiqueta == null) {
                fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            } else {
                fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            PanelAbaAbstrata aba = this.getAba(0);
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo);
            if (req == null) {
                this.fireExcecaoEncontrada(String.format("Solicita\u00e7\u00e3o recebida do aparelho n\u00e3o localizada ou n\u00e3o interfaceada: %s", sampleId));
                continue;
            }
            String exa_codigo = ((String)req[aba.getColIndice("Exame")]).trim();
            String int_codigo = (String)req[aba.getColIndice("Interface")];
            String mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            if (!Funcoes.isNumeric(fil_codigo)) {
                this.fireExcecaoEncontrada(String.format("Codigo da filial n\u00e3o num\u00e9rico: %s", sampleId));
                continue;
            }
            if (!Funcoes.isNumeric(int_codigo)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da interface n\u00e3o \u00e9 num\u00e9rico: %s", sampleId));
                continue;
            }
            if (!Funcoes.isNumeric(mco_codigo)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo do material n\u00e3o \u00e9 num\u00e9rico: %s", sampleId));
                continue;
            }
            if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                this.tuboPai = (String)req[aba.getColIndice("Tubo")];
                req[aba.getColIndice((String)"Tubo")] = rec_codigo;
                this.curva = true;
            }
            req[aba.getColIndice((String)"Cod. Apoiado")] = sampleId;
            this.requisicoesQuery.add(req);
        }
        if (!this.requisicoesQuery.isEmpty()) {
            this.confirmacaoHostQuery = true;
        }
    }

    private void enviaRequisicaoQuery(Object[] req) {
        PanelAbaAbstrata aba = this.getAba(0);
        int colExame = aba.getColIndice("Exame");
        String tmp = (String)req[aba.getColIndice("C\u00f3digo")];
        if (Funcoes.textoVazio(tmp)) {
            tmp = (String)req[aba.getColIndice("Multiguia")];
        }
        String fil_codigo = tmp.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = tmp.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = (String)req[aba.getColIndice("Tubo")];
        String exames = (String)req[aba.getColIndice("Exame")];
        String pac_nome = (String)req[aba.getColIndice("Paciente")];
        String pac_sexo = (String)req[aba.getColIndice("S")];
        String pac_idade = (String)req[aba.getColIndice("Ide")];
        String int_codigo = (String)req[aba.getColIndice("Interface")];
        String data = (String)req[aba.getColIndice("Data")];
        String hora = (String)req[aba.getColIndice("Hora")];
        String mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
        String cod_apoiado = (String)req[aba.getColIndice("Cod. Apoiado")];
        if (!Funcoes.textoVazio(exames)) {
            if (Funcoes.textoVazio(cod_apoiado)) {
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "00,00", null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, "N");
            } else {
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("codigoApoiado", cod_apoiado);
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "00,00", null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, "N", maps);
            }
        }
    }

    private void enviarProximaRequisicao(PanelAbaAbstrata aba) {
        if (aba == null) {
            return;
        }
        int colRack = aba.getColIndice("Rack");
        int colExames = aba.getColIndice("Exame");
        int colSituacao = aba.getColIndice("Sit");
        for (int i = 0; i < aba.getRowCount(); ++i) {
            String situacao;
            String rack = (String)aba.getValueAt(i, colRack);
            String string = colSituacao == -1 ? PanelAbaAbstrata.SIT_NAO_ENVIADO : (situacao = (String)aba.getValueAt(i, colSituacao));
            if (Funcoes.textoVazio(rack)) continue;
            if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_NAO_ENVIADO)) {
                if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) continue;
            }
            String exames = (String)aba.getValueAt(i, colExames);
            aba.transmiteExames(i, exames);
            return;
        }
        try {
            this.rackIniciada = false;
            this.inicioRack = false;
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (acao.equalsIgnoreCase("C")) {
                return "";
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome).replaceAll("  ", " ");
            String nome = null;
            String nomeDoMeio = "";
            String ultimoNome = short_name;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (names.length <= 2) {
                    ultimoNome = names[1];
                } else {
                    ultimoNome = names[names.length - 1];
                    nomeDoMeio = names.length > 3 ? String.format("%s%s", names[1].substring(0, 1), names[2].substring(0, 1)) : names[1].substring(0, 1);
                }
            }
            String[] tmp = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String idade = tmp[0];
            String tipoIdade = tmp[1];
            String dataNasc = tmp[2];
            dataNasc = !Funcoes.textoVazio(dataNasc) ? Funcoes.formataData("ddMMyy", dataNasc) : StringUtil.repeteCaractere(' ', 6);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] outros = BDUtil.getExameDesmembradosTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, mco_codigo);
            exa_lista = this.examesTubo(exa_lista, outros);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
            for (ExameMaterial e : alternativos) {
                if (e == null || Funcoes.textoVazio(e.getNomeExame()) || temporario.contains(e)) continue;
                temporario.add(e);
            }
            alternativos = new ExameMaterial[temporario.size()];
            for (int i = 0; i < temporario.size(); ++i) {
                alternativos[i] = (ExameMaterial)temporario.get(i);
            }
            String sector = rackposition.substring(0, rackposition.indexOf(","));
            String cup = (rackposition = rackposition.substring(rackposition.indexOf(",") + 1)).indexOf(",") > 0 ? rackposition.substring(0, rackposition.indexOf(",")) : rackposition;
            sector = StringUtil.preencheString(sector, 2, '0', 1);
            cup = StringUtil.preencheString(cup, 2, '0', 1);
            StringBuilder codigo = new StringBuilder();
            String codigoBarras = "";
            codigoBarras = mapaParametros != null && mapaParametros.get("codigoApoiado") != null ? mapaParametros.get("codigoApoiado") : Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(codigoBarras);
            if (descritorCodigoEtiqueta != null) {
                codigo.append(StringUtil.preencheString(descritorCodigoEtiqueta.getFilialApoio() != null ? descritorCodigoEtiqueta.getFilialApoio() : descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial(), '0', 1));
            } else {
                codigo.append(StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1));
            }
            codigo.append(StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
            codigo.append(StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
            StringBuilder msg = new StringBuilder();
            msg.append(this.getMsgStart());
            msg.append("00,");
            msg.append("701,");
            msg.append("01,");
            msg.append(sector).append(",");
            msg.append(cup).append(",");
            msg.append("1,");
            msg.append("RO,");
            msg.append("SE,");
            msg.append(this.formataTamanho(codigo.toString(), 11)).append(",");
            msg.append(StringUtil.repeteCaractere(' ', 20)).append(",");
            msg.append(StringUtil.repeteCaractere(' ', 25)).append(",");
            msg.append(StringUtil.repeteCaractere(' ', 25)).append(",");
            msg.append(this.formataTamanho(ultimoNome, 18)).append(",");
            msg.append(this.formataTamanho(nome, 15)).append(",");
            msg.append(this.formataTamanho(nomeDoMeio, 1)).append(",");
            msg.append(this.formataTamanho("", 12)).append(",");
            msg.append(this.formataTamanho("", 18)).append(",");
            msg.append(Funcoes.formataData("ddMMyy", new Date())).append(",");
            msg.append(Funcoes.formataData("hhmm", new Date())).append(",");
            msg.append(this.formataTamanho("", 20)).append(",");
            msg.append(this.formataTamanho("", 3)).append(",");
            msg.append(" ").append(",");
            msg.append(dataNasc).append(",");
            msg.append(pac_sexo).append(",");
            msg.append(this.formataTamanho("", 25)).append(",");
            msg.append(this.formataTamanho("", 7)).append(",");
            msg.append(this.formataTamanho("", 4)).append(",");
            msg.append(this.formataTamanho("", 4)).append(",");
            msg.append(this.formataTamanho("", 6)).append(",");
            msg.append(StringUtil.preencheString(Integer.toString(alternativos.length), 3, '0', 1)).append(",");
            for (int i = 0; i < alternativos.length; ++i) {
                if (i > 0) {
                    msg.append(",");
                }
                ExameMaterial temp = alternativos[i];
                msg.append(StringUtil.preencheString(temp.getNomeExame(), 4, ' ', 0)).append(",0");
            }
            msg.append("]");
            msg.append(this.getChecksumMod256(msg.toString()));
            msg.append(LINE);
            String[] exas = exames.split(" ", 0);
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exas[0], mco_codigo, rec_codigo);
            String tubo = rec_codigo;
            if (this.curva && !Funcoes.textoVazio(this.tuboPai)) {
                tubo = this.tuboPai;
            }
            this.ultimaRequisicao = new Requisicao(fil_codigo, req_codigo, tubo, mco_codigo, int_codigo, exas, sector, cup, situacao, this.curva);
            this.ultimoFrame = msg.toString();
            this.countTx = 0;
            this.getPortaCOM().write(msg.toString());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private ExameMaterial[] examesTubo(ExameMaterial[] exa_lista, ExameMaterial[] outros) {
        ArrayList<ExameMaterial> nova_lista = new ArrayList<ExameMaterial>();
        for (ExameMaterial ex : exa_lista) {
            nova_lista.add(ex);
        }
        for (ExameMaterial exm : outros) {
            String exa_codigo = exm.getString();
            String mco_codigo = exm.getCodigo().toString();
            boolean jaExiste = false;
            for (ExameMaterial ex : exa_lista) {
                if (!exa_codigo.equals(ex.getString()) || !exa_codigo.equals(ex.getCodigo().toString())) continue;
                jaExiste = true;
                break;
            }
            if (jaExiste) continue;
            nova_lista.add(exm);
        }
        ExameMaterial[] retorno = nova_lista.toArray(new ExameMaterial[nova_lista.size()]);
        return retorno;
    }

    private String formataTamanho(String texto, int tam) {
        return String.format("%s%s", texto, StringUtil.repeteCaractere(' ', tam)).substring(0, tam);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        String checksum = Integer.toHexString(256 - sum % 256).toUpperCase();
        checksum = StringUtil.preencheString(checksum, 2, '0', 1);
        return checksum.substring(checksum.length() - 2);
    }

    private String arrumaValor(String valor, String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) {
        if (valor.endsWith(".")) {
            valor = valor + "0";
        }
        if (valor.startsWith(".")) {
            valor = "0" + valor;
        }
        int idxVirgula = valor.indexOf(".");
        String mask = "0";
        if (idxVirgula >= 0 && idxVirgula < 8) {
            mask = "0." + StringUtil.preencheString("", 8 - idxVirgula, '0', 1);
        }
        if (Funcoes.isNumeric(valor)) {
            Double d = Double.valueOf(valor);
            valor = Funcoes.formataDecimal(mask, d);
            valor = this.arrendondaValor(valor, fil_codigo, exa_codigo, mco_codigo, int_codigo);
            valor = valor.replaceAll("\\.", ",");
        }
        return valor;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String amostra1 = "010001116241";
        String amostra2 = "010001116242";
        String amostra3 = "010001116243";
        String amostra4 = "010001116244";
        tmp.setLength(0);
        tmp.append("[[SP]0,701,06,").append(amostra1).append(",").append(amostra2).append(",").append(amostra3).append(",").append(amostra4).append("[SP]");
        tmp.append(",[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP],[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]");
        tmp.append(",[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP],[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]]B2[LINE]");
        tmp.setLength(0);
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "Confirma\u00e7\u00e3o envio", "Resultado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoOK();
        } else if (op == 2) {
            this.resultado();
        }
    }

    private void resultado() {
        StringBuilder tmp = new StringBuilder();
        String amostra1 = JOptionPane.showInputDialog("Informe o Id da amostra?");
        String amostra2 = "010001116242";
        String amostra3 = "010001116243";
        String amostra4 = "010001116244";
        tmp.setLength(0);
        tmp.append("[[SP]0,702,03,110213,163951,18196,[SP][SP][SP][SP][SP][SP]163,41,[SP]1," + amostra1 + ",1[SP][SP][SP],###,######,75,[SP]1,[SP][SP][SP][SP][SP][SP][SP]32.5,#########,2,0,[SP]0,");
        tmp.append("NA,NR,NA,0,NA,86.339676,[SP][SP][SP][SP][SP][SP][SP][SP][SP],NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,1.0000,NR,####################]B2[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    private void query() {
        StringBuilder tmp = new StringBuilder();
        String amostra1 = JOptionPane.showInputDialog("Informe o Id da amostra?");
        String amostra2 = "[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]";
        String amostra3 = "[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]";
        String amostra4 = "[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]";
        tmp.setLength(0);
        tmp.append("[[SP]0,701,06,").append(amostra1).append(",").append(amostra2).append(",").append(amostra3).append(",").append(amostra4).append("[SP]");
        tmp.append(",[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP],[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]");
        tmp.append(",[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP],[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]]B2[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
        this.handShakeCharReceived('\u0004');
        this.handShakeCharReceived('\u0006');
    }

    private void confirmacaoOK() {
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        tmp.append("[[SP]0,701,02,[SP]0,[SP][SP][SP][SP]0,[SP]0,[SP]0,7000011162;]EF[LINE]");
    }

    class Requisicao {
        private String fil_codigo;
        private String req_codigo;
        private String rec_codigo;
        private String int_codigo;
        private String mco_codigo;
        private String[] exames;
        private String sector;
        private String cup;
        private int situacao;
        private boolean curva;

        public Requisicao(String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, String[] exames, String sector, String cup, int situacao, boolean curva) {
            this.fil_codigo = fil_codigo;
            this.req_codigo = req_codigo;
            this.rec_codigo = rec_codigo;
            this.mco_codigo = mco_codigo;
            this.int_codigo = int_codigo;
            this.exames = exames;
            this.sector = sector;
            this.cup = cup;
            this.situacao = situacao;
            this.curva = curva;
        }

        public String getFil_codigo() {
            return this.fil_codigo;
        }

        public String getReq_codigo() {
            return this.req_codigo;
        }

        public String getRec_codigo() {
            return this.rec_codigo;
        }

        public String getInt_codigo() {
            return this.int_codigo;
        }

        public String getMco_codigo() {
            return this.mco_codigo;
        }

        public String[] getExames() {
            return this.exames;
        }

        public String getSector() {
            return this.sector;
        }

        public String getCup() {
            return this.cup;
        }

        public int getSituacao() {
            return this.situacao;
        }

        public boolean isCurva() {
            return this.curva;
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

