/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.beckmancx;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.interfaces.beckmancx.EnvioRackListener;
import jalis.laboratorio.interfaceamento.interfaces.beckmancx.InterfaceListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.Statement;
import java.util.ArrayList;

class ThreadEnvio
extends Thread {
    private ArrayList requisicoes;
    private ArrayList<EnvioRackListener> listeners = new ArrayList();
    private int indexRequisicao;
    private int indexRack;
    private int indexTubo;
    private int indexInterface;
    private PanelAbaAbstrata aba;
    private boolean repeticao;

    public void addEnvioRackListener(EnvioRackListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEnvioRackListener(EnvioRackListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public ThreadEnvio(ArrayList requisicoes, int indexRequisicao, int indexRack, int indexTubo, int indexInterface, PanelAbaAbstrata aba, boolean repeticao) {
        this.requisicoes = requisicoes;
        this.indexRequisicao = indexRequisicao;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.aba = aba;
        this.indexInterface = indexInterface;
        this.repeticao = repeticao;
    }

    @Override
    public void run() {
        if (this.requisicoes.size() == 0) {
            for (EnvioRackListener l : this.listeners) {
                l.envioFinalizado();
            }
            return;
        }
        Object[] r = (Object[])this.requisicoes.get(0);
        String fil_codigo = (String)r[this.indexRequisicao];
        fil_codigo = fil_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)r[5];
        ConfiguracaoSerial c = this.aba.getConfiguracaoPorta(fil_codigo, int_codigo);
        InterfaceListener listener = (InterfaceListener)c.getInterfacementoListener();
        ArrayList<Object[]> reqs = new ArrayList<Object[]>();
        Object[] reqOld = (Object[])this.requisicoes.remove(0);
        String exames = reqOld[2].toString();
        int contExames = 1;
        while (this.requisicoes.size() > 0) {
            Object[] req = (Object[])this.requisicoes.remove(0);
            if (reqOld[0].toString().equalsIgnoreCase(req[0].toString()) && reqOld[3].toString().equalsIgnoreCase(req[3].toString())) {
                exames = exames + " " + req[2].toString();
                ++contExames;
                reqOld[2] = exames;
                reqs.add(reqOld);
                Object[] reqTemp = new Object[reqOld.length];
                for (int i = 0; i < reqOld.length; ++i) {
                    reqTemp[i] = reqOld[i];
                }
                reqOld = reqTemp;
                reqOld[2] = "";
                exames = "";
                contExames = 0;
                continue;
            }
            reqOld[2] = exames;
            reqs.add(reqOld);
            reqOld = req;
            exames = req[2].toString();
            contExames = 1;
        }
        reqOld[2] = exames;
        if (!Funcoes.textoVazio(exames)) {
            reqs.add(reqOld);
        }
        try {
            Statement st = Conexao.getStatement();
            block7: while (reqs.size() > 0) {
                Object[] requisicao = (Object[])reqs.remove(0);
                String req = requisicao[0].toString();
                String rec = requisicao[4].toString();
                for (int row = 0; row < this.aba.getRowCount(); ++row) {
                    String reqNew = this.aba.getValueAt(row, this.indexRequisicao).toString();
                    String recNew = this.aba.getValueAt(row, this.indexTubo).toString();
                    if (!req.equalsIgnoreCase(reqNew) || !rec.equalsIgnoreCase(recNew)) continue;
                    fil_codigo = (String)this.aba.getValueAt(row, this.aba.getColIndice("C\u00f3digo"));
                    String req_codigo = fil_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    fil_codigo = fil_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String mco_codigo = (String)this.aba.getValueAt(row, this.aba.getColIndice("C\u00f3d. Mat."));
                    String rec_codigo = (String)this.aba.getValueAt(row, this.aba.getColIndice("Tubo"));
                    BDUtil.setExmSituacaoRackTubo(st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, this.repeticao ? 5 : 0, (String)requisicao[3]);
                    this.aba.setValueAt(requisicao[3], row, this.indexRack);
                    continue block7;
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            listener.iniciarTransmissaoRack(this.aba);
            Thread.sleep(500L);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (EnvioRackListener l : this.listeners) {
            l.envioFinalizado();
        }
    }

    private boolean verificaRequisicaoTransmitida(String requisicao) {
        for (int j = 0; j < this.aba.getRowCount(); ++j) {
            String requisicaoExame = this.aba.getValueAt(j, this.indexRequisicao).toString();
            if (!requisicao.equalsIgnoreCase(requisicaoExame)) continue;
            return false;
        }
        return true;
    }
}

