/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.beckmancx;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.beckmancx.EnvioRackListener;
import jalis.laboratorio.interfaceamento.interfaces.beckmancx.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.beckmancx.ThreadEnvio;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RequisicaoRack
extends JDialog
implements ActionListener,
EnvioRackListener {
    private AbstractInterfaceamento equip;
    private InterfaceConfiguracao configuracao;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private int MAX_RACK = 30;
    private int MAX_CUBETA = 10;
    private ArrayList exames;
    private int indexRequisicao;
    private int indexNomePaciente;
    private int indexExame;
    private int indexRack;
    private int indexTubo;
    private int indexAparelho;
    private int indexMaterial;
    private boolean repeticao;
    private PanelAbaAbstrata aba;
    private TTextField textCodigoBarras = ComponenteFactory.novoTTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textRack = ComponenteFactory.novoTTextField(6, 1);
    private TTextField textCubeta = ComponenteFactory.novoTTextField(6, 1);
    private JComboBox comboExames = ComponenteFactory.novoJComboBox(this);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame", "Rack", "Tubo"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new FlowLayout(2));
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private ArrayList requisicoes = new ArrayList();

    public RequisicaoRack(JFrame parent, AbstractInterfaceamento equip, ArrayList exames, int indexRequisicao, int indexNomePaciente, int indexExame, int indexRack, int indexTubo, int indexAparelho, int indexMaterial, PanelAbaAbstrata aba, boolean repeticao) {
        super(parent);
        this.equip = equip;
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.indexAparelho = indexAparelho;
        this.indexMaterial = indexMaterial;
        this.repeticao = repeticao;
        this.aba = aba;
        Object[] r = (Object[])exames.get(0);
        String fil_codigo = (String)r[indexRequisicao];
        fil_codigo = fil_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)r[5];
        ConfiguracaoSerial c = aba.getConfiguracaoPorta(fil_codigo, int_codigo);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        try {
            this.MAX_RACK = Integer.parseInt(this.configuracao.getQtdeRack());
            this.MAX_CUBETA = Integer.parseInt(this.configuracao.getQtdeCubetasPorRack());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(0);
        this.configTela();
    }

    private void configTela() {
        this.setPreferredSize(new Dimension(750, 350));
        this.setTitle("Rack");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.tableModel.setColumnSize(new int[]{100, 0, 80, 50, 1}, this.tableRequisicao);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Exame(s)"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Rack"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Cubeta"), c);
        this.textCodigoBarras.setPreferredSize(new Dimension(130, 20));
        this.textCodigoBarras.setMinimumSize(new Dimension(130, 20));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.panelRoot.add((Component)this.textCodigoBarras, c);
        this.textNomePaciente.setPreferredSize(new Dimension(250, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(250, 20));
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        ++c.gridx;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        this.comboExames.setPreferredSize(new Dimension(100, 20));
        this.comboExames.setMinimumSize(new Dimension(100, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.comboExames, c);
        this.textRack.setPreferredSize(new Dimension(65, 20));
        this.textRack.setMinimumSize(new Dimension(65, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.textRack, c);
        this.textCubeta.setPreferredSize(new Dimension(65, 20));
        this.textCubeta.setMinimumSize(new Dimension(65, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.textCubeta, c);
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 7;
        this.panelRoot.add((Component)this.scrollTable, c);
        this.panelButton.add(this.buttonEnviar);
        this.panelButton.add(this.buttonCancelar);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.textCodigoBarras.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RequisicaoRack.this.loadExamesRequisicao();
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (RequisicaoRack.this.tableRequisicao.getSelectedRowCount() > 0 && e.getKeyCode() == 127) {
                    RequisicaoRack.this.requisicoes.remove(RequisicaoRack.this.tableRequisicao.getSelectedRow());
                    RequisicaoRack.this.populateTable();
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private boolean validaRequisicao(boolean adicionaLista) throws SQLException {
        int i;
        String requisicao = this.textCodigoBarras.getText();
        boolean achou = false;
        if (Funcoes.textoVazio(requisicao)) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o preenchida!", 5);
            return false;
        }
        if (this.comboExames.getSelectedItem() == null) {
            Funcoes.mensagem(this, "Exame n\u00e3o selecionado!", 5);
            return false;
        }
        if (this.requisicoes.size() > 0) {
            for (i = 0; i < this.requisicoes.size(); ++i) {
                Object[] req = (Object[])this.requisicoes.get(i);
                String r = req[0].toString();
                String rack = req[3].toString();
                String exame = req[2].toString();
                String rack_new = this.textRack.getText() + "," + this.textCubeta.getText();
                if (!r.equalsIgnoreCase(requisicao) && rack_new.equalsIgnoreCase(rack) && !this.repeticao) {
                    Funcoes.mensagem(this, "Rack j\u00e1 adicionada!", 5);
                    return false;
                }
                String examesCombo = this.comboExames.getSelectedItem().toString();
                if (!req[this.indexRequisicao].toString().equalsIgnoreCase(requisicao) || examesCombo.indexOf(exame) < 0 || this.repeticao) continue;
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o j\u00e1 adicionada!", 5);
                return false;
            }
        }
        if (requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            requisicao = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        }
        for (i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            String fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = linha[this.indexAparelho].toString();
            String mco_codigo = linha[this.indexMaterial].toString();
            if (!req.equalsIgnoreCase(requisicao) || !this.comboExames.getSelectedItem().equals(linha[this.indexExame])) continue;
            if (adicionaLista) {
                String exaReq = linha[this.indexExame].toString();
                String[] exasOld = exaReq.split(" ");
                ArrayList<String> exames = new ArrayList<String>();
                for (String s : exasOld) {
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, s, mco_codigo)) {
                        ExameMaterial[] filhos;
                        for (ExameMaterial e : filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, s, mco_codigo)) {
                            if (exames.contains(e.getNomeExame())) continue;
                            exames.add(e.getNomeExame());
                        }
                        continue;
                    }
                    if (exames.contains(s)) continue;
                    exames.add(s);
                }
                for (int j = 0; j < exames.size(); ++j) {
                    String s = (String)exames.get(j);
                    Object[] line = new Object[]{req, linha[this.indexNomePaciente].toString(), s, this.textRack.getText() + "," + this.textCubeta.getText(), linha[this.indexTubo].toString(), int_codigo};
                    this.requisicoes.add(line);
                }
            }
            achou = true;
        }
        if (!achou) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada!", 5);
        }
        return achou;
    }

    private void loadExamesRequisicao() {
        String requisicao = this.textCodigoBarras.getText();
        if (Funcoes.textoVazio(requisicao)) {
            return;
        }
        if (requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return;
        }
        this.comboExames.removeAllItems();
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                if (!req.equalsIgnoreCase(requisicao)) continue;
                this.comboExames.addItem(linha[this.indexExame]);
                this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                continue;
            }
            String tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String rq = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String tb = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            if (!req.equalsIgnoreCase(rq) || !tubo.equalsIgnoreCase(tb)) continue;
            this.comboExames.addItem(linha[this.indexExame]);
            this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
        }
        if (this.comboExames.getItemCount() > 1) {
            this.comboExames.setEnabled(true);
        } else {
            this.addRequisicao();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.requisicoes.clear();
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar && this.validarLote()) {
            this.enviar();
        }
    }

    private void addRequisicao() {
        try {
            if (Funcoes.textoVazio(this.textRack.getText())) {
                Funcoes.mensagem(this, "Rack n\u00e3o preenchida!", 5);
                return;
            }
            if (Funcoes.textoVazio(this.textCubeta.getText())) {
                Funcoes.mensagem(this, "Cubeta n\u00e3o preenchida!", 5);
                return;
            }
            if (this.validaRequisicao(false)) {
                this.validaRequisicao(true);
                int cubeta = Integer.parseInt(this.textCubeta.getText()) + 1;
                int rack = Integer.parseInt(this.textRack.getText());
                if (cubeta > this.MAX_CUBETA) {
                    cubeta = 1;
                    ++rack;
                }
                if (rack > this.MAX_RACK) {
                    rack = 1;
                }
                this.populateTable();
                this.textNomePaciente.setText("");
                this.comboExames.removeAllItems();
                this.textRack.setText(Integer.toString(rack));
                this.textCubeta.setText(Integer.toString(cubeta));
                this.textCodigoBarras.setText("");
                this.textCodigoBarras.grabFocus();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (384)");
        }
        catch (SQLException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (387)");
        }
    }

    private void populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            Object[] o = (Object[])this.requisicoes.get(i);
            this.tableModel.addLine(o);
        }
        this.tableRequisicao.setModel(this.tableModel);
    }

    private void editaRequisicao() {
        int row = this.tableRequisicao.getSelectedRow();
        Object[] req = (Object[])this.requisicoes.get(row);
        this.textCodigoBarras.setText(req[this.indexRequisicao].toString());
        this.textNomePaciente.setText(req[this.indexNomePaciente].toString());
        String[] rack = req[this.indexRack].toString().split("\\^", 0);
        String r = rack[1];
        this.textRack.setText(r.substring(0, r.indexOf(",")));
        this.textCubeta.setText(r.substring(r.indexOf(",") + 1));
        this.textCubeta.grabFocus();
    }

    public ArrayList getRequisicoes() {
        return this.requisicoes;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equip.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equip.examesPendentes).getExames();
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            String rack;
            Object[] req = (Object[])this.requisicoes.get(i);
            int requisicao = Integer.parseInt(req[this.indexRequisicao].toString());
            int row = this.validaExisteExame(requisicao);
            if (row < 0 || req[3] == null || !this.validaExisteExamePendente(rack = req[3].toString(), pendentes)) continue;
            Funcoes.mensagem(this, "A rack " + rack + " j\u00e1 esta cadastrada\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = (Object[])this.exames.get(i);
            int requisicaoExame = Integer.parseInt(exame[this.indexRequisicao].toString());
            if (requisicao != requisicaoExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(String contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            String contadorExame;
            Object[] pendente = (Object[])pendentes.get(i);
            if (pendente[this.indexRack] == null || !contador.equalsIgnoreCase(contadorExame = pendente[this.indexRack].toString())) continue;
            return true;
        }
        return false;
    }

    private void enviar() {
        ThreadEnvio envio = new ThreadEnvio(this.requisicoes, this.indexRequisicao, this.indexRack, this.indexTubo, this.indexAparelho, this.aba, this.repeticao);
        this.buttonEnviar.setEnabled(false);
        this.buttonCancelar.setEnabled(false);
        envio.addEnvioRackListener(this);
        envio.start();
    }

    @Override
    public void envioFinalizado() {
        this.setVisible(false);
    }
}

