/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.beckmancx;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char LB = '\u0001';
    public static final char LBO = '\u0002';
    private boolean lastAck = false;
    private boolean inicioRack = false;
    private boolean rackIniciada = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private Requisicao ultimaRequisicao = null;
    private PanelAbaAbstrata abaRack = null;

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (!message.equals("")) {
                        if (message.length() == 1) {
                            char c = message.charAt(0);
                            if (c == '\u0003' || c == '\u0004' || c == '\u0006' || c == '\u0001' || c == '\u0015') {
                                InterfaceListener.this.getPortaCOM().clearInputString();
                                InterfaceListener.this.handShakeCharReceived(c);
                            }
                            return;
                        }
                        message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                        if (!message.equals("")) {
                            InterfaceListener.this.getPortaCOM().write(InterfaceListener.this.lastAck ? String.valueOf('\u0003') : String.valueOf('\u0006'));
                            InterfaceListener.this.lastAck = !InterfaceListener.this.lastAck;
                            InterfaceListener.this.addListaRecebimento(message);
                            InterfaceListener.this.restartThreadRecebimento();
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0001': {
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                            InterfaceListener.this.lastAck = true;
                            break;
                        }
                        case '\u0003': 
                        case '\u0006': {
                            if (!InterfaceListener.this.inicioRack) break;
                            if (!InterfaceListener.this.rackIniciada) {
                                InterfaceListener.this.rackIniciada = true;
                                InterfaceListener.this.enviarProximaRequisicao(InterfaceListener.this.abaRack);
                                break;
                            }
                            InterfaceListener.this.rackIniciada = false;
                            InterfaceListener.this.inicioRack = false;
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0004'));
                            break;
                        }
                        case '\u0015': {
                            if (!InterfaceListener.this.inicioRack) break;
                            InterfaceListener.this.rackIniciada = false;
                            break;
                        }
                        case '\u0004': {
                            InterfaceListener.this.iniciarTransmissaoRack(InterfaceListener.this.abaRack);
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return "[";
    }

    public void iniciarTransmissaoRack(PanelAbaAbstrata abaRack) throws IOException, InterruptedException {
        this.inicioRack = true;
        this.rackIniciada = false;
        this.abaRack = abaRack;
        this.getPortaCOM().write(String.valueOf('\u0001'));
    }

    @Override
    public String parse(String message) {
        try {
            Statement st = Conexao.getStatement();
            int idx = message.indexOf("]");
            String checksum = message.substring(idx + 1, message.length());
            message = message.substring(1, idx);
            ArrayList<String> fields = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(message, ",");
            while (tokenizer.hasMoreElements()) {
                fields.add(tokenizer.nextToken());
            }
            if (fields != null && fields.size() > 0) {
                String device = (String)fields.remove(0);
                int stream = Integer.parseInt((String)fields.remove(0));
                int function = Integer.parseInt((String)fields.remove(0));
                if (stream == 401 && function == 2) {
                    if (this.ultimaRequisicao != null) {
                        fields.remove(0);
                        String acession = (String)fields.remove(0);
                        StringBuilder rack = new StringBuilder();
                        rack.append(StringUtil.preencheString(this.ultimaRequisicao.getSector(), 2, '0', 1));
                        rack.append(",");
                        rack.append(StringUtil.preencheString(this.ultimaRequisicao.getCup(), 2, '0', 1));
                        rack.append(",");
                        if (acession.trim().length() > 14) {
                            acession = acession.substring(0, 14);
                        }
                        rack.append(acession);
                        for (String e : this.ultimaRequisicao.getExames()) {
                            this.atualizarSituacaoExame(st, this.ultimaRequisicao.getFil_codigo(), this.ultimaRequisicao.getReq_codigo(), this.ultimaRequisicao.getRec_codigo(), e, this.ultimaRequisicao.getMco_codigo(), this.ultimaRequisicao.getInt_codigo(), rack.toString(), this.ultimaRequisicao.getSituacao() == 2 ? 3 : 1);
                        }
                        Conexao.arquivaSQL();
                    }
                } else if (stream == 402 && function == 3) {
                    fields.remove(0);
                    fields.remove(0);
                    String acession = (String)fields.remove(0);
                    fields.remove(0);
                    String sector = (String)fields.remove(0);
                    String cup = (String)fields.remove(0);
                    String emi_alternativo = ((String)fields.remove(0)).trim();
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    String resultado = (String)fields.remove(0);
                    String rack = sector + "," + cup + "," + acession;
                    String req_codigo = this.getRequisicaoRack(rack);
                    if (Funcoes.textoVazio(req_codigo) || req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        return "Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo;
                    }
                    String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo()), rec_codigo, emi_alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        return "Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo;
                    }
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    } else {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        dados.put(campo, this.arrumaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo));
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                    }
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            return "";
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    private void enviarProximaRequisicao(PanelAbaAbstrata aba) {
        if (aba == null) {
            return;
        }
        int colRack = aba.getColIndice("Rack");
        int colExames = aba.getColIndice("Exame");
        int colSituacao = aba.getColIndice("Sit");
        for (int i = 0; i < aba.getRowCount(); ++i) {
            String situacao;
            String rack = (String)aba.getValueAt(i, colRack);
            String string = colSituacao == -1 ? PanelAbaAbstrata.SIT_NAO_ENVIADO : (situacao = (String)aba.getValueAt(i, colSituacao));
            if (Funcoes.textoVazio(rack)) continue;
            if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_NAO_ENVIADO)) {
                if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) continue;
            }
            String exames = (String)aba.getValueAt(i, colExames);
            aba.transmiteExames(i, exames);
            return;
        }
        try {
            this.rackIniciada = false;
            this.inicioRack = false;
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            if (acao.equalsIgnoreCase("C")) {
                return "";
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            Statement st = Conexao.getStatement();
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
            for (ExameMaterial e : alternativos) {
                if (temporario.contains(e)) continue;
                temporario.add(e);
            }
            alternativos = new ExameMaterial[temporario.size()];
            for (int i = 0; i < temporario.size(); ++i) {
                alternativos[i] = (ExameMaterial)temporario.get(i);
            }
            String sector = rackposition.substring(0, rackposition.indexOf(","));
            String cup = (rackposition = rackposition.substring(rackposition.indexOf(",") + 1)).indexOf(",") > 0 ? rackposition.substring(0, rackposition.indexOf(",")) : rackposition;
            sector = StringUtil.preencheString(sector, 2, '0', 1);
            cup = StringUtil.preencheString(cup, 2, '0', 1);
            StringBuilder msg = new StringBuilder();
            msg.append(this.getMsgStart());
            msg.append("00,");
            msg.append("401,");
            msg.append("01,");
            msg.append("1,");
            msg.append(sector).append(",");
            msg.append(cup).append(",");
            msg.append("RO,");
            msg.append("SE,");
            msg.append(StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1));
            msg.append(StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
            msg.append(StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
            msg.append(",");
            msg.append("                         ,");
            msg.append("                         ,");
            msg.append("                              ,");
            msg.append("            ,");
            msg.append("               ,");
            msg.append(Funcoes.formataData("ddMMyy", new Date())).append(",");
            msg.append(Funcoes.formataData("hhmm", new Date())).append(",");
            msg.append("     ,");
            msg.append("0000,");
            msg.append("      ,");
            msg.append("M,");
            msg.append("                                                            ,");
            msg.append(StringUtil.preencheString(Integer.toString(alternativos.length), 2, '0', 1)).append(",");
            for (int i = 0; i < alternativos.length; ++i) {
                if (i > 0) {
                    msg.append(",");
                }
                ExameMaterial temp = alternativos[i];
                msg.append(StringUtil.preencheString(temp.getNomeExame(), 4, ' ', 0)).append(",0");
            }
            msg.append("]");
            msg.append(this.getChecksumMod256(msg.toString()));
            msg.append(LINE);
            String[] exas = exames.split(" ", 0);
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exas[0], mco_codigo, rec_codigo);
            this.ultimaRequisicao = new Requisicao(fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, exas, sector, cup, situacao);
            this.getPortaCOM().write(msg.toString());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        String checksum = Integer.toHexString(256 - sum % 256).toUpperCase();
        checksum = StringUtil.preencheString(checksum, 2, '0', 1);
        return checksum.substring(checksum.length() - 2);
    }

    private String arrumaValor(String valor, String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) {
        if (valor.endsWith(".")) {
            valor = valor + "0";
        }
        if (valor.startsWith(".")) {
            valor = "0" + valor;
        }
        int idxVirgula = valor.indexOf(".");
        String mask = "0";
        if (idxVirgula >= 0 && idxVirgula < 8) {
            mask = "0." + StringUtil.preencheString("", 8 - idxVirgula, '0', 1);
        }
        if (Funcoes.isNumeric(valor)) {
            Double d = Double.valueOf(valor);
            valor = Funcoes.formataDecimal(mask, d);
            valor = this.arrendondaValor(valor, fil_codigo, exa_codigo, mco_codigo, int_codigo);
            valor = valor.replaceAll("\\.", ",");
        }
        return valor;
    }

    class Requisicao {
        private String fil_codigo;
        private String req_codigo;
        private String rec_codigo;
        private String int_codigo;
        private String mco_codigo;
        private String[] exames;
        private String sector;
        private String cup;
        private int situacao;

        public Requisicao(String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, String[] exames, String sector, String cup, int situacao) {
            this.fil_codigo = fil_codigo;
            this.req_codigo = req_codigo;
            this.rec_codigo = rec_codigo;
            this.mco_codigo = mco_codigo;
            this.int_codigo = int_codigo;
            this.exames = exames;
            this.sector = sector;
            this.cup = cup;
            this.situacao = situacao;
        }

        public String getFil_codigo() {
            return this.fil_codigo;
        }

        public String getReq_codigo() {
            return this.req_codigo;
        }

        public String getRec_codigo() {
            return this.rec_codigo;
        }

        public String getInt_codigo() {
            return this.int_codigo;
        }

        public String getMco_codigo() {
            return this.mco_codigo;
        }

        public String[] getExames() {
            return this.exames;
        }

        public String getSector() {
            return this.sector;
        }

        public String getCup() {
            return this.cup;
        }

        public int getSituacao() {
            return this.situacao;
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

