/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc5800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocket;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7Socket.InterfaceHl7SocketListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7SocketListener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private HashMap<String, String> parametros = new HashMap();

    public InterfaceListener() {
        super("BC-5800");
        this.parametros.put("6690-2^WBC^LN", "leucocitos");
        this.parametros.put("704-7^BAS#^LN", "basofilos_contagem");
        this.parametros.put("706-2^BAS%^LN", "basofilos_percentual");
        this.parametros.put("751-8^NEU#^LN", "neutrofilo_contagem");
        this.parametros.put("770-8^NEU%^LN", "neutrofilo_percentual");
        this.parametros.put("711-2^EOS#^LN", "eosinofilos_contagem");
        this.parametros.put("713-8^EOS%^LN", "eosinofilos_percentual");
        this.parametros.put("731-0^LYM#^LN", "linfocitos_tipicos_contagem");
        this.parametros.put("736-9^LYM%^LN", "linfocitos_tipicos_percentual");
        this.parametros.put("742-7^MON#^LN", "monocitos_contagem");
        this.parametros.put("5905-5^MON%^LN", "monocitos_percentual");
        this.parametros.put("26477-0^*ALY#^LN", "linfocitos_atipicos_contagem");
        this.parametros.put("13046-8^*ALY%^LN", "linfocitos_atipicos_percentual");
        this.parametros.put("789-8^RBC^LN", "hemacias");
        this.parametros.put("718-7^HGB^LN", "hgb");
        this.parametros.put("787-2^MCV^LN", "vcm");
        this.parametros.put("785-6^MCH^LN", "hcm");
        this.parametros.put("786-4^MCHC^LN", "mchc");
        this.parametros.put("788-0^RDW-CV^LN", "rdw_cv");
        this.parametros.put("21000-5^RDW-SD^LN", "rdw_sd");
        this.parametros.put("4544-3^HCT^LN", "hct");
        this.parametros.put("777-3^PLT^LN", "plaquetas");
        this.parametros.put("32623-1^MPV^LN", "vpm");
        this.parametros.put("32207-3^PDW^LN", "pdw");
        this.parametros.put("10002^PCT^99MRC", "pct");
        this.parametros.put("10001^*LIC%^99MRC", "bastonados_percentual");
        this.parametros.put("10000^*LIC#^99MRC", "bastonados_contagem");
        this.parametros.put("10007^GainLasDiff^99MRC", "gain_las_diff");
        this.parametros.put("10008^GainMasDiff^99MRC", "gain_mas_diff");
        this.parametros.put("10009^GainLasBaso^99MRC", "gain_las_baso");
        this.parametros.put("10010^GainMasBaso^99MRC", "gain_mas_baso");
        this.parametros.put("12010^Basophilia^99MRC", "basophilia");
        this.parametros.put("10003^GRAN-X^99MRC", "gran_x");
        this.parametros.put("10004^GRAN-Y^99MRC", "gran_y");
        this.parametros.put("10005^GRAN-Y(W)^99MRC", "gran_y_w");
        this.parametros.put("10011^WBCBAX^99MRC", "wbc_ba_x");
        this.parametros.put("10012^WBCBAY^99MRC", "wbc_ba_y");
        this.parametros.put("15008^WBC Histogram. BMP^99MRC", "celldyn_histograma_wb1");
        this.parametros.put("15056^RBC Histogram. BMP^99MRC", "celldyn_histograma_rbc");
        this.parametros.put("15116^PLT Histogram. BMP^99MRC", "celldyn_histograma_plt");
        this.parametros.put("15200^WBC DIFF Scattergram. BMP^99MRC", "celldyn_histograma_wb2");
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Mindray");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                MessageSegmentObx obx;
                String emiAlternativo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = (obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "08003^Test Mode^99MRC")).getObservationValue());
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                for (String p : this.parametros.keySet()) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (obx == null) continue;
                    if (obx.getAbnormalFlag() != null) {
                        flags.add(obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        ImageIO.getCacheDirectory();
        File img = File.createTempFile("bc5800_" + reqCodigo, ".png");
        ImageIO.write((RenderedImage)image, "png", img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    public void dataChangedInput() {
        try {
            String message = ((PortaSocket)this.getPortaCOM()).removeStringInput(this.getMsgEnd(), true);
            if (message.contains(String.valueOf('\u0002'))) {
                message = message.replaceAll(String.valueOf('\u0002'), "");
            }
            if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
                this.parse(message);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dataChangedOutput() {
        try {
            String string = ((PortaSocket)this.getPortaCOM()).getStringOutput();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceivedInput(char c) {
    }

    @Override
    public void handShakeCharReceivedOutput(char c) {
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String req = JOptionPane.showInputDialog("Informe o Id da amostra");
        tmp.append("[SB]MSH|^~\\&|BC5800|MINDRAY|||20160818153246||ORU^R01|8|P|2.3.1||||||UNICODE[CR]".trim());
        tmp.append("PID|1||^^^^MR[CR]".trim());
        tmp.append("PV1|1[CR]".trim());
        tmp.append("OBR|1||" + req + "|00001^Automated[SP]Count^99MRC|||20160818153244|||||||||||||||||HM||||||||ADMIN[CR]".trim());
        tmp.append("OBX|1|IS|08001^Take[SP]Mode^99MRC||A||||||F[CR]".trim());
        tmp.append("OBX|2|IS|08002^Blood[SP]Mode^99MRC||W||||||F[CR]".trim());
        tmp.append("OBX|3|IS|08003^Test[SP]Mode^99MRC||CBC+5DIFF||||||F[CR]".trim());
        tmp.append("OBX|4|IS|01002^Ref[SP]Group^99MRC||Geral||||||F[CR]".trim());
        tmp.append("OBX|5|NM|6690-2^WBC^LN||6.15|10*3/uL|4.00-10.00||||F[CR]".trim());
        tmp.append("OBX|6|NM|704-7^BAS#^LN||0.02|10*3/uL|0.00-0.10||||F[CR]".trim());
        tmp.append("OBX|7|NM|706-2^BAS%^LN||0.4|%|0.0-1.0||||F[CR]".trim());
        tmp.append("OBX|8|NM|751-8^NEU#^LN||3.90|10*3/uL|2.00-7.00||||F[CR]".trim());
        tmp.append("OBX|9|NM|770-8^NEU%^LN||63.3|%|50.0-70.0||||F[CR]".trim());
        tmp.append("OBX|10|NM|711-2^EOS#^LN||0.10|10*3/uL|0.02-0.50||||F[CR]".trim());
        tmp.append("OBX|11|NM|713-8^EOS%^LN||1.7|%|0.5-5.0||||F[CR]".trim());
        tmp.append("OBX|12|NM|731-0^LYM#^LN||1.75|10*3/uL|0.80-4.00||||F[CR]".trim());
        tmp.append("OBX|13|NM|736-9^LYM%^LN||28.5|%|20.0-40.0||||F[CR]".trim());
        tmp.append("OBX|14|NM|742-7^MON#^LN||0.38|10*3/uL|0.12-1.20||||F[CR]".trim());
        tmp.append("OBX|15|NM|5905-5^MON%^LN||6.1|%|3.0-12.0||||F[CR]".trim());
        tmp.append("OBX|16|NM|26477-0^*ALY#^LN||0.04|10*3/uL|0.00-0.20||||F[CR]".trim());
        tmp.append("OBX|17|NM|13046-8^*ALY%^LN||0.7|%|0.0-2.0||||F[CR]".trim());
        tmp.append("OBX|18|NM|10000^*LIC#^99MRC||0.11|10*3/uL|0.00-0.20||||F[CR]".trim());
        tmp.append("OBX|19|NM|10001^*LIC%^99MRC||1.8|%|0.0-2.5||||F[CR]".trim());
        tmp.append("OBX|20|NM|789-8^RBC^LN||4.44|10*6/uL|3.50-5.50||||F[CR]".trim());
        tmp.append("OBX|21|NM|718-7^HGB^LN||13.4|g/dL|11.0-16.0||||F[CR]".trim());
        tmp.append("OBX|22|NM|787-2^MCV^LN||91.9|fL|80.0-100.0||||F[CR]".trim());
        tmp.append("OBX|23|NM|785-6^MCH^LN||30.2|pg|27.0-34.0||||F[CR]".trim());
        tmp.append("OBX|24|NM|786-4^MCHC^LN||32.8|g/dL|32.0-37.0||||F[CR]".trim());
        tmp.append("OBX|25|NM|788-0^RDW-CV^LN||12.9|%|11.0-15.0||||F[CR]".trim());
        tmp.append("OBX|26|NM|21000-5^RDW-SD^LN||43.8|fL|35.0-56.0||||F[CR]".trim());
        tmp.append("OBX|27|NM|4544-3^HCT^LN||40.8|%|37.0-54.0||||F[CR]".trim());
        tmp.append("OBX|28|NM|777-3^PLT^LN||132|10*3/uL|140-450|L|||F[CR]".trim());
        tmp.append("OBX|29|NM|32623-1^MPV^LN||11.3|fL|6.5-12.0||||F[CR]".trim());
        tmp.append("OBX|30|NM|32207-3^PDW^LN||17.1||9.0-17.0|H|||F[CR]".trim());
        tmp.append("OBX|31|NM|10002^PCT^99MRC||0.149|%|0.108-0.282||||F[CR]".trim());
        tmp.append("OBX|32|NM|10003^GRAN-X^99MRC||*||*-*||||F[CR]".trim());
        tmp.append("OBX|33|NM|10004^GRAN-Y^99MRC||*||*-*||||F[CR]".trim());
        tmp.append("OBX|34|NM|10005^GRAN-Y(W)^99MRC||*||*-*||||F[CR]".trim());
        tmp.append("OBX|35|NM|10011^WBCBAX^99MRC||36||*-*||||F[CR]".trim());
        tmp.append("OBX|36|NM|10012^WBCBAY^99MRC||28||*-*||||F[CR]".trim());
        tmp.append("OBX|37|NM|10007^GainLasDiff^99MRC||82.7|fL|***.*-***.*||||F[CR]".trim());
        tmp.append("OBX|38|NM|10008^GainMasDiff^99MRC||55.7|fL|***.*-***.*||||F[CR]".trim());
        tmp.append("OBX|39|NM|10009^GainLasBaso^99MRC||28.4|fL|***.*-***.*||||F[CR]".trim());
        tmp.append("OBX|40|NM|10010^GainMasBaso^99MRC||36.3|fL|***.*-***.*||||F[CR]".trim());
        tmp.append("OBX|41|NM|10013^PLCC^99MRC||67|10*9/L|30-90||||F[CR]".trim());
        tmp.append("OBX|42|NM|10014^PLCR^99MRC||50.8|%|11.0-45.0|H|||F[CR]".trim());
        tmp.append("OBX|43|IS|12018^Thrombopenia^99MRC||T||||||F[CR]".trim());
        tmp.append("OBX|44|NM|15051^RBC[SP]Histogram.[SP]Left[SP]Line^99MRC||39||||||F[CR]".trim());
        tmp.append("OBX|45|NM|15052^RBC[SP]Histogram.[SP]Right[SP]Line^99MRC||154||||||F[CR]".trim());
        tmp.append("OBX|46|NM|15053^RBC[SP]Histogram.[SP]Binary[SP]Meta[SP]Length^99MRC||1||||||F[CR]".trim());
        tmp.append("OBX|47|NM|15057^RBC[SP]Histogram.[SP]Total^99MRC||448||||||F[CR]".trim());
        tmp.append("OBX|48|ED|15050^RBC[SP]Histogram.[SP]Binary^99MRC||^Application^Octer-stream^Base64^AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAQEBAQEBAQEBAgICAwQFBggKDhEWHCQtND5KV2Z0iJmot8fT4On0/fz/+ffu4tzTxbammYl2bF5TST83LikjHRgVEQ4MCgkIBwYGBQQDAwICAgICAgICAgICAgICAgICAgICAgIDAwIDAgMDAwMDAwMDAwMDAwMDAwMDAgMCAgICAgECAgICAgICAgICAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==||||||F[CR]".trim());
        tmp.append("OBX|49|NM|15111^PLT[SP]Histogram.[SP]Left[SP]Line^99MRC||5||||||F[CR]".trim());
        tmp.append("OBX|50|NM|15112^PLT[SP]Histogram.[SP]Right[SP]Line^99MRC||123||||||F[CR]".trim());
        tmp.append("OBX|51|NM|15113^PLT[SP]Histogram.[SP]Binary[SP]Meta[SP]Length^99MRC||1||||||F[CR]".trim());
        tmp.append("OBX|52|NM|15117^PLT[SP]Histogram.[SP]Total^99MRC||133||||||F[CR]".trim());
        tmp.append("OBX|53|ED|15100^PLT[SP]Histogram.[SP]Binary^99MRC||^Application^Octer-stream^Base64^AAAABAoVJDZKW2tzdXd7foOMmaSstLi7wMHCxMvP0dXa4eXt8/z9///8+/f49fDt5NvPxLuvp6GblZCNjIiGhoN/e3p7eXt5d3JrZF1YVFJPTUpHREE9Ojc1MzEvLi4tLCwsKyoqKiknJyYkIyEfHRsaGRgYGBkZGxscHiEjJCY=||||||F[CR]".trim());
        tmp.append("OBX|54|NM|15203^WBC[SP]DIFF[SP]Scattergram.[SP]Meta[SP]len^99MRC||4||||||F[CR]".trim());
        tmp.append("OBX|55|NM|15204^WBC[SP]DIFF[SP]Scattergram.[SP]Meta[SP]count^99MRC||3922||||||F[CR]".trim());
        tmp.append("OBX|56|ED|15202^WBC[SP]DIFF[SP]Scattergram.[SP]BIN[SP]type[SP]data^99MRC||^Application^Octer-stream^Base64^AY8D+gFXAF0IFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA||||||F[CR]".trim());
        tmp.append("OBX|57|ED|15201^WBC[SP]DIFF[SP]Scattergram.[SP]BIN^99MRC||^Application^Octer-stream^Base64^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".trim());
        tmp.append("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".trim());
        tmp.append("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".trim());
        tmp.append("Wi8AAFrvAABbLwAAW28AAFwvAABdbwAAXm8AAF7vAABfrwAAX+8AAFovQABWb4AAVy+AAFevgABZr4AAWe+AAFovgABab4AAXC+AAFyvgABfL4AAX6+AAFuvwABcr8AAXO/AAF7vwABf78AAVnAAAFcwAABXcAAAW7AAAF8wAABb8IAAQ==||||||F[CR]".trim());
        tmp.append("OBX|58|NM|15253^Baso[SP]Scattergram.[SP]Meta[SP]Len^99MRC||4||||||F[CR]".trim());
        tmp.append("OBX|59|NM|15254^Baso[SP]Scattergram.[SP]Meta[SP]count^99MRC||1726||||||F[CR]".trim());
        tmp.append("OBX|60|ED|15252^Baso[SP]Scattergram.[SP]BIN[SP]type[SP]data^99MRC||^Application^Octer-stream^Base64^AAIAAAajABkAAA==||||||F[CR]".trim());
        tmp.append("OBX|61|ED|15251^Baso[SP]Scattergram.[SP]BIN^99MRC||^Application^Octer-stream^Base64^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".trim());
        tmp.append("PAABXjwAAfM8AAErPQABLj0AAS89AAEyPQABMz0AATQ9AAE1PQABOD0AATk9AAE6PQABOz0AATw9AAE9PQABPj0AAT89AAFAPQABQT0AAUI9AAFDPQABRD0AAUU9AAFGPQABSD0AAU49AAEmPgABKD4AASk+AAEqPgABKz4AASw+AAEtPgABLj4AAS8+AAEwPgABMT4AATI+AAEzPgABND4AATU+AAE2PgABNz4AATg+AAE5PgABOj4AATs+AAE8PgABPT4AAT4+AAE/PgABQD4AAUE+AAFDPgABRD4AAUY+AAFJPgABSj4AAUs+AAFPPgABKD8AASk/AAErPwABLD8AAS0/AAEuPwABMD8AATE/AAEyPwABMz8AATQ/AAE1PwABNj8AATc/AAE4PwABOT8AATo/AAE7PwABPD8AAT4/AAE/PwABQD8AAUE/AAFCPwABQz8AAUw/AAFPPwABrD8AASZAAAErQAABLEAAAS1AAAEuQAABL0AAATBAAAExQAABMkAAATNAAAE0QAABNUAAATZAAAE3QAABOEAAATlAAAE6QAABO0AAATxAAAE9QAABPkAAAT9AAAFAQAABQUAAAUJAAAFDQAABRUAAAUZAAAFJQAABSkAAAU5AAAFTQAABVEAAAVZAAAEuQQABL0EAATBBAAExQQABMkEAATNBAAE0QQABNUEAATZBAAE3QQABOEEAATtBAAE8QQABPkEAAT9BAAFFQQABIkIAASZCAAEoQgABL0IAATBCAAExQgABMkIAATNCAAE1QgABNkIAAThCAAE5QgABO0IAATxCAAE9QgABPkIAAT9CAAFAQgABQUIAAUJCAAFDQgABRUIAAUZCAAFHQgABS0IAASBDAAElQwABKEMAASlDAAEqQwABMEMAATFDAAEyQwABM0MAATRDAAE1QwABNkMAAThDAAE5QwABOkMAATtDAAE8QwABPUMAAUJDAAFGQwABUEMAAWxDAAEyRAABNUQAAThEAAE5RAABOkQAAUJEAAErRQABLkUAATBFAAExRQABMkUAATNFAAE0RQABNkUAATlFAAE7RQABQEUAAUlFAAEuRgABL0YAATBGAAEzRgABNUYAAUNGAAFJRgAB/0YAARZIAAEmSAABL0gAATNIAAE4SAABQEgAAUJIAAFGSAAB/0gAAS5JAAE7SQABLkoAASlLAAEvSwABQEsAATNMAAE0TAABMk4AATNOAAE8TgABPk8AAU9QAAHoUgABHFMAAVNTAAEwVQABwFUAAShYAAFcWwABOFwAAVlcAAFYXgABW18AAUBiAAFfZQABYmwAAf9sAAFMcAABXHAAAVlyAAHScwABMIUAAf+TAAF+nAABcLUAAXXOAAH//wABZkIAAVhIAAFYSQABZkkAAXBJAAFYSwABYksAAWxLAAFOTAABXEwAAWBMAAFgTgABWU8AAWBPAAFeUAABY1AAAWZQAAFgUgABY1IAAXJSAAFjVQABYFgAAWZcAAFsXAABeF4AAQ==||||||F[CR]".trim());
        tmp.append("[EB][CR] ttt".trim());
    }
}

