/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc5500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocket;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.padroes.socket.InterfaceSocketListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceSocketListener {
    private String NOME_EXAME = "HEMOG";
    public static final char BS = '\b';
    public static final char FF = '\f';
    public static final char DLE = '\u0010';
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void dataChangedInput() {
        Runnable run = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    String message = ((PortaSocket)InterfaceListener.this.getPortaCOM()).getStringInput();
                    ((PortaSocket)InterfaceListener.this.getPortaCOM()).writeInput(String.valueOf('\u0006'));
                    int idxENQ = message.indexOf(String.valueOf('\u0005'));
                    if (message == null || idxENQ < 0 || message.indexOf(String.valueOf('\u0002'), idxENQ) < 0) return;
                    int idxLF = message.lastIndexOf(String.valueOf('\n'));
                    if (message.equals("") || idxENQ < 0 || idxLF < 0 || idxENQ >= idxLF) return;
                    String tst = message.substring(idxENQ + 1, idxLF);
                    message = ((PortaSocket)InterfaceListener.this.getPortaCOM()).removeStringInput(idxLF);
                    String retorno = InterfaceListener.this.parse(tst);
                    ((PortaSocket)InterfaceListener.this.getPortaCOM()).writeInput(String.valueOf('\u0006'));
                    if (!InterfaceListener.this.isRX()) return;
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                        return;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            StringBuilder message = new StringBuilder();
            message.append(String.valueOf('\u0005'));
            message.append("CMD");
            message.append(String.valueOf('\u0003'));
            message.append("CTMR");
            message.append(String.valueOf('\f'));
            message.append("SampleID");
            message.append(String.valueOf('\u0016'));
            message.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            message.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            message.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
            message.append(String.valueOf('\b'));
            message.append(String.valueOf('\u0004'));
            message.append(String.valueOf('\n'));
            ((PortaSocket)this.getPortaCOM()).writeOutput(message.toString());
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0005');
    }

    @Override
    public String parse(String message) {
        String[] fields;
        if (Funcoes.textoVazio(message)) {
            return "Erro: mensagem com tamanho inv\u00e1lido foi recebida";
        }
        String tipoMsg = message.substring(0, message.indexOf(String.valueOf('\u0003')));
        if (!tipoMsg.equalsIgnoreCase("CTR")) {
            return "";
        }
        HashMap<String, Object> hemograma = new HashMap<String, Object>();
        String req_codigo = "";
        message = message.substring(message.indexOf(String.valueOf('\u0003')) + 1);
        block6: for (String s : fields = message.split(String.valueOf('\u0004'))) {
            String[] v;
            String result;
            String field;
            int idxSYN;
            int idxFF = s.indexOf(String.valueOf('\f'));
            if (idxFF < 1) continue;
            String campo = s.substring(0, idxFF);
            s = s.substring(idxFF + 1);
            if (campo.equalsIgnoreCase("PatInfo")) {
                String[] f;
                req_codigo = s;
                for (String f1 : f = req_codigo.split(String.valueOf('\b'))) {
                    idxSYN = f1.indexOf(String.valueOf('\u0016'));
                    field = f1.substring(0, idxSYN);
                    result = f1.substring(idxSYN + 1);
                    if (!field.equalsIgnoreCase("SampleID")) continue;
                    req_codigo = result;
                    continue block6;
                }
                continue;
            }
            for (String s1 : v = s.split(String.valueOf('\b'))) {
                idxSYN = s1.indexOf(String.valueOf('\u0016'));
                if (idxSYN <= 0 || !(field = s1.substring(0, idxSYN)).equalsIgnoreCase("Val")) continue;
                result = s1.substring(idxSYN + 1);
                if (campo.equalsIgnoreCase("WBC")) {
                    hemograma.put("leucocitos", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Neu#")) {
                    hemograma.put("neutrofilo_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Lymph#")) {
                    hemograma.put("linfocitos_tipicos_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Mon#")) {
                    hemograma.put("monocitos_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Eos#")) {
                    hemograma.put("eosinofilos_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Bas#")) {
                    hemograma.put("basofilos_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Neu%")) {
                    hemograma.put("neutrofilo_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Lymph%")) {
                    hemograma.put("linfocitos_tipicos_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Mon%")) {
                    hemograma.put("monocitos_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Eos%")) {
                    hemograma.put("eosinofilos_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("Bas%")) {
                    hemograma.put("basofilos_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("PDW")) {
                    hemograma.put("pdw", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("PCT")) {
                    hemograma.put("pct", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("PLT")) {
                    hemograma.put("plaquetas", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("MPV")) {
                    hemograma.put("vpm", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("MCV")) {
                    hemograma.put("vcm", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("MCHC")) {
                    hemograma.put("chcm", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("MCH")) {
                    hemograma.put("hcm", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("HCT")) {
                    hemograma.put("hct", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("RDW-CV")) {
                    hemograma.put("rdw_cv", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("RDW-SD")) {
                    hemograma.put("rdw_sd", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("RBC")) {
                    hemograma.put("hemacias", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("RGB")) {
                    hemograma.put("hgb", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("ALY#")) {
                    hemograma.put("linfocitos_atipicos_contagem", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (campo.equalsIgnoreCase("ALY%")) {
                    hemograma.put("linfocitos_atipicos_percentual", result.replaceFirst("\\.", ","));
                    continue;
                }
                if (!campo.equalsIgnoreCase("ALY#")) continue;
                hemograma.put("linfocitos_atipicos_contagem", result.replaceFirst("\\.", ","));
            }
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
            return null;
        }
        Statement st = Conexao.getStatement();
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
            return null;
        }
        try {
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            String mco_codigo = BDUtil.getExmCodigoMaterial(fil_codigo, int_codigo, req_codigo, rec_codigo);
            if (int_codigo == null) {
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, this.NOME_EXAME, mco_codigo, rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(req_codigo).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, hemograma);
                Conexao.arquivaSQL();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
        return "";
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void dataChangedOutput() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = ((PortaSocket)InterfaceListener.this.getPortaCOM()).getStringOutput();
                    System.out.println(message);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void handShakeCharReceivedInput(char c) {
    }

    @Override
    public void handShakeCharReceivedOutput(char c) {
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

