/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc5150bd;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.interfaces.sx260.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int QTDE_EXAMES_TOTAL_RACK = 59;
    public static final int QTDE_EXAMES_ENVIO_RACK = 35;
    private static final String FEMININO = "F";
    private HashMap<String, String> parametros = new HashMap();
    private static Connection connectionAccess;
    private static InterfaceConfiguracao configuracao;
    private String NOME_EXAME = "HEMOG";

    public InterfaceListener() {
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("Bas#", "basofilos_contagem");
        this.parametros.put("Bas%", "basofilos_percentual");
        this.parametros.put("Neu#", "neutrofilo_contagem");
        this.parametros.put("Neu%", "neutrofilo_percentual");
        this.parametros.put("Eos#", "eosinofilos_contagem");
        this.parametros.put("Eos%", "eosinofilos_percentual");
        this.parametros.put("Lymph#", "linfocitos_tipicos_contagem");
        this.parametros.put("Lymph%", "linfocitos_tipicos_percentual");
        this.parametros.put("Mon#", "monocitos_contagem");
        this.parametros.put("Mon%", "monocitos_percentual");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("MCV", "vcm");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCH", "mchc");
        this.parametros.put("RDW-CV", "rdw_cv");
        this.parametros.put("RDW-SD", "rdw_sd");
        this.parametros.put("HCT", "hct");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("PCT", "pct");
        this.parametros.put("P-LCC", "plaquetas_lcc");
        this.parametros.put("P-LCR", "plaquetas_lcr");
    }

    public void buscarResultados() {
        try {
            ArrayList<String> lista = new ArrayList<String>();
            this.getRequisicoes(lista, 1);
            this.getRequisicoes(lista, 2);
            int qtdeBusca = 0;
            StringBuilder requisicoes = new StringBuilder();
            for (int i = 0; i < lista.size(); ++i) {
                requisicoes.append("'").append((String)lista.get(i)).append("'");
                if (++qtdeBusca > 50) {
                    qtdeBusca = 0;
                    this.buscaRequisicoes(requisicoes.toString());
                    requisicoes.setLength(0);
                    continue;
                }
                requisicoes.append(", ");
            }
            if (qtdeBusca > 0) {
                this.buscaRequisicoes(requisicoes.deleteCharAt(requisicoes.length() - 2).toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void buscaRequisicoes(String requisicoes) throws Exception {
        if (Funcoes.textoVazio(requisicoes)) {
            return;
        }
        List<Registro> listaRegistros = this.pegaResultadosV2(requisicoes);
        String fil_codigo = "";
        String rec_codigo = "";
        String req_codigo = "";
        String int_codigo = "";
        String tuboID = "";
        ExameMaterial exame = null;
        HashMap<String, Object> dados = new HashMap<String, Object>();
        Statement st = Conexao.getStatement();
        for (Registro registro : listaRegistros) {
            tuboID = registro.getString("SpecimenID");
            String valor = registro.getString("Value");
            String campo = registro.getString("ItemCode");
            for (String p : this.parametros.keySet()) {
                if (!p.equalsIgnoreCase(campo)) continue;
                dados.put(this.parametros.get(p), valor);
            }
        }
        if (!Funcoes.textoVazio(tuboID)) {
            if (!Funcoes.isNumeric(tuboID) || tuboID.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o fora do padr\u00e3o do jalis (%s) ou n\u00e3o interfaceada", req_codigo));
                return;
            }
            fil_codigo = tuboID.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = tuboID.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
            req_codigo = tuboID.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Interfaceamento do exame " + this.NOME_EXAME + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return;
            }
            exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + this.NOME_EXAME + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            }
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit < 3 ? 2 : 4);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            if (BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo)) {
                ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, null, null, dados, null, false, (AbstractInterfaceamentoListener)this);
            }
        }
    }

    private List<Registro> pegaResultadosV2(String requisicoes) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList<Registro> resultados = new ArrayList<Registro>();
        StringBuilder sql = new StringBuilder();
        sql.append("select SpecimenID, ItemCode, Value, Unit from tblTestResult ");
        sql.append(" where SpecimenID in(").append(requisicoes).append(") ");
        sql.append(" order by ItemCode");
        Statement stResults = this.createStatement();
        ResultSet rs = stResults.executeQuery(sql.toString());
        while (rs != null && rs.next()) {
            Registro registro = new Registro(rs);
            resultados.add(registro);
        }
        return resultados;
    }

    private Statement createStatement() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        String fonteWorklist = c.getFonteOdbcWorklist();
        String connectionUrl = "jdbc:sqlserver://localhost; databaseName=" + fonteWorklist + " ; integratedSecurity=true;";
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
        Connection con = DriverManager.getConnection(connectionUrl);
        Statement stmt = con.createStatement();
        return stmt;
    }

    private void getRequisicoes(List<String> lista, int abaSelecionada) {
        ArrayList examesPendentes = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < examesPendentes.size(); ++i) {
            Object[] req = (Object[])examesPendentes.get(i);
            if (abaSelecionada == 2) {
                if (!"3;4;5".contains((String)req[aba.getColIndice("Sit")])) continue;
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            ArrayList tubosFilho = new ArrayList();
            if (lista.contains(requisicao = String.format("%s%s", requisicao, tubo))) continue;
            lista.add(requisicao);
        }
    }

    private boolean tuboValido(Object[] req) {
        return null != req && req.length > 0 && null != req[20] && Funcoes.isNumeric(StringUtil.removeCaracteresNaoNumericos(req[20].toString()));
    }

    private boolean contemTubos(ArrayList tubos) {
        return tubos != null && !tubos.isEmpty();
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return null;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }
}

