/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc3200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String CODIGO_ALTERNATIVO = "bc3200";
    private boolean ultimoParseOk = true;

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exames.split(" ")) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return "";
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    break;
                }
                case '\u0004': {
                    this.parse(this.getPortaCOM().getInputString());
                    this.getPortaCOM().clearInputString();
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", e.getStackTrace());
        }
    }

    @Override
    public void dataChanged() {
        String data = this.getPortaCOM().getInputString();
        if (data != null && data.equals(String.valueOf('\u0003'))) {
            this.getPortaCOM().clearInputString();
            try {
                this.getPortaCOM().write(String.valueOf(this.ultimoParseOk ? (char)'\u0006' : '\u0015'));
            }
            catch (IOException ioEx) {
                ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", ioEx.getStackTrace());
            }
        }
    }

    @Override
    public synchronized String parse(String message) {
        try {
            if (message == null || !message.startsWith("A")) {
                this.ultimoParseOk = true;
                return null;
            }
            SampleData sampleData = new SampleData(message);
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = sampleData.getId();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, CODIGO_ALTERNATIVO);
                if (intCodigo == null) {
                    this.ultimoParseOk = true;
                    return "N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put("leucocitos", sampleData.getWbc().replace('.', ','));
                dados.put("linfocitos_tipicos_contagem", this.formataValor(sampleData.getLymphNum()));
                dados.put("linfocitos_tipicos_percentual", this.formataValor(sampleData.getLymphPer()));
                dados.put("hemacias", this.formataValor(sampleData.getRbc()));
                dados.put("hgb", this.formataValor(sampleData.getHgb()));
                dados.put("chcm", this.formataValor(sampleData.getMchc()));
                dados.put("vcm", this.formataValor(sampleData.getMcv()));
                dados.put("hcm", this.formataValor(sampleData.getMch()));
                dados.put("rdw_cv", this.formataValor(sampleData.getRdwCvPer()));
                dados.put("hct", this.formataValor(sampleData.getHctPer()));
                dados.put("plaquetas", this.formataValor(sampleData.getPlt()));
                dados.put("vpm", this.formataValor(sampleData.getMpv()));
                dados.put("pdw", this.formataValor(sampleData.getPdw()));
                dados.put("pct", this.formataValor(sampleData.getPctPer()));
                dados.put("rdw_sd", this.formataValor(sampleData.getRdwSd()));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ultimoParseOk = false;
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao receber dados do equipamento";
        }
        this.ultimoParseOk = true;
        return null;
    }

    private String formataValor(String valor) {
        return valor != null ? valor.replace('.', ',') : null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    private class SampleData {
        private String id;
        private String wbc;
        private String lymphNum;
        private String midNum;
        private String granNum;
        private String lymphPer;
        private String midPer;
        private String granPer;
        private String rbc;
        private String hgb;
        private String mchc;
        private String mcv;
        private String mch;
        private String rdwCvPer;
        private String hctPer;
        private String plt;
        private String mpv;
        private String pdw;
        private String pctPer;
        private String rdwSd;

        public SampleData(String data) throws ParseException {
            String[] partes = data.split(String.valueOf('\n'), -1);
            this.id = partes[5];
            this.wbc = partes[13];
            this.lymphNum = partes[14];
            this.midNum = partes[15];
            this.granNum = partes[16];
            this.lymphPer = partes[17];
            this.midPer = partes[18];
            this.granPer = partes[19];
            this.rbc = partes[20];
            this.hgb = partes[21];
            this.mchc = partes[22];
            this.mcv = partes[23];
            this.mch = partes[24];
            this.rdwCvPer = partes[25];
            this.hctPer = partes[26];
            this.plt = partes[27];
            this.mpv = partes[28];
            this.pdw = partes[29];
            this.pctPer = partes[30];
            this.rdwSd = partes[31];
        }

        public String getId() {
            return this.id;
        }

        public String getWbc() {
            return this.wbc;
        }

        public String getLymphNum() {
            return this.lymphNum;
        }

        public String getMidNum() {
            return this.midNum;
        }

        public String getGranNum() {
            return this.granNum;
        }

        public String getLymphPer() {
            return this.lymphPer;
        }

        public String getMidPer() {
            return this.midPer;
        }

        public String getGranPer() {
            return this.granPer;
        }

        public String getRbc() {
            return this.rbc;
        }

        public String getHgb() {
            return this.hgb;
        }

        public String getMchc() {
            return this.mchc;
        }

        public String getMcv() {
            return this.mcv;
        }

        public String getMch() {
            return this.mch;
        }

        public String getRdwCvPer() {
            return this.rdwCvPer;
        }

        public String getHctPer() {
            return this.hctPer;
        }

        public String getPlt() {
            return this.plt;
        }

        public String getMpv() {
            return this.mpv;
        }

        public String getPdw() {
            return this.pdw;
        }

        public String getPctPer() {
            return this.pctPer;
        }

        public String getRdwSd() {
            return this.rdwSd;
        }
    }
}

