/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc3000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.interfaces.bc3000.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String CODIGO_ALTERNATIVO = "HEMOG";
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            if (this.configuracao.getGravarRack()) {
                rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
                rackposition = rackposition + Funcoes.preencheZero(Long.parseLong(req_codigo), 8);
            } else {
                rackposition = null;
            }
            for (String exame : exames.split(" ")) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, rackposition, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u001a');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void dataChanged() {
        String data = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (data != null && data.startsWith(this.getMsgStart())) {
            this.parse(data);
        }
    }

    @Override
    public synchronized String parse(String message) {
        try {
            if (!message.startsWith(this.getMsgStart())) {
                return null;
            }
            message = message.substring(1);
            SampleData sampleData = new SampleData(message);
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = "";
            if (this.configuracao.getGravarRack()) {
                String rack = sampleData.getId();
                tuboId = this.getRequisicaoRack(rack);
            } else {
                tuboId = sampleData.getId();
            }
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, CODIGO_ALTERNATIVO);
                if (intCodigo == null) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.");
                    return "N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put("leucocitos", sampleData.getWbc().replace('.', ','));
                dados.put("linfocitos_tipicos_contagem", this.formataValor(sampleData.getLymphNum()));
                dados.put("monocitos_contagem", this.formataValor(sampleData.getMidNum()));
                dados.put("granulocitos_contagem", this.formataValor(sampleData.getGranNum()));
                dados.put("linfocitos_tipicos_percentual", this.formataValor(sampleData.getLymphPer()));
                dados.put("monocitos_percentual", this.formataValor(sampleData.getMidPer()));
                dados.put("granulocitos_percentual", this.formataValor(sampleData.getGranPer()));
                dados.put("hemacias", this.formataValor(sampleData.getRbc()));
                dados.put("hgb", this.formataValor(sampleData.getHgb()));
                dados.put("chcm", this.formataValor(sampleData.getMchc()));
                dados.put("vcm", this.formataValor(sampleData.getMcv()));
                dados.put("hcm", this.formataValor(sampleData.getMch()));
                dados.put("rdw_cv", this.formataValor(sampleData.getRdwCvPer()));
                dados.put("hct", this.formataValor(sampleData.getHctPer()));
                dados.put("plaquetas", this.formataValor(sampleData.getPlt()));
                dados.put("vpm", this.formataValor(sampleData.getMpv()));
                dados.put("pdw", this.formataValor(sampleData.getPdw()));
                dados.put("pct", this.formataValor(sampleData.getPctPer()));
                dados.put("rdw_sd", this.formataValor(sampleData.getRdwSd()));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao receber dados do equipamento";
        }
        return null;
    }

    private String formataValor(String valor) {
        return valor != null ? valor.replace('.', ',') : null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void teste() {
        StringBuilder bui = new StringBuilder();
        bui.append(String.valueOf('\u0002'));
        bui.append("AAAI10P1900010702130100425201815050068002400060038353");
        bui.append("08356464213203240634020515840702471001602470347000000000000000001100100500842550");
        bui.append("26133014236000000000000000000000000000000000000000000000000000000000301102304307");
        bui.append("11061391742062272452552492362232041881751581431311191111050950880820770730720690");
        bui.append("66065062059055053049044042040039038038038039038035035033034033030029029029029029");
        bui.append("02702702702502502502402502402402302302302402402302302202302302302202202402302302");
        bui.append("30240240250240220240240240240240230240250250260260270270270270290290280290300320");
        bui.append("32034034035038038039039039040042043043044045048050052051054054058059062064065066");
        bui.append("06707006806906806907007207307407807707907907907907907907708108308308308008007807");
        bui.append("80760720700700700690680680670660660640650660660640630630630630620590560550550530");
        bui.append("50047044043043041038037036035034034033031031029028027027025024022021020019017016");
        bui.append("01501401501301301201201201101101001100900900800600600600500400500500500500500000");
        bui.append("00000000000000000000000000000000000000000000000000000000000000000000000010020030");
        bui.append("05007010014020026033043055068084100118138159178194210226239249254255253251246237");
        bui.append("22621319918717316014713512411310509709208407907407006606306105605505205004804504");
        bui.append("20400380350340320300280260240230220200180170160150140120110100100090090080080070");
        bui.append("07007007006006006006006006005005005005004004004003003003003003003003003003003002");
        bui.append("00200200200200200200200100100100100100100100100100100100100100100100100100100100");
        bui.append("10010010000000000000000000000000000000000000000000000000000000000000000000000000");
        bui.append("00000000000000000000000000000000000000000000000000000000000000000000000000000000");
        bui.append("00000000000000000000000000000000000000000000000000000000000000000000000000000000");
        bui.append("00000000000000000000000000000000000000000000000000000000000000000000000000000000");
        bui.append("01001001002004005006008011015019022026030035040045050055061067074081088096103110");
        bui.append("11712413113914515215916617217918519119720421021622122723323924224624825025225425");
        bui.append("32532532532542552542542532522502492472452442442432422412412402402382362342332292");
        bui.append("26222218214210206202197193188184179174170166163160158156154153152151150149147146");
        bui.append("14414214114013813613513413213112812612312111911811411110810510109709309008808708");
        bui.append("60850840840830820800780770760750750760780800820830850850850840840820810800790780");
        bui.append("78077077076075074073071070069068067066065064062061060059058057056056055054053052");
        bui.append("05105004904804804804804905005105205405505605605605605605505505605705805906006206");
        bui.append("20620620630630630640660680710730760790820850880900920930940940950950950950950950");
        bui.append("95095095095");
        this.parse(this.equipamento.arruma(bui.toString()));
    }

    private class SampleData {
        private String id;
        private String wbc;
        private String lymphNum;
        private String midNum;
        private String granNum;
        private String lymphPer;
        private String midPer;
        private String granPer;
        private String rbc;
        private String hgb;
        private String mchc;
        private String mcv;
        private String mch;
        private String rdwCvPer;
        private String hctPer;
        private String plt;
        private String mpv;
        private String pdw;
        private String pctPer;
        private String rdwSd;

        public SampleData(String data) throws ParseException {
            data = data.substring(11);
            this.id = data.substring(0, 10);
            this.wbc = data.substring(23, 26) + "." + data.substring(26, 27);
            this.lymphNum = data.substring(27, 30) + "." + data.substring(30, 31);
            this.midNum = data.substring(31, 34) + "." + data.substring(34, 35);
            this.granNum = data.substring(35, 38) + "." + data.substring(38, 39);
            this.lymphPer = data.substring(39, 41) + "." + data.substring(41, 42);
            this.midPer = data.substring(42, 44) + "." + data.substring(44, 45);
            this.granPer = data.substring(45, 47) + "." + data.substring(47, 48);
            this.rbc = data.substring(48, 49) + "." + data.substring(49, 51);
            this.hgb = data.substring(51, 53) + "." + data.substring(53, 54);
            this.mchc = data.substring(54, 58);
            this.mcv = data.substring(58, 61) + "." + data.substring(61, 62);
            this.mch = data.substring(62, 65) + "." + data.substring(65, 66);
            this.rdwCvPer = data.substring(66, 68) + "." + data.substring(68, 69);
            this.hctPer = data.substring(69, 71) + "." + data.substring(71, 72);
            this.plt = data.substring(72, 76);
            this.mpv = data.substring(76, 78) + "." + data.substring(78, 79);
            this.pdw = data.substring(79, 81) + "." + data.substring(81, 82);
            this.pctPer = "0." + data.substring(82, 85);
            this.rdwSd = data.substring(85, 88) + "." + data.substring(88, 89);
        }

        public String getId() {
            return this.id;
        }

        public String getWbc() {
            return this.wbc;
        }

        public String getLymphNum() {
            return this.lymphNum;
        }

        public String getMidNum() {
            return this.midNum;
        }

        public String getGranNum() {
            return this.granNum;
        }

        public String getLymphPer() {
            return this.lymphPer;
        }

        public String getMidPer() {
            return this.midPer;
        }

        public String getGranPer() {
            return this.granPer;
        }

        public String getRbc() {
            return this.rbc;
        }

        public String getHgb() {
            return this.hgb;
        }

        public String getMchc() {
            return this.mchc;
        }

        public String getMcv() {
            return this.mcv;
        }

        public String getMch() {
            return this.mch;
        }

        public String getRdwCvPer() {
            return this.rdwCvPer;
        }

        public String getHctPer() {
            return this.hctPer;
        }

        public String getPlt() {
            return this.plt;
        }

        public String getMpv() {
            return this.mpv;
        }

        public String getPdw() {
            return this.pdw;
        }

        public String getPctPer() {
            return this.pctPer;
        }

        public String getRdwSd() {
            return this.rdwSd;
        }
    }
}

