/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc2800b;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.bc2800.InterfaceListener {
    @Override
    public synchronized String parse(String message) {
        try {
            if (message.startsWith(String.valueOf('\u0002'))) {
                message = message.substring(1);
            }
            if (message.endsWith(String.valueOf('\u0003'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message.endsWith(String.valueOf('\u0004'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message == null || !message.startsWith("A")) {
                this.ultimoParseOk = true;
                return null;
            }
            SampleData sampleData = new SampleData(message);
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String rack = sampleData.getId();
            String requisicao = this.getRequisicaoRack(rack);
            if (requisicao != null && requisicao.length() == digitosCodigoTubo && Funcoes.isNumeric(requisicao)) {
                Statement st = Conexao.getStatement();
                String filCodigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, "HEMOG");
                if (intCodigo == null) {
                    this.ultimoParseOk = true;
                    return "N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put("leucocitos", sampleData.getWbc().replace('.', ','));
                dados.put("linfocitos_tipicos_contagem", this.formataValor(sampleData.getLymphNum()));
                dados.put("celulas_media_contagem", this.formataValor(sampleData.getMidNum()));
                dados.put("segmentados_contagem", this.formataValor(sampleData.getGranNum()));
                dados.put("linfocitos_tipicos_percentual", this.formataValor(sampleData.getLymphPer()));
                dados.put("celulas_media_percentual", this.formataValor(sampleData.getMidPer()));
                dados.put("segmentados_percentual", this.formataValor(sampleData.getGranPer()));
                dados.put("hemacias", this.formataValor(sampleData.getRbc()));
                dados.put("hgb", this.formataValor(sampleData.getHgb()));
                dados.put("chcm", this.formataValor(sampleData.getMchc()));
                dados.put("vcm", this.formataValor(sampleData.getMcv()));
                dados.put("hcm", this.formataValor(sampleData.getMch()));
                dados.put("rdw_cv", this.formataValor(sampleData.getRdwCvPer()));
                dados.put("hct", this.formataValor(sampleData.getHctPer()));
                dados.put("plaquetas", this.formataValor(sampleData.getPlt()));
                dados.put("vpm", this.formataValor(sampleData.getMpv()));
                dados.put("pdw", this.formataValor(sampleData.getPdw()));
                dados.put("pct", this.formataValor(sampleData.getPctPer()));
                dados.put("rdw_sd", this.formataValor(sampleData.getRdwSd()));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s ", rack));
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ultimoParseOk = false;
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao receber dados do equipamento";
        }
        this.ultimoParseOk = true;
        return null;
    }

    @Override
    public void teste() {
        StringBuilder b = new StringBuilder();
        b.append("A0203109700709202111420053002800050020526088386481145030010060301130483038110415339604850000000000000000000001006308925501");
        b.append("7189024214000000000000000000000000000000000000000000000000100200400601001301501701701601501401201101001001101401802503605107109");
        b.append("4121149178204226243252255251242229213195176156137119102088076066058052048044040038035033032032032032033033034034034034033032032");
        b.append("0310300290290280270260250240230220210200190180170160150150150150150150150150150150150150150160160170180190200200210210220230240");
        b.append("2502602702803003103203303403503603703703803803803903903903904004004104204304404404504604604604704704704704704604604604604504504");
        b.append("4044043043042041041040039039038036035033032030028026024022021020019018017016016015015014014013013012011011011010010009009008008");
        b.append("0070070060060050050050040040040040030030030030030020020020020020020010010010010010010010010010010010010010010010010000000000000");
        b.append("0000000000000000000000000000000000000000000000000000000000000000000000000000000000100300400500600600700800800700600600600600600");
        b.append("6005005005005005005004004004004003003003003003003003004004005005006007009011013017021026033040047056067077090102116130145160176");
        b.append("1922042182282382462492512512552532502432362312212121951841731641531421341251201121040990940890850810760730690660620610570550540");
        b.append("5205004904704404204003803603503403203002902802502302001901801601501401301301201201000900900900800800700700700700600600500500500");
        b.append("5004004004004004004003003004004004004004004004004004004003003003003003003003003003003003003003002002002002002002002002002002002");
        b.append("0020020020010020020020010010010010010010010010010010010010010010010010010010010010010010010010010010000000000000000010000000000");
        b.append("0000000000000000000000000100100100100100000000000000000000000000000000000000000000000000000000000000000000000100300500801402102");
        b.append("9038045053064075086098109120129139149159170182193204211218228238241245248252253255254253252252249247248249247245242239237236235");
        b.append("2352302252222192142102062032001981931881851821761701671641591541511481461441391351331321291271261251201161131111081061041031000");
        b.append("9809709709409208908708708708408207907607407307307307107007207407106906907006906906606406206106006005805705705705605605605705605");
        b.append("6053050051052049047045043044045046047045043043044044044042040038037036035035036035034034035036038037036034033033033032032031031");
        b.append("0310320310310310310290280280290280280270270270280290300300310300290280270260260260260250250250260270280270270260260250240240240");
        b.append("23022022022022022022022022022022022022022022[EOT][ETX]");
        this.parse(this.equipamento.arruma(b.toString()));
    }

    private class SampleData {
        private String id;
        private String wbc;
        private String lymphNum;
        private String midNum;
        private String granNum;
        private String lymphPer;
        private String midPer;
        private String granPer;
        private String rbc;
        private String hgb;
        private String mchc;
        private String mcv;
        private String mch;
        private String rdwCvPer;
        private String hctPer;
        private String plt;
        private String mpv;
        private String pdw;
        private String pctPer;
        private String rdwSd;

        public SampleData(String data) throws ParseException {
            data = data.substring(1);
            this.id = data.substring(0, 8);
            this.wbc = data.substring(21, 24) + "." + data.substring(24, 25);
            this.lymphNum = data.substring(25, 28) + "." + data.substring(28, 29);
            this.midNum = data.substring(29, 32) + "." + data.substring(32, 33);
            this.granNum = data.substring(33, 36) + "." + data.substring(36, 37);
            this.lymphPer = data.substring(37, 39) + "." + data.substring(39, 40);
            this.midPer = data.substring(40, 42) + "." + data.substring(42, 43);
            this.granPer = data.substring(43, 45) + "." + data.substring(45, 46);
            this.rbc = data.substring(46, 47) + "." + data.substring(47, 49);
            this.hgb = data.substring(49, 51) + "." + data.substring(51, 52);
            this.mchc = data.substring(52, 55) + "." + data.substring(55, 56);
            this.mcv = data.substring(56, 59) + "." + data.substring(59, 60);
            this.mch = data.substring(60, 63) + "." + data.substring(63, 64);
            this.rdwCvPer = data.substring(64, 66) + "." + data.substring(66, 67);
            this.hctPer = data.substring(67, 69) + "." + data.substring(69, 70);
            this.plt = data.substring(70, 74);
            this.mpv = data.substring(74, 76) + "." + data.substring(76, 77);
            this.pdw = data.substring(77, 79) + "." + data.substring(79, 80);
            this.pctPer = "0." + data.substring(80, 83);
            this.rdwSd = data.substring(83, 86) + "." + data.substring(86, 87);
        }

        public String getId() {
            return this.id;
        }

        public String getWbc() {
            return this.wbc;
        }

        public String getLymphNum() {
            return this.lymphNum;
        }

        public String getMidNum() {
            return this.midNum;
        }

        public String getGranNum() {
            return this.granNum;
        }

        public String getLymphPer() {
            return this.lymphPer;
        }

        public String getMidPer() {
            return this.midPer;
        }

        public String getGranPer() {
            return this.granPer;
        }

        public String getRbc() {
            return this.rbc;
        }

        public String getHgb() {
            return this.hgb;
        }

        public String getMchc() {
            return this.mchc;
        }

        public String getMcv() {
            return this.mcv;
        }

        public String getMch() {
            return this.mch;
        }

        public String getRdwCvPer() {
            return this.rdwCvPer;
        }

        public String getHctPer() {
            return this.hctPer;
        }

        public String getPlt() {
            return this.plt;
        }

        public String getMpv() {
            return this.mpv;
        }

        public String getPdw() {
            return this.pdw;
        }

        public String getPctPer() {
            return this.pctPer;
        }

        public String getRdwSd() {
            return this.rdwSd;
        }
    }
}

