/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc2800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.interfaces.bc2800.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected static final String CODIGO_ALTERNATIVO = "HEMOG";
    protected boolean ultimoParseOk = true;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            rackposition = rackposition + Funcoes.preencheZero(Long.parseLong(req_codigo), 6);
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.fireAtualizarTabela(1);
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    break;
                }
                case '\u0003': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", e.getStackTrace());
        }
    }

    @Override
    public void dataChanged() {
        String data = this.getPortaCOM().getInputString();
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!message.equals("")) {
            try {
                this.getPortaCOM().clearInputString();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.parse(message);
            }
            catch (IOException ioEx) {
                ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", ioEx.getStackTrace());
            }
        }
    }

    @Override
    public synchronized String parse(String message) {
        try {
            if (message.startsWith(String.valueOf('\u0002'))) {
                message = message.substring(1);
            }
            if (message.endsWith(String.valueOf('\u0003'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message.endsWith(String.valueOf('\u0004'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message == null || !message.startsWith("A")) {
                this.ultimoParseOk = true;
                return null;
            }
            SampleData sampleData = new SampleData(message);
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String rack = sampleData.getId();
            String requisicao = this.getRequisicaoRack(rack);
            if (requisicao != null && requisicao.length() == digitosCodigoTubo && Funcoes.isNumeric(requisicao)) {
                Statement st = Conexao.getStatement();
                String filCodigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, CODIGO_ALTERNATIVO);
                if (intCodigo == null) {
                    this.ultimoParseOk = true;
                    return "N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put("leucocitos", sampleData.getWbc().replace('.', ','));
                dados.put("linfocitos_tipicos_contagem", this.formataValor(sampleData.getLymphNum()));
                dados.put("celulas_media_contagem", this.formataValor(sampleData.getMidNum()));
                dados.put("segmentados_contagem", this.formataValor(sampleData.getGranNum()));
                dados.put("linfocitos_tipicos_percentual", this.formataValor(sampleData.getLymphPer()));
                dados.put("celulas_media_percentual", this.formataValor(sampleData.getMidPer()));
                dados.put("segmentados_percentual", this.formataValor(sampleData.getGranPer()));
                dados.put("hemacias", this.formataValor(sampleData.getRbc()));
                dados.put("hgb", this.formataValor(sampleData.getHgb()));
                dados.put("chcm", this.formataValor(sampleData.getMchc()));
                dados.put("vcm", this.formataValor(sampleData.getMcv()));
                dados.put("hcm", this.formataValor(sampleData.getMch()));
                dados.put("rdw_cv", this.formataValor(sampleData.getRdwCvPer()));
                dados.put("hct", this.formataValor(sampleData.getHctPer()));
                dados.put("plaquetas", this.formataValor(sampleData.getPlt()));
                dados.put("vpm", this.formataValor(sampleData.getMpv()));
                dados.put("pdw", this.formataValor(sampleData.getPdw()));
                dados.put("pct", this.formataValor(sampleData.getPctPer()));
                dados.put("rdw_sd", this.formataValor(sampleData.getRdwSd()));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s ", rack));
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ultimoParseOk = false;
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao receber dados do equipamento";
        }
        this.ultimoParseOk = true;
        return null;
    }

    protected String formataValor(String valor) {
        return valor != null ? valor.replace('.', ',') : null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    private class SampleData {
        private String id;
        private String wbc;
        private String lymphNum;
        private String midNum;
        private String granNum;
        private String lymphPer;
        private String midPer;
        private String granPer;
        private String rbc;
        private String hgb;
        private String mchc;
        private String mcv;
        private String mch;
        private String rdwCvPer;
        private String hctPer;
        private String plt;
        private String mpv;
        private String pdw;
        private String pctPer;
        private String rdwSd;

        public SampleData(String data) throws ParseException {
            if (InterfaceListener.this.configuracao.getResultadoSemCabecalho() && InterfaceListener.this.configuracao.getModoContinuo()) {
                this.id = data.substring(1, 9);
                this.wbc = data.substring(22, 25) + "." + data.substring(25, 26);
                this.lymphNum = data.substring(26, 29) + "." + data.substring(29, 30);
                this.midNum = data.substring(30, 33) + "." + data.substring(33, 34);
                this.granNum = data.substring(34, 37) + "." + data.substring(37, 38);
                this.lymphPer = data.substring(38, 40) + "." + data.substring(40, 41);
                this.midPer = data.substring(41, 43) + "." + data.substring(43, 44);
                this.granPer = data.substring(44, 46) + "." + data.substring(46, 47);
                this.rbc = data.substring(46, 48) + "." + data.substring(48, 50);
                this.hgb = data.substring(50, 52) + "." + data.substring(52, 53);
                this.rdwCvPer = data.substring(65, 67) + "." + data.substring(67, 68);
                this.hctPer = data.substring(68, 70) + "." + data.substring(70, 71);
                this.plt = data.substring(72, 75);
                this.mpv = data.substring(75, 77) + "." + data.substring(77, 78);
                this.rdwSd = data.substring(85, 88) + "." + data.substring(88, 89);
            } else if (!InterfaceListener.this.configuracao.getModoContinuo()) {
                String[] partes = data.split(String.valueOf('\n'), -1);
                this.id = partes[5];
                this.wbc = partes[13];
                this.lymphNum = partes[14];
                this.midNum = partes[15];
                this.granNum = partes[16];
                this.lymphPer = partes[17];
                this.midPer = partes[18];
                this.granPer = partes[19];
                this.rbc = partes[20];
                this.hgb = partes[21];
                this.mchc = partes[22];
                this.mcv = partes[23];
                this.mch = partes[24];
                this.rdwCvPer = partes[25];
                this.hctPer = partes[26];
                this.plt = partes[27];
                this.mpv = partes[28];
                this.pdw = partes[29];
                this.pctPer = partes[30];
                this.rdwSd = partes[31];
            } else {
                data = data.substring(14);
                this.id = data.substring(0, 8);
                this.wbc = data.substring(21, 24) + "." + data.substring(24, 25);
                this.lymphNum = data.substring(25, 28) + "." + data.substring(28, 29);
                this.midNum = data.substring(29, 32) + "." + data.substring(32, 33);
                this.granNum = data.substring(33, 36) + "." + data.substring(36, 37);
                this.lymphPer = data.substring(37, 39) + "." + data.substring(39, 40);
                this.midPer = data.substring(40, 42) + "." + data.substring(42, 43);
                this.granPer = data.substring(43, 45) + "." + data.substring(45, 46);
                this.rbc = data.substring(46, 48) + "." + data.substring(48, 50);
                this.hgb = data.substring(50, 52) + "." + data.substring(52, 53);
                this.rdwCvPer = data.substring(65, 67) + "." + data.substring(67, 68);
                this.hctPer = data.substring(68, 70) + "." + data.substring(70, 71);
                this.plt = data.substring(72, 75);
                this.mpv = data.substring(75, 77) + "." + data.substring(77, 78);
                this.rdwSd = data.substring(84, 87) + "." + data.substring(87, 88);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getWbc() {
            return this.wbc;
        }

        public String getLymphNum() {
            return this.lymphNum;
        }

        public String getMidNum() {
            return this.midNum;
        }

        public String getGranNum() {
            return this.granNum;
        }

        public String getLymphPer() {
            return this.lymphPer;
        }

        public String getMidPer() {
            return this.midPer;
        }

        public String getGranPer() {
            return this.granPer;
        }

        public String getRbc() {
            return this.rbc;
        }

        public String getHgb() {
            return this.hgb;
        }

        public String getMchc() {
            return this.mchc;
        }

        public String getMcv() {
            return this.mcv;
        }

        public String getMch() {
            return this.mch;
        }

        public String getRdwCvPer() {
            return this.rdwCvPer;
        }

        public String getHctPer() {
            return this.hctPer;
        }

        public String getPlt() {
            return this.plt;
        }

        public String getMpv() {
            return this.mpv;
        }

        public String getPdw() {
            return this.pdw;
        }

        public String getPctPer() {
            return this.pctPer;
        }

        public String getRdwSd() {
            return this.rdwSd;
        }
    }
}

