/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc2300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.interfaces.bc2300.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String CODIGO_ALTERNATIVO = "HEMOG";
    private boolean ultimoParseOk = true;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            rackposition = rackposition + Funcoes.preencheZero(Long.parseLong(req_codigo), 6);
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    break;
                }
                case '\u0003': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", e.getStackTrace());
        }
    }

    @Override
    public void dataChanged() {
        String data = this.getPortaCOM().getInputString();
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!message.equals("") || data.getBytes()[data.length() - 1] == 26) {
            try {
                this.getPortaCOM().clearInputString();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.parse(Funcoes.textoVazio(message) ? data : message);
            }
            catch (IOException ioEx) {
                ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o aparelho", ioEx.getStackTrace());
            }
        }
    }

    @Override
    public synchronized String parse(String message) {
        try {
            if (message.startsWith(String.valueOf('\u0002'))) {
                message = message.substring(1);
            }
            if (message.endsWith(String.valueOf('\u0003'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message.endsWith(String.valueOf('\u0004'))) {
                message = message.substring(0, message.length() - 1);
            }
            if (message == null || !message.startsWith("A")) {
                this.ultimoParseOk = true;
                return "N\u00e3o foi poss\u00edvel interpretar a mensagem recebida.";
            }
            SampleData sampleData = new SampleData(message);
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String rack = sampleData.getId();
            String requisicao = this.getRequisicaoRack(rack);
            if (requisicao != null && requisicao.length() == digitosCodigoTubo && Funcoes.isNumeric(requisicao)) {
                Statement st = Conexao.getStatement();
                String filCodigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, CODIGO_ALTERNATIVO);
                if (intCodigo == null) {
                    this.ultimoParseOk = true;
                    return "N\u00e3o foi poss\u00edvel encontrar a interface. Verifique configura\u00e7\u00e3o do exame.";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put("leucocitos", sampleData.getWbc().replace('.', ','));
                dados.put("linfocitos_tipicos_contagem", this.formataValor(sampleData.getLymphNum()));
                dados.put("celulas_media_contagem", this.formataValor(sampleData.getMidNum()));
                dados.put("segmentados_contagem", this.formataValor(sampleData.getGranNum()));
                dados.put("linfocitos_tipicos_percentual", this.formataValor(sampleData.getLymphPer()));
                dados.put("celulas_media_percentual", this.formataValor(sampleData.getMidPer()));
                dados.put("segmentados_percentual", this.formataValor(sampleData.getGranPer()));
                dados.put("hemacias", this.formataValor(sampleData.getRbc()));
                dados.put("hgb", this.formataValor(sampleData.getHgb()));
                dados.put("chcm", this.formataValor(sampleData.getMchc()));
                dados.put("vcm", this.formataValor(sampleData.getMcv()));
                dados.put("hcm", this.formataValor(sampleData.getMch()));
                dados.put("rdw_cv", this.formataValor(sampleData.getRdwCvPer()));
                dados.put("hct", this.formataValor(sampleData.getHctPer()));
                dados.put("plaquetas", this.formataValor(sampleData.getPlt()));
                dados.put("vpm", this.formataValor(sampleData.getMpv()));
                dados.put("pdw", this.formataValor(sampleData.getPdw()));
                dados.put("pct", this.formataValor(sampleData.getPctPer()));
                dados.put("rdw_sd", this.formataValor(sampleData.getRdwSd()));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ultimoParseOk = false;
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao receber dados do equipamento";
        }
        this.ultimoParseOk = true;
        return null;
    }

    private String formataValor(String valor) {
        return valor != null ? valor.replace('.', ',') : null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String requisicao = "";
        buf.append("[STX]AAAI08P190");
        buf.append("1h220107722");
        buf.append("70021820221");
        buf.append("01400440017");
        buf.append("00030024378");
        buf.append("06855403471");
        buf.append("07032709430");
        buf.append("30811932702");
        buf.append("29096149219");
        buf.append("03890000000");
        buf.append("00000000000");
        buf.append("00010053086");
        buf.append("25501916302");
        buf.append("02100000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000100");
        buf.append("20030050070");
        buf.append("08010011012");
        buf.append("01201401602");
        buf.append("20310450630");
        buf.append("86112141168");
        buf.append("19421623324");
        buf.append("62532552512");
        buf.append("41226207186");
        buf.append("16514412510");
        buf.append("60900750620");
        buf.append("52043037032");
        buf.append("03002902903");
        buf.append("00310320320");
        buf.append("32032032032");
        buf.append("03203203203");
        buf.append("10300290270");
        buf.append("25023021019");
        buf.append("01701601501");
        buf.append("40130130120");
        buf.append("12012011011");
        buf.append("01101001001");
        buf.append("00100090090");
        buf.append("09009009010");
        buf.append("01101201301");
        buf.append("40160170180");
        buf.append("19020020021");
        buf.append("02302402602");
        buf.append("80310330360");
        buf.append("38039040041");
        buf.append("04204304404");
        buf.append("60490520560");
        buf.append("60063067069");
        buf.append("07107307407");
        buf.append("60770780790");
        buf.append("81082084086");
        buf.append("08808909009");
        buf.append("10920920930");
        buf.append("93093092092");
        buf.append("09108908808");
        buf.append("70860850850");
        buf.append("84084083082");
        buf.append("08208108007");
        buf.append("90770760740");
        buf.append("72070068065");
        buf.append("06306105805");
        buf.append("70550530520");
        buf.append("51050049047");
        buf.append("04604404204");
        buf.append("00380350330");
        buf.append("30028026025");
        buf.append("02302202102");
        buf.append("00180170160");
        buf.append("15014013012");
        buf.append("01101000900");
        buf.append("80070070060");
        buf.append("06006005005");
        buf.append("00500500400");
        buf.append("40040030030");
        buf.append("03002002002");
        buf.append("00100100100");
        buf.append("10010010010");
        buf.append("01000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000100100");
        buf.append("20020020020");
        buf.append("02002002002");
        buf.append("00200200200");
        buf.append("20020020020");
        buf.append("02002002002");
        buf.append("00200300300");
        buf.append("30030040040");
        buf.append("06006008011");
        buf.append("01401802403");
        buf.append("00390490620");
        buf.append("73089107125");
        buf.append("14316017819");
        buf.append("72132272372");
        buf.append("47254255254");
        buf.append("24524423622");
        buf.append("72152031941");
        buf.append("84174160148");
        buf.append("13813012111");
        buf.append("31050990940");
        buf.append("90084078073");
        buf.append("06906406205");
        buf.append("80560540530");
        buf.append("52050049045");
        buf.append("04304103903");
        buf.append("60350330310");
        buf.append("30030028026");
        buf.append("02402202102");
        buf.append("00190180170");
        buf.append("15015014014");
        buf.append("01301201101");
        buf.append("10110100100");
        buf.append("09009009008");
        buf.append("00800800700");
        buf.append("70070070060");
        buf.append("06006006005");
        buf.append("00500400400");
        buf.append("40040040040");
        buf.append("04004004004");
        buf.append("00300300300");
        buf.append("30030020020");
        buf.append("02002002002");
        buf.append("00200100100");
        buf.append("10010010010");
        buf.append("01001001001");
        buf.append("00100100100");
        buf.append("10010010010");
        buf.append("01001001001");
        buf.append("00100100100");
        buf.append("10010010010");
        buf.append("01001001001");
        buf.append("00100100100");
        buf.append("10010010010");
        buf.append("01001001000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000000");
        buf.append("00000000010");
        buf.append("03006010015");
        buf.append("02002903804");
        buf.append("50530620710");
        buf.append("80090102114");
        buf.append("12613915116");
        buf.append("41741841932");
        buf.append("03212222228");
        buf.append("23423824224");
        buf.append("32442482522");
        buf.append("53255253252");
        buf.append("24924624223");
        buf.append("82332292262");
        buf.append("24222221215");
        buf.append("21020520019");
        buf.append("51901851801");
        buf.append("75170164159");
        buf.append("15615314814");
        buf.append("41411381331");
        buf.append("29125122119");
        buf.append("11611311111");
        buf.append("01091061031");
        buf.append("01099094090");
        buf.append("08708508408");
        buf.append("30800770740");
        buf.append("72070068067");
        buf.append("06606306005");
        buf.append("80560540530");
        buf.append("53053052052");
        buf.append("05004904704");
        buf.append("60440430420");
        buf.append("42041041040");
        buf.append("04003803703");
        buf.append("50340340340");
        buf.append("32030030031");
        buf.append("02902702602");
        buf.append("60260260250");
        buf.append("24023022020");
        buf.append("01901801701");
        buf.append("70170170170");
        buf.append("17017017017");
        buf.append("01501401401");
        buf.append("40140140130");
        buf.append("13013013013");
        buf.append("01401401401");
        buf.append("40140130130");
        buf.append("12012011010");
        buf.append("01001000900");
        this.parse(this.equipamento.arruma(buf.toString()));
    }

    private class SampleData {
        private String id;
        private String wbc;
        private String lymphNum;
        private String midNum;
        private String granNum;
        private String lymphPer;
        private String midPer;
        private String granPer;
        private String rbc;
        private String hgb;
        private String mchc;
        private String mcv;
        private String mch;
        private String rdwCvPer;
        private String hctPer;
        private String plt;
        private String mpv;
        private String pdw;
        private String pctPer;
        private String rdwSd;

        public SampleData(String data) throws ParseException {
            if (!InterfaceListener.this.configuracao.getModoContinuo()) {
                String[] partes = data.split(String.valueOf('\n'), -1);
                this.id = partes[5];
                this.wbc = partes[13];
                this.lymphNum = partes[14];
                this.midNum = partes[15];
                this.granNum = partes[16];
                this.lymphPer = partes[17];
                this.midPer = partes[18];
                this.granPer = partes[19];
                this.rbc = partes[20];
                this.hgb = partes[21];
                this.mchc = partes[22];
                this.mcv = partes[23];
                this.mch = partes[24];
                this.rdwCvPer = partes[25];
                this.hctPer = partes[26];
                this.plt = partes[27];
                this.mpv = partes[28];
                this.pdw = partes[29];
                this.pctPer = partes[30];
                this.rdwSd = partes[31];
            } else {
                data = data.substring(14);
                this.id = data.substring(0, 8);
                this.wbc = data.substring(21, 24) + "." + data.substring(24, 25);
                this.lymphNum = data.substring(25, 28) + "." + data.substring(28, 29);
                this.midNum = data.substring(29, 32) + "." + data.substring(32, 33);
                this.granNum = data.substring(33, 36) + "." + data.substring(36, 37);
                this.lymphPer = data.substring(37, 39) + "." + data.substring(39, 40);
                this.midPer = data.substring(40, 42) + "." + data.substring(42, 43);
                this.granPer = data.substring(43, 45) + "." + data.substring(45, 46);
                this.rbc = data.substring(46, 48) + "." + data.substring(48, 50);
                this.hgb = data.substring(50, 52) + "." + data.substring(52, 53);
                this.rdwCvPer = data.substring(65, 67) + "." + data.substring(67, 68);
                this.hctPer = data.substring(68, 70) + "." + data.substring(70, 71);
                this.plt = data.substring(72, 75);
                this.mpv = data.substring(75, 77) + "." + data.substring(77, 78);
                this.rdwSd = data.substring(84, 87) + "." + data.substring(87, 88);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getWbc() {
            return this.wbc;
        }

        public String getLymphNum() {
            return this.lymphNum;
        }

        public String getMidNum() {
            return this.midNum;
        }

        public String getGranNum() {
            return this.granNum;
        }

        public String getLymphPer() {
            return this.lymphPer;
        }

        public String getMidPer() {
            return this.midPer;
        }

        public String getGranPer() {
            return this.granPer;
        }

        public String getRbc() {
            return this.rbc;
        }

        public String getHgb() {
            return this.hgb;
        }

        public String getMchc() {
            return this.mchc;
        }

        public String getMcv() {
            return this.mcv;
        }

        public String getMch() {
            return this.mch;
        }

        public String getRdwCvPer() {
            return this.rdwCvPer;
        }

        public String getHctPer() {
            return this.hctPer;
        }

        public String getPlt() {
            return this.plt;
        }

        public String getMpv() {
            return this.mpv;
        }

        public String getPdw() {
            return this.pdw;
        }

        public String getPctPer() {
            return this.pctPer;
        }

        public String getRdwSd() {
            return this.rdwSd;
        }
    }
}

