/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bc20s;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.bc5380.InterfaceListener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_BINARY_BASE64 = "^Application^Octet-stream^Base64^";
    private static final String IMAGE_BINARY_OCTER_BASE64 = "^Application^Octer-stream^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();
    public static final int SIT_NAO_ENVIADO = 0;
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_A_REPETIR = 5;
    public static final int SIT_EXCECAO = 6;
    public static final int SIT_PRONTO_VALIDADO = 7;
    public static final int SIT_EXPORTADO = 8;

    @Override
    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QRY_Q02: {
                this.messageQryQ02Recebida((MessageQryQ02)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            case ORR_O02: {
                this.messageOrro02Recebida((MessageOrrO02)message);
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void messageOrro02Recebida(MessageOrrO02 orro02) {
        block16: {
            String messageId = orro02.getMsh().getMessageControlId();
            try {
                String idTubo = orro02.getObr().getPlacerOrderNumber();
                int digitosCodigoTubo = this.getQtdeDigitosTubo();
                if (!Funcoes.textoVazio(idTubo) && Funcoes.isNumeric(idTubo) && idTubo.length() == digitosCodigoTubo) {
                    String filCodigo = idTubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = idTubo.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (this.isNull(req)) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (this.isNull(req)) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (this.isNull(req)) {
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orro02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (!this.isSituacaoValida(n)) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orro02);
                        this.fireExcecaoEncontrada(idTubo + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(idTubo, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orro02.getPid().setId(1);
                        orro02.getPid().setPatientName("^" + pacNome);
                        orro02.getPid().setSex(pacSexo);
                        orro02.getPid().setDataOfBirth(pacNasc);
                        orro02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orro02.getOrc().setOrderControl("AF");
                        orro02.getOrc().setPlaceOrderNumber(orro02.getObr().getPlacerOrderNumber());
                        orro02.getObr().setPlacerOrderNumber(orro02.getObr().getPlacerOrderNumber());
                        orro02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orro02.getObr().setCollectorIdentifier("MA");
                        orro02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orro02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("08003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orro02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("01002^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        this.enviaMensagem(messageId, orro02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(idTubo));
                        this.examesEnviadosPorSid.remove(idTubo);
                    }
                    break block16;
                }
                orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orro02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private boolean isSituacaoValida(int situacao) {
        return situacao == 0 || situacao == 1 || situacao == 3;
    }

    private int getQtdeDigitosTubo() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = this.getQtdeDigitosTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                MessageSegmentObx obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "08003^Test Mode^99MRC");
                if (this.isNull(obx)) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "08002^Blood Mode^99MRC");
                }
                if (this.isNull(obx)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar o alternativo do exame: " + filCodigo + " " + reqCodigo + " " + recCodigo);
                    return;
                }
                String emiAlternativo = obx.getObservationValue();
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                for (String p : this.parametros.keySet()) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (this.isNull(obx)) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, resultado, listaWarning);
                    if (resultado.length() > IMAGE_BINARY_BASE64.length() && resultado.substring(0, IMAGE_BINARY_BASE64.length()).equalsIgnoreCase(IMAGE_BINARY_BASE64)) {
                        resultado = resultado.substring(IMAGE_BINARY_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else if (resultado.length() > IMAGE_BINARY_OCTER_BASE64.length() && resultado.substring(0, IMAGE_BINARY_OCTER_BASE64.length()).equalsIgnoreCase(IMAGE_BINARY_OCTER_BASE64)) {
                        resultado = resultado.substring(IMAGE_BINARY_OCTER_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        if (!this.isNull(image)) {
            ImageIO.getCacheDirectory();
            File img = File.createTempFile("bc20s_" + reqCodigo, ".png");
            ImageIO.write((RenderedImage)image, "png", img);
            BufferedImage imgNew = ImageIO.read(img);
            resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            img.delete();
            return resultado;
        }
        return "";
    }

    private void retornaAlerta(String campo, String resultado, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private boolean isNull(Object obx) {
        return obx == null;
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        buf.append("[SB]MSH|^~\\&||Mindray|||20141105151358||ORR^O02||P|2.3.1||||||UNICODE[CR]");
        buf.append("MSA|AA|60PID|1||test1^^^^MR||^Tom||20080525000000|[CR]");
        buf.append("PV1|1||ICU^^BedNO1[CR]");
        buf.append("ORC|AF|010007507901|||[CR]");
        buf.append("OBR|1|010007507901||00001^Automated Count^99MRC||20090205100000||||S1||||20090203101020||||||||||HM||||||||A5[CR]");
        buf.append("OBX|1|IS|08002^Blood Mode^99MRC||W||||||F[CR]");
        buf.append("OBX|2|IS|08003^Test Mode^99MRC||CBC||||||F[CR]");
        buf.append("OBX|3|NM|30525-0^Age^LN||14|yr|||||F[CR]");
        buf.append("OBX|4|ST|01001^Remark^99MRC||R5||||||F[CR]");
        buf.append("[EB][CR]");
        String req = "010007507901";
        tmp.append("[SB]MSH|^~\\&|||||20150120161704||ORU^R01|1|P|2.3.1||||||UNICODE[CR][CR]");
        tmp.append("PID|1||binglihao^^^^MR||^zhangsan||19820123000000|Male[CR]");
        tmp.append("PV1|1|Zhuyuan|ICU^^chuanghao[CR]");
        tmp.append("OBR|1||").append(req).append("|00001^Automated[SP]Count^99MRC||20141013101300|20141013125435|||lisi||||20141013121200||||||||||HM||||||||Admin[CR]");
        tmp.append("OBX|1|IS|08001^Take Mode^99MRC||O||||||F[CR]");
        tmp.append("OBX|2|IS|08002^Blood Mode^99MRC||W||||||F[CR]");
        tmp.append("OBX|3|IS|01002^Ref Group^99MRC||Adult Male||||||F[CR]");
        tmp.append("OBX|4|NM|30525-0^Age^LN||32|yr|||||F[CR]");
        tmp.append("OBX|5|ST|01001^Remark^99MRC||beizhu||||||F[CR]");
        tmp.append("OBX|6|NM|6690-2^WBC^LN||5.2|10*9/L|4.0-10.0|N|||F[CR]");
        tmp.append("OBX|7|NM|731-0^LYM#^LN||2.2|10*9/L|0.8-4.0|N|||F[CR]");
        tmp.append("OBX|8|NM|736-9^LYM%^LN||42.4|%|20.0-40.0|H~N|||F[CR]");
        tmp.append("OBX|9|NM|789-8^RBC^LN||3.03|10*12/L|4.00-5.50|L~N|||F[CR]");
        tmp.append("OBX|10|NM|718-7^HGB^LN||96|g/L|120-160|L~N|||F[CR]");
        tmp.append("OBX|11|NM|787-2^MCV^LN||96.1|fL|80.0-100.0|N|||F[CR]");
        tmp.append("OBX|12|NM|785-6^MCH^LN||31.7|pg|27.0-34.0|N|||F[CR]");
        tmp.append("OBX|13|NM|786-4^MCHC^LN||330|g/L|320-360|N|||F[CR]");
        tmp.append("OBX|14|NM|788-0^RDW-CV^LN||17.8|%|11.0-16.0|H~N|||F[CR]");
        tmp.append("OBX|15|NM|21000-5^RDW-SD^LN||63.7|fL|35.0-56.0|H~N|||F[CR]");
        tmp.append("OBX|16|NM|4544-3^HCT^LN||29.1|%|40.0-54.0|L~N|||F[CR]");
        tmp.append("OBX|17|NM|777-3^PLT^LN||235|10*9/L|100-300|N|||F[CR]");
        tmp.append("OBX|18|NM|32623-1^MPV^LN||11.0|fL|6.5-12.0|N|||F[CR]");
        tmp.append("OBX|19|NM|32207-3^PDW^LN||16.5||15.0-17.0|N|||F[CR]");
        tmp.append("OBX|20|NM|10002^PCT^99MRC||0.258|%|0.108-0.282|N|||F[CR]");
        tmp.append("OBX|21|NM|10027^MID#^99MRC||0.7|10*9/L|0.1-1.5|N|||F[CR]");
        tmp.append("OBX|22|NM|10029^MID%^99MRC||12.5|%|3.0-15.0|N|||F[CR]");
        tmp.append("OBX|23|NM|10028^GRAN#^99MRC||2.4|10*9/L|2.0-7.0|N|||F[CR]");
        tmp.append("OBX|24|NM|10030^GRAN%^99MRC||45.1|%|50.0-70.0|L~N|||F[CR]");
        tmp.append("OBX|25|NM|10013^PLCC^99MRC||83|10*9/L|30-90|N|||F[CR]");
        tmp.append("OBX|26|NM|10014^PLCR^99MRC||35.2|%|11.0-45.0|N|||F[CR]");
        tmp.append("OBX|27|NM|15004^WBC Histogram. Meta Length^99MRC||1||||||F[CR]");
        tmp.append("OBX|28|NM|15009^WBC Histogram. Total^99MRC||128||||||F [CR]");
        tmp.append("OBX|29|NM|15010^WBC Lym left line.^99MRC||8||||||F[CR]");
        tmp.append("OBX|30|NM|15011^WBC Lym Mid line.^99MRC||26||||||F[CR]");
        tmp.append("OBX|31|NM|15012^WBC Mid Gran line.^99MRC||44||||||F[CR]");
        tmp.append("OBX|32|NM|15013^WBC Gran right line^99MRC||105||||||F[CR]");
        tmp.append("OBX|33|ED|15000^WBC Histogram. Binary^99MRC||^Application^Octer-stream^Base64^AAAAAAABAwkVKUZjdn59d21gUUQ6MSsmIh8dH");
        tmp.append("BsbGhgXFhYWFhcWFRQTExQUExIREhMUFRYYGhsbHB0dHR0fISMkJSYnKCoqKiooJyUiIB0bGhkYF");
        tmp.append("xYUEhEPDw0MCggHBgYFBAQDAwMCAgICAgEBAQEBAQEBAQEAAAAAAAAAAAA=||||||F[CR]");
        tmp.append("OBX|34|NM|15051^RBC Histogram. Left Line^99MRC||17||||||F[CR]");
        tmp.append("OBX|35|NM|15052^RBC Histogram. Right Line^99MRC||79||||||F[CR]");
        tmp.append("OBX|36|NM|15053^RBC Histogram. Binary Meta Length^99MRC||1||||||F[CR]");
        tmp.append("OBX|37|NM|15057^RBC Histogram. Total^99MRC||128||||||F[CR]");
        tmp.append("OBX|38|ED|15050^RBC Histogram. Binary^99MRC||^Application^Octer-stream^Base64^AAAAAAAAAAAAAAAAAAAAAAECAgMEBQUH");
        tmp.append("CQsPFBoiLDdFUl9sd3Z7fnx2bWhhWk9GPzk0LCYgGhURDgwLCQgHBwYFBAQDAwICAgIBAQICAgE");
        tmp.append("BAQEBAQEBAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        tmp.append("AA=||||||F[CR]");
        tmp.append("OBX|39|NM|15111^PLT Histogram. Left Line^99MRC||3||||||F[CR]");
        tmp.append("OBX|40|NM|15112^PLT Histogram. Right Line^99MRC||96||||||F[CR]");
        tmp.append("OBX|41|NM|15113^PLT Histogram. Binary Meta Length^99MRC||1||||||F[CR]");
        tmp.append("OBX|42|NM|15117^PLT Histogram. Total^99MRC||128||||||F[CR]");
        tmp.append("OBX|43|ED|15100^PLT Histogram. Binary^99MRC||^Application^Octer-stream^Base64^AAUJDhQaISgxOkNNVl9lanB0eHt9fX59fHt5dnNvbG");
        tmp.append("hlYV5aVlNPTElGQ0E+PDk3NDIwLSspJyUjIR8dGxkXFhQTEhEREA8PDg0NDQ0NDQwMDAwMDAwM");
        tmp.append("DA0NDQ0ODg4PDw8PDw8PDw8PDw8PEBARERITExQVFRYWFhYWFxgYGBg=||||||F [CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

