/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bactec;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.interfaces.bactec.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.bactec.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.bdmodem.BdModemStandard;
import jalis.laboratorio.interfaceamento.padroes.bdmodem.InterfaceBdModemListener;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceBdModemListener {
    private ThreadRecebimento threadRecebimento;
    private List<String> request = new ArrayList<String>();
    protected boolean hostQuery = false;
    protected String host_fil_codigo = "";
    protected String host_req_codigo = "";
    protected String host_rec_codigo = "";
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private Timer timerResultados;
    private Thread buscaResultados;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceBdModemListener(this);
        super.setBdModemRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 40;
        this.threadRecebimento = new ThreadRecebimento(this);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (Funcoes.isNumeric(this.configuracao.getTempoParaBuscarResultados())) {
            int tempoIteracoesBuscarResultados = Integer.parseInt(this.configuracao.getTempoParaBuscarResultados()) * 60000;
            this.timerResultados = new Timer(tempoIteracoesBuscarResultados, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InterfaceListener.this.buscarResultadosPendentes();
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace());
                    }
                }
            });
            this.timerResultados.start();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        if (acao.equals("R")) {
            try {
                this.sendRequestResultsRecord(req_codigo + rec_codigo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            return "";
        }
        return super.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, mapaParametros);
    }

    protected void buscarResultadosPendentes() {
        final ArrayList exames = this.getExamesAba(1);
        final PanelAbaAbstrata aba = this.getAba(1);
        if (this.buscaResultados != null && !this.buscaResultados.isInterrupted() && this.buscaResultados.isAlive()) {
            return;
        }
        this.buscaResultados = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> requisicoes = new ArrayList<String>();
                for (int i = 0; i < exames.size(); ++i) {
                    Object[] req = (Object[])exames.get(i);
                    String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        requisicao = (String)req[aba.getColIndice("Multiguia")];
                    }
                    String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    String codigoBarra = requisicao + tubo;
                    if (requisicoes.contains(codigoBarra)) continue;
                    requisicoes.add(codigoBarra);
                    try {
                        int tentativas;
                        for (tentativas = 5; (InterfaceListener.this.getPortaCOM() == null || InterfaceListener.this.isTX() || InterfaceListener.this.isRX() || !InterfaceListener.this.isIdle()) && tentativas > 0; --tentativas) {
                            Thread.sleep(5000L);
                        }
                        if (tentativas > 0) {
                            System.out.println("Requisitando " + codigoBarra);
                            InterfaceListener.this.sendRequestResultsRecord(codigoBarra);
                            System.out.println("aguarda receber o resultado " + codigoBarra);
                            Thread.sleep(5000L);
                            continue;
                        }
                        System.out.println("Ocupado");
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.buscaResultados.start();
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.timerResultados != null) {
            this.timerResultados.stop();
        }
    }

    public void sendRequestResultsRecord(String barcode) throws Exception {
        if (this.tx_list == null) {
            this.tx_list = new MemoryList();
        }
        if (this.rx_list == null) {
            this.rx_list = new MemoryList();
        }
        StringBuilder msg = new StringBuilder();
        msg.append(BdModemStandard.getDefaultHeaderRecord(this.DELIMITERS));
        String string = "^" + barcode;
        this.getClass();
        msg.append(BdModemStandard.getDefaultEnquiryRecord(string, null, "ALL", null, null, "P"));
        msg.append(BdModemStandard.getDefaultTerminationRecord("N"));
        this.tx_list.add(msg.toString());
        this.tx_list = this.makeFrames(this.tx_list);
        this.tx_list.resetUltimoLido();
        this.tx_list.resetUltimoLido();
        this.setTX(this.TIME_TX);
        this.tx_counter = 0;
        this.getPortaCOM().write(String.valueOf('\u0016'));
    }

    @Override
    public void sendRequestAllResultsRecord() throws Exception {
        this.sendRequestResultsRecord("ALL^ALL");
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            if (!(Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.mco_codigo) || this.exames == null)) {
                Statement st = Conexao.getStatement();
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        if (this.hostQuery || this.ultima_acao.equals("N")) {
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
        if (this.request.size() == 0) {
            this.hostQuery = false;
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (!this.configuracao.getModoHostQuery()) {
                return;
            }
            if (starting_range.startsWith("^")) {
                starting_range = starting_range.substring(1);
            }
            if (Funcoes.textoVazio(starting_range)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            if (starting_range.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.host_fil_codigo = "01";
            this.host_req_codigo = "00026254";
            this.host_rec_codigo = "04";
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) throws Exception {
        StringBuilder msg = new StringBuilder();
        StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
        rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
        codigo.append(rec_codigo);
        msg.append(BdModemStandard.getDefaultHeaderRecord(this.DELIMITERS));
        Object patient_id = null;
        String laboratory_pid = req_codigo;
        msg.append(BdModemStandard.getDefaultPatientRecord(1, laboratory_pid, "", ""));
        msg.append(BdModemStandard.getDefaultOrderRecord(1, codigo.toString()));
        msg.append(BdModemStandard.getDefaultTerminationRecord());
        this.tx_list.add(msg.toString());
        this.tx_list = this.makeFrames(this.tx_list);
        this.tx_list.resetUltimoLido();
        this.setTX(this.TIME_TX);
        this.tx_counter = 0;
        this.resetCountFrame();
        this.getPortaCOM().write(String.valueOf('\u0016'));
    }

    @Override
    public void teste() {
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }
}

