/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.ba400;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.ba400.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected String host_id_unique = null;
    protected String rackpos = null;
    protected boolean hostQuery = false;
    private Map<String, String> flags = new HashMap<String, String>();
    private RecordParser recordParser = null;
    private static final String ENVIO_POR_QUERY = "TSDWN^REPLY";
    private static final String ENVIO_POR_LOTE = "TSDWN^BATCH";
    private List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private List<String> tubos = new ArrayList<String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private InterfaceamentoConfiguracao configuracao = new InterfaceamentoConfiguracao();
    private boolean exr_codigoapoiado = false;
    private String[] sampleId = null;

    public InterfaceListener() {
        this.recordParser = new RecordParser();
        this.recordParser.setInterfaceASTMListener(this);
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        super.setASTMRecordParser(this.recordParser);
        this.HOST_SYSTEM_VERSION = "1";
        this.INSTRUMENT_NAME = "ba400";
        this.INSTRUMENT_SYSTEM_VERSION = "1";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.flags.put("001", "Abs > optical limit");
        this.flags.put("002", "Sample Abs < Blank Abs");
        this.flags.put("003", "Sample Abs > Blank Abs");
        this.flags.put("004", "Non Linear Kinetics");
        this.flags.put("005", "Absorbance < 0");
        this.flags.put("006", "Absorbance increase < 0");
        this.flags.put("007", "Substrate depletion");
        this.flags.put("008", "Possible prozone (it requires manual dilution and repetition)");
        this.flags.put("009", "Reactions rotor thermo warning");
        this.flags.put("010", "Possible clot in sample");
        this.flags.put("011", "Clot detected in sample");
        this.flags.put("012", "Sample arm fluidic system blocked");
        this.flags.put("027", "Conc. out of calibration curve (HIGH)");
        this.flags.put("028", "Conc. out of calibration curve (LOW)");
        this.flags.put("029", "Conc < 0");
        this.flags.put("030", "Conc > Linearity limit");
        this.flags.put("031", "Conc < Detection limit");
        this.flags.put("032", "Conc < Normality Min");
        this.flags.put("033", "Conc > Normality Max");
        this.flags.put("034", "Conc < Panic Min");
        this.flags.put("035", "Conc > Panic max");
        this.flags.put("036", "Calculated Test with some partial tests with remarks");
        this.flags.put("037", "Drift in calibrator A");
        this.flags.put("038", "Drift in calibrator A");
        this.flags.put("039", "Noise in measuring calibrator A");
        this.flags.put("040", "Noise in measuring calibrator B");
        this.flags.put("041", "Noise measuring calibrator B");
        this.flags.put("042", "Voltage out of limit measuring calibrator A");
        this.flags.put("043", "Drift out of limits");
        this.flags.put("044", "Voltage out of limit measuring calibrator B");
        this.flags.put("045", "Result out of range");
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            String short_name;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            prioridade = "R";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()), 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (!Funcoes.objectIsNull(aba)) {
                if (aba.getColIndice("Urgente") >= 0 && null != req) {
                    if (!Funcoes.objectIsNull(req[aba.getColIndice("Urgente")])) {
                        if (((Boolean)req[aba.getColIndice("Urgente")]).booleanValue()) {
                            prioridade = "S";
                        }
                    }
                }
            }
            if ((short_name = StringUtil.removerAcentos(pac_nome)).length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "SER";
            }
            if (Funcoes.textoVazio(rackposition)) {
                rackposition = String.format("^^^^S%s^SC", tipo_amostra);
            } else if (!rackposition.endsWith("^SC")) {
                rackposition = String.format("%s^^S%s^SC", rackposition, tipo_amostra);
            }
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            StringBuilder frame = new StringBuilder();
            frame.append(this.getHeaderRecord(this.DELIMITERS, this.getMessageControlId(), "JALIS", "BA400"));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Object laboratory_pid = null;
            String t = InterfaceListener.getPatientRecord(1, codigo.toString(), nome, dtNascPac);
            frame.append(t);
            int tam = 13;
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                for (int i = 0; i < alternativos.length; ++i) {
                    t = this.getOrderRecord(++seq, Funcoes.preencheVazio(codigo.toString(), tam, 1), rackposition, alternativos[i], prioridade, "A", tipo_amostra, "O");
                    frame.append(t);
                }
            }
            String recipiente = "";
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    recipiente = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    String tubo = cod + recipiente;
                    t = this.getOrderRecord(++seq, Funcoes.preencheVazio(tubo, 13, 1), rackposition, alternativosCurva.get(key).get(0), prioridade, "A", tipo_amostra, "O");
                    frame.append(t);
                }
            }
            t = this.getTermination();
            frame.append(t);
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            infoExame.setTuboPai(this.rec_tuboPai);
            infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            infoExame.setCurva(this.curva);
            this.examesEnviados.add(infoExame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 1024);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    public static String getPatientRecord(int patient_sequence, String codigo, String pac_nome, String pac_nascimento) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("||").append(codigo).append("||");
        record.append(pac_nome);
        record.append("||");
        record.append(pac_nascimento);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial test_item_numbers, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id.trim());
        record.append("||");
        if (test_item_numbers != null) {
            record.append("^^^");
            record.append(test_item_numbers.getNomeExame());
        }
        record.append("|");
        record.append(priority);
        record.append("|||||");
        record.append("|" + action_code + "|||");
        record.append("|" + sample_type + "|||||||||");
        record.append("|" + report_type);
        record.append('\r');
        return record.toString();
    }

    private String getHeaderRecord(String delimiters, String password, String sender_id_name, String receiver_id_name) throws NoSuchAlgorithmException {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("|");
        record.append(password);
        record.append("||");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append("|||||");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append("||P|");
        record.append("LIS2A|");
        record.append(ASTMStandard.getCurrentMoment().trim());
        record.append('\r');
        return record.toString();
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() == 0) {
            this.enviarRequisicaoSemExame("", "");
            this.hostQuery = false;
        }
        if (this.tubos.size() > 0) {
            this.hostQuery = true;
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }

    private void enviaProximaAmostra() {
        this.sampleId = this.tubos.remove(0).split("[|]");
        String amostra = this.sampleId[0];
        Integer quantidadeTubos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        if (quantidadeTubos.intValue() != amostra.length()) {
            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o para a requisi\u00e7\u00e3o %s ", amostra));
            return;
        }
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
            this.fireAtualizarTabela(0);
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        ++this.rx_counter;
                        this.setIdle();
                        this.setRX();
                        this.rx_counter = 0;
                        this.tratarEnquiry();
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            StringBuilder frame = new StringBuilder();
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            frame.append(this.getHeaderRecord(this.DELIMITERS, this.getMessageControlId(), "JALIS", "BA400"));
            frame.append(this.getTermination());
            this.tx_list.add(frame.toString());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            this.tubos.clear();
            String[] tubosRecebidos = starting_range.split("\\\\");
            this.hostQuery = true;
            for (String tuboRecebido : tubosRecebidos) {
                this.tubos.add(tuboRecebido);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "BA 400: Host Query Response");
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String codigoEtiqueta = this.sampleId[0];
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String rack = this.rackpos;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String req_codigoapoio = null;
                if (this.exr_codigoapoiado) {
                    if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                        if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (ParametrosGerais.isAgruparGuiasInterface()) {
                                requisicao = (String)req[aba.getColIndice("Multiguia")];
                            }
                            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                            String tubo = (String)req[aba.getColIndice("Tubo")];
                            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                            if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                                if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                    req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                                }
                            }
                            fil_codigo = filial;
                            req_codigo = requisicao;
                            rec_codigo = tubo;
                        }
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    map.put("codigoApoiado", req_codigoapoio);
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                } else {
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                }
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "BA 400: Host Query Response");
        }
    }

    private String getTermination() {
        return "L|1|N\r";
    }

    @Override
    public String getErroTraduzido(String erro) {
        if (this.flags.containsKey(erro)) {
            return this.flags.get(erro);
        }
        if (erro.startsWith("ASTM")) {
            return this.flags.get("ASTM") + erro;
        }
        return null;
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        if (this.ultima_acao.equals("N")) {
            this.fireAtualizarTabela(0);
        } else if (this.ultima_acao.equals("A")) {
            this.fireAtualizarTabela(2);
        }
        this.setIdle();
        if (this.examesEnviados.size() > 0) {
            this.encerrarTransmissao(this.examesEnviados.remove(0));
        }
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        Statement st = Conexao.getStatement();
        if (infoExame != null) {
            String[] exames = infoExame.getExames().split(" ");
            String fil_codigo = infoExame.getFilial();
            String int_codigo = infoExame.getInterface();
            String req_codigo = infoExame.getCodigo();
            String mco_codigo = infoExame.getMaterial();
            String rec_tuboPai = infoExame.getTuboPai();
            String rec_codigo = infoExame.getRecipiente();
            boolean curva = infoExame.isCurva();
            for (int i = 0; i < exames.length; ++i) {
                int situacao;
                String[] examesFilho = infoExame.getExamesFilho().split(" ");
                if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                    for (String exame : examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (examesFilho != null && examesFilho.length > 0) {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    protected void confirmacaoACK() {
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra?");
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        tmp.append("[STX]1H|\\^&|0e115a94-bcfc-4000-96a1-7216c4702336||BA400|||||Host||P|LIS2A|20140325172110[CR]");
        tmp.append("Q|1|010007576504\\010002366504||O[CR]");
        tmp.append("L|1|N[CR]");
        tmp.append("[ETX]3C[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    private String stringHexa(byte[] bytes) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                s.append('0');
            }
            s.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return s.toString();
    }

    private String getMessageControlId() {
        String messageControlID = ASTMStandard.getCurrentMoment();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ASTMStandard.getCurrentMoment().getBytes());
            byte[] hashMd5 = md.digest();
            messageControlID = this.stringHexa(hashMd5);
            return messageControlID;
        }
        catch (NoSuchAlgorithmException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            return messageControlID;
        }
    }

    private void resultado() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[STX]1H|\\^&|ff80badc-1599-4d01-9533-601d01cdd9a1||BA400|||||Jalis||P|LIS2A|20170517154902[CR]");
        tmp.append("P|1||2205060204|||||[CR]");
        tmp.append("O|1|010002625504||^^^690|R||||||||||SER|||||||20170517124901|||F[CR]");
        tmp.append("R|1|^^^690|4.71000004|mmol/L||||F||admin||20170517124901|A400^834000697[CR]");
        tmp.append("O|2|010002625541||^^^781^|R||||||||||SER|||||||20170517124901|||F[CR]");
        tmp.append("R|1|^^^781|137.185989|mmol/L||||F||admin||20170517124901|A400^834000697[CR]");
        tmp.append("O|2|010002625504||^^^692^|R||||||||||SER|||||||20170517124901|||F[CR]");
        tmp.append("R|1|^^^692|692.185989|mmol/L||||F||admin||20170517124901|A400^834000697[CR]");
        tmp.append("L|1|N[CR]");
        tmp.append("[ETX]BC[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                ArrayList<String> msgResultado = new ArrayList<String>();
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    String record = s.substring(0, s.length() - 1);
                    String record_type = ASTMStandard.getRecordTypeIdentifier(record);
                    if (record_type == null) continue;
                    if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                        msgResultado.add(s);
                        ArrayList<String> resultado = new ArrayList<String>(msgResultado);
                        this.parseRes(resultado);
                        msgResultado.clear();
                        continue;
                    }
                    msgResultado.add(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private synchronized void parseRes(List<String> resultado) throws Exception {
        RecordParser recordParser = new RecordParser();
        recordParser.setInterfaceASTMListener(this);
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        exameAtual = new HashMap();
        boolean isOrdem = false;
        for (String s : resultado) {
            exameAtual = recordParser.recordFound(s, exameAtual);
        }
        Conexao.arquivaSQL();
        RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
    }

    private synchronized void parseRecord(String s) throws Exception {
        this.recordParser.recordFound(s);
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                if (this.hostQuery) {
                    this.handShakeCharReceived('\u0004');
                    return;
                }
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

