/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.axsym;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.axsym.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    public static final String RESULT_STATUS_INTERPRETATION = "I";
    public static final Integer TEST_QUALIFIER = new Integer(7);
    public static final Integer TEST_RESULT_TYPE = new Integer(8);

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 15;
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 6, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            components.put(TEST_RESULT_TYPE, tokens[7]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = null;
            String sobrenome = short_name;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }
}

