/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.audmaxevolution;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.audmaxevolution.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    private List<String> requestsQuery = new LinkedList<String>();
    private List<InfoExameRequisicao> listaInfoExameRequisicao = new ArrayList<InfoExameRequisicao>();
    private boolean hostQuery = false;
    private Map<String, String> ageUnits = new HashMap<String, String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "Host";
        this.MAX_PATIENT_NAME_CHARS = 30;
        this.ageUnits.put("A", "Y");
        this.ageUnits.put("M", "M");
        this.ageUnits.put("D", "D");
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            String dataNascimento;
            String laboratory_pid;
            String patient_id;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            if (!this.hostQuery) {
                this.tx_list.clear();
                this.rx_list.clear();
            }
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            String sample_number = "";
            String disk_ID = "";
            String position_number = "";
            String diluent = "N";
            Statement st = Conexao.getStatement();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            }
            if (!exa_listaCurva.isEmpty()) {
                ArrayList<String> exameCurva = new ArrayList<String>();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            String nome = short_name;
            String sobrenome = null;
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                for (ExameMaterial exameMaterial : alternativos) {
                    this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
                    }
                    patient_id = req_codigo;
                    laboratory_pid = null;
                    dataNascimento = Funcoes.formataData(BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo));
                    this.tx_list.add(this.getPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, Funcoes.calculaIdade(dataNascimento, false), this.ageUnits.get(Funcoes.calculaAnoMes(dataNascimento))));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
                    }
                    this.tx_list.add(this.getOrderRecord(++seq, codigo.toString(), rackposition, exameMaterial, exa_lista[seq - 1], "R", acao, tipo_amostra, "O"));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
                    }
                    this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
                    }
                    patient_id = req_codigo;
                    laboratory_pid = null;
                    dataNascimento = Funcoes.formataData(BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo));
                    this.tx_list.add(this.getPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, Funcoes.calculaIdade(dataNascimento, false), this.ageUnits.get(Funcoes.calculaAnoMes(dataNascimento))));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
                    }
                    ++seq;
                    this.tx_list.add(this.getOrderRecord(++seq, sample_id.append(tubo).toString(), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, "R", acao, tipo_amostra, "O"));
                    if (this.tx_list.size() < 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
                    }
                    this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                }
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            this.listaInfoExameRequisicao.add(infoExame);
            if (!this.hostQuery) {
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String query = starting_range;
            if (starting_range.contains("^")) {
                query = starting_range.substring(0, starting_range.indexOf("^"));
            }
            if (query.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
                return;
            }
            this.requestsQuery.add(starting_range);
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CS 240: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (!this.requestsQuery.isEmpty()) {
            this.responseHostQuery();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (!this.listaInfoExameRequisicao.isEmpty()) {
                InfoExameRequisicao infoExameRequisicao = null;
                while (this.listaInfoExameRequisicao.size() > 0 && (infoExameRequisicao = this.listaInfoExameRequisicao.remove(0)) != null) {
                    String[] exames = infoExameRequisicao.getExames().split(" ");
                    if (exames != null && exames.length > 0) {
                        for (String exame : exames) {
                            int situacao = this.getExameSituacao(st, infoExameRequisicao.getFilial(), infoExameRequisicao.getMaterial(), infoExameRequisicao.getCodigo(), exame, infoExameRequisicao.getMaterial(), infoExameRequisicao.getRecipiente());
                            this.atualizarSituacaoExame(st, infoExameRequisicao.getFilial(), infoExameRequisicao.getCodigo(), infoExameRequisicao.getRecipiente(), exame, infoExameRequisicao.getMaterial(), infoExameRequisicao.getInterface(), null, situacao < 2 ? 1 : 3);
                        }
                        Conexao.arquivaSQL();
                        String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                        this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                        continue;
                    }
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.fireAtualizarTabela(0);
        this.limpaDadosRequisicao();
        this.setIdle();
        if (this.hostQuery) {
            this.hostQuery = false;
        }
    }

    public void responseHostQuery() {
        try {
            String starting_range = "";
            while (this.requestsQuery.size() > 0 && !Funcoes.textoVazio(starting_range = this.requestsQuery.remove(0))) {
                String rec_codigoPai;
                String query = starting_range;
                String rack = "";
                if (starting_range.contains("^")) {
                    query = starting_range.substring(0, starting_range.indexOf("^"));
                    rack = String.format("^%s%s", query, starting_range.substring(starting_range.indexOf("^") + 1));
                }
                String fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
                starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
                String req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                String rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo() + ParametrosGerais.getDigitosTuboRequisicao());
                String pac_nome = null;
                String pac_sexo = null;
                String pac_idade = null;
                String data = null;
                String hora = null;
                String prioridade = null;
                String int_codigo = null;
                String mco_codigo = null;
                StringBuilder pac_exames = new StringBuilder("");
                String acao = "A";
                Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]);
                }
                if (req == null) {
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    aba = this.equipamento.getTab(1);
                    if (req != null) {
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        for (Object[] r : reqs) {
                            pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                        }
                    }
                }
                String situacao = null;
                if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                    aba = this.equipamento.getTab(2);
                    if (req != null) {
                        Object[] r;
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                        r = reqs.iterator();
                        while (r.hasNext()) {
                            Object[] r2 = (Object[])r.next();
                            if (Integer.parseInt((String)r2[aba.getColIndice("Sit")]) <= 2) continue;
                            situacao = (String)r2[aba.getColIndice("Sit")];
                            pac_exames.append((String)r2[aba.getColIndice("Exame")]).append(" ");
                        }
                    }
                }
                if (req == null) continue;
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Tubo") >= 0 ? (String)req[aba.getColIndice("Tubo")] : (rec_codigoPai = null);
                if (Funcoes.textoVazio(pac_exames.toString())) {
                    pac_exames.append(aba.getColIndice("Exame") >= 0 ? (String)req[aba.getColIndice("Exame")] : "");
                }
                String tmp = pac_exames.toString();
                pac_exames.setLength(0);
                for (String exa : tmp.trim().split(" ")) {
                    if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa, mco_codigo)) {
                        BDExame[] t;
                        for (BDExame bdExame : t = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa, mco_codigo, rec_codigoPai, rec_codigo)) {
                            pac_exames.append(bdExame.getExame()).append(" ");
                        }
                        continue;
                    }
                    pac_exames.append(exa).append(" ");
                }
                if (situacao == null) {
                    situacao = aba.getColIndice("Sit") >= 0 ? (String)req[aba.getColIndice("Sit")] : null;
                }
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao);
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    private String getOrderRecord(int order_sequence, String sample_ID, String sample_number, String disk_ID, String position_number, String diluent, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String priority, String action_code, String sample_type, String report_type) {
        String rack = String.format("%s^%s^%s^%s", sample_number, disk_ID, position_number, diluent);
        return this.getOrderRecord(order_sequence, sample_ID, rack, test_item_numbers, test_item_names, priority, action_code, sample_type, report_type);
    }

    private String getOrderRecord(int order_sequence, String sample_ID, String rack, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(String.format("%s%s", sample_ID, rack));
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()));
        record.append("|||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sample_ID, String rack, ExameMaterial test_item, ExameMaterial test_item_name, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(String.format("%s%s", sample_ID, rack));
        record.append("||");
        if (test_item != null) {
            record.append("^^^");
            record.append(test_item.getNomeExame());
            record.append(test_item_name == null ? "" : "^" + test_item_name.getNomeExame());
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()));
        record.append("|||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, String age, String ageUnit) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("|||");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("||||||");
        record.append(String.format("%s^%s", age, ageUnit));
        record.append('\r');
        return record.toString();
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.resultado();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    private void resultado() {
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        tmp.append("[STX]1H|\\^&|||CS240|||||JALIS[SP]1.0||1|20201029120641[CR][ETX]76[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]2P|1||||^TESTE[SP]LABMAX[SP]PLENNO|||F||||||24^Y[CR][ETX]92[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]3O|1|010006055204|||R|20201029114607|||||||||0||||||||||O[CR][ETX]77[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]4R|1|^^^COL|271^1|mg/dL|0^500\\^|N||F||||20201029120441[CR][ETX]98[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]5R|2|^^^HDL|49^1|mg/dL|1^150\\^|N||F||||20201029120541[CR][ETX]6A[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]6R|3|^^^LDL|194^1|mg/dL|0^200\\^|N||F||||20201029114615[CR][ETX]A1[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]7R|4|^^^ALB|4.19^1|g/dL|^\\^|N||F||||20201029115901[CR][ETX]94[LINE]");
        this.getPortaCOM().read(tmp.toString(), tmp.toString().length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]0R|5|^^^PROT|7.58^1|g/dL|1^14\\^|N||F||||20201029120641[CR][ETX]9D[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]1R|6|^^^GGT|70^1|U/L|0^700\\^|N||F||||20201029120321[CR][ETX]83[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]2R|7|^^^BILIT|0.37^1|mg/dL|0^200\\^|N||F||||20201029120501[CR][ETX]5A[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]3R|8|^^^BILID|0.12^1|mg/dL|0^200\\^|N||F||||20201029120441[CR][ETX]48[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]4R|9|^^^TRI|140^1|mg/dL|0^1100\\^|N||F||||20201029120621[CR][ETX]D9[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]5R|10|^^^GLI|33^1|mg/dL|0^500\\^|N||F||||20201029120601[CR][ETX]91[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]6R|11|^^^AMI|89^1|mg/dL|2.4^1700\\^|N||F||||20201029115801[CR][ETX]36[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]7R|12|^^^CREA|0.68^1|mg/dL|0^12\\^|N||F||||20201029120441[CR][ETX]0A[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]0L|1|N[CR][ETX]03[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        this.handShakeCharReceived('\u0004');
    }

    private void query() {
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        tmp.append("[STX]1H|\\^&|||Analyzer[SP]ID|||||Host||1|20210625100538[CR]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]2Q|1|010007662638^^1^1^N||ALL||||||||O[CR]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[STX]3L|1|N[CR]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[ETX]06[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[EOT]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    InterfaceListener.this.getPortaCOM().write(resultado.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                    if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

