/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.audmax240;

import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.text.ParseException;
import java.util.Date;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("Audmax240");
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao receber mensagem do equipamento");
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    protected void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        String messageId = ackQ03.getMsa().getMessageControlId();
        if (messageId != null) {
            switch (ackQ03.getMsa().getAckCode()) {
                case ACCEPTED: {
                    this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorMid.remove(messageId));
                    break;
                }
                case REJECTED: {
                    this.fireExcecaoEncontrada("Erro ao enviar " + ackQ03.toString());
                    break;
                }
                case ERROR: {
                    break;
                }
            }
        }
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    public void teste() {
        String requisicao = "010006500304";
        StringBuilder message = new StringBuilder();
        message.append("[SB]MSH|^~|Mindray|BS-200E|||20150106153717||ORU^R01|148|P|2.3.1||||0||ASCII|||[CR]");
        message.append("PID|117||||INES[SP]GOULART[SP]DA[SP]SILVA||||||||||||||||||||||||||[CR]");
        message.append("OBR|1|" + requisicao + "|23|Mindray^BS-200E|N||20150106115447||||||||Soro|||||||||||||||||||||||||||||||||[CR]");
        message.append("OBX|1|NM|2|Triglicerides|98.800000|mg/dL|-|Normal|||F||98.842508|20150106115447||||[CR]");
        message.append("[EB][CR]");
        this.parse(this.equipamento.arruma(message.toString()));
    }
}

