/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.audh5;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_BINARY_BASE64 = "^Application^Octet-stream^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();

    public InterfaceListener() {
        super("AUD-H5");
        this.parametros.put("6690-2^WBC^LN", "leucocitos");
        this.parametros.put("704-7^BAS#^LN", "basofilos_contagem");
        this.parametros.put("706-2^BAS%^LN", "basofilos_percentual");
        this.parametros.put("751-8^NEU#^LN", "neutrofilo_contagem");
        this.parametros.put("770-8^NEU%^LN", "neutrofilo_percentual");
        this.parametros.put("711-2^EOS#^LN", "eosinofilos_contagem");
        this.parametros.put("713-8^EOS%^LN", "eosinofilos_percentual");
        this.parametros.put("731-0^LYM#^LN", "linfocitos_tipicos_contagem");
        this.parametros.put("736-9^LYM%^LN", "linfocitos_tipicos_percentual");
        this.parametros.put("742-7^MON#^LN", "monocitos_contagem");
        this.parametros.put("5905-5^MON%^LN", "monocitos_percentual");
        this.parametros.put("26477-0^*ALY#^LN", "linfocitos_atipicos_contagem");
        this.parametros.put("13046-8^*ALY%^LN", "linfocitos_atipicos_percentual");
        this.parametros.put("789-8^RBC^LN", "hemacias");
        this.parametros.put("718-7^HGB^LN", "hgb");
        this.parametros.put("787-2^MCV^LN", "vcm");
        this.parametros.put("785-6^MCH^LN", "hcm");
        this.parametros.put("786-4^MCHC^LN", "mchc");
        this.parametros.put("788-0^RDW-CV^LN", "rdw_cv");
        this.parametros.put("21000-5^RDW-SD^LN", "rdw_sd");
        this.parametros.put("4544-3^HCT^LN", "hct");
        this.parametros.put("777-3^PLT^LN", "plaquetas");
        this.parametros.put("32623-1^MPV^LN", "vpm");
        this.parametros.put("32207-3^PDW^LN", "pdw");
        this.parametros.put("10002^PCT^99MRC", "pct");
        this.parametros.put("10001^*LIC%^99MRC", "bastonados_percentual");
        this.parametros.put("10000^*LIC#^99MRC", "bastonados_contagem");
        this.parametros.put("15008^WBC Histogram. BMP^99MRC", "celldyn_histograma_wb1");
        this.parametros.put("15056^RBC Histogram. BMP^99MRC", "celldyn_histograma_rbc");
        this.parametros.put("15116^PLT Histogram. BMP^99MRC", "celldyn_histograma_plt");
        this.parametros.put("15200^WBC DIFF Scattergram. BMP^99MRC", "celldyn_histograma_wb2");
        this.parametros.put("15000^WBC Histogram. Binary^99MRC", "celldyn_histograma_wb1");
        this.parametros.put("15050^RBC Histogram. Binary^99MRC", "celldyn_histograma_rbc");
        this.parametros.put("15100^PLT Histogram. Binary^99MRC", "celldyn_histograma_plt");
        this.warning.put("12000^WBC Abnormal scattergram^99MRC", "WBC Abnormal scattergram");
        this.warning.put("12001^WBC Abnormal histogram^99MRC", "WBC Abnormal histogram");
        this.warning.put("12002^Leucocytosis^99MRC", "Leucocytosis");
        this.warning.put("12003^Leucopenia^99MRC", "Leucopenia");
        this.warning.put("12004^Neutrophilia^99MRC", "Neutrophilia");
        this.warning.put("12005^Neutropenia^99MRC", "Neutropenia");
        this.warning.put("12006^Lymphocytosis^99MRC", "Lymphocytosis");
        this.warning.put("12007^Lymphopenia^99MRC", "Lymphopenia");
        this.warning.put("12008^Monocytosis^99MRC^", "Monocytosis");
        this.warning.put("12009^Eosinophilia^99MRC", "Eosinophilia");
        this.warning.put("12010^Basophilia^99MRC", "Basophilia");
        this.warning.put("12011^WBC Abnormal^99MRC", "WBC Abnormal");
        this.warning.put("17790-7^WBC Left Shift?^LN", "WBC Left Shift");
        this.warning.put("34165-1^ImmGranulocytes?^LN", "IMM Granulocytes");
        this.warning.put("15192-8^Atypical Lymphs?^LN", "Atypical Lymphs");
        this.warning.put("34525-6^rstRBC^LN", "rstRBC");
        this.warning.put("12012^Erythrocytosis^99MRC", "Erythrocytosis");
        this.warning.put("12013^RBC Abnormal distribution^99MRC", "RBC Abnormal distribution");
        this.warning.put("15150-6^Anisocytosis^LN", "Anisocytosis");
        this.warning.put("15198-5^Macrocytes^LN", "Macrocytes");
        this.warning.put("15199-3^Microcytes^LN", "Mycrocytes");
        this.warning.put("10379-6^RBC Dual Pop^LN", "RBC Dual Pop");
        this.warning.put("12014^Anemia^99MRC", "Anemia");
        this.warning.put("15180-3^Hypochromia^LN", "Hypochromia");
        this.warning.put("12015^HGB Interfere^99MRC", "HGB Interfere");
        this.warning.put("12016^PLT Abnormal Distribution^99MRC", "PLT Abnormal Distribution");
        this.warning.put("12017^Thrombocytos is^99MRC", "Thrombocytosis");
        this.warning.put("12018^Thrombopenia^99MRC", "Thrombopenia");
        this.warning.put("7796-6^Platelet Clump?^LN", "Platelet Clump?");
        this.parametros.putAll(this.warning);
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Mindray");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                MessageSegmentObx obx;
                String emiAlternativo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = (obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "08003^Test Mode^99MRC")).getObservationValue());
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                for (String p : this.parametros.keySet()) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (obx == null) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, resultado, listaWarning);
                    if (resultado.length() > IMAGE_BINARY_BASE64.length() && resultado.substring(0, IMAGE_BINARY_BASE64.length()).equalsIgnoreCase(IMAGE_BINARY_BASE64)) {
                        resultado = resultado.substring(IMAGE_BINARY_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private void retornaAlerta(String campo, String resultado, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        ImageIO.getCacheDirectory();
        File img = File.createTempFile("audh5_" + reqCodigo, ".png");
        ImageIO.write((RenderedImage)image, "png", img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block17: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setDataOfBirth(pacNasc);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("08003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("01002^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block17;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (this.iniciaComSB(message) && this.terminaComSTX(message.trim())) {
            message = this.removerSTX(message.trim());
        }
        if (this.iniciaComSB(message) && this.terminaComChar10(message.trim())) {
            message = this.removerChar10(message.trim());
        }
        if (!Funcoes.textoVazio(message = this.removerSTXNoInicio(message)) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    private String removerSTXNoInicio(String message) {
        char c;
        int contadorSTX = 0;
        for (int i = 0; i < message.length() && (c = message.charAt(i)) != '\u000b'; ++i) {
            if (c != '\u0002') continue;
            ++contadorSTX;
        }
        return message.substring(contadorSTX, message.length());
    }

    private boolean iniciaComSB(String mensagem) {
        return !Funcoes.textoVazio(mensagem) && mensagem.charAt(0) == '\u000b';
    }

    private boolean terminaComSTX(String mensagem) {
        if (!Funcoes.textoVazio(mensagem)) {
            char[] array = mensagem.toCharArray();
            return array[array.length - 1] == '\u0002';
        }
        return false;
    }

    private String removerSTX(String mensagem) {
        String tmp = mensagem;
        while (this.terminaComSTX(tmp)) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    private boolean terminaComChar10(String mensagem) {
        if (!Funcoes.textoVazio(mensagem)) {
            char[] array = mensagem.toCharArray();
            return array[array.length - 1] == '\n';
        }
        return false;
    }

    private String removerChar10(String mensagem) {
        String tmp = mensagem;
        while (this.terminaComChar10(mensagem)) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String req = "010005613101";
        tmp.append("[SB]MSH|^~\\&|BC-5380|Mindray|||20080617143943||ORU^R01|1|P|2.3.1||||||UNICODE");
        tmp.append("PID|1||7393670^^^^MR||Joan^JIang||19900804000000|Female[CR]");
        tmp.append("PV1|1||nk^^001[CR]");
        tmp.append("OBR|1||" + req + "|00001^Automated[SP]Count^99MRC||20080508140600|20080508150616|||John||||20080508150000||||||||||HM||||||||Mindray[SP][CR]");
        tmp.append("OBX|1|IS|08001^Take Mode^99MRC||O||||||F [CR]");
        tmp.append("OBX|2|IS|08002^Blood Mode^99MRC||W||||||F [CR]");
        tmp.append("OBX|3|IS|08003^Test Mode^99MRC||CBC||||||F [CR]");
        tmp.append("OBX|4|IS|01002^Ref Group^99MRC||Woman||||||F [CR]");
        tmp.append("OBX|5|NM|30525-0^Age^LN||18|yr|||||F [CR]");
        tmp.append("OBX|6|NM|6690-2^WBC^LN||9.81|10*9/L|4.00-10.00|N|||F||E [CR]");
        tmp.append("OBX|7|NM|704-7^BAS#^LN|||10*9/L|0.00-0.10||||F [CR]");
        tmp.append("OBX|8|NM|706-2^BAS%^LN||||0.000-0.010||||F [CR]");
        tmp.append("OBX|9|NM|751-8^NEU#^LN|||10*9/L|2.00-7.00||||F [CR]");
        tmp.append("OBX|10|NM|770-8^NEU%^LN||||0.500-0.700||||F [CR]");
        tmp.append("OBX|11|NM|711-2^EOS#^LN|||10*9/L|0.02-0.50||||F [CR]");
        tmp.append("OBX|12|NM|713-8^EOS%^LN||||0.005-0.050||||F [CR]");
        tmp.append("OBX|13|NM|731-0^LYM#^LN|||10*9/L|0.80-4.00||||F [CR]");
        tmp.append("OBX|14|NM|736-9^LYM%^LN||||0.200-0.400||||F [CR]");
        tmp.append("OBX|15|NM|742-7^MON#^LN|||10*9/L|0.12-0.80||||F [CR]");
        tmp.append("OBX|16|NM|5905-5^MON%^LN||||0.030-0.080||||F [CR]");
        tmp.append("OBX|17|NM|26477-0^*ALY#^LN|||10*9/L|0.00-0.20||||F [CR]");
        tmp.append("OBX|18|NM|13046-8^*ALY%^LN||||0.000-0.020||||F [CR]");
        tmp.append("OBX|19|NM|10000^*LIC#^99MRC|||10*9/L|0.00-0.20||||F [CR]");
        tmp.append("OBX|20|NM|10001^*LIC%^99MRC||||0.000-0.025||||F [CR]");
        tmp.append("OBX|21|NM|789-8^RBC^LN||4.53|10*12/L|3.50-5.00|N|||F [CR]");
        tmp.append("OBX|22|NM|718-7^HGB^LN||65|g/L|110-150|L|||F [CR]");
        tmp.append("OBX|23|NM|787-2^MCV^LN||89.5|fL|80.0-100.0|N|||F [CR]");
        tmp.append("OBX|24|NM|785-6^MCH^LN||14.4|pg|27.0-31.0|L|||F [CR]");
        tmp.append("OBX|25|NM|786-4^MCHC^LN||160|g/L|320-360|L|||F [CR]");
        tmp.append("OBX|26|NM|788-0^RDW-CV^LN||0.133||0.115-0.145|N|||F [CR]");
        tmp.append("OBX|27|NM|21000-5^RDW-SD^LN||50.9|fL|35.0-56.0|N|||F [CR]");
        tmp.append("OBX|28|NM|4544-3^HCT^LN||0.405||0.370-0.480|N|||F [CR]");
        tmp.append("OBX|29|NM|777-3^PLT^LN||212|10*9/L|100-300|N|||F [CR]");
        tmp.append("OBX|30|NM|32623-1^MPV^LN||6.6|fL|7.0-11.0|L|||F [CR]");
        tmp.append("OBX|31|NM|32207-3^PDW^LN||15.4||15.0-17.0|N|||F [CR]");
        tmp.append("OBX|32|NM|10002^PCT^99MRC||1.40|mL/L|1.08-2.82|N|||F [CR]");
        tmp.append("OBX|33|IS|12014^Anemia^99MRC||T||||||F [CR]");
        tmp.append("OBX|34|IS|15180-3^Hypochromia^LN||T||||||F [CR]");
        tmp.append("OBX|35|NM|15001^WBC Histogram. Left Line^99MRC||7||||||F [CR]");
        tmp.append("OBX|36|NM|15002^WBC Histogram. Right Line^99MRC||65||||||F [CR]");
        tmp.append("OBX|37|NM|15003^WBC Histogram. Middle Line^99MRC||30||||||F [CR]");
        tmp.append("OBX|38|ED|15008^WBC Histogram. BMP^99MRC||^Image^BMP^Base64^iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAIAAADTED8xAAADMElEQVR4nOzVwQnAIBQFQYXff81RUkQCOyDj1YOPnbXWPmeTRef+/3O/OyBjzh3CD95BfqICMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMO0TAAD//2Anhf4QtqobAAAAAElFTkSuQmCC\n||||||F [CR]");
        tmp.append("OBX|39|NM|15051^RBC Histogram. Left Line^99MRC||26||||||F [CR]");
        tmp.append("OBX|40|NM|15052^RBC Histogram. Right Line^99MRC||164||||||F [CR]");
        tmp.append("OBX|41|ED|15056^RBC Histogram. BMP^99MRC||^Image^BMP^Base64^iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAIAAADTED8xAAADMElEQVR4nOzVwQnAIBQFQYXff81RUkQCOyDj1YOPnbXWPmeTRef+/3O/OyBjzh3CD95BfqICMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMO0TAAD//2Anhf4QtqobAAAAAElFTkSuQmCC\n||||||F [CR]");
        tmp.append("OBX|42|NM|15111^PLT Histogram. Left Line^99MRC||3||||||F [CR]");
        tmp.append("OBX|43|NM|15112^PLT Histogram. Right Line^99MRC||43||||||F [CR]");
        tmp.append("OBX|44|ED|15116^PLT Histogram. BMP^99MRC||^Image^BMP^Base64^iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAIAAADTED8xAAADMElEQVR4nOzVwQnAIBQFQYXff81RUkQCOyDj1YOPnbXWPmeTRef+/3O/OyBjzh3CD95BfqICMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMO0TAAD//2Anhf4QtqobAAAAAElFTkSuQmCC\n||||||F [CR]");
        tmp.append("OBX|45|ED|15200^WBC DIFF Scattergram. BMP^99MRC||^Image^BMP^Base64^iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAIAAADTED8xAAADMElEQVR4nOzVwQnAIBQFQYXff81RUkQCOyDj1YOPnbXWPmeTRef+/3O/OyBjzh3CD95BfqICMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMK0CMO0TAAD//2Anhf4QtqobAAAAAElFTkSuQmCC\n||||||F [CR]");
        tmp.append("OBR|2||" + req + "|00002^Manual Count^99MRC|||||||||||BLDV |||[CR]");
        tmp.append("OBX|46|NM|747-6^Myeloblasts%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|47|NM|783-1^Promyelocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|48|NM|749-2^Myelocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|49|NM|740-1^Metamyelocyte%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|50|NM|764-1^Neuts Band%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|51|NM|769-0^Neuts Seg%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|52|NM|714-6^Eosinophils%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|53|NM|707-0^Basophils%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|54|NM|33831-9^Lymphoblasts%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|55|NM|6746-2^Prolymphocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|56|NM|737-7^Lymphocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|57|NM|29261-5^Abnormal Lymphs%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|58|NM|33840-0^Monoblasts%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|59|NM|13599-6^Promonocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|60|NM|744-3^Monocytes%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|61|NM|18309-5^NRBCs%. Manual^LN||0.0|%|||||F [CR]");
        tmp.append("OBX|62|NM|31112-6^Reticulocytes%. Manual^LN||0.0|%|||||F[CR]");
        tmp.append("OBX|63|NM|11000^Undefined Cells%. Manual^99MRC||0.0|%|||||F [CR]");
        tmp.append("OBX|64|NM|11001^Other Abnormal Cells%. Manual^99MRC||0.0|%|||||F [CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

