/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.au480;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.padroes.olympus.InterfaceOlympusListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceOlympusListener {
    private static final int MAX_PACIENTE_NAME = 20;
    private static final String REQUISICAO_NAO_ENCONTRADA_OU_NAO_INTERFACEADA = "Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: ";
    private static final String ERRO_NAO_ENCONTRADA_NENHUMA_REQUISICAO = "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
    private Map<String, String> flagsResultado = new HashMap<String, String>();
    protected Map<String, InfoExameRequisicao> examesEnviados = new HashMap<String, InfoExameRequisicao>();

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, acao, "", null);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao, String codigoApoiado) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, acao, codigoApoiado, null);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, acao, "", mapaParametros);
    }

    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao, String codigoApoiado, HashMap<String, String> mapaParametros) {
        try {
            filCodigo = Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial());
            reqCodigo = Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao());
            recCodigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
            StringBuilder codigo = this.getEtiqueta(filCodigo, reqCodigo, codigoApoiado);
            String[] idade = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
            int mes = this.getMesNacPaciente(idade);
            this.formataIdade(idade);
            pacNome = this.formataNomePaciente(pacNome);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exaLista = ExamesUtil.anexarCodigoMaterial(exames.split(" "), mcoCodigo);
            exaLista = ExamesUtil.desmembrarExames(st, filCodigo, intCodigo, exaLista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, filCodigo, intCodigo, exaLista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String temp = " ";
            if (exaLista != null && exaLista.length > 0) {
                temp = ExamesUtil.getMaterialAlternativo(st, filCodigo, intCodigo, exaLista);
            }
            String sampleType = " ";
            if (Funcoes.textoVazio(temp.trim())) {
                sampleType = temp;
            }
            StringBuilder message = this.montaMensagem(pacNome, pacSexo, rackposition, prioridade, codigo, Arrays.asList(alternativos), sampleType, idade, mes, recCodigo);
            boolean isCurva = false;
            if (mapaParametros != null) {
                isCurva = Boolean.getBoolean(mapaParametros.get("POSSUI_CURVA"));
            }
            this.enviaMensagemParaEquipamento(pacNome, pacSexo, pacIdade, data, hora, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, message, isCurva, recCodigo);
            return "Enviando " + pacNome + " para o equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    private void enviaMensagemParaEquipamento(String pacNome, String pacSexo, String pacIdade, String data, String hora, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, StringBuilder message, boolean curva, String recTudoPai) throws IOException {
        StringBuilder examesFilho = new StringBuilder();
        this.ultimoEnvio = message.toString();
        this.ultimo_enviado = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
        this.ultimo_enviado.setInterface(intCodigo);
        this.ultimo_enviado.setCurva(curva);
        this.ultimo_enviado.setTuboPai(recTudoPai);
        this.ultimo_enviado.setExamesFilho(examesFilho.toString().trim());
        this.getPortaCOM().write(message.toString());
    }

    private StringBuilder getEtiqueta(String filCodigo, String reqCodigo, String codigoApoiado) {
        StringBuilder codigo = new StringBuilder(filCodigo).append(reqCodigo);
        if (!Funcoes.textoVazio(codigoApoiado)) {
            codigo.setLength(0);
            codigo.append(codigoApoiado);
        }
        return codigo;
    }

    private String formataNomePaciente(String pacNome) {
        if (pacNome.length() > 20) {
            pacNome = pacNome.substring(0, 20);
        }
        return pacNome;
    }

    private void formataIdade(String[] idade) {
        if (Funcoes.textoVazio(idade[1])) {
            idade[1] = "a";
        }
        if (Funcoes.textoVazio(idade[0])) {
            idade[0] = "";
        }
    }

    private int getMesNacPaciente(String[] idade) {
        int mes = !Funcoes.textoVazio(idade[2]) ? Integer.parseInt(Funcoes.formataData("MM", Funcoes.getData("dd/MM/yyyy", idade[2]))) - 1 : Integer.parseInt(Funcoes.formataData("MM", Funcoes.getData("dd/MM/yyyy", TempoUtil.getCurrentDateBr()))) - 1;
        return mes;
    }

    private StringBuilder montaMensagem(String pacNome, String pacSexo, String rackposition, String prioridade, StringBuilder codigo, List<ExameMaterial> alternados, String sampleType, String[] idade, int mes, String recipiente) {
        StringBuilder message = new StringBuilder();
        message.append(this.getMsgStart());
        message.append(prioridade);
        message.append(rackposition);
        message.append(sampleType);
        message.append(this.proximaPosicao);
        message.append(StringUtil.preencheString(codigo.toString() + recipiente, 26, ' ', 1));
        message.append("    ");
        message.append("E");
        message.append(pacSexo);
        message.append(StringUtil.preencheString(idade[1].equalsIgnoreCase("a") ? idade[0] : "0", 3, '0', 1));
        message.append(StringUtil.preencheString(Integer.toString(mes), 2, '0', 1));
        message.append(StringUtil.preencheString(pacNome, 20, ' ', 0));
        message.append(StringUtil.preencheString("", 20, ' ', 0));
        message.append(StringUtil.preencheString("", 20, ' ', 0));
        message.append(StringUtil.preencheString("", 20, ' ', 0));
        message.append(StringUtil.preencheString("", 20, ' ', 0));
        message.append(StringUtil.preencheString("", 20, ' ', 0));
        for (ExameMaterial e : alternados) {
            if (Funcoes.textoVazio(e.getNomeExame())) continue;
            message.append(Funcoes.preencheZero(e.getNomeExame(), 3));
            message.append("0");
        }
        message.append(this.getMsgEnd());
        return message;
    }

    @Override
    protected void retransmitir() {
        if (this.ultimoEnvio != null) {
            super.retransmitir();
        }
    }

    @Override
    protected void confirmaTransmissao() {
        super.confirmaTransmissao();
        this.ultimo_enviado = null;
        this.ultimoEnvio = null;
    }

    @Override
    public String parseNormalSampleResult(String message) throws Exception {
        String msg;
        String requisicao = message.substring(17, 42).trim();
        if (requisicao.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada(REQUISICAO_NAO_ENCONTRADA_OU_NAO_INTERFACEADA + requisicao);
            return ERRO_NAO_ENCONTRADA_NENHUMA_REQUISICAO;
        }
        String filCodigo = "";
        String recCodigo = "";
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(requisicao);
        if (codigoEtiqueta != null) {
            filCodigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            recCodigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            requisicao = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
        } else {
            filCodigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            recCodigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            requisicao = StringUtil.removeZerosEsquerda(reqCodigo);
        }
        if (!Funcoes.isNumeric(filCodigo)) {
            msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + filCodigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(requisicao)) {
            msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + requisicao + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(recCodigo)) {
            msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + recCodigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        return this.parseResultados(filCodigo, requisicao, recCodigo, message.substring(113, message.length() - 1), false);
    }

    private String parseResultados(String filCodigo, String reqCodigo, String recCodigo, String message, boolean repeticao) throws Exception {
        Statement st = Conexao.getStatement();
        try {
            String regex = "(\\d{3})\\s+([\\d.]+[a-zA-Z#()]?)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String emiAlternativo = StringUtil.removeZerosEsquerda(matcher.group(1));
                String resultadoComFlag = matcher.group(2);
                System.out.println("ALTERNATIVO" + emiAlternativo);
                System.out.println("RESULTADO" + resultadoComFlag);
                String resultado = resultadoComFlag.replaceAll("[^\\d.]", "");
                String flag = resultadoComFlag.replaceAll("[\\d.]", "");
                flag = flag.isEmpty() ? "" : flag;
                String reqCod = Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo, reqCod);
                if (intCodigo == null) {
                    this.requisicaoNaoEncontrada(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCod, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.requisicaoNaoEncontrada(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    continue;
                }
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put(campo, resultado.replace(".", ","));
                System.out.println("EXAME - " + exame.getNomeExame() + " | SIT - " + sit + " | CAMPO - " + campo + " | RESULTADO - " + resultado + " | " + reqCodigo);
                if (sit == 3 || sit == 2) {
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, null, sit < 3 ? 2 : 4);
                }
                boolean validarLiberado = !resultado.equals("EXCE\u00c7\u00c3O");
                List<String> flags = this.retornaFlags(flag);
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags, validarLiberado);
                List<String> requisicoes = this.getMultiguia(filCodigo, reqCodigo);
                for (String req : requisicoes) {
                    if (!BDUtil.existeDesmembramento(filCodigo, intCodigo, req, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial()) || !BDUtil.existeExame(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo)) continue;
                    ResolvedorResultado.salvaDados(st, filCodigo, intCodigo, req, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, null, null, dados, null, false, (AbstractInterfaceamentoListener)this);
                }
            }
            Conexao.arquivaSQL();
            if (!this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                this.fireAtualizarTabela(2);
            }
        }
        catch (Exception e) {
            this.requisicaoNaoEncontrada(filCodigo, reqCodigo, recCodigo, "");
        }
        Conexao.fecharStatement(st);
        return "Dados recebidos com sucesso";
    }

    private List<String> getMultiguia(String filCodigo, String reqCodigo) throws SQLException {
        ArrayList<String> requisicoes = new ArrayList<String>();
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicoes = BDUtil.getReqMultiGuias(filCodigo, reqCodigo);
        } else {
            requisicoes.add(reqCodigo);
        }
        return requisicoes;
    }

    @Override
    public String getIntCodigo(String filCodigo, String reqCodigo, String recCodigo, String emiAlternativo, String reqCod) throws SQLException {
        String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
        if (intCodigo == null && ParametrosGerais.getTipoExportacaoInterface().equals("T")) {
            this.getAba(1).reloadExames();
            intCodigo = this.getIntCodigo(filCodigo, reqCod, recCodigo, emiAlternativo);
        }
        return intCodigo;
    }

    private void requisicaoNaoEncontrada(String filCodigo, String reqCodigo, String recCodigo, String emiAlternativo) {
        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
    }

    @Override
    public String parseInquirySample(String message, boolean normal) throws SQLException {
        this.hostQuery = true;
        String rackPosition = message.substring(5, 11);
        this.proximaPosicao = Funcoes.preencheZero(message.substring(12, 16), 4);
        String reqCodigo = message.substring(30, message.length() - 1).trim();
        StringBuilder pacExames = new StringBuilder("");
        String filCodigo = "";
        String recCodigo = "";
        String reqCodigoOriginal = "";
        if (Funcoes.textoVazio(rackPosition)) {
            this.fireExcecaoEncontrada(String.format("Envio manual ou sem informar a rack e prioridade n\u00e3o permitido %s %s %s ", filCodigo, reqCodigo, recCodigo));
            return "Envio manual ou sem informar a rack e prioridade n\u00e3o permitido";
        }
        int tamEtiqueta = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        if (reqCodigo.length() < tamEtiqueta) {
            this.fireExcecaoEncontrada("C\u00f3digo de etiqueta n\u00e3o corresponde as configura\u00e7\u00f5es do jalis: " + reqCodigo);
            return ERRO_NAO_ENCONTRADA_NENHUMA_REQUISICAO;
        }
        if (!Funcoes.textoVazio(reqCodigo) && reqCodigo.length() == tamEtiqueta) {
            reqCodigoOriginal = reqCodigo;
            filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        }
        if (!Funcoes.isNumeric(filCodigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + filCodigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(reqCodigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + reqCodigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(recCodigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + recCodigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(reqCodigoOriginal);
        if (codigoEtiqueta != null) {
            filCodigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            recCodigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            reqCodigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            String reqMae = BDUtil.getReqMultiGuiaMae(filCodigo, reqCodigo);
            if (!codigoEtiqueta.getRequisicao().equals(reqMae)) {
                reqCodigo = Funcoes.preencheZero(reqMae, ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        String examesTemp = "";
        if (req != null) {
            examesTemp = (String)req[aba.getColIndice("Exame")];
        }
        if (req == null && Funcoes.textoVazio(examesTemp = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), examesTemp, 1)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
            examesTemp = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, examesTemp, 1);
        }
        if (req == null && Funcoes.textoVazio(examesTemp = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), examesTemp, 2)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
            examesTemp = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, examesTemp, 2);
        }
        if (!Funcoes.textoVazio(examesTemp)) {
            pacExames.append(examesTemp);
        }
        if (req != null) {
            String rack = (String)req[aba.getColIndice("Rack")];
            if (rack == null) {
                rack = "";
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String intCodigo = (String)req[aba.getColIndice("Interface")];
            String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            ArrayList tubosFilho = null;
            if (req[aba.getColIndice("Tubos Filhos")] != null) {
                tubosFilho = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
                StringBuilder examesNovos = new StringBuilder();
                if (aba.getColIndice("Sit") != -1) {
                    for (String exame : pacExames.toString().split(" ")) {
                        BDExame[] exames = BDUtil.getDesmExamesFilhos(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, tubo, recCodigo);
                        if (exames != null && exames.length > 0) {
                            for (BDExame exa : exames) {
                                if (exa.getSituacao() != 3) continue;
                                examesNovos.append(exa.getExame()).append(" ");
                            }
                            continue;
                        }
                        if (BDUtil.isExameCurva(filCodigo, intCodigo, exame, mcoCodigo)) {
                            List<BDExame> curva = BDUtil.getDesmExamesFilhosX(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo);
                            for (BDExame exameCurva : curva) {
                                if (!exameCurva.getRecipienteFilho().equals(String.valueOf(recCodigo)) || exameCurva.getSituacao() != 3) continue;
                                examesNovos.append(exameCurva.getExame()).append(" ");
                            }
                            continue;
                        }
                        int sit = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recCodigo);
                        if (sit != 3) continue;
                        examesNovos.append(exame).append(" ");
                    }
                }
                if (!Funcoes.textoVazio(examesNovos.toString())) {
                    pacExames.setLength(0);
                    pacExames.append(examesNovos.toString().trim());
                }
            }
            String codigoApoiado = "";
            if (this.exr_codigoapoiado && !filCodigo.equalsIgnoreCase(filial)) {
                String[] exames;
                for (String exame : exames = pacExames.toString().trim().split(" ")) {
                    String[] codigoJalis = BDUtil.getCodigoJalis(filCodigo, reqCodigo, recCodigo, intCodigo, exame, mcoCodigo);
                    if (codigoJalis == null || Funcoes.textoVazio(codigoJalis[0])) continue;
                    codigoApoiado = String.format("%s%s%s", filCodigo, reqCodigo, recCodigo);
                    filCodigo = filial;
                    reqCodigo = StringUtil.preencheString(codigoJalis[1], ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                    recCodigo = StringUtil.preencheString(codigoJalis[2], ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                    break;
                }
            }
            if (rack.equalsIgnoreCase(rackPosition) || filCodigo.equalsIgnoreCase(filial) && reqCodigo.equalsIgnoreCase(requisicao) && (recCodigo.equalsIgnoreCase(tubo) || tubosFilho != null && tubosFilho.contains(String.valueOf(Integer.parseInt(recCodigo))))) {
                return this.enviarRequisicao((String)req[aba.getColIndice("Paciente")], (String)req[aba.getColIndice("S")], (String)req[aba.getColIndice("Ide")], TempoUtil.getCurrentDateBr(), TempoUtil.getCurrentTime(), rackPosition, normal ? "S " : "SH", filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames.toString().trim(), "N", codigoApoiado);
            }
        }
        this.fireExcecaoEncontrada(REQUISICAO_NAO_ENCONTRADA_OU_NAO_INTERFACEADA + filCodigo + reqCodigo + recCodigo);
        return ERRO_NAO_ENCONTRADA_NENHUMA_REQUISICAO;
    }

    protected String getExames(String filCodigo, String reqCodigo, String recCodigo, Object[] req, PanelAbaAbstrata aba, String exames, int abaSelecionada) {
        if (req != null) {
            exames = exames + " ";
            List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, abaSelecionada);
            for (Object[] r : reqs) {
                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
            }
            exames = exames.trim();
        }
        return exames;
    }

    private List<String> retornaFlags(String flag) {
        ArrayList<String> flags = new ArrayList<String>();
        this.parseFlags();
        if (this.flagsResultado.containsKey(flag)) {
            flags.add(this.flagsResultado.get(flag));
        }
        return flags;
    }

    public Map<String, String> parseFlags() {
        this.flagsResultado.put("d", "Excluded from QC by user");
        this.flagsResultado.put("e", "Data edited by user");
        this.flagsResultado.put("(", "Shortage of detergent for contamination parameters");
        this.flagsResultado.put("Wa", "Result has been analyzed with an erroneous cuvette");
        this.flagsResultado.put("R", "Insufficient reagent");
        this.flagsResultado.put("#", "Insufficient sample");
        this.flagsResultado.put("%", "Clot detected");
        this.flagsResultado.put("?", "Unable to calculate a result");
        this.flagsResultado.put("n", "LIH test not performed");
        this.flagsResultado.put("l", "Result may be affected by lipemia");
        this.flagsResultado.put("i", "Result may be affected by icterus");
        this.flagsResultado.put("h", "Result may be affected by hemolysis");
        this.flagsResultado.put("Y", "Reagent blank OD at last photometric point high");
        this.flagsResultado.put("U", "Reagent blank OD at last photometric point low");
        this.flagsResultado.put("y", "Reagent blank/routine OD at first photometric point high");
        this.flagsResultado.put("u", "Reagent blank/routine OD at first photometric point low");
        this.flagsResultado.put("@", "OD is higher than 3.0");
        this.flagsResultado.put("$", "Not enough data to determine linearity of reaction");
        this.flagsResultado.put("D", "OD of reaction is higher than maximum OD range");
        this.flagsResultado.put("B", "OD of reaction is lower than minimum OD range");
        this.flagsResultado.put("*", "Linearity error and/or Reverse reaction error");
        this.flagsResultado.put("&", "Prozone test data is abnormal");
        this.flagsResultado.put("Z", "Prozone error");
        this.flagsResultado.put("E", "Overreaction in a rate assay detected");
        this.flagsResultado.put("Fx", "Result (OD) is higher than the dynamic range");
        this.flagsResultado.put("Gx", "Result (OD) is lower than the dynamic range");
        this.flagsResultado.put("!", "Unable to calculate concentration");
        this.flagsResultado.put(")", "Reagent lot no. used at sample analysis is different from that used at calibration analysis");
        this.flagsResultado.put("a", "Reagent expired");
        this.flagsResultado.put("ba", "Calibration expired");
        this.flagsResultado.put("bh", "No valid calibration used");
        this.flagsResultado.put("bn", "Master curve used");
        this.flagsResultado.put("bz", "Calibration curve for Prozone data used");
        this.flagsResultado.put("F", "Result is higher than the dynamic range");
        this.flagsResultado.put("G", "Result is lower than the dynamic range");
        this.flagsResultado.put("Tx", "Abnormality found in inner check of HbA1c");
        this.flagsResultado.put("ph", "Result is higher than the upper panic value");
        this.flagsResultado.put("pl", "Result is lower than the low panic value");
        this.flagsResultado.put("T", "Abnormality found in inter-chemistry check");
        this.flagsResultado.put("P", "Positive");
        this.flagsResultado.put("N", "Negative");
        this.flagsResultado.put("H", "Result is higher than reference range");
        this.flagsResultado.put("L", "Result is lower than reference range");
        this.flagsResultado.put("J", "Result is higher than the repeat decision range");
        this.flagsResultado.put("K", "Result is lower than the repeat decision range");
        this.flagsResultado.put("fh", "Result is higher than the repeat run reflex range.");
        this.flagsResultado.put("fl", "Result is lower than the repeat run reflex range");
        this.flagsResultado.put("Va", "The result of multiple measurement alienation check is NG");
        this.flagsResultado.put("8Q", "QC deviation error");
        this.flagsResultado.put("xQ", "Failure of one control used in multirule QC");
        this.flagsResultado.put("1Q", "QC data exceeds the range entered in the Single Check Level field");
        this.flagsResultado.put("2Q", "QC data exceeds 13S control range");
        this.flagsResultado.put("3Q", "QC data exceeds 22S control range");
        this.flagsResultado.put("4Q", "QC data exceeds R4S control range");
        this.flagsResultado.put("5Q", "QC data exceeds 41S control range");
        this.flagsResultado.put("6Q", "A preset number of consecutive QC results fall on one side of the mean");
        this.flagsResultado.put("7Q", "Consecutive QC results show steadily increasing or decreasing values");
        this.flagsResultado.put("S", "Sample repeated and original results replaced by repeat result");
        this.flagsResultado.put("/", "Test pending or not analyzed");
        this.flagsResultado.put("r", "Data transmitted to host");
        this.flagsResultado.put("c", "Data corrected by user");
        return this.flagsResultado;
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!Funcoes.textoVazio(message) && this.iniciarComSTX(message) && this.terminaComETX(message)) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                if (!Funcoes.textoVazio(this.getPortaCOM().getInputString())) {
                    this.dataChanged();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean iniciarComSTX(String mensagem) {
        return !Funcoes.textoVazio(mensagem) && mensagem.charAt(0) == '\u0002';
    }

    private boolean terminaComETX(String mensagem) {
        if (!Funcoes.textoVazio(mensagem)) {
            char[] array = mensagem.toCharArray();
            return array[array.length - 1] == '\u0003';
        }
        return false;
    }

    @Override
    public void teste() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "0100514369");
        this.parse(this.equipamento.arruma("[STX]D[SP]01001207[SP]0107[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]" + idAmostra + "[SP][SP][SP][SP]EM05702ALCIR[SP]CLOVIS[SP]BALDO[SP]J[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]008[SP]143.4[SP][SP]014[SP][SP]0.23[SP][SP]018[SP][SP]47.2[SP][SP]020[SP]107.1[SP][SP]025[SP][SP]1.03[SP][SP]027[SP]115.4[SP][SP]028[SP]265.0[SP][SP]029[SP][SP]48.7[SP][SP]098[SP][SP][SP]4.6[SP][SP][ETX]"));
    }
}

