/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.au480;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.au480.ExameCurva;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String filCodigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String intCodigo = (String)exame[this.getColIndice("Interface")];
            String exaCodigo = (String)exame[this.getColIndice("Exame")];
            String mcoCodigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exaCodigo, mcoCodigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<ExameCurva> exames = new ArrayList<ExameCurva>();
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("Multiguia")];
            }
            String filCodigo = reqRepetir.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = reqRepetir.substring(ParametrosGerais.getDigitosTuboFilial(), reqRepetir.length());
            String recCodigo = (String)linhaRepeticao[this.getColIndice("Tubo")];
            String intCodigo = (String)linhaRepeticao[this.getColIndice("Interface")];
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqPronto = (String)linhaProntos[this.getColIndice("Multiguia")];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                Statement st = Conexao.getStatement();
                if (desmembrado != null) {
                    boolean addDesm = false;
                    if (!(addDesm = this.setSituacaoExameCurva(exames, filCodigo, reqCodigo, recCodigo, intCodigo, exaRepetir, matRepetir, exaPronto, matPronto, desmembrado, st, addDesm))) continue;
                    linhas.add(j);
                    continue;
                }
                this.setSituacaoExame(requisicaoExames, exames, linhas, linhaRepeticao, filCodigo, reqCodigo, recCodigo, intCodigo, exaRepetir, matRepetir, j, exaPronto, matPronto, st);
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!exames.isEmpty()) {
            Map<String, List<ExameCurva>> tubos = this.getExamesPorTubo(exames);
            for (Map.Entry<String, List<ExameCurva>> entry : tubos.entrySet()) {
                String tubo = entry.getKey();
                String listaExames = StringUtil.implode(entry.getValue(), " ");
                String pacSexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pacIdade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String pacNome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                String reqCodigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqCodigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Multiguia"));
                }
                String filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String intCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                String mcoCodigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                Boolean isCurva = entry.getValue().stream().anyMatch(exa -> exa.isCurva());
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("POSSUI_CURVA", isCurva.toString());
                String resposta = this.equipamento.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rack, null, filCodigo, intCodigo, reqCodigo, mcoCodigo, tubo, listaExames, "A", maps);
                if (resposta == null) continue;
                this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
            }
            for (Integer i : linhas) {
                this.reloadLinha(i);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void setSituacaoExame(ArrayList requisicaoExames, List<ExameCurva> exames, ArrayList<Integer> linhas, Object[] linhaRepeticao, String filCodigo, String reqCodigo, String recCodigo, String intCodigo, String exaRepetir, String matRepetir, int j, String exaPronto, String matPronto, Statement st) {
        String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
        if (sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) || requisicaoExames.size() == 1 && sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO)) {
            try {
                sit = requisicaoExames.size() == 1 && sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO) ? SelecionaExame.SIT_REPETIR : sit;
                ExameCurva exameCurva = null;
                List<String> requisicoes = this.getMultiguia(filCodigo, reqCodigo);
                for (String req : requisicoes) {
                    if (BDUtil.existeDesmembramento(filCodigo, intCodigo, req, recCodigo, exaPronto, matPronto)) {
                        ExameMaterial[] examePai;
                        for (ExameMaterial pai : examePai = BDUtil.getDesmExamesPai(filCodigo, intCodigo, req, recCodigo, exaPronto, matPronto)) {
                            Integer tubo = BDUtil.getTuboPai(filCodigo, req, recCodigo, intCodigo);
                            String tuboPai = tubo != null ? String.valueOf(tubo) : recCodigo;
                            BDUtil.setDesmSituacao(st, filCodigo, intCodigo, req, pai.getNomeExame(), matRepetir, tuboPai, exaRepetir, matRepetir, Integer.valueOf(sit));
                            BDUtil.setExmSituacao(st, filCodigo, req, exaRepetir, matRepetir, Integer.valueOf(sit), intCodigo, recCodigo);
                            exameCurva = new ExameCurva(exaPronto, String.valueOf(recCodigo));
                        }
                    }
                    if (!BDUtil.existeExame(filCodigo, intCodigo, req, exaPronto, matPronto, recCodigo)) continue;
                    BDUtil.setExmSituacao(st, filCodigo, req, exaPronto, matPronto, Integer.valueOf(sit), intCodigo, recCodigo);
                    exameCurva = new ExameCurva(exaPronto, String.valueOf(recCodigo));
                }
                if (exameCurva != null) {
                    exames.add(exameCurva);
                    linhas.add(j);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setSituacaoExameCurva(List<ExameCurva> exames, String filCodigo, String reqCodigo, String recCodigo, String intCodigo, String exaRepetir, String matRepetir, String exaPronto, String matPronto, ArrayList desmembrado, Statement st, boolean addDesm) {
        for (int k = 0; k < desmembrado.size(); ++k) {
            try {
                Object[] exame = (Object[])desmembrado.get(k);
                String situacao = (String)exame[exame.length - 1];
                if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                List<String> requisicoes = this.getMultiguia(filCodigo, reqCodigo);
                for (String req : requisicoes) {
                    if (!BDUtil.existeExame(filCodigo, intCodigo, req, exaPronto, matPronto, recCodigo)) continue;
                    Integer tubo = BDUtil.getTuboFilho(filCodigo, req, recCodigo, intCodigo, exame[1].toString(), matRepetir);
                    boolean isCurva = BDUtil.isExameCurva(filCodigo, intCodigo, exaPronto, matPronto);
                    ExameCurva exameCurva = new ExameCurva((String)exame[1], String.valueOf(tubo), isCurva);
                    BDUtil.setDesmSituacao(st, filCodigo, intCodigo, req, exaRepetir, matRepetir, recCodigo, exameCurva.getNome(), matRepetir, Integer.valueOf(situacao));
                    BDUtil.setExmSituacao(st, filCodigo, req, exaRepetir, matRepetir, Integer.valueOf(situacao), intCodigo, recCodigo);
                    if (BDUtil.existeExame(filCodigo, intCodigo, req, exameCurva.getNome(), matRepetir, exameCurva.getTubo())) {
                        BDUtil.setExmSituacao(st, filCodigo, req, exameCurva.getNome(), matRepetir, Integer.valueOf(situacao), intCodigo, exameCurva.getTubo());
                    }
                    exames.add(exameCurva);
                    addDesm = true;
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return addDesm;
    }

    private List<String> getMultiguia(String filCodigo, String reqCodigo) throws SQLException {
        ArrayList<String> requisicoes = new ArrayList<String>();
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicoes = BDUtil.getReqMultiGuias(filCodigo, reqCodigo);
        } else {
            requisicoes.add(reqCodigo);
        }
        return requisicoes;
    }

    private Map<String, List<ExameCurva>> getExamesPorTubo(List<ExameCurva> examesCurva) {
        LinkedHashMap<String, List<ExameCurva>> lista = new LinkedHashMap<String, List<ExameCurva>>();
        for (ExameCurva curva : examesCurva) {
            if (!lista.containsKey(curva.getTubo())) {
                lista.put(curva.getTubo(), new ArrayList());
            }
            if (((List)lista.get(curva.getTubo())).contains(curva)) continue;
            ((List)lista.get(curva.getTubo())).add(curva);
        }
        return lista;
    }

    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            ArrayList<Object[]> dadosTemp = new ArrayList<Object[]>();
            StringBuilder query = this.getSqlLoadExames();
            PreparedStatement pst = Conexao.getPreparedStatement(query.toString());
            ResultSet rs = pst.executeQuery();
            query.delete(0, query.length());
            query.append("select b.ier_xmlvalores from interfaceexamerequisicaodesm a");
            query.append(" left join interfaceexamerequisicao b on a.fil_codigo = b.fil_codigo and a.int_codigo = b.int_codigo");
            query.append("   and a.exa_kodigo = b.exa_codigo and a.mco_kodigo = a.mco_codigo and a.req_codigo = b.req_codigo");
            query.append("   and a.rec_codigo = b.rec_codigo");
            query.append(" where b.fil_codigo = ? and b.int_codigo = ? and b.exa_codigo = ? and b.mco_codigo = ?");
            query.append("   and b.req_codigo = ? and b.rec_codigo = ?");
            PreparedStatement psFilhos = Conexao.getPreparedStatement(query.toString());
            while (rs != null && rs.next()) {
                Object[] linha = new Object[this.getColCount()];
                String reqCodigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                reqCodigo = reqCodigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                String idade = String.valueOf(rs.getInt("req_idade")) + " " + (rs.getString("req_anomes") == null ? "" : rs.getString("req_anomes").toLowerCase());
                String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                if (Funcoes.textoVazio(nome.trim())) {
                    nome = reqCodigo + " Nome nao compativel com interfaceamento";
                }
                linha[this.getColIndice((String)"C\u00f3digo")] = reqCodigo;
                linha[this.getColIndice((String)"Paciente")] = nome;
                linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                linha[this.getColIndice((String)"Ide")] = idade;
                linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                linha[this.getColIndice((String)"Cod. Apoiado")] = "";
                if (this.exr_codigoapoiado) {
                    linha[this.getColIndice((String)"Cod. Apoiado")] = rs.getString("exr_codigoapoiado");
                }
                linha[this.getColIndice((String)"Valor Alterado")] = rs.getInt("ier_resultadoalterado");
                linha[this.getColIndice((String)"Cod. M\u00e9todo")] = rs.getString("met_codigo");
                String xml = rs.getString("ier_xmlvalores");
                linha[this.getColIndice((String)"Valores")] = xml;
                linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                linha[this.getColIndice((String)"Contador")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                    linha[this.getColIndice((String)"Multiguia")] = multiguia;
                    linha[this.getColIndice((String)"C\u00f3digo Temp.")] = reqCodigo;
                    if (reqCodigo.equalsIgnoreCase(multiguia)) {
                        linha[this.getColIndice((String)"C\u00f3digo")] = "";
                    }
                }
                ResultSet rsTubosFilhos = rs.getArray("tubosFilhos").getResultSet();
                boolean exameDesmembrado = false;
                ArrayList<String> tubosFilhos = new ArrayList<String>();
                if (rsTubosFilhos.next()) {
                    do {
                        tubosFilhos.add(String.valueOf(rsTubosFilhos.getInt(2)));
                    } while (rsTubosFilhos.next());
                    exameDesmembrado = true;
                }
                if (exameDesmembrado) {
                    linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                }
                if (xml != null) {
                    Map<String, Object> dados = StringUtil.getMapDeXML(xml);
                    if (this.mostraColunaFlags) {
                        List<String> flags = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dados.get("flag")));
                        if (flags != null && !flags.isEmpty()) {
                            linha[this.getColIndice((String)"F")] = true;
                        } else if (exameDesmembrado) {
                            psFilhos.setInt(1, rs.getInt("fil_codigo"));
                            psFilhos.setInt(2, rs.getInt("int_codigo"));
                            psFilhos.setString(3, rs.getString("exa_codigo"));
                            psFilhos.setInt(4, rs.getInt("mco_codigo"));
                            psFilhos.setLong(5, rs.getLong("req_codigo"));
                            psFilhos.setLong(6, rs.getLong("rec_codigo"));
                            ResultSet rsFilhos = psFilhos.executeQuery();
                            while (rsFilhos.next()) {
                                Map<String, Object> dadosFilho = StringUtil.getMapDeXML(rsFilhos.getString("ier_xmlvalores"));
                                List<String> flagsFilho = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dadosFilho.get("flag")));
                                if (flagsFilho == null || flagsFilho.isEmpty()) continue;
                                linha[this.getColIndice((String)"F")] = true;
                                break;
                            }
                        }
                    }
                    for (PanelAbaAbstrata.Coluna c : this.colunas) {
                        int index = this.getColIndice(c.getNomeColuna());
                        String campo = c.getNomeCampo();
                        String valor = this.notNull((String)dados.get(campo));
                        linha[index] = valor;
                    }
                }
                dadosTemp.add(linha);
            }
            this.exames = dadosTemp;
            this.tabelaExames.setData(this.exames);
            this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
            pst.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    private StringBuilder getSqlLoadExames() {
        StringBuilder query = new StringBuilder();
        query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
        query.append("a.ier_situacao, a.ier_xmlvalores, b.req_anomes, b.req_idade, ");
        query.append("c.pac_nome, c.pac_sexo, d.mco_abreviatura, a.ier_rackpos, ");
        query.append("(b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, ");
        query.append("a.int_codigo, f.met_codigo, ");
        if (this.exr_codigoapoiado) {
            query.append("  ( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(e.exr_codigoapoiado as varchar) end) as exr_codigoapoiado,  ");
        }
        query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
        query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev ");
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
        }
        query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
        query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
        query.append(" , a.ier_resultadoalterado ");
        query.append("from interfaceexamerequisicao a ");
        query.append("join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
        query.append("join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
        query.append("join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
        if (this.exr_codigoapoiado) {
            query.append("left join examerequisicaorecipiente erc on erc.fil_codigo = b.fil_codigo and erc.req_codigo = b.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
        }
        query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
        query.append("join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
        query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
        query.append("  and (a.ier_situacao between ").append(SIT_PRONTO).append(" and ").append(SIT_PRONTO_VALIDADO).append(") ");
        if (!this.equipamento.isPesquisaExamesComExcecao()) {
            query.append(" and a.ier_situacao <> 6");
        }
        query.append(" and e.exr_situacao not in ( ");
        query.append("'").append("T").append("', ");
        query.append("'").append("A").append("', ");
        query.append("'").append("F").append("', ");
        query.append("'").append("R").append("', ");
        query.append("'").append("N").append("', ");
        query.append("'").append("C").append("', ");
        query.append("'").append("L").append("', ");
        query.append("'").append("E").append("', ");
        query.append("'").append("I").append("' ");
        query.append(") ");
        query.append("and not e.exr_excluido ");
        query.append("and not b.req_excluida ");
        if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
            query.append(" and b.col_codigo in ('");
            StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
            query.append("')");
        }
        if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
            query.append(" and b.des_codigo in ('");
            StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
            query.append("')");
        }
        if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
            query.append(" and b.sit_codigo in ('");
            StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
            query.append("')");
        }
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.exa_codigo");
        } else {
            query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo");
        }
        return query;
    }

    @Override
    public void voltaExamesNaoExportados(List<Object[]> examesNaoExportados) {
        if (!examesNaoExportados.isEmpty()) {
            this.equipamento.refresh(2);
        }
    }

    @Override
    public int verificaLancados(int sequence) {
        int seq = sequence;
        List<Registro> registros = BDUtil.getListaExamesLancado(sequence);
        if (!registros.isEmpty()) {
            seq = registros.get(registros.size() - 1).getInt("ers_codigo");
            boolean atualizar = false;
            for (Registro registro : registros) {
                String filCodigo = Funcoes.preencheZero(registro.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                String requisicao = Funcoes.preencheZero(registro.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                String codigo = String.format("%s%s", filCodigo, requisicao);
                String mco = registro.getString("mco_codigo");
                String exa = registro.getString("exa_codigo");
                for (int i = 0; i < this.tabelaExames.getRowCount(); ++i) {
                    Object[] obj = this.tabelaExames.getRow(i);
                    String reqCodigo = (String)obj[this.getColIndice("C\u00f3digo")];
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        reqCodigo = (String)obj[this.getColIndice("C\u00f3digo Temp.")];
                    }
                    String exaCodigo = (String)obj[this.getColIndice("Exame")];
                    String mcoCodigo = (String)obj[this.getColIndice("C\u00f3d. Mat.")];
                    if (!codigo.equals(reqCodigo) || !mco.equals(mcoCodigo) || !exa.equals(exaCodigo)) continue;
                    atualizar = true;
                    break;
                }
                if (!atualizar) continue;
                break;
            }
        }
        return seq;
    }

    @Override
    protected String exportarValidados(ArrayList<Object[]> examesProntos) {
        this.jButtonExportar.setEnabled(false);
        this.jButtonLiberarUm.setEnabled(false);
        String retorno = "Exames exportados com sucesso";
        try {
            this.panelExportacao.addExames(examesProntos);
            this.panelExportacao.restart();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                retorno = "Erro: Os exames n\u00e3o puderam ser exportados. " + ex.getMessage();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.jButtonExportar.setEnabled(true);
        this.jButtonLiberarUm.setEnabled(true);
        return retorno;
    }
}

