/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.atellicasolution;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    public static String RECORD_TYPE_HEADER = "H";
    public static String RECORD_TYPE_PATIENT = "P";
    public static String RECORD_TYPE_ORDER = "O";
    public static String RECORD_TYPE_REQUEST = "Q";
    public static String RECORD_TYPE_RESULT = "R";
    public static String RECORD_TYPE_COMMENT = "C";
    public static String RECORD_TYPE_MANUFACTURER = "M";
    public static String RECORD_TYPE_TERMINATION = "L";
    public static final char EOT = '\u0004';
    public static int HEADER_RECORD_FIELDS_NUMBER = 14;
    public static int PATIENT_RECORD_FIELDS_NUMBER = 35;
    public static int ORDER_RECORD_FIELDS_NUMBER = 31;
    public static int RESULT_RECORD_FIELDS_NUMBER = 14;
    public static int COMMENT_RECORD_FIELDS_NUMBER = 5;
    public static int REQUEST_RECORD_FIELDS_NUMBER = 13;
    public static int TERMINATION_RECORD_FIELDS_NUMBER = 3;
    public static int MANUFACTURER_RECORD_FIELDS_NUMBER = 5;
    public static Integer RECORD_TYPE = new Integer(1);
    public static Integer SEQUENCE_NUMBER = new Integer(2);
    public static Integer ORDER_FIELD_RECORD_ID = new Integer(1);
    public static Integer ORDER_FIELD_SEQUENCE = new Integer(2);
    public static Integer ORDER_FIELD_SAMPLE_ID = new Integer(3);
    public static Integer ORDER_FIELD_SYSTEM_SID = new Integer(4);
    public static Integer ORDER_FIELD_TEST_ID = new Integer(5);
    public static Integer ORDER_FIELD_PRIORITY = new Integer(6);
    public static Integer ORDER_FIELD_REQUESTED_DATETIME = new Integer(7);
    public static Integer ORDER_FIELD_COLLECTION_DATETIME = new Integer(8);
    public static Integer ORDER_FIELD_COLLECTION_LASTTIME = new Integer(9);
    public static Integer ORDER_FIELD_COLLECTION_AMOUNT = new Integer(10);
    public static Integer ORDER_FIELD_COLLECTOR_ID = new Integer(11);
    public static Integer ORDER_FIELD_ACTION_CODE = new Integer(12);
    public static Integer ORDER_FIELD_DANGER_CODE = new Integer(13);
    public static Integer ORDER_FIELD_RELEVANT_CLINICAL_INFO = new Integer(14);
    public static Integer ORDER_FIELD_DATE_SAMPLE_RECEIVED = new Integer(15);
    public static Integer ORDER_FIELD_SAMPLE_INFO = new Integer(16);
    public static Integer ORDER_FIELD_ORDERING_DOCTOR = new Integer(17);
    public static Integer ORDER_FIELD_DOCTOR_PHONE = new Integer(18);
    public static Integer ORDER_FIELD_USER1 = new Integer(19);
    public static Integer ORDER_FIELD_USER2 = new Integer(20);
    public static Integer ORDER_FIELD_LAB1 = new Integer(21);
    public static Integer ORDER_FIELD_LAB2 = new Integer(22);
    public static Integer ORDER_FIELD_DATETIME_REPORTED = new Integer(23);
    public static Integer ORDER_FIELD_CHARGE = new Integer(24);
    public static Integer ORDER_FIELD_SYSTEM_SECTION = new Integer(25);
    public static Integer ORDER_FIELD_REPORT_TYPE = new Integer(26);
    public static Integer ORDER_FIELD_RESERVED = new Integer(27);
    public static Integer ORDER_FIELD_COLLECTION_WARD = new Integer(28);
    public static Integer ORDER_FIELD_NOSOCOMIAL_FLAG = new Integer(29);
    public static Integer ORDER_FIELD_SAMPLE_SERVICE = new Integer(30);
    public static Integer ORDER_FIELD_SAMPLE_INSTITUTION = new Integer(31);
    public static String CR = String.valueOf('\r');

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Hashtable result_fields;
        block39: {
            String resultado;
            String resultType;
            block40: {
                String campo;
                int sit;
                block42: {
                    block41: {
                        String result_status;
                        String int_codigo;
                        String fil_codigo;
                        block38: {
                            Statement st;
                            String req_codigo;
                            String rec_codigo;
                            block37: {
                                block36: {
                                    if (this.exame_atual == null) {
                                        return;
                                    }
                                    String action_code = (String)this.exame_atual.get(ACTION_CODE);
                                    String report_type = (String)this.exame_atual.get(REPORT_TYPE);
                                    if (action_code != null) {
                                        this.equip.getClass();
                                        if (action_code.equals("Q")) {
                                            this.exame_atual = null;
                                            return;
                                        }
                                    }
                                    if (report_type != null) {
                                        this.equip.getClass();
                                        if (report_type.equals("X")) {
                                            this.exame_atual = null;
                                            return;
                                        }
                                    }
                                    result_fields = ASTMStandard.parseDefaultResultRecord(record);
                                    Map<Integer, String> components = this.equip.parseOrderTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
                                    resultType = (String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID);
                                    String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
                                    fil_codigo = this.exame_atual.get(FIL_CODIGO).toString();
                                    rec_codigo = this.exame_atual.get(REC_CODIGO).toString();
                                    req_codigo = this.exame_atual.get(REQ_CODIGO).toString();
                                    st = Conexao.getStatement();
                                    int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                                    if (int_codigo == null) {
                                        int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                                    }
                                    if (int_codigo == null) {
                                        this.equip.fireExcecaoEncontrada("C\u00f3digo do interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + "n\u00e3o localizado.");
                                        return;
                                    }
                                    ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                                    this.exame_atual.put(INT_CODIGO, int_codigo);
                                    if (exame == null) {
                                        this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                                        return;
                                    }
                                    String exaOld = (String)this.exame_atual.get(EXA_CODIGO);
                                    String mcoOld = (String)this.exame_atual.get(MCO_CODIGO);
                                    String intOld = (String)this.exame_atual.get(INT_CODIGO);
                                    String exa_codigo = exame.getNomeExame();
                                    String mco_codigo = exame.getCodigoMaterial();
                                    if (!(exaOld == null || mcoOld == null || intOld == null || exaOld.equalsIgnoreCase(exa_codigo) && mcoOld.equalsIgnoreCase(mco_codigo) && intOld.equalsIgnoreCase(int_codigo))) {
                                        try {
                                            this.salvaExame(this.exame_atual);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        this.exame_atual.remove("resultado_qualitativo");
                                        this.exame_atual.remove("repeticao_qualitativo");
                                        this.exame_atual.remove("resultado_quantitativo");
                                        this.exame_atual.remove("repeticao_quantitativo");
                                        this.exame_atual.remove("centaur_rlu");
                                        this.exame_atual.remove("centaur_coff");
                                        this.exame_atual.remove("centaur_indx");
                                    }
                                    this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
                                    this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
                                    result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
                                    if (result_status != null) {
                                        this.equip.getClass();
                                        if (!result_status.contains("F")) {
                                            this.equip.getClass();
                                            if (!result_status.contains("R")) {
                                                this.exame_atual = null;
                                                return;
                                            }
                                        }
                                    }
                                    if ((resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE)).contains("[SP]")) {
                                        resultado = resultado.replace("[SP]", " ");
                                    }
                                    if (resultado.startsWith(".")) {
                                        resultado = "0" + resultado;
                                    }
                                    if (resultado.charAt(resultado.length() - 1) == '.') {
                                        resultado = resultado + "0";
                                    }
                                    resultado = this.equip.arrendondaValor(resultado, fil_codigo, this.exame_atual.get(EXA_CODIGO).toString(), this.exame_atual.get(MCO_CODIGO).toString(), int_codigo);
                                    this.equip.getClass();
                                    if (result_status.contains("F")) break block36;
                                    this.equip.getClass();
                                    if (!result_status.contains("R")) break block37;
                                }
                                resultado = resultado.replaceAll("\\.", ",");
                            }
                            sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, this.exame_atual.get(EXA_CODIGO).toString(), this.exame_atual.get(MCO_CODIGO).toString(), rec_codigo);
                            campo = "";
                            if (Funcoes.isNumeric(this.removeMaiorMenor(resultado))) break block38;
                            campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                            this.exame_atual.put(campo, resultado);
                            break block39;
                        }
                        if (!resultType.contains("DOSE")) break block40;
                        if (resultado.startsWith(".")) {
                            resultado = "0" + resultado;
                        }
                        if (resultado.charAt(resultado.length() - 1) == '.') {
                            resultado = resultado + "0";
                        }
                        resultado = this.equip.arrendondaValor(resultado, fil_codigo, this.exame_atual.get(EXA_CODIGO).toString(), this.exame_atual.get(MCO_CODIGO).toString(), int_codigo);
                        this.equip.getClass();
                        if (result_status.contains("F")) break block41;
                        this.equip.getClass();
                        if (!result_status.contains("R")) break block42;
                    }
                    resultado = resultado.replaceAll("\\.", ",");
                }
                String string = campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                if (resultado.matches("\\d*\\,?\\d+") || Funcoes.isNumeric(this.removeMaiorMenor(resultado))) {
                    this.exame_atual.put(campo, resultado);
                }
                break block39;
            }
            if (resultType.contains("RLU")) {
                this.exame_atual.put("centaur_rlu", resultado);
            } else if (resultType.contains("COFF")) {
                this.exame_atual.put("centaur_coff", resultado);
            } else if (resultType.contains("INDX")) {
                this.exame_atual.put("centaur_indx", resultado);
            }
        }
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    private String removeMaiorMenor(String resultado) {
        String retorno = resultado;
        if (resultado.contains("<")) {
            retorno = resultado.replace("<", "");
        }
        if (resultado.contains(">")) {
            retorno = resultado.replace(">", "");
        }
        return retorno;
    }

    public static String getRecordTypeIdentifier(String record) {
        if (record != null && !record.equals("")) {
            char record_type = record.charAt(0);
            switch (record_type) {
                case 'h': {
                    return RECORD_TYPE_HEADER;
                }
                case 'H': {
                    return RECORD_TYPE_HEADER;
                }
                case 'p': {
                    return RECORD_TYPE_PATIENT;
                }
                case 'P': {
                    return RECORD_TYPE_PATIENT;
                }
                case 'o': {
                    return RECORD_TYPE_ORDER;
                }
                case 'O': {
                    return RECORD_TYPE_ORDER;
                }
                case 'r': {
                    return RECORD_TYPE_RESULT;
                }
                case 'R': {
                    return RECORD_TYPE_RESULT;
                }
                case 'q': {
                    return RECORD_TYPE_REQUEST;
                }
                case 'Q': {
                    return RECORD_TYPE_REQUEST;
                }
                case 'l': {
                    return RECORD_TYPE_TERMINATION;
                }
                case 'L': {
                    return RECORD_TYPE_TERMINATION;
                }
                case 'm': {
                    return RECORD_TYPE_MANUFACTURER;
                }
                case 'M': {
                    return RECORD_TYPE_MANUFACTURER;
                }
                case 'c': {
                    return RECORD_TYPE_COMMENT;
                }
                case 'C': {
                    return RECORD_TYPE_COMMENT;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void recordFound(String record) throws Exception {
        boolean charIsNumber = Character.isDigit((record = record.trim()).charAt(0));
        String record_type = RecordParser.getRecordTypeIdentifier(record = charIsNumber ? record.substring(1, record.length() - 1) : record.substring(0, record.length() - 1));
        if (record_type != null) {
            if (record_type.equals(RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }

    public static String fillRecordFields(String record, int fields_number) {
        StringBuilder temp = new StringBuilder(record);
        for (int n = StringUtil.contaOcorrencias(new StringBuilder(record), '|'); n < fields_number - 1; ++n) {
            temp.append("|");
        }
        return temp.toString();
    }

    public static String[] tokenizeRecordFields(String record, int fields_number) {
        String[] temp = record.split("[|]");
        String[] tokens = new String[fields_number];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = i < temp.length ? temp[i] : "";
        }
        return tokens;
    }

    public static Hashtable<Integer, String> parseDefaultOrderRecord(String record) {
        try {
            record = RecordParser.removeCR(record);
            record = RecordParser.fillRecordFields(record, ORDER_RECORD_FIELDS_NUMBER);
            String[] tokens = RecordParser.tokenizeRecordFields(record, ORDER_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> order_fields = new Hashtable<Integer, String>();
            order_fields.put(RECORD_TYPE, tokens[0]);
            order_fields.put(SEQUENCE_NUMBER, tokens[1]);
            order_fields.put(ORDER_FIELD_SAMPLE_ID, tokens[2]);
            order_fields.put(ORDER_FIELD_SYSTEM_SID, tokens[3]);
            order_fields.put(ORDER_FIELD_TEST_ID, tokens[4]);
            order_fields.put(ORDER_FIELD_PRIORITY, tokens[5]);
            order_fields.put(ORDER_FIELD_REQUESTED_DATETIME, tokens[6]);
            order_fields.put(ORDER_FIELD_COLLECTION_DATETIME, tokens[7]);
            order_fields.put(ORDER_FIELD_COLLECTION_LASTTIME, tokens[8]);
            order_fields.put(ORDER_FIELD_COLLECTION_AMOUNT, tokens[9]);
            order_fields.put(ORDER_FIELD_COLLECTOR_ID, tokens[10]);
            order_fields.put(ORDER_FIELD_ACTION_CODE, tokens[11]);
            order_fields.put(ORDER_FIELD_DANGER_CODE, tokens[12]);
            order_fields.put(ORDER_FIELD_RELEVANT_CLINICAL_INFO, tokens[13]);
            order_fields.put(ORDER_FIELD_DATE_SAMPLE_RECEIVED, tokens[14]);
            order_fields.put(ORDER_FIELD_SAMPLE_INFO, tokens[15]);
            order_fields.put(ORDER_FIELD_ORDERING_DOCTOR, tokens[16]);
            order_fields.put(ORDER_FIELD_DOCTOR_PHONE, tokens[17]);
            order_fields.put(ORDER_FIELD_USER1, tokens[18]);
            order_fields.put(ORDER_FIELD_USER2, tokens[19]);
            order_fields.put(ORDER_FIELD_LAB1, tokens[20]);
            order_fields.put(ORDER_FIELD_LAB2, tokens[21]);
            order_fields.put(ORDER_FIELD_DATETIME_REPORTED, tokens[22]);
            order_fields.put(ORDER_FIELD_CHARGE, tokens[23]);
            order_fields.put(ORDER_FIELD_SYSTEM_SECTION, tokens[24]);
            order_fields.put(ORDER_FIELD_REPORT_TYPE, tokens[25]);
            order_fields.put(ORDER_FIELD_RESERVED, tokens[26]);
            order_fields.put(ORDER_FIELD_COLLECTION_WARD, tokens[27]);
            order_fields.put(ORDER_FIELD_NOSOCOMIAL_FLAG, tokens[28]);
            order_fields.put(ORDER_FIELD_SAMPLE_SERVICE, tokens[29]);
            order_fields.put(ORDER_FIELD_SAMPLE_INSTITUTION, tokens[30]);
            return order_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static String removeCR(String record) {
        if (record.endsWith(CR)) {
            record = record.substring(0, record.length() - 1);
        }
        return record;
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null && this.exame_atual.get(INT_CODIGO) != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = RecordParser.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ORDER_FIELD_SAMPLE_ID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        try {
            Long.parseLong(id);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(id);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String req_codigo = Funcoes.preencheZero(id, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(id);
        if (etiqueta != null) {
            fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }
}

