/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.atellicasolution;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.atellicasolution.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.PacketParser;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    boolean exr_codigoapoiado = false;
    protected PacketParser packetParser;
    private Message messageToReceive;
    RecordParser recordParser;
    private boolean possuiEOTnoBloco = false;
    private MemoryList<String> tx_list_backup = new MemoryList();
    private Timer porta = null;
    private boolean heartbit = false;

    public InterfaceListener() {
        this.recordParser = new RecordParser();
        this.recordParser.setInterfaceASTMListener(this);
        this.packetParser = new PacketParser();
        this.TIME_RX = 30000;
        super.setASTMRecordParser(this.recordParser);
        this.porta = new Timer(100000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX()) {
                    try {
                        if (!InterfaceListener.this.heartbit) {
                            InterfaceListener.this.setTX(InterfaceListener.this.TIME_TX);
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0005'));
                            InterfaceListener.this.heartbit = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.porta.start();
    }

    @Override
    public void fcTimedOut(EventObject e) {
        super.fcTimedOut(e);
        if (this.heartbit) {
            this.heartbit = false;
        }
    }

    @Override
    public String getMiddleFrameEnd() {
        return String.valueOf('\u0017');
    }

    @Override
    public String getFinalFrameEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 4, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        if (this.hostQuery) {
            this.responseHostQuery();
        }
        this.getPortaCOM().write(String.valueOf('\u0005'));
    }

    @Override
    protected void caracterNaoEsperado() throws Exception {
        if (!this.tx_list_backup.isEmpty() && this.tx_list_backup.size() > 0) {
            this.tx_list = this.tx_list_backup;
            this.enviarProximoFrame();
            this.tx_list_backup = new MemoryList();
        } else {
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void responseHostQuery() {
        try {
            block16: {
                block15: {
                    fil_codigo = this.host_fil_codigo;
                    req_codigo = this.host_req_codigo;
                    rec_codigo = this.host_rec_codigo;
                    pac_nome = null;
                    pac_sexo = null;
                    pac_idade = null;
                    data = null;
                    hora = null;
                    rack = null;
                    prioridade = null;
                    int_codigo = null;
                    mco_codigo = null;
                    pac_exames = null;
                    acao = "A";
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                    aba = this.equipamento.getTab(0);
                    if (req != null) {
                        pac_exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        aba = this.equipamento.getTab(1);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames.trim();
                        }
                    }
                    if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames.trim();
                        }
                    }
                    if (req == null) break block15;
                    if (this.exr_codigoapoiado) {
                        if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                                if (ParametrosGerais.isAgruparGuiasInterface()) {
                                    requisicao = (String)req[aba.getColIndice("Multiguia")];
                                }
                                filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                                requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                                tubo = (String)req[aba.getColIndice("Tubo")];
                                tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                                fil_codigo = filial;
                                req_codigo = requisicao;
                                rec_codigo = tubo;
                            }
                        }
                    }
                    pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                    pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                    data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                    v0 = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : (hora = null);
                    if (this.exr_codigoapoiado) ** GOTO lbl-1000
                    if (req[aba.getColIndice("Cod. Apoiado")] == null) ** GOTO lbl-1000
                    if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                        rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                    } else lbl-1000:
                    // 3 sources

                    {
                        rack = (String)req[aba.getColIndice("Cod. Apoiado")];
                    }
                    int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    break block16;
                }
                return;
            }
            mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Atellica Solution: Host Query Response");
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            if ((starting_range = starting_range.substring(1)).length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Atellica Solution: Host Query Response");
        }
    }

    private void confirmacaoACK() {
        this.handShakeCharReceived('\u0006');
    }

    private void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            String material = ExamesUtil.getMaterialAlternativo(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            StringBuilder response = new StringBuilder();
            response.append(this.getHeaderRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = codigo.toString();
            Object laboratory_pid = null;
            Date dtNascimento = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            if (dtNascimento == null) {
                dtNascimento = new Date();
            }
            response.append(this.getPatientRecord(1, patient_id, nome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro do paciente");
            }
            exa_lista = null;
            for (int i = 0; i < alternativos.length; ++i) {
                response.append(this.getOrderRecord(i + 1, codigo.toString(), alternativos[i], exa_lista, "R", acao, material));
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            response.append(this.getTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list.add(response.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getHeaderRecord() {
        StringBuilder record = new StringBuilder("H|\\^&||||||||||P|1");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sexo) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("||");
        record.append("||");
        record.append(pac_nome).append("|||");
        record.append(pac_sexo).append(String.valueOf('\r'));
        return record.toString();
    }

    public String getTerminationRecord(String termination_code) {
        StringBuilder record = new StringBuilder("L|1|F");
        record.append('\r');
        return record.toString();
    }

    public String getOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_numbers, ExameMaterial[] test_item_names, String priority, String action_code, String tipoAmostra) {
        String tmp;
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("^^||");
        if (test_item_numbers != null && (tmp = test_item_numbers.getNomeExame()) != null && !tmp.matches("\\^\\d+\\^\\w+\\^\\d+")) {
            tmp = "^^^" + test_item_numbers.getNomeExame();
            record.append(tmp);
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|" + this.getCurrentMoment());
        record.append("|||||A||||");
        record.append(tipoAmostra != null && !Funcoes.textoVazio(tipoAmostra) ? tipoAmostra : "Serum");
        record.append("||||||||||");
        record.append('\r');
        return record.toString();
    }

    public String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||UIW_LIS|||||LIS_ID||P||20230215094827[CR]P|1||||TAIS[SP]LONARDONI[SP]FRIGO|||F[CR]O|1|" + idAmostra + "^045822^B4||^^^COL^^^1|R|20230214170144|||||||||Serum^^^1||||||||||F[CR]R|1|^^^COL^^^1^RLU^6088#0|106444|||||F\\R||Labmar^System||20230214174117|SP00649^IH00739[CR]R|2|^^^COL^^^1^COFF^6088#0|1.00|Index||||F\\R||Labmar^System||20230214174117|SP00649^IH00739[CR]R|3|^^^COL^^^1^INDX^6088#0|0.56|Index||||F\\R||Labmar^System||20230214174117|SP00649^IH00739[CR]L|1|N[CR][ETX]4E[LINE][EOT]"));
    }

    public String getMsgEOT() {
        return String.valueOf('\u0004');
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = "";
            String termination = "";
            if (message.charAt(0) == '\u0005' && message.length() > 5) {
                message = message.substring(1);
            }
            int stx_index = message.indexOf(this.getMsgStart());
            int eot_index = message.indexOf(this.getMsgEOT());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] records;
                    String recordsString = (String)this.rx_list.remove(0);
                    recordsString = recordsString.substring(1, recordsString.length() - 1);
                    for (String record : records = recordsString.split("\r")) {
                        if (record.trim().isEmpty()) continue;
                        this.recordParser.recordFound(record);
                    }
                    if (eot_index <= 0) continue;
                    this.possuiEOTnoBloco = true;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        super.setPortaCOM(portaCOM);
    }

    private void query() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[ENQ][STX]1H|^&|||UIW_LIS|||||LIS_ID||P||20230127112730[CR]Q|1|^010008613888|^010008613888|ALL||||||||O[CR]L|1|N[CR][ETX]D5[LINE][STX]1H|^&|||UIW_LIS|||||LIS_ID||P||20230127112730[CR]Q|1|^010007810304|^010007810304|ALL||||||||O[CR]L|1|N[CR][ETX]D5[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0) {
                        this.tx_list_backup = this.tx_list;
                    }
                    this.tratarEnquiry();
                    break;
                }
                case '\u0002': {
                    this.tratarEndOfTX();
                }
                case '\u0006': {
                    if (this.heartbit) {
                        this.getPortaCOM().write(String.valueOf('\u0004'));
                        this.setIdle();
                        this.heartbit = false;
                        this.porta.stop();
                        this.porta.setDelay(540000);
                        this.porta.start();
                    }
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0003': {
                    if (this.hostQuery) {
                        this.responseHostQuery();
                    }
                    break;
                }
                case '\u0004': {
                    if (this.heartbit) {
                        this.heartbit = false;
                    }
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void tratarEnquiry() throws Exception {
        if (this.isTX()) {
            this.getPortaCOM().write(String.valueOf('\u0006'));
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceber();
        } else {
            this.prepararParaReceber();
        }
    }
}

