/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.architectsr1000i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.architectsr1000i.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.architectsr1000i.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.architect.InterfaceListener {
    private String host_fil_codigo = null;
    private String host_req_codigo = null;
    private String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean envioVazio = false;
    protected ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected RecordParser recordResult = new RecordParser();
    private List<String> mensagens = new ArrayList<String>();
    private boolean query = false;
    protected InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        this.recordResult.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        if ((starting_range = starting_range.substring(1)).length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return;
        }
        String fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
        starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.host_fil_codigo = fil_codigo;
        this.host_req_codigo = req_codigo;
        this.host_rec_codigo = rec_codigo;
        this.hostQuery = true;
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!this.envioVazio) {
            super.encerrarTransmissao();
        } else {
            this.envioVazio = false;
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (this.query) {
                        while (this.mensagens.size() > 0) {
                            String resultado = this.parse(this.mensagens.remove(0));
                            if (resultado == null || !resultado.startsWith("Erro")) continue;
                            this.fireExcecaoEncontrada(resultado);
                        }
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            if (this.isTX()) {
                this.fireExcecaoEncontrada("Aparelho j\u00e1 est\u00e1 transmitindo aguarde o termino para enviar outro paciente");
            }
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            this.ultima_acao = acao;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            Statement st = Conexao.getStatement();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                exa_lista = ExamesUtil.removeDuplicados(exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int n = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < n && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            if (alternativos != null && exa_lista != null && alternativos.length == exa_lista.length) {
                ArrayList<Integer> remov = new ArrayList<Integer>();
                for (int i = 0; i < alternativos.length; ++i) {
                    if (!Funcoes.textoVazio(alternativos[i].getNomeExame()) && !alternativos[i].getNomeExame().equals("null")) continue;
                    this.fireExcecaoEncontrada(String.format("Exame %s sem alternativo configurado verifique!", exa_lista[i].getNomeExame()));
                    remov.add(i);
                }
                int[] r = new int[remov.size()];
                if (remov.size() > 0) {
                    alternativos = ArraysUtil.remover(alternativos, r);
                    exa_lista = ArraysUtil.remover(exa_lista, r);
                }
            }
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            Date dt = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = "";
            if (dt != null) {
                dataNasc = Funcoes.formataData("yyyyMMdd", dt);
            }
            String t = ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, dataNasc, "");
            this.tx_list.add(t);
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = ASTMStandard.getDefaultOrderRecord(++seq, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, this.hostQuery || this.configuracao.getModoHostQuery() ? "Q" : "O");
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", acao, tipo_amostra, this.hostQuery || this.configuracao.getModoHostQuery() ? "Q" : "O");
                    this.tx_list.add(t);
                }
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String parseResult(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    System.out.println(message);
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    System.out.println(message);
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordResult.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (!this.configuracao.getNaoEnviarExamesPendentes() && req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    List<Object[]> reqs2 = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs2) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            if (req == null) {
                aba.reloadExames();
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                if (req != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]);
                }
            }
            if (!this.configuracao.getNaoEnviarExamesPendentes() && req == null) {
                aba = this.equipamento.getTab(1);
                aba.reloadExames();
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            if (req != null) {
                String rec_codigoPai;
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Tubo") >= 0 ? (String)req[aba.getColIndice("Tubo")] : (rec_codigoPai = null);
                if (Funcoes.textoVazio(pac_exames.toString())) {
                    pac_exames.append(aba.getColIndice("Exame") >= 0 ? (String)req[aba.getColIndice("Exame")] : "");
                }
                if (situacao == null) {
                    situacao = aba.getColIndice("Sit") >= 0 ? (String)req[aba.getColIndice("Sit")] : null;
                }
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao);
            } else {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos %s %s %s", fil_codigo, req_codigo, rec_codigo));
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) {
        try {
            String sample = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String nome = "";
            if (!Funcoes.textoVazio(fil_codigo) && !Funcoes.textoVazio(req_codigo)) {
                nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
            }
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, req_codigo, null, nome, null, this.pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, sample, null, null, null, "R", "N", "S", this.hostQuery || this.configuracao.getModoHostQuery() ? "Q" : "O"));
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.envioVazio = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            for (int i = 0; i < 12; ++i) {
                this.handShakeCharReceived('\u0006');
            }
        } else if (op == 2) {
            this.resultado();
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||ASI^1.0^s/n^H1P1O1R1Q1L1C1|||||My^Host^System||P|1|19930631[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + idAmosta + "||^^^ALL||||||||O[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]FF[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        String idAmostra1 = JOptionPane.showInputDialog("Informe o Id da amostra");
        String alternativo = JOptionPane.showInputDialog("Informe o Alternativo");
        HashMap<String, String> res = new HashMap<String, String>();
        if (Funcoes.textoVazio(idAmostra1) || Funcoes.textoVazio(alternativo)) {
            return;
        }
        res.put(alternativo, String.valueOf(Math.random() * 100.0));
        this.parseResult(this.equipamento.arruma("[STX]1H|\\^&|||ASI^1.0^s/n^H1P1O1R1Q1L1C1|||||My^Host^System||P|1|19930631[CR][ETX]FF[LINE]"));
        this.parseResult(this.equipamento.arruma("[STX]2P|1||PID0001||Doe^John|Smith|19500522|M|||||Jones^Bob^^^Dr|||||300.0^Anxiety\u00c9.0^Depression|[CR][ETX]FF[LINE]"));
        for (String key : res.keySet()) {
            this.parseResult(this.equipamento.arruma("[STX]3O|1|" + idAmostra1 + "||^^^" + key + "^Test10^protocol1|S|19930631|19930629||||||||SERUM|Miller^John^^^Dr|||||||||O|[CR][ETX]FF[LINE]"));
            this.parseResult(this.equipamento.arruma("[STX]4R|1|^^^" + key + "^B-hCG^UNDILUTED^P^47331M100^00788^^F|" + (String)res.get(key) + "|mIU/mL|0.35 TO 4.94|EXP^<||F||||19990715081030|I20100[CR][ETX]FF[LINE]"));
            this.parseResult(this.equipamento.arruma("[STX]5C|1|I|Accidently deleted result and had to reenter|G [CR][ETX]FF[LINE]"));
        }
        this.parseResult(this.equipamento.arruma("[STX]1L|1|N[CR][ETX]FF[LINE]"));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        public boolean listaDeExamesProcessando() {
            return this.listaRecebimento.size() > 0;
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parseResult(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

