/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.architect;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.interfaces.architect.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.util.HashMap;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    public static final String RESULT_STATUS_INTERPRETATION = "I";
    public static final Integer TEST_STATUS = new Integer(7);
    public static final Integer TEST_REAGENT_LOT = new Integer(8);
    public static final Integer TEST_REAGENT_SERIAL_NUMBER = new Integer(9);
    public static final Integer TEST_CONTROL_LOT_NUMBER = new Integer(10);
    public static final Integer TEST_RESULT_TYPE = new Integer(11);
    public boolean hostQuery = false;
    private String host_fil_codigo = null;
    private String host_req_codigo = null;
    private String host_rec_codigo = null;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 10, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            components.put(TEST_STATUS, tokens[6]);
            components.put(TEST_REAGENT_LOT, tokens[7]);
            components.put(TEST_REAGENT_SERIAL_NUMBER, tokens[8]);
            components.put(TEST_CONTROL_LOT_NUMBER, tokens[9]);
            components.put(TEST_RESULT_TYPE, tokens[10]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        if ((starting_range = starting_range.substring(1)).length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return;
        }
        String fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
        starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
        System.out.println(fil_codigo);
        System.out.println(req_codigo);
        System.out.println(rec_codigo);
        this.host_fil_codigo = fil_codigo;
        this.host_req_codigo = req_codigo;
        this.host_rec_codigo = rec_codigo;
        this.hostQuery = true;
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.equipamento.transmiteRequisicao(this.host_fil_codigo, this.host_req_codigo, this.host_rec_codigo);
            this.hostQuery = false;
        }
    }
}

