/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.adviacentaurcp;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private static final String REAGENTE_LOTE = "exr_lotereag";
    private static final String REAGENTE_SERIAL = "exr_serialreag";
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean considerarIndxQuantitativo = false;

    public RecordParser(boolean considerarIndxQuantitativo) {
        this.considerarIndxQuantitativo = considerarIndxQuantitativo;
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type;
        if (Funcoes.isNumeric(record.substring(0, 1)) && record.length() > 1) {
            record = record.substring(1, record.length() - 1);
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(record)) != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Hashtable result_fields;
        String result_status;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                return;
            }
        }
        if ((result_status = (String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_RESULT_STATUS)) != null) {
            this.equip.getClass();
            if (result_status.indexOf("F") < 0) {
                this.equip.getClass();
                if (result_status.indexOf("R") < 0) {
                    return;
                }
            }
        }
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        String resultType = components.get(this.equip.TEST_RESULT_ASPECTS);
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        String exaOld = (String)this.exame_atual.get(EXA_CODIGO);
        String mcoOld = (String)this.exame_atual.get(MCO_CODIGO);
        String intOld = (String)this.exame_atual.get(INT_CODIGO);
        String exa_codigo = exame.getNomeExame();
        String mco_codigo = exame.getCodigoMaterial();
        if (!(exaOld == null || mcoOld == null || intOld == null || exaOld.equalsIgnoreCase(exa_codigo) && mcoOld.equalsIgnoreCase(mco_codigo) && intOld.equalsIgnoreCase(int_codigo))) {
            try {
                this.salvaExame(this.exame_atual);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.exame_atual.remove("resultado_qualitativo");
            this.exame_atual.remove("repeticao_qualitativo");
            this.exame_atual.remove("resultado_quantitativo");
            this.exame_atual.remove("repeticao_quantitativo");
        }
        this.exame_atual.put(EXA_CODIGO, exa_codigo);
        this.exame_atual.put(MCO_CODIGO, mco_codigo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if (Funcoes.textoVazio(resultado)) {
            this.equip.fireExcecaoEncontrada("Resultado do exame " + exa_codigo + " recebido sem valor do aparelho " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        this.equip.getClass();
        if (result_status.indexOf("F") >= 0 && (resultType.equalsIgnoreCase("DOSE") || resultType.equalsIgnoreCase("INDX"))) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = "";
        campo = resultType.equalsIgnoreCase("INTR") ? (sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo") : (resultType.equalsIgnoreCase("DOSE") ? (sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo") : (resultType.equalsIgnoreCase("COFF") ? "centaur_coff" : (resultType.equalsIgnoreCase("RLU") ? "centaur_rlu" : (resultType.equalsIgnoreCase("INDX") ? (this.considerarIndxQuantitativo && !this.exame_atual.containsKey("resultado_quantitativo") && !this.exame_atual.containsKey("repeticao_quantitativo") ? (sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo") : "centaur_indx") : resultType))));
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Statement st = Conexao.getStatement();
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        if (this.starting_range.startsWith("^")) {
            this.starting_range = this.starting_range.substring(1);
        }
        if (this.starting_range.endsWith("^")) {
            this.starting_range = this.starting_range.substring(0, this.starting_range.length() - 1);
        }
        if (this.starting_range.indexOf("\\") >= 0) {
            this.starting_range = this.starting_range.substring(0, this.starting_range.indexOf("\\"));
        }
        this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }
}

