/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.adviacentaurcp;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.adviacentaurcp.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.adviacentaurcp.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String INSTRUMENT_NAME = "CENTAUR";
    private List<String> request = new ArrayList<String>();
    protected boolean hostQuery = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        RecordParser record = new RecordParser(configuracao.isIndxQuantitativo());
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.request.add(starting_range);
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CentaurCP: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            String laboratory_pid = null;
            String t = ASTMStandard.getDefaultPatientRecord(1, patient_id.toString(), laboratory_pid, nome, sobrenome, pac_sexo);
            this.tx_list.add(t);
            if (!Funcoes.textoVazio(rackposition) && !rackposition.startsWith("\\^")) {
                rackposition = "^" + rackposition;
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = ASTMStandard.getDefaultOrderRecord(++seq, codigo.toString(), rackposition, alternativos, null, null, "R", "", tipo_amostra, "O");
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", "", tipo_amostra, "O");
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord(null);
            t = "L|1|F\r";
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 1);
            checksum = message.substring(message.length() - 3);
            termination = message.substring(message.length() - 4, message.length() - 3);
            message = message.substring(0, message.length() - 4);
            if (this.checkCRC(message, checksum)) {
                message = message.substring(1, message.length());
                if (this.middleFrame && this.rx_list.getUltimoInserido() > -1 && this.rx_list.size() > this.rx_list.getUltimoInserido()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.middleFrame = false;
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] lines;
                    String s = (String)this.rx_list.remove(0);
                    for (String l : lines = s.split(String.valueOf('\r'))) {
                        this.recordParser.recordFound(l);
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            if (tokens.length > 6) {
                components.put(this.TEST_REPLICATE_NUMBER, tokens[6]);
            }
            if (tokens.length > 7) {
                components.put(this.TEST_RESULT_ASPECTS, tokens[7]);
            }
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery || !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            if (this.request.isEmpty()) {
                return;
            }
            String sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CentaurCP: Host Query Response");
        }
    }

    @Override
    public void teste() {
        this.parse(TestesInterface.arruma("[STX]1H|\\^&|||CENTAUR|||||JALIS||P|1|20150921153908[CR][ETX]89[LINE]"));
        this.parse(TestesInterface.arruma("[STX]2Q|1|^010019430604^|^^|ALL^^^||||||||O[CR][ETX]AA[LINE]"));
        this.parse(TestesInterface.arruma("[STX]3Q|2|^010019428804^|^^|ALL^^^||||||||O[CR][ETX]B5[LINE]"));
        this.parse(TestesInterface.arruma("[STX]6L|1|N[CR][ETX]09[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.handShakeCharReceived('\u0006');
            }
            this.handShakeCharReceived('\u0004');
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                        if (InterfaceListener.this.hostQuery) {
                            InterfaceListener.this.handShakeCharReceived('\u0004');
                            return;
                        }
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                    }
                    if (!(message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd())).equals("")) {
                        String retorno = InterfaceListener.this.parse(message);
                        InterfaceListener.this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                        if (InterfaceListener.this.isRX()) {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

