/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.adviacentaur;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.adviacentaur.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.adviacentaur.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String INSTRUMENT_NAME = "CENTAUR";
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    boolean exr_codigoapoiado = false;
    protected boolean hostQueryVazio = false;
    public static final String ACAO_CANCELAR = "C";
    private String rec_tuboPai = "";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        RecordParser record = new RecordParser(configuracao.isIndxQuantitativo());
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            if ((starting_range = starting_range.substring(1)).length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Centaur: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Iterator temporario;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.tx_list = new MemoryList();
            }
            this.tx_list.clear();
            if (this.rx_list != null) {
                this.rx_list.clear();
            }
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.trim().split(" ", 0);
            this.ultima_acao = acao;
            ExameMaterial[] exa_lista = null;
            ExameMaterial[] alternativos = null;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            Integer[] multiguias = this.verificaAgrupaMultiguias(fil_codigo, req_codigo);
            Map<String, BDExame> exames_curva = null;
            for (Integer multiguia : multiguias) {
                if (this.exames == null) continue;
                exa_lista = InterfaceListener.getDesmExamesPai(fil_codigo, int_codigo, multiguia.toString(), this.exames[0], mco_codigo);
                if (exa_lista.length <= 0) {
                    exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                }
                exames_curva = this.obtemExamesCurva(fil_codigo, int_codigo, multiguia.toString(), mco_codigo, rec_codigo, codigo.toString(), exa_lista);
            }
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            this.rec_tuboPai = rec_codigo;
            String tipo_amostra = null;
            if (this.existeExames()) {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                temporario = new ArrayList();
                for (ExameMaterial e : alternativos) {
                    if (((ArrayList)((Object)temporario)).contains(e)) continue;
                    ((ArrayList)((Object)temporario)).add(e);
                }
                alternativos = new ExameMaterial[((ArrayList)((Object)temporario)).size()];
                for (int i = 0; i < ((ArrayList)((Object)temporario)).size(); ++i) {
                    alternativos[i] = (ExameMaterial)((ArrayList)((Object)temporario)).get(i);
                }
            } else {
                temporario = exames_curva.keySet().iterator();
                if (temporario.hasNext()) {
                    String key = (String)temporario.next();
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exames_curva.get(key).getExame(), exames_curva.get(key).getMaterial(), int_codigo);
                }
            }
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            String laboratory_pid = null;
            String t = ASTMStandard.getDefaultPatientRecord(1, patient_id.toString(), laboratory_pid, nome, sobrenome, pac_sexo);
            this.tx_list.add(t);
            if (!Funcoes.textoVazio(rackposition) && !rackposition.startsWith("\\^")) {
                rackposition = "^" + rackposition;
            }
            int processo = this.getSitucaoProcesso(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_lista, st);
            String situacaoProcesso = "";
            situacaoProcesso = this.isRepeticao(processo) ? "S" : "R";
            int seq = 1;
            if (this.validaListaExames(alternativos)) {
                t = ASTMStandard.getDefaultOrderRecord(seq++, codigo.toString(), rackposition, alternativos, null, null, situacaoProcesso, "", tipo_amostra, "O");
                this.tx_list.add(t);
            }
            if (!exames_curva.isEmpty()) {
                for (String key : exames_curva.keySet()) {
                    this.curva = true;
                    String emi_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exames_curva.get(key).getExame(), exames_curva.get(key).getMaterial(), int_codigo);
                    if (Funcoes.textoVazio(emi_alternativo)) continue;
                    t = ASTMStandard.getDefaultOrderRecord(seq++, key, emi_alternativo, exames_curva.get(key).getExame(), null, situacaoProcesso, "", "O");
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord(null);
            t = "L|1|F\r";
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            if (this.validaListaExames(exa_lista)) {
                for (ExameMaterial e : exa_lista) {
                    int situacao;
                    if (this.validaExameCurva(exames_curva)) {
                        for (String key : exames_curva.keySet()) {
                            int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai, exames_curva.get(key).getExame(), exames_curva.get(key).getMaterial());
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exames_curva.get(key).getExame(), exames_curva.get(key).getMaterial(), this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, this.rec_tuboPai, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!exames_curva.isEmpty()) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Exame(s) " + (acao.equals(ACAO_CANCELAR) ? "excluido(s)" : "enviado(s)") + " com sucesso para " + pac_nome, 0, 10000);
            }
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private boolean isRepeticao(int processo) {
        return processo == 3;
    }

    private int getSitucaoProcesso(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, ExameMaterial[] exa_lista, Statement st) throws SQLException {
        int situacaoRotina = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), rec_codigo);
        int processo = situacaoRotina < 2 ? 1 : 3;
        return processo;
    }

    private Integer[] verificaAgrupaMultiguias(String fil_codigo, String req_codigo) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(fil_codigo, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String fil_codigo, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), fil_codigo, multiguias);
    }

    private boolean validaExameCurva(Map<String, BDExame> exames_curva) {
        return !Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !exames_curva.isEmpty();
    }

    private boolean validaListaExames(ExameMaterial[] exa_lista) {
        return exa_lista != null;
    }

    private boolean existeExames() {
        return this.exames != null && this.exames.length > 0;
    }

    public static synchronized ExameMaterial[] getDesmExamesPai(String fil_codigo, String int_codigo, String req_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_codigo = ").append(mco_kodigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return pais;
    }

    private Map<String, BDExame> obtemExamesCurva(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String codigo, ExameMaterial[] exa_lista) throws SQLException {
        HashMap<String, BDExame> exames_curva = new HashMap<String, BDExame>();
        StringBuilder curva = new StringBuilder();
        for (ExameMaterial exa : exa_lista) {
            BDExame[] filhos;
            if (!BDUtil.isExameCurva(fil_codigo, int_codigo, exa.getNomeExame(), mco_codigo)) continue;
            curva.append(exa).append(" ");
            for (BDExame bdExame : filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa.getNomeExame(), mco_codigo, rec_codigo)) {
                String tubo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, bdExame.getRecipiente(), int_codigo, bdExame.getExame(), mco_codigo);
                if (!this.validaTubo(tubo)) continue;
                String etiqueta = String.format("%s%s", codigo, StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
                exames_curva.put(etiqueta, new BDExame(req_codigo, bdExame.getExame(), mco_codigo, tubo, null));
            }
        }
        if (!Funcoes.textoVazio(curva.toString()) && !exames_curva.isEmpty()) {
            for (String ex : curva.toString().split(" ")) {
                int p = ArraysUtil.indice((Object[])this.exames, ex);
                this.exames = ArraysUtil.remover(this.exames, p);
            }
        }
        return exames_curva;
    }

    private boolean validaTubo(String tubo) {
        return tubo != null;
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 1);
            checksum = message.substring(message.length() - 3);
            termination = message.substring(message.length() - 4, message.length() - 3);
            message = message.substring(0, message.length() - 4);
            if (this.checkCRC(message, checksum)) {
                message = message.substring(1, message.length());
                if (this.middleFrame && this.rx_list.getUltimoInserido() > -1 && this.rx_list.size() > this.rx_list.getUltimoInserido()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.middleFrame = false;
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] lines;
                    String s = (String)this.rx_list.remove(0);
                    for (String l : lines = s.split(String.valueOf('\r'))) {
                        this.recordParser.recordFound(l);
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            if (tokens.length > 6) {
                components.put(this.TEST_REPLICATE_NUMBER, tokens[6]);
            }
            if (tokens.length > 7) {
                components.put(this.TEST_RESULT_ASPECTS, tokens[7]);
            }
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    @Override
    public void teste() {
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0004');
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = "";
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                if (this.exr_codigoapoiado) {
                    if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                        if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (ParametrosGerais.isAgruparGuiasInterface()) {
                                requisicao = (String)req[aba.getColIndice("Multiguia")];
                            }
                            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                            String tubo = (String)req[aba.getColIndice("Tubo")];
                            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                            fil_codigo = filial;
                            req_codigo = requisicao;
                            rec_codigo = tubo;
                        }
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            } else {
                this.hostQueryVazio = true;
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
                return;
            }
            mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Centaur: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, req_codigo, null, nome, null, this.pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!this.hostQueryVazio) {
            super.encerrarTransmissao();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.setIdle();
            this.fireAtualizarTabela();
        }
        this.hostQueryVazio = false;
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                        if (InterfaceListener.this.hostQuery) {
                            InterfaceListener.this.handShakeCharReceived('\u0004');
                            return;
                        }
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                    }
                    if (!(message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd())).equals("")) {
                        String retorno = InterfaceListener.this.parse(message);
                        InterfaceListener.this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                        if (InterfaceListener.this.isRX()) {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

