/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.adviacentaur;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        requisicaoExames = (ArrayList)requisicaoExames.clone();
        String codigoApoiado = null;
        if (requisicaoExames.size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            codigoApoiado = (String)exame[this.getColIndice("Cod. Apoiado")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String exames = " ";
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("Multiguia")];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqPronto = (String)linhaProntos[this.getColIndice("Multiguia")];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames = exames + exame[1] + " ";
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames = exames + exaPronto + " ";
                linhas.add(j);
            }
        }
        if (this.existeExame(exames)) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String pac_nome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                if (Funcoes.textoVazio(codigoApoiado)) {
                    codigoApoiado = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Cod. Apoiado"));
                }
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Multiguia"));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("codigoApoiado", codigoApoiado);
                String resposta = "";
                resposta = Funcoes.textoVazio(codigoApoiado) ? this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames.trim(), "A") : this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames.trim(), "A", maps);
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private boolean existeExame(String exames) {
        return exames.trim().length() > 0;
    }

    private void setaPortaEquipamento(int row) {
        String xmlValores = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Valores"));
        Map<String, Object> xmlVlrMap = StringUtil.getMapDeXML(xmlValores);
        JComboBox equipamentos = this.getComboEquipamentos();
        if (xmlVlrMap.containsKey("enderecoPorta") && !Funcoes.textoVazio(xmlVlrMap.get("enderecoPorta").toString()) && equipamentos != null) {
            this.setPortaEnvio(xmlVlrMap.get("enderecoPorta").toString(), equipamentos);
        } else if (xmlValores.contains("enderecoPorta")) {
            for (String key : xmlVlrMap.keySet()) {
                if (!key.startsWith("enderecoPorta")) continue;
                this.setPortaEnvio(xmlVlrMap.get(key).toString(), equipamentos);
                break;
            }
        }
    }

    private void setPortaEnvio(String enderecoPorta, JComboBox equipamentos) {
        int pos = -1;
        for (int i = 0; i < equipamentos.getItemCount(); ++i) {
            if (!((ConfiguracaoSerial)equipamentos.getItemAt(i)).getPorta().equalsIgnoreCase(enderecoPorta)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            equipamentos.setSelectedIndex(pos);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setBotaoResultadoDisponivel(boolean state) {
        this.jButtonResultado.setVisible(state);
    }

    @Override
    public void setExames(ArrayList exames) {
        this.exames = exames;
    }
}

