/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens;

import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.IdClassification;
import jalis.util.Funcoes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MensagemMeasurementData {
    private String sampleId;
    private IdClassification idClassification;
    private Date inspectionDate;
    private String comment1;
    private String comment2;
    private Map<Integer, TestResult> testsResultsByTestNumber;
    private int numberTests;

    public MensagemMeasurementData(BaseRecebimento baseRecebimento) {
        String data = baseRecebimento.getData();
        this.testsResultsByTestNumber = new HashMap<Integer, TestResult>();
        this.numberTests = Integer.parseInt(data.substring(5, 8));
        this.inspectionDate = Funcoes.stringToDate("yyyyMMdd", data.substring(8, 16));
        this.idClassification = IdClassification.getValueById(data.substring(17, 18));
        this.sampleId = data.substring(18, 31).trim();
        this.comment1 = data.substring(38, 54).trim();
        this.comment2 = data.substring(54, 70).trim();
        for (int i = 0; i < this.numberTests; ++i) {
            boolean overflow;
            int iString = 88 + 15 * i;
            int testNumber = Integer.parseInt(data.substring(iString, iString + 3).trim());
            String resultString = data.substring(iString + 4, iString + 12).trim();
            String mark = data.substring(iString + 12, iString + 15);
            Float result = null;
            if (resultString.contains("////////")) {
                overflow = true;
            } else {
                overflow = false;
                result = resultString.trim().isEmpty() ? null : Float.valueOf(Float.parseFloat(resultString));
            }
            this.testsResultsByTestNumber.put(testNumber, new TestResult(result, mark, overflow));
        }
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public IdClassification getIdClassification() {
        return this.idClassification;
    }

    public Date getInspectionDate() {
        return this.inspectionDate;
    }

    public String getComment1() {
        return this.comment1;
    }

    public String getComment2() {
        return this.comment2;
    }

    public Map<Integer, TestResult> getTestsResultsByTestNumber() {
        return this.testsResultsByTestNumber;
    }

    public class TestResult {
        private Float result;
        private String mark;
        private boolean overflow;

        public TestResult(Float result, String mark, boolean overflow) {
            this.result = result;
            this.mark = mark;
            this.overflow = overflow;
        }

        public Float getResult() {
            return this.result;
        }

        public String getMark() {
            return this.mark;
        }

        public boolean isOverflow() {
            return this.overflow;
        }
    }
}

