/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens;

import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.Tipos;
import jalis.laboratorio.interfaceamento.util.Checksum;

public class BaseRecebimento {
    private Tipos tipo;
    private int frameNumber;
    private String data;
    private boolean finalFrame = false;
    private boolean checksumValido = false;

    public BaseRecebimento(String mensagem) {
        this.frameNumber = Integer.parseInt(mensagem.substring(1, 2));
        this.tipo = Tipos.getTipoById(mensagem.substring(2, 3));
        this.data = mensagem.substring(3, mensagem.length() - 5);
        String checksum = mensagem.substring(mensagem.length() - 4, mensagem.length() - 2);
        String checksumAlvo = Checksum.getChecksumMod256(mensagem.substring(1, mensagem.length() - 4));
        if (checksum.equals(checksumAlvo)) {
            this.checksumValido = true;
        }
        if (mensagem.charAt(mensagem.length() - 5) == '\u0003') {
            this.finalFrame = true;
        }
    }

    public boolean isChecksumValido() {
        return true;
    }

    public boolean isFinalFrame() {
        return this.finalFrame;
    }

    public Tipos getTipo() {
        return this.tipo;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public String getData() {
        return this.data;
    }
}

