/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.Tipos;
import jalis.util.StringUtil;

public class BaseEnvio {
    private Tipos tipo;
    private StringBuilder data;

    public BaseEnvio(Tipos tipo) {
        this.tipo = tipo;
        this.data = new StringBuilder();
    }

    public void addDataItem(int tamanho, String valor, Orientacoes orientacao) {
        int ori;
        int n = ori = orientacao.equals((Object)Orientacoes.DIREITA) ? 0 : 1;
        if (valor == null) {
            valor = "";
        }
        if (valor.length() > tamanho) {
            valor = valor.substring(0, tamanho);
        }
        this.data.append(StringUtil.preencheString(valor, tamanho, ' ', ori));
    }

    public void addDataItem(int tamanho, String valor) {
        this.addDataItem(tamanho, valor, Orientacoes.DIREITA);
    }

    public void addDataItemFlexible(String valor) {
        this.data.append(valor);
    }

    public void addDataEspaco(int tamanho) {
        this.addDataItem(tamanho, "", Orientacoes.DIREITA);
    }

    public void limpa() {
        this.data.delete(0, this.data.length());
    }

    public String getTextoMensagem(int frameNumber, boolean finalFrame) {
        StringBuilder mensagem = new StringBuilder();
        StringBuilder pacote = new StringBuilder();
        pacote.append(frameNumber);
        pacote.append(this.tipo.getId());
        pacote.append((CharSequence)this.data);
        pacote.append(finalFrame ? (char)'\u0003' : '\u0017');
        mensagem.append('\u0002');
        mensagem.append((CharSequence)pacote);
        mensagem.append("  ");
        mensagem.append(AbstractInterfaceamento.LINE);
        return mensagem.toString();
    }

    public static enum Orientacoes {
        ESQUERDA,
        DIREITA;

    }
}

