/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.MarkSpecifications;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.IdClassification;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.MensagemMeasurementData;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.MensagemTestRequest;
import jalis.laboratorio.interfaceamento.interfaces.advia1800.mensagens.MensagemTestSelection;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int MAX_TENTATIVAS_ENVIO = 3;
    private static final int TAMANHO_SAMPLE_ID = 13;
    private Queue<IMensagemEnvio> mensagensParaEnviar = new LinkedList<IMensagemEnvio>();
    private Map<String, InfoExameRequisicao> exameRequisicaoPorSampleId = new HashMap<String, InfoExameRequisicao>();
    private IMensagemEnvio ultimaMensagemEnviada;
    private int tentativasEnvio;
    private int frameNumber = 0;
    private boolean finalFrame;
    private boolean aguardandoConfirmacaoEnq;
    private Timer timerEnq;
    private ThreadRecebimentoMeasurementData threadRecebimentoMeasurementData;
    private final TravaFechamento travaProcessandoResultados = new TravaFechamento("Os resultados est\u00e3o sendo processados");

    public InterfaceListener() {
        this.timerEnq = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InterfaceListener.this.mensagensParaEnviar.isEmpty()) {
                    InterfaceListener.this.timerEnq.stop();
                    InterfaceListener.this.aguardandoConfirmacaoEnq = true;
                    InterfaceListener.this.enviaHandShake('\u0005');
                }
            }
        });
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return null;
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        switch (c) {
            case '\u0005': {
                this.tratarEnquiry();
                break;
            }
            case '\u0006': {
                this.tratarAcknowledge();
                break;
            }
            case '\u0015': {
                this.tratarNegativeAck();
                break;
            }
            case '\u0004': {
                this.tratarEndOfTX();
                break;
            }
            case '\u0011': {
                this.trataRequestSkip();
                break;
            }
            default: {
                this.handShakeNaoEsperado(c);
            }
        }
    }

    protected void handShakeNaoEsperado(char c) {
        this.setIdle();
        this.fireExcecaoEncontrada("Caracter 0x" + Integer.valueOf(c) + " n\u00e3o esperado quando " + this.getFluxoString());
    }

    protected void tratarEnquiry() {
        if (this.isTX()) {
            this.handShakeNaoEsperado('\u0005');
        }
        this.zeraEnvio();
        this.timerEnq.stop();
        this.setRX();
        this.enviaHandShake('\u0006');
    }

    protected void tratarAcknowledge() {
        if (this.aguardandoConfirmacaoEnq) {
            this.aguardandoConfirmacaoEnq = false;
            this.setTX();
        }
        if (this.isTX()) {
            MensagemTestSelection testSelection;
            if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada instanceof MensagemTestSelection && this.exameRequisicaoPorSampleId.containsKey((testSelection = (MensagemTestSelection)this.ultimaMensagemEnviada).getSampleId())) {
                this.alteraSituacaoParaPendente(this.exameRequisicaoPorSampleId.remove(testSelection.getSampleId()));
                this.ultimaMensagemEnviada = null;
            }
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0006');
        }
    }

    protected void tratarNegativeAck() {
        if (this.isTX()) {
            if (this.tentativasEnvio <= 3) {
                this.enviaMensagem(this.ultimaMensagemEnviada);
            } else {
                this.encerraTransmissao();
            }
        } else {
            this.handShakeNaoEsperado('\u0015');
        }
    }

    protected void tratarEndOfTX() {
        if (this.isRX()) {
            this.setIdle();
            this.enviaEnq();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    protected void trataRequestSkip() {
        if (this.isTX()) {
            this.ultimaMensagemEnviada = null;
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    private void enviaHandShake(char c) {
        try {
            this.getPortaCOM().write(String.valueOf(c));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar Handshake 0x" + Integer.valueOf(c));
            ex.printStackTrace();
        }
    }

    private void enviaEnq() {
        if (!this.timerEnq.isRunning()) {
            this.timerEnq.start();
        }
    }

    private void enviaProximaMensagem() {
        if (this.mensagensParaEnviar.isEmpty()) {
            this.encerraTransmissao();
        } else {
            this.nextFrame();
            this.finalFrame = this.mensagensParaEnviar.size() == 1;
            this.enviaMensagem(this.mensagensParaEnviar.remove());
        }
    }

    private void enviaMensagem(IMensagemEnvio mensagem) {
        try {
            this.ultimaMensagemEnviada = mensagem;
            this.getPortaCOM().write(mensagem.getTextoMensagem(this.frameNumber, this.finalFrame));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar mensagem " + mensagem);
            ex.printStackTrace();
        }
    }

    private void encerraTransmissao() {
        this.zeraEnvio();
        this.setIdle();
        this.enviaHandShake('\u0004');
    }

    private void zeraEnvio() {
        this.mensagensParaEnviar.clear();
        this.ultimaMensagemEnviada = null;
        this.tentativasEnvio = 0;
        this.frameNumber = 0;
    }

    private int nextFrame() {
        ++this.frameNumber;
        if (this.frameNumber > 7) {
            this.frameNumber = 1;
        }
        return this.frameNumber;
    }

    @Override
    public String parse(String mensagem) {
        BaseRecebimento baseRecebimento;
        try {
            baseRecebimento = new BaseRecebimento(mensagem);
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro no parse da mensagem");
            this.enviaHandShake('\u0015');
            return null;
        }
        if (baseRecebimento.isChecksumValido()) {
            switch (baseRecebimento.getTipo()) {
                case TEST_REQUEST: {
                    this.recebidoTestRequest(new MensagemTestRequest(baseRecebimento));
                    this.enviaHandShake('\u0006');
                    break;
                }
                case MEASUREMENT_DATA: {
                    this.recebidoMeasurementData(new MensagemMeasurementData(baseRecebimento));
                    this.enviaHandShake('\u0006');
                    break;
                }
                default: {
                    this.fireExcecaoEncontrada("Mensagem de tipo desconhecido rebebida");
                    this.enviaHandShake('\u0015');
                    break;
                }
            }
        } else {
            this.fireExcecaoEncontrada("O checksum da mensagem " + (Object)((Object)baseRecebimento.getTipo()) + " recebida \u00e9 inv\u00e1lido");
            this.enviaHandShake('\u0015');
        }
        return null;
    }

    private void recebidoTestRequest(MensagemTestRequest testRequest) {
        block20: {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            try {
                if (digitosCodigoTubo > 13) {
                    throw new Exception("O equipamento n\u00e3o suporta a identifica\u00e7\u00e3o do tubo com mais de 13 d\u00edgitos");
                }
                if (testRequest.getIdClassification() == IdClassification.BARCODE_OR_SEQUENTIAL) {
                    for (String sampleId : testRequest.getSampleIds()) {
                        if (!Funcoes.isNumeric(sampleId) || sampleId.length() != digitosCodigoTubo) continue;
                        String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                        String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                        PanelAbaAbstrata aba = this.equipamento.getTab(0);
                        if (req == null) {
                            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                            aba = this.equipamento.getTab(1);
                        }
                        if (req == null) {
                            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                            aba = this.equipamento.getTab(2);
                        }
                        if (req != null) {
                            String exames = (String)req[aba.getColIndice("Exame")];
                            String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                            String intCodigo = (String)req[aba.getColIndice("Interface")];
                            String pacNome = (String)req[aba.getColIndice("Paciente")];
                            String pacIdade = (String)req[aba.getColIndice("Ide")];
                            String pacSexo = (String)req[aba.getColIndice("S")];
                            String data = TempoUtil.getCurrentDateBr();
                            String hora = TempoUtil.getCurrentTime();
                            ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
                            for (String string : exames.split(" ", 0)) {
                                examesMateriais.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                            }
                            HashSet<Integer> testNumbers = new HashSet<Integer>();
                            ExameMaterial primeiroExame = null;
                            for (ExameMaterial exameMaterial : examesMateriais) {
                                if (primeiroExame == null) {
                                    primeiroExame = exameMaterial;
                                }
                                ExameMaterial[] exameMaterialFilhos = BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo) ? BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo) : new ExameMaterial[]{exameMaterial};
                                for (ExameMaterial exameFilho : exameMaterialFilhos) {
                                    int testNumber = 0;
                                    try {
                                        testNumber = Integer.parseInt(BDUtil.getExmCodigoAlternativo(filCodigo, exameFilho.getNomeExame(), mcoCodigo, intCodigo));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (testNumber > 0) {
                                        testNumbers.add(testNumber);
                                        continue;
                                    }
                                    this.fireExcecaoEncontrada(reqCodigo + " - Exame " + exameFilho.getNomeExame() + " requisitado, mas seu c\u00f3digo alternativo est\u00e1 incorreto ou n\u00e3o configurado");
                                }
                            }
                            if (testNumbers.isEmpty()) {
                                this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                                continue;
                            }
                            this.exameRequisicaoPorSampleId.put(sampleId, new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames));
                            Integer anos = null;
                            String[] stringArray = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
                            if (stringArray[0] != null && !stringArray[0].trim().isEmpty()) {
                                anos = stringArray[1].equalsIgnoreCase("A") ? Integer.valueOf(Integer.parseInt(stringArray[0])) : Integer.valueOf(0);
                            }
                            MensagemTestSelection testSelection = new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.TEST_ADDITION);
                            testSelection.setComment1(pacNome);
                            if (anos != null) {
                                testSelection.setAge(anos);
                            }
                            testSelection.setSex(pacSexo.equalsIgnoreCase("M") ? MensagemTestSelection.Sex.MALE : MensagemTestSelection.Sex.FEMALE);
                            testSelection.setBloodSamplingDate(BDUtil.getExmColeta(filCodigo, reqCodigo, primeiroExame.getNomeExame(), primeiroExame.getCodigoMaterial()));
                            Iterator iterator = testNumbers.iterator();
                            while (iterator.hasNext()) {
                                int testNumber = (Integer)iterator.next();
                                testSelection.addTest(testNumber, MensagemTestSelection.TestCondition.M_ANALYTICAL);
                            }
                            this.mensagensParaEnviar.add(testSelection);
                            continue;
                        }
                        this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                    }
                    break block20;
                }
                for (String sampleId : testRequest.getSampleIds()) {
                    this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
                ex.printStackTrace();
            }
        }
    }

    private void recebidoMeasurementData(MensagemMeasurementData measurementData) {
        if (this.threadRecebimentoMeasurementData != null && this.threadRecebimentoMeasurementData.isAlive()) {
            this.threadRecebimentoMeasurementData.add(measurementData);
        } else {
            this.threadRecebimentoMeasurementData = new ThreadRecebimentoMeasurementData();
            this.threadRecebimentoMeasurementData.add(measurementData);
            this.threadRecebimentoMeasurementData.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvaMeasurementData(MensagemMeasurementData measurementData) {
        Statement st;
        block16: {
            st = Conexao.getStatement();
            try {
                String sampleId = measurementData.getSampleId();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (sampleId.trim().isEmpty() || !Funcoes.isNumeric(sampleId) || sampleId.trim().length() != digitosCodigoTubo) break block16;
                String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                for (Map.Entry<Integer, MensagemMeasurementData.TestResult> entryResult : measurementData.getTestsResultsByTestNumber().entrySet()) {
                    String emiAlternativo = String.valueOf(entryResult.getKey());
                    emiAlternativo = StringUtil.preencheString(emiAlternativo, 3, '0', 1);
                    MensagemMeasurementData.TestResult result = entryResult.getValue();
                    String int_codigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, int_codigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo alternativo " + emiAlternativo + " n\u00e3o encontrado na requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                        continue;
                    }
                    int sit = BDUtil.getExmSituacao(filCodigo, int_codigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    if (sit != 1 && sit != 3 && sit != 4 && sit != -1) continue;
                    ArrayList<String> excecoes = new ArrayList<String>();
                    if (result.getMark().charAt(0) != ' ') {
                        excecoes.add(MarkSpecifications.getDescricaoFirstByte(result.getMark().charAt(0)));
                    }
                    if (result.getMark().charAt(1) != ' ') {
                        excecoes.add(MarkSpecifications.getDescricaoSecondByteElectrolyte(result.getMark().charAt(1)));
                    }
                    if (result.getMark().charAt(2) != ' ') {
                        excecoes.add(MarkSpecifications.getDescricaoThirdByte(result.getMark().charAt(2)));
                    }
                    if (result.isOverflow()) {
                        excecoes.add("Result overflow");
                        BDUtil.setExmSituacao(st, filCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), 6, int_codigo, recCodigo);
                    } else if (result.getResult() == null) {
                        excecoes.add("Sem resultado");
                    } else {
                        String campo = sit == 3 || sit == 4 ? "repeticao_quantitativo" : "resultado_quantitativo";
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        String resultString = result.getResult() != null ? String.valueOf(result.getResult()).replace('.', ',') : "";
                        dados.put(campo, resultString);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                    }
                    for (String descricaoExcecao : excecoes) {
                        this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o " + filCodigo + reqCodigo + recCodigo + " exame " + emiAlternativo + ": " + descricaoExcecao);
                    }
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().getInputString();
        if (!message.trim().isEmpty() && message.contains(this.getMsgEnd())) {
            this.parse(this.getPortaCOM().removeInputString(this.getMsgEnd()));
        }
    }

    private String getFluxoString() {
        switch (this.getFluxo().getEstado()) {
            case 2: {
                return "Rx";
            }
            case 1: {
                return "Tx";
            }
            case 0: {
                return "Idle";
            }
        }
        return "";
    }

    private void alteraSituacaoParaPendente(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = exameRequisicao.getFilial();
                String req_codigo = exameRequisicao.getCodigo();
                String mco_codigo = exameRequisicao.getMaterial();
                int atual = BDUtil.getExmSituacao(fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = exameRequisicao.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private class ThreadRecebimentoMeasurementData
    extends Thread {
        private Queue<MensagemMeasurementData> measurementDatas = new LinkedList<MensagemMeasurementData>();

        public void add(MensagemMeasurementData measurementData) {
            this.measurementDatas.add(measurementData);
        }

        @Override
        public void run() {
            InterfaceListener.this.addTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
            while (!this.measurementDatas.isEmpty()) {
                InterfaceListener.this.salvaMeasurementData(this.measurementDatas.remove());
                try {
                    ThreadRecebimentoMeasurementData.sleep(500L);
                }
                catch (Exception exception) {}
            }
            InterfaceListener.this.removeTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
        }
    }
}

