/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] objectArray = (Object[])desmembrado.get(k);
                        String situacao = (String)objectArray[objectArray.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames.add((String)objectArray[1]);
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames.add(exaPronto);
                linhas.add(j);
            }
        }
        if (exames.size() > 0) {
            try {
                String aux = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    aux = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Multiguia"));
                }
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String pac_nome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                String req_codigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
                Statement st = Conexao.getStatement();
                for (String string : exames) {
                    if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, string, mco_codigo)) {
                        ExameMaterial[] exaPais;
                        for (ExameMaterial ePai : exaPais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, string, mco_codigo)) {
                            BDUtil.setDesmSituacao(st, fil_codigo, int_codigo, req_codigo, ePai.getNomeExame(), mco_codigo, rec_codigo, string, mco_codigo, 5);
                            BDUtil.setExmSituacao(st, fil_codigo, req_codigo, ePai.getNomeExame(), mco_codigo, 5, int_codigo, rec_codigo);
                        }
                    }
                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, string, mco_codigo, 5, int_codigo, rec_codigo);
                }
                Conexao.arquivaSQL();
                for (Integer n : linhas) {
                    this.reloadLinha(n);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

