/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia120serial.mensagens;

import jalis.laboratorio.interfaceamento.interfaces.advia120serial.mensagens.Tipos;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.StringUtil;

public class BaseEnvio {
    private Tipos tipo;
    private StringBuilder data;

    public BaseEnvio(Tipos tipo) {
        this.tipo = tipo;
        this.data = new StringBuilder();
    }

    public void addDataItem(int tamanho, String valor, Orientacoes orientacao) {
        int ori;
        int n = ori = orientacao.equals((Object)Orientacoes.DIREITA) ? 0 : 1;
        if (valor == null) {
            valor = "";
        }
        if (valor.length() > tamanho) {
            valor = valor.substring(0, tamanho);
        }
        this.data.append(StringUtil.preencheString(valor, tamanho, ' ', ori));
    }

    public void addDataItem(int tamanho, String valor) {
        this.addDataItem(tamanho, valor, Orientacoes.DIREITA);
    }

    public void addDataItemFlexible(String valor) {
        this.data.append(valor);
    }

    public void addDataEspaco(int tamanho) {
        this.addDataItem(tamanho, "", Orientacoes.DIREITA);
    }

    public synchronized String getTextoMensagem(char mt) {
        StringBuilder mensagem = new StringBuilder();
        StringBuilder pacote = new StringBuilder();
        pacote.append(mt);
        pacote.append(this.tipo.getId());
        pacote.append((CharSequence)this.data);
        mensagem.append('\u0002');
        mensagem.append((CharSequence)pacote);
        mensagem.append(Checksum.getLRC(pacote.toString()));
        mensagem.append('\u0003');
        return mensagem.toString();
    }

    public static enum Orientacoes {
        ESQUERDA,
        DIREITA;

    }
}

