/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens;

import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.InterfaceListener;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.IdClassification;
import jalis.util.Funcoes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MensagemMeasurementData {
    private String sampleId;
    private IdClassification idClassification;
    private Date inspectionDate;
    private String comment1;
    private String comment2;
    private Map<Integer, TestResult> testsResultsByTestNumber;
    private int numberTests;

    public MensagemMeasurementData(BaseRecebimento baseRecebimento, InterfaceConfiguracao configuracao, InterfaceListener interfaceListener) {
        String data = baseRecebimento.getData();
        this.testsResultsByTestNumber = new HashMap<Integer, TestResult>();
        this.numberTests = Integer.parseInt(data.substring(5, 8));
        this.inspectionDate = Funcoes.stringToDate("yyyyMMdd", data.substring(8, 16));
        this.idClassification = configuracao.isNovaClassificacao() ? IdClassification.getValueById(data.substring(16, 17)) : IdClassification.getValueById(data.substring(17, 18));
        String sampleClassification = data.substring(22, 23);
        if (!Funcoes.isNumeric(sampleClassification) && configuracao.getNovoFormato()) {
            interfaceListener.fireExcecaoEncontrada("Mensagem com tamanho menor que o padr\u00e3o verifique as configura\u00e7\u00f5es do Jalis e tente habilitar a op\u00e7\u00e3o do novo formato!");
            return;
        }
        if (!configuracao.getNovoFormato() && !Funcoes.isNumeric(sampleClassification = data.substring(16, 17))) {
            interfaceListener.fireExcecaoEncontrada("Mensagem com tamanho menor que o padr\u00e3o verifique as configura\u00e7\u00f5es do Jalis e tente habilitar a op\u00e7\u00e3o do novo formato!");
            return;
        }
        int iSampleId = 24;
        int iComment1 = 38;
        int iComment2 = 54;
        int iTests = 94;
        int ip = 19;
        if (configuracao.getNovoFormato()) {
            iSampleId = 18;
            iComment1 = 32;
            iComment2 = 48;
            iTests = 88;
            ip = 15;
        }
        this.sampleId = data.substring(iSampleId, iSampleId + 13).trim();
        this.comment1 = data.substring(iComment1, iComment1 + 16).trim();
        this.comment2 = data.substring(iComment2, iComment1 + 16).trim();
        for (int i = 0; i < this.numberTests; ++i) {
            boolean overflow;
            int iString = iTests + ip * i;
            String test = data.substring(iString, iString + 3).trim();
            if (Funcoes.textoVazio(test)) {
                interfaceListener.fireExcecaoEncontrada("Bloco da mensagem de resultado sem o alternativo do exame " + data);
                continue;
            }
            int testNumber = Integer.parseInt(test);
            String resultString = data.substring(iString + 4, iString + 12).trim();
            String mark = data.substring(iString + 12, iString + 15);
            Float result = null;
            if (resultString.contains("////////")) {
                overflow = true;
            } else {
                overflow = false;
                result = resultString.trim().isEmpty() ? null : Float.valueOf(Float.parseFloat(resultString));
            }
            this.testsResultsByTestNumber.put(testNumber, new TestResult(result, mark, overflow));
        }
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public IdClassification getIdClassification() {
        return this.idClassification;
    }

    public Date getInspectionDate() {
        return this.inspectionDate;
    }

    public String getComment1() {
        return this.comment1;
    }

    public String getComment2() {
        return this.comment2;
    }

    public Map<Integer, TestResult> getTestsResultsByTestNumber() {
        return this.testsResultsByTestNumber;
    }

    public class TestResult {
        private Float result;
        private String mark;
        private boolean overflow;

        public TestResult(Float result, String mark, boolean overflow) {
            this.result = result;
            this.mark = mark;
            this.overflow = overflow;
        }

        public Float getResult() {
            return this.result;
        }

        public String getMark() {
            return this.mark;
        }

        public boolean isOverflow() {
            return this.overflow;
        }
    }
}

