/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1200v2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.MarkSpecifications;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.IdClassification;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.MensagemMeasurementData;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.MensagemTestRequest;
import jalis.laboratorio.interfaceamento.interfaces.advia1200v2.mensagens.MensagemTestSelection;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int MAX_TENTATIVAS_ENVIO = 3;
    private static final int TAMANHO_SAMPLE_ID = 13;
    private Queue<IMensagemEnvio> mensagensParaEnviar;
    private Map<String, InfoExameRequisicao> exameRequisicaoPorSampleId;
    private IMensagemEnvio ultimaMensagemEnviada;
    private int tentativasEnvio;
    private int frameNumber = 0;
    private boolean finalFrame;
    private boolean aguardandoConfirmacaoEnq;
    private Timer timerEnq;
    private ThreadRecebimentoMeasurementData threadRecebimentoMeasurementData;
    private final TravaFechamento travaProcessandoResultados;
    private InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.mensagensParaEnviar = new LinkedList<IMensagemEnvio>();
        this.exameRequisicaoPorSampleId = new HashMap<String, InfoExameRequisicao>();
        this.travaProcessandoResultados = new TravaFechamento("Os resultados est\u00e3o sendo processados");
        this.timerEnq = new Timer(2000, action -> {
            if (!this.mensagensParaEnviar.isEmpty()) {
                this.timerEnq.stop();
                this.aguardandoConfirmacaoEnq = true;
                this.enviaHandShake('\u0005');
            }
        });
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return null;
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        switch (c) {
            case '\u0005': {
                this.tratarEnquiry();
                break;
            }
            case '\u0006': {
                this.tratarAcknowledge();
                break;
            }
            case '\u0015': {
                this.tratarNegativeAck();
                break;
            }
            case '\u0004': {
                this.tratarEndOfTX();
                break;
            }
            case '\u0011': {
                this.trataRequestSkip();
                break;
            }
            default: {
                this.handShakeNaoEsperado(c);
            }
        }
    }

    protected void handShakeNaoEsperado(char c) {
        this.setIdle();
        this.fireExcecaoEncontrada("Caracter 0x" + Integer.valueOf(c) + " n\u00e3o esperado quando " + this.getFluxoString());
    }

    protected void tratarEnquiry() {
        if (this.isTX()) {
            this.handShakeNaoEsperado('\u0005');
        }
        this.zeraEnvio();
        this.timerEnq.stop();
        this.setRX();
        this.enviaHandShake('\u0006');
    }

    protected void tratarAcknowledge() {
        if (this.aguardandoConfirmacaoEnq) {
            this.aguardandoConfirmacaoEnq = false;
            this.setTX();
        }
        if (this.isTX()) {
            MensagemTestSelection testSelection;
            if (this.ultimaMensagemEnviada instanceof MensagemTestSelection && this.exameRequisicaoPorSampleId.containsKey((testSelection = (MensagemTestSelection)this.ultimaMensagemEnviada).getSampleId())) {
                this.alteraSituacaoParaPendente(this.exameRequisicaoPorSampleId.remove(testSelection.getSampleId()));
                this.ultimaMensagemEnviada = null;
            }
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0006');
        }
    }

    protected void tratarNegativeAck() {
        if (this.isTX()) {
            if (this.tentativasEnvio <= 3) {
                this.enviaMensagem(this.ultimaMensagemEnviada);
            } else {
                this.encerraTransmissao();
            }
        } else {
            this.handShakeNaoEsperado('\u0015');
        }
    }

    protected void tratarEndOfTX() {
        if (this.isRX()) {
            this.setIdle();
            this.enviaEnq();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    protected void trataRequestSkip() {
        if (this.isTX()) {
            this.ultimaMensagemEnviada = null;
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    private void enviaHandShake(char c) {
        try {
            this.getPortaCOM().write(String.valueOf(c));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar Handshake 0x" + Integer.valueOf(c));
            ex.printStackTrace();
        }
    }

    private void enviaEnq() {
        if (!this.timerEnq.isRunning()) {
            this.timerEnq.start();
        }
    }

    private void enviaProximaMensagem() {
        if (this.mensagensParaEnviar.isEmpty()) {
            this.encerraTransmissao();
        } else {
            this.finalFrame = true;
            this.nextFrame();
            this.enviaMensagem(this.mensagensParaEnviar.remove());
        }
    }

    private void enviaMensagem(IMensagemEnvio mensagem) {
        try {
            this.ultimaMensagemEnviada = mensagem;
            this.getPortaCOM().write(mensagem.getTextoMensagem(this.frameNumber, this.finalFrame));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar mensagem " + mensagem);
            ex.printStackTrace();
        }
    }

    private void encerraTransmissao() {
        this.zeraEnvio();
        this.setIdle();
        this.enviaHandShake('\u0004');
    }

    private void zeraEnvio() {
        this.mensagensParaEnviar.clear();
        this.ultimaMensagemEnviada = null;
        this.tentativasEnvio = 0;
        this.frameNumber = 0;
    }

    private int nextFrame() {
        ++this.frameNumber;
        if (this.frameNumber > 7) {
            this.frameNumber = 0;
        }
        return this.frameNumber;
    }

    @Override
    public String parse(String mensagem) {
        BaseRecebimento baseRecebimento;
        try {
            baseRecebimento = new BaseRecebimento(mensagem);
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro no parse da mensagem");
            this.enviaHandShake('\u0015');
            return null;
        }
        this.trataLog(baseRecebimento);
        return null;
    }

    private void trataLog(BaseRecebimento baseRecebimento) {
        if (baseRecebimento.isChecksumValido()) {
            switch (baseRecebimento.getTipo()) {
                case TEST_REQUEST: {
                    this.recebidoTestRequest(new MensagemTestRequest(baseRecebimento));
                    this.enviaHandShake('\u0006');
                    break;
                }
                case MEASUREMENT_DATA: {
                    this.recebidoMeasurementData(new MensagemMeasurementData(baseRecebimento, this.configuracao, this));
                    this.enviaHandShake('\u0006');
                    break;
                }
                default: {
                    this.fireExcecaoEncontrada("Mensagem de tipo desconhecido rebebida");
                    this.enviaHandShake('\u0015');
                    break;
                }
            }
        } else {
            this.fireExcecaoEncontrada("O checksum da mensagem " + (Object)((Object)baseRecebimento.getTipo()) + " recebida \u00e9 inv\u00e1lido");
            this.enviaHandShake('\u0015');
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void recebidoTestRequest(MensagemTestRequest testRequest) {
        block43: {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            try {
                if (digitosCodigoTubo > 13) {
                    this.fireExcecaoEncontrada("O equipamento n\u00e3o suporta a identifica\u00e7\u00e3o do tubo com mais de 13 d\u00edgitos");
                }
                if (testRequest.getIdClassification() == IdClassification.BARCODE_OR_SEQUENTIAL) {
                    for (String sampleId : testRequest.getSampleIds()) {
                        ExameMaterial[] reqs;
                        String examesAux;
                        if (!Funcoes.isNumeric(sampleId) || sampleId.length() != digitosCodigoTubo) continue;
                        String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                        String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                        PanelAbaAbstrata aba = this.equipamento.getTab(0);
                        String intCodigo = "";
                        if (req != null && req[aba.getColIndice("Interface")] != null) {
                            intCodigo = (String)req[aba.getColIndice("Interface")];
                        }
                        StringBuilder exames = new StringBuilder();
                        ExameMaterial[] examesMaterial = null;
                        if (req != null) {
                            for (ExameMaterial exameMaterial : examesMaterial = BDUtil.getExamesReqLIS(filCodigo, intCodigo, reqCodigo, recCodigo)) {
                                exames.append(exameMaterial.getString());
                                if (examesMaterial.length <= 1) continue;
                                exames.append(" ");
                            }
                            examesAux = (String)req[aba.getColIndice("Exame")];
                            if (!exames.toString().contains(examesAux)) {
                                if (!Funcoes.textoVazio(exames.toString())) {
                                    exames.append(" ");
                                }
                                exames.append(examesAux);
                            }
                        }
                        if (req == null) {
                            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                            aba = this.equipamento.getTab(1);
                            if (req != null) {
                                exames.append(" ");
                                reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                                for (Object[] r : reqs) {
                                    exames.append((String)r[aba.getColIndice("Exame")] + " ");
                                }
                                exames = new StringBuilder(exames.toString().trim());
                            }
                        }
                        if (req == null) {
                            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                            aba = this.equipamento.getTab(2);
                            if (req != null) {
                                if (req[aba.getColIndice("Interface")] != null) {
                                    intCodigo = (String)req[aba.getColIndice("Interface")];
                                }
                                for (ExameMaterial exameMaterial : examesMaterial = BDUtil.getExamesReqLIS(filCodigo, intCodigo, reqCodigo, recCodigo)) {
                                    exames.append(exameMaterial.getString());
                                    if (examesMaterial.length <= 1) continue;
                                    exames.append(" ");
                                }
                                examesAux = (String)req[aba.getColIndice("Exame")];
                                if (!exames.toString().contains(examesAux)) {
                                    if (!Funcoes.textoVazio(exames.toString())) {
                                        exames.append(" ");
                                    }
                                    exames.append(examesAux);
                                }
                            } else {
                                reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                                for (Object[] r : reqs) {
                                    exames.append((String)r[aba.getColIndice("Exame")] + " ");
                                }
                                exames = new StringBuilder(exames.toString().trim());
                            }
                        }
                        if (req == null) {
                            this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                            continue;
                        }
                        String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        intCodigo = (String)req[aba.getColIndice("Interface")];
                        String pacNome = (String)req[aba.getColIndice("Paciente")];
                        String pacIdade = (String)req[aba.getColIndice("Ide")];
                        String pacSexo = (String)req[aba.getColIndice("S")];
                        String data = TempoUtil.getCurrentDateBr();
                        String hora = TempoUtil.getCurrentTime();
                        ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
                        if (examesMaterial != null) {
                            for (ExameMaterial exameMaterial : examesMaterial) {
                                if (Funcoes.textoVazio(exameMaterial.getString())) continue;
                                examesMateriais.add(new ExameMaterial(exameMaterial.getString(), exameMaterial.getCodigo()));
                            }
                        }
                        MensagemTestSelection.SampleClassification sampleClassification = MensagemTestSelection.SampleClassification.BLOOD_SERUM;
                        if (!examesMateriais.isEmpty()) {
                            String codigoMaterial = BDUtil.getExmEquipamentoMaterial(filCodigo, ((ExameMaterial)examesMateriais.get(0)).getNomeExame(), ((ExameMaterial)examesMateriais.get(0)).getCodigoMaterial(), intCodigo);
                            if (!Funcoes.textoVazio(codigoMaterial) && codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.URINE.getId())) {
                                sampleClassification = MensagemTestSelection.SampleClassification.URINE;
                            } else if (!Funcoes.textoVazio(codigoMaterial) && !codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.BLOOD_SERUM.getId())) {
                                this.fireExcecaoEncontrada(String.format("C\u00f3digo do material do exame informado incorretamente: informe 1 para Sangue e 2 para Urina no cadastro est\u00e1 informado %s, amostra %s, exame %s", codigoMaterial, sampleId, ((ExameMaterial)examesMateriais.get(0)).getNomeExame()));
                            }
                        }
                        HashSet<Integer> testNumbers = new HashSet<Integer>();
                        ExameMaterial primeiroExame = null;
                        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                        for (ExameMaterial exame : examesMateriais) {
                            ArrayList<String> ms;
                            String multiguia;
                            int situacao;
                            if (primeiroExame == null) {
                                primeiroExame = exame;
                            }
                            if ((situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo)) == -1 && ParametrosGerais.isAgruparGuiasInterface() && !Funcoes.textoVazio(multiguia = (String)req[aba.getColIndice("C\u00f3digo Temp.")]) && (situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, multiguia = multiguia.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()), exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo)) == -1 && (ms = BDUtil.getReqMultiGuias(filCodigo, multiguia)) != null && ms.size() > 1) {
                                while (situacao == -1 && !ms.isEmpty()) {
                                    multiguia = ms.remove(0);
                                    situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, multiguia, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                                }
                            }
                            if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), exame.getCodigo().toString())) {
                                List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), exame.getCodigo().toString()));
                                if (situacao == 0 || situacao == 1) {
                                    examesParaEnviar.addAll(examesFilhos);
                                    continue;
                                }
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 5 && sitFilho != 0) continue;
                                    String codigoMaterial = BDUtil.getExmEquipamentoMaterial(filCodigo, exameFilho.getString(), exameFilho.getCodigoMaterial(), intCodigo);
                                    if (!Funcoes.textoVazio(codigoMaterial) && codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.URINE.getId())) {
                                        sampleClassification = MensagemTestSelection.SampleClassification.URINE;
                                    }
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            if (situacao != 0 && situacao != 1 && situacao != 5) continue;
                            examesParaEnviar.add(exame);
                        }
                        for (ExameMaterial exameFilho : examesParaEnviar) {
                            int testNumber = this.pegaCodigoAlternativo(filCodigo, intCodigo, exameFilho);
                            if (testNumber > 0) {
                                testNumbers.add(testNumber);
                                continue;
                            }
                            this.fireExcecaoEncontrada(reqCodigo + " - Exame " + exameFilho.getNomeExame() + " requisitado, mas seu c\u00f3digo alternativo est\u00e1 incorreto ou n\u00e3o configurado");
                        }
                        if (testNumbers.isEmpty()) {
                            this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                            continue;
                        }
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames.toString());
                        infoExameRequisicao.setInterface(intCodigo);
                        this.exameRequisicaoPorSampleId.put(sampleId, infoExameRequisicao);
                        Integer anos = null;
                        String[] idade = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
                        if (idade[0] != null && !idade[0].trim().isEmpty()) {
                            anos = idade[1].equalsIgnoreCase("A") ? Integer.valueOf(Integer.parseInt(idade[0])) : Integer.valueOf(0);
                        }
                        MensagemTestSelection testSelection = new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.TEST_ADDITION);
                        testSelection.setComment1(pacNome);
                        if (anos != null) {
                            testSelection.setAge(anos);
                        }
                        testSelection.setSex(pacSexo.equalsIgnoreCase("M") ? MensagemTestSelection.Sex.MALE : MensagemTestSelection.Sex.FEMALE);
                        testSelection.setBloodSamplingDate(BDUtil.getExmColeta(filCodigo, reqCodigo, primeiroExame.getNomeExame(), primeiroExame.getCodigoMaterial()));
                        testSelection.setSampleClassification(sampleClassification);
                        Iterator<ExameMaterial> iterator = testNumbers.iterator();
                        while (iterator.hasNext()) {
                            int testNumber = (Integer)((Object)iterator.next());
                            testSelection.addTest(testNumber, MensagemTestSelection.TestCondition.M_ANALYTICAL);
                        }
                        this.mensagensParaEnviar.add(testSelection);
                    }
                    break block43;
                }
                for (String sampleId : testRequest.getSampleIds()) {
                    this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
                ex.printStackTrace();
            }
        }
    }

    private int pegaCodigoAlternativo(String filCodigo, String intCodigo, ExameMaterial exameFilho) {
        int testNumber = 0;
        try {
            testNumber = Integer.parseInt(BDUtil.getExmCodigoAlternativo(filCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), intCodigo));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testNumber;
    }

    public List<ExameMaterial> getListReqExame(String filCodigo, String intCodigo, String reqCodigo) throws SQLException {
        ExameMaterial[] exames = BDUtil.getExamesLIS(filCodigo, intCodigo, reqCodigo);
        return Arrays.asList(exames);
    }

    private void recebidoMeasurementData(MensagemMeasurementData measurementData) {
        if (this.threadRecebimentoMeasurementData != null && this.threadRecebimentoMeasurementData.isAlive()) {
            this.threadRecebimentoMeasurementData.add(measurementData);
        } else {
            this.threadRecebimentoMeasurementData = new ThreadRecebimentoMeasurementData();
            this.threadRecebimentoMeasurementData.add(measurementData);
            this.threadRecebimentoMeasurementData.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvaMeasurementData(MensagemMeasurementData measurementData) {
        Statement st;
        block20: {
            st = Conexao.getStatement();
            try {
                String sampleId = measurementData.getSampleId();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (!Funcoes.textoVazio(sampleId) && Funcoes.isNumeric(sampleId) && sampleId.trim().length() == digitosCodigoTubo) {
                    String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    for (Map.Entry<Integer, MensagemMeasurementData.TestResult> entryResult : measurementData.getTestsResultsByTestNumber().entrySet()) {
                        String emiAlternativo = String.valueOf(entryResult.getKey());
                        emiAlternativo = StringUtil.preencheString(emiAlternativo, 3, '0', 1);
                        MensagemMeasurementData.TestResult result = entryResult.getValue();
                        String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                        List<ExameMaterial> listasExame = this.getListReqExameLIS(filCodigo, intCodigo, emiAlternativo);
                        for (ExameMaterial exame : listasExame) {
                            if (exame == null) {
                                this.fireExcecaoEncontrada("C\u00f3digo alternativo " + emiAlternativo + " n\u00e3o encontrado na requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                                continue;
                            }
                            int sit = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            if (sit < 0) {
                                sit = BDUtil.getExmSituacaoFilho(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            }
                            if (sit != 1 && sit != 3 && sit != 4 && 5 != sit && sit != -1) continue;
                            ArrayList<String> excecoes = new ArrayList<String>();
                            ArrayList<String> flags = new ArrayList<String>();
                            if (result.getMark().charAt(0) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoFirstByte(result.getMark().charAt(0)));
                            }
                            if (result.getMark().charAt(1) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoSecondByteElectrolyte(result.getMark().charAt(1)));
                            }
                            if (result.getMark().charAt(2) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoThirdByte(result.getMark().charAt(2)));
                            }
                            if (result.isOverflow()) {
                                excecoes.add("Result overflow");
                                BDUtil.setExmSituacao(st, filCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), 6, intCodigo, recCodigo);
                            } else if (result.getResult() == null) {
                                excecoes.add("Sem resultado");
                            } else {
                                String campo = sit == 3 || sit == 4 || sit == 5 ? "repeticao_quantitativo" : "resultado_quantitativo";
                                HashMap<String, Object> dados = new HashMap<String, Object>();
                                String resultString = result.getResult() != null ? String.valueOf(result.getResult()).replace('.', ',') : "";
                                dados.put(campo, resultString);
                                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                            }
                            for (String descricaoExcecao : excecoes) {
                                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o " + filCodigo + reqCodigo + recCodigo + " exame " + emiAlternativo + ": " + descricaoExcecao);
                            }
                        }
                    }
                    Conexao.arquivaSQL();
                    this.fireAtualizarTabela();
                    break block20;
                }
                if (sampleId != null && Funcoes.isNumeric(sampleId.trim()) && sampleId.trim().length() != digitosCodigoTubo) {
                    this.fireExcecaoEncontrada(String.format("Resultado recebido com o c\u00f3digo de barras menor que a configura\u00e7\u00e3o do jalis, ID:%s, Tam:%s, Conf. Jalis: %s", sampleId.trim(), sampleId.trim().length(), digitosCodigoTubo));
                    break block20;
                }
                this.fireExcecaoEncontrada("Resultado recebido sem nenhum c\u00f3digo de barras ou mensagem com erro: " + sampleId);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public List<ExameMaterial> getListReqExameLIS(String filCodigo, String intCodigo, String emiAlternativo) throws SQLException {
        ExameMaterial[] exames = BDUtil.getExamesLIS(filCodigo, intCodigo, emiAlternativo);
        return Arrays.asList(exames);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().getInputString();
        if (!message.trim().isEmpty() && message.contains(this.getMsgEnd())) {
            this.parse(this.getPortaCOM().removeInputString(this.getMsgEnd()));
        }
    }

    private String getFluxoString() {
        switch (this.getFluxo().getEstado()) {
            case 2: {
                return "Rx";
            }
            case 1: {
                return "Tx";
            }
            case 0: {
                return "Idle";
            }
        }
        return "";
    }

    /*
     * Could not resolve type clashes
     */
    private void alteraSituacaoParaPendente(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                int atual;
                String filCodigo = exameRequisicao.getFilial();
                String reqCodigo = exameRequisicao.getCodigo();
                String mcoCodigo = exameRequisicao.getMaterial();
                String recCodigo = exameRequisicao.getRecipiente();
                String intCodigo = exameRequisicao.getInterface();
                Integer tuboPai = null;
                if (Funcoes.textoVazio(intCodigo)) {
                    intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, exame, mcoCodigo);
                }
                if ((atual = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recCodigo)) < 0) {
                    String codMaterial = BDUtil.getExmCodigoMaterialDesm(filCodigo, intCodigo, reqCodigo, recCodigo, exame);
                    if (!Funcoes.textoVazio(codMaterial)) {
                        mcoCodigo = codMaterial;
                    }
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame, mcoCodigo)) {
                        Object tb = BDUtil.getExameDesmembradoTuboPai(filCodigo, reqCodigo, recCodigo, intCodigo, exame, mcoCodigo);
                        if (!Funcoes.textoVazio((String)tb)) {
                            tuboPai = Integer.valueOf((String)tb);
                        }
                        if (tuboPai != null) {
                            atual = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, tuboPai.toString());
                        }
                    }
                }
                if (atual <= 2 && BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame, mcoCodigo)) {
                    ExameMaterial[] exFilho;
                    if (tuboPai == null) {
                        tuboPai = Integer.valueOf(recCodigo);
                    }
                    if ((exFilho = BDUtil.getExamesFilhos(filCodigo, intCodigo, exame, mcoCodigo)) != null) {
                        for (ExameMaterial exameMaterial : exFilho) {
                            ArrayList<String> listaTubos = BDUtil.getExameDesmembradoTubosPorExame(filCodigo, reqCodigo, tuboPai.toString(), exameMaterial.getString(), exameMaterial.getCodigoMaterial(), intCodigo);
                            for (String tb : listaTubos) {
                                if (!Funcoes.preencheZero(tb, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                int situacaoAtual = atual > 2 ? 3 : atual;
                                BDUtil.setExmSituacaoFilho(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, exameMaterial.getString(), exameMaterial.getCodigoMaterial(), tuboPai.toString(), atual < 2 ? 1 : situacaoAtual);
                            }
                        }
                    }
                    if (!BDUtil.getTodosFilhosConferidos(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recCodigo)) continue;
                    int situacaoAtual = atual > 2 ? 3 : atual;
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, tuboPai.toString(), exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : situacaoAtual);
                    continue;
                }
                if (atual >= 2) continue;
                int situacaoAtual = atual > 2 ? 3 : atual;
                this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : situacaoAtual);
            }
            Conexao.arquivaSQL();
            this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.testeQuery();
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.testeResultado();
        } else if (op == 3) {
            this.getPortaCOM().read(String.valueOf('\u0004'), String.valueOf('\u0004').length());
        }
    }

    private void testeQuery() {
        this.handShakeCharReceived('\u0005');
        this.parse(this.equipamento.arruma("[STX]1Q[SP]0101020010005895104[SP]010005895111[SP][SP][ETX][SP][SP][LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    private void testeResultado() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100520191004N0010005895104[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011105M[SP][SP][SP][SP]0.74[SP][SP]R106M[SP][SP][SP][SP][SP]203h[SP]R107M[SP][SP][SP][SP][SP]168[SP][SP]R109M[SP][SP][SP][SP]25.0[SP][SP]R115M[SP][SP][SP][SP][SP][SP]21[SP][SP]R[SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100820191004N0010005895104[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011103M[SP][SP][SP][SP][SP][SP]82[SP][SP][SP]104M[SP][SP][SP][SP][SP][SP]37h[SP][SP]105M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]106M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]107M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]109M[SP][SP][SP][SP]24.5[SP][SP][SP]114M[SP][SP][SP][SP][SP][SP]30[SP][SP][SP]115M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP][SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100520191004N0010005895111[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011105M[SP][SP][SP][SP]0.74[SP][SP]R106M[SP][SP][SP][SP][SP]203h[SP]R107M[SP][SP][SP][SP][SP]168[SP][SP]R109M[SP][SP][SP][SP]25.0[SP][SP]R115M[SP][SP][SP][SP][SP][SP]21[SP][SP]R[SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100820191004N0010005876010[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011103M[SP][SP][SP][SP][SP][SP]82[SP][SP][SP]104M[SP][SP][SP][SP][SP][SP]37h[SP][SP]105M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]106M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]107M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]109M[SP][SP][SP][SP]24.5[SP][SP][SP]114M[SP][SP][SP][SP][SP][SP]30[SP][SP][SP]115M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP][SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100520191004N0010005876032[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011105M[SP][SP][SP][SP]0.74[SP][SP]R106M[SP][SP][SP][SP][SP]203h[SP]R107M[SP][SP][SP][SP][SP]168[SP][SP]R109M[SP][SP][SP][SP]25.0[SP][SP]R115M[SP][SP][SP][SP][SP][SP]21[SP][SP]R[SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100820191004N0010005876032[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011103M[SP][SP][SP][SP][SP][SP]82[SP][SP][SP]104M[SP][SP][SP][SP][SP][SP]37h[SP][SP]105M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]106M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]107M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]109M[SP][SP][SP][SP]24.5[SP][SP][SP]114M[SP][SP][SP][SP][SP][SP]30[SP][SP][SP]115M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP][SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
    }

    private class ThreadRecebimentoMeasurementData
    extends Thread {
        private Queue<MensagemMeasurementData> measurementDatas = new LinkedList<MensagemMeasurementData>();

        public void add(MensagemMeasurementData measurementData) {
            this.measurementDatas.add(measurementData);
        }

        @Override
        public void run() {
            InterfaceListener.this.addTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
            while (!this.measurementDatas.isEmpty()) {
                InterfaceListener.this.salvaMeasurementData(this.measurementDatas.remove());
                try {
                    ThreadRecebimentoMeasurementData.sleep(500L);
                }
                catch (Exception exception) {}
            }
            InterfaceListener.this.removeTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
        }
    }
}

