/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1200v2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String filCodigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String intCodigo = (String)exame[this.getColIndice("Interface")];
            String exaCodigo = (String)exame[this.getColIndice("Exame")];
            String mcoCodigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exaCodigo, mcoCodigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        Object[] linhaRepeticao = null;
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (Funcoes.textoVazio(reqRepetir)) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo") - 1];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (Funcoes.textoVazio(reqPronto)) {
                    reqPronto = (String)linhaRepeticao[this.getColIndice("C\u00f3digo") - 1];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames.add((String)exame[1]);
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && requisicaoExames.size() != 1) continue;
                exames.add(exaPronto);
                linhas.add(j);
            }
        }
        if (!exames.isEmpty()) {
            try {
                for (Integer linha : linhas) {
                    String aux = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3digo"));
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        // empty if block
                    }
                    String recCodigo = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Tubo"));
                    String mcoCodigo = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3d. Mat."));
                    String filCodigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String intCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                    String reqCodigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
                    String exaPai = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Exame"));
                    String codigoRequisicao = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
                    if (Funcoes.textoVazio(codigoRequisicao)) {
                        codigoRequisicao = (String)linhaRepeticao[this.getColIndice("C\u00f3digo") - 1];
                    }
                    if (Funcoes.textoVazio(aux) || !aux.equals(codigoRequisicao)) continue;
                    Statement st = Conexao.getStatement();
                    for (String exame : exames) {
                        if (BDUtil.existeDesmembramento(filCodigo, intCodigo, reqCodigo, recCodigo, exame, mcoCodigo) || BDUtil.isExameCurva(filCodigo, intCodigo, exaPai, mcoCodigo)) {
                            List listaTubos = (List)this.tabelaExames.getValueAt(linha, this.getColIndice("Tubos Filhos"));
                            if (Funcoes.textoVazio(recCodigo)) {
                                listaTubos.add(recCodigo);
                            }
                            if (listaTubos != null) {
                                Iterator iterator = listaTubos.iterator();
                                while (iterator.hasNext()) {
                                    ExameMaterial[] exaFilho;
                                    String tb;
                                    String tubo = tb = (String)iterator.next();
                                    for (ExameMaterial exameMaterial : exaFilho = BDUtil.getExameMaterialRecipiente(filCodigo, reqCodigo, tubo, intCodigo)) {
                                        ExameMaterial[] exaPais;
                                        for (ExameMaterial ePai : exaPais = BDUtil.getDesmExamesPai(filCodigo, intCodigo, reqCodigo, tubo, exameMaterial.getString(), exameMaterial.getCodigo().toString())) {
                                            BDUtil.setDesmSituacao(st, filCodigo, intCodigo, reqCodigo, ePai.getNomeExame(), mcoCodigo, recCodigo, exame, exameMaterial.getCodigo().toString(), 5);
                                            BDUtil.setExmSituacao(st, filCodigo, reqCodigo, ePai.getNomeExame(), mcoCodigo, 5, intCodigo, recCodigo);
                                        }
                                    }
                                }
                            }
                        }
                        try {
                            ExameMaterial exameMaterial = BDUtil.getReqExamePaiLIS(filCodigo, intCodigo, reqCodigo, recCodigo);
                            if (exameMaterial != null && BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                                ExameMaterial[] exameFilhos;
                                for (ExameMaterial exameFilho : exameFilhos = BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                                    if (!exameFilho.getString().equals(exame)) continue;
                                    BDUtil.setDesmSituacao(st, filCodigo, intCodigo, reqCodigo, exameMaterial.getString(), mcoCodigo, recCodigo, exame, mcoCodigo, 5);
                                    BDUtil.setExmSituacao(st, filCodigo, reqCodigo, exameMaterial.getString(), mcoCodigo, 5, intCodigo, recCodigo);
                                }
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        BDUtil.setExmSituacao(st, filCodigo, reqCodigo, exame, mcoCodigo, 5, intCodigo, recCodigo);
                    }
                }
                Conexao.arquivaSQL();
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

