/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens;

import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.BaseEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.Tipos;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MensagemTestSelection
implements IMensagemEnvio {
    private BaseEnvio base;
    private Tipos tipo = Tipos.TEST_SELECTION;
    private String sampleId;
    private RegistrationData registrationData;
    private List<RequestTest> tests;
    private Integer age;
    private Sex sex = Sex.MALE;
    private Date bloodSamplingDate;
    private SampleClassification sampleClassification = SampleClassification.BLOOD_SERUM;
    private float dilutionCoefficient = 1.0f;
    private String comment1;
    private String comment2;

    public MensagemTestSelection(String sampleId, RegistrationData registrationData) {
        this.sampleId = sampleId.trim();
        this.registrationData = registrationData;
        this.base = new BaseEnvio(this.tipo);
        this.tests = new ArrayList<RequestTest>();
    }

    public void addTest(int testNumber, TestCondition testCondition) {
        this.tests.add(new RequestTest(testNumber, testCondition));
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public void setBloodSamplingDate(Date bloodSamplingDate) {
        this.bloodSamplingDate = bloodSamplingDate;
    }

    public void setSampleClassification(SampleClassification sampleClassification) {
        this.sampleClassification = sampleClassification;
    }

    public void setDilutionCoefficient(float dilutionCoefficient) {
        this.dilutionCoefficient = dilutionCoefficient;
    }

    public void setComment1(String comment1) {
        this.comment1 = StringUtil.removerAcentos(comment1);
    }

    public void setComment2(String comment2) {
        this.comment2 = StringUtil.removerAcentos(comment2);
    }

    @Override
    public String getTextoMensagem(int frameNumber, boolean finalFrame) {
        this.base.limpa();
        this.base.addDataEspaco(1);
        this.base.addDataItem(2, "01");
        this.base.addDataItem(2, "01");
        this.base.addDataItem(3, Funcoes.preencheZero(this.tests.size(), 3));
        this.base.addDataItem(1, "N");
        this.base.addDataItem(1, this.registrationData.getId());
        this.base.addDataItem(13, this.sampleId);
        this.base.addDataEspaco(7);
        this.base.addDataItem(16, this.comment1);
        this.base.addDataItem(16, this.comment2);
        this.base.addDataItem(1, this.sex.getId());
        this.base.addDataItem(3, this.age != null ? String.valueOf(this.age) : "", BaseEnvio.Orientacoes.ESQUERDA);
        this.base.addDataItem(8, this.bloodSamplingDate != null ? Funcoes.formataData("yyyyMMdd", this.bloodSamplingDate) : "");
        this.base.addDataItem(4, String.valueOf((float)Math.round(this.dilutionCoefficient * 10.0f) / 10.0f), BaseEnvio.Orientacoes.ESQUERDA);
        this.base.addDataItem(1, this.sampleClassification.getId());
        this.base.addDataItem(1, "1");
        for (RequestTest test : this.tests) {
            this.base.addDataItem(3, Funcoes.preencheZero(test.getTestNumber(), 3));
            this.base.addDataItem(1, test.getTestCondition().getId());
        }
        this.base.addDataEspaco(1);
        return this.base.getTextoMensagem(frameNumber, finalFrame);
    }

    @Override
    public Tipos getTipo() {
        return this.tipo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sampleId: " + this.sampleId + "; chemistryNumbers: " + StringUtil.implode(this.tests, ", ") + "]";
    }

    private class RequestTest {
        private int testNumber;
        private TestCondition testCondition;
        private int material;

        public RequestTest(int testNumber, TestCondition testCondition) {
            this.testNumber = testNumber;
            this.testCondition = testCondition;
        }

        public int getTestNumber() {
            return this.testNumber;
        }

        public TestCondition getTestCondition() {
            return this.testCondition;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[testNumber: " + this.testNumber + "; testCondition: " + (Object)((Object)this.testCondition) + "]";
        }
    }

    public static enum SampleClassification {
        BLOOD_SERUM("1"),
        URINE("2");

        private String id;

        private SampleClassification(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum Sex {
        MALE("M"),
        FEMALE("F");

        private String id;

        private Sex(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum RegistrationData {
        NEW_REQUEST("0"),
        TEST_ADDITION("1"),
        NO_REQUEST("2"),
        SAMPLE_DELETION("3");

        private String id;

        private RegistrationData(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum TestCondition {
        M_ANALYTICAL("M"),
        D_REANALYSIS("D"),
        U_REANALYSIS("U");

        private String id;

        private TestCondition(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

