/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia1200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.MarkSpecifications;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.RetornoAba;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.IdClassification;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.MensagemMeasurementData;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.MensagemTestRequest;
import jalis.laboratorio.interfaceamento.interfaces.advia1200.mensagens.MensagemTestSelection;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final int MAX_TENTATIVAS_ENVIO = 3;
    private static final int TAMANHO_SAMPLE_ID = 13;
    private Queue<IMensagemEnvio> mensagensParaEnviar;
    private Map<String, InfoExameRequisicao> exameRequisicaoPorSampleId;
    private IMensagemEnvio ultimaMensagemEnviada;
    private int tentativasEnvio;
    private int frameNumber = 0;
    private boolean finalFrame;
    private boolean aguardandoConfirmacaoEnq;
    private Timer timerEnq;
    private ThreadRecebimentoMeasurementData threadRecebimentoMeasurementData;
    private final TravaFechamento travaProcessandoResultados;
    private InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.mensagensParaEnviar = new LinkedList<IMensagemEnvio>();
        this.exameRequisicaoPorSampleId = new HashMap<String, InfoExameRequisicao>();
        this.travaProcessandoResultados = new TravaFechamento("Os resultados est\u00e3o sendo processados");
        this.timerEnq = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InterfaceListener.this.mensagensParaEnviar.isEmpty()) {
                    InterfaceListener.this.timerEnq.stop();
                    InterfaceListener.this.aguardandoConfirmacaoEnq = true;
                    InterfaceListener.this.enviaHandShake('\u0005');
                }
            }
        });
    }

    @Override
    protected ArrayList getExamesAba(int abaSelecionada) {
        ArrayList exames = null;
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        switch (abaSelecionada) {
            case 0: {
                exames = ((AbaDefaultNaoEnviados)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                exames = ((AbaDefaultNaoEnviados)aba).getExames();
                break;
            }
            case 1: {
                exames = ((AbaDefaultPendentes)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                exames = ((AbaDefaultPendentes)aba).getExames();
                break;
            }
            case 2: {
                exames = ((AbaDefaultProntos)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                exames = ((AbaDefaultProntos)aba).getExames();
            }
        }
        if (exames == null) {
            return new ArrayList();
        }
        return exames;
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return null;
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        switch (c) {
            case '\u0005': {
                this.tratarEnquiry();
                break;
            }
            case '\u0006': {
                this.tratarAcknowledge();
                break;
            }
            case '\u0015': {
                this.tratarNegativeAck();
                break;
            }
            case '\u0004': {
                this.tratarEndOfTX();
                break;
            }
            case '\u0011': {
                this.trataRequestSkip();
                break;
            }
            default: {
                this.handShakeNaoEsperado(c);
            }
        }
    }

    protected void handShakeNaoEsperado(char c) {
        this.setIdle();
        this.fireExcecaoEncontrada("Caracter 0x" + Integer.valueOf(c) + " n\u00e3o esperado quando " + this.getFluxoString());
    }

    protected void tratarEnquiry() {
        if (this.isTX()) {
            this.handShakeNaoEsperado('\u0005');
        }
        this.zeraEnvio();
        this.timerEnq.stop();
        this.setRX();
        this.enviaHandShake('\u0006');
    }

    protected void tratarAcknowledge() {
        if (this.aguardandoConfirmacaoEnq) {
            this.aguardandoConfirmacaoEnq = false;
            this.setTX();
        }
        if (this.isTX()) {
            MensagemTestSelection testSelection;
            if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada instanceof MensagemTestSelection && this.exameRequisicaoPorSampleId.containsKey((testSelection = (MensagemTestSelection)this.ultimaMensagemEnviada).getSampleId())) {
                this.alteraSituacaoParaPendente(this.exameRequisicaoPorSampleId.remove(testSelection.getSampleId()));
                this.ultimaMensagemEnviada = null;
            }
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0006');
        }
    }

    protected void tratarNegativeAck() {
        if (this.isTX()) {
            if (this.tentativasEnvio <= 3) {
                this.enviaMensagem(this.ultimaMensagemEnviada);
            } else {
                this.encerraTransmissao();
            }
        } else {
            this.handShakeNaoEsperado('\u0015');
        }
    }

    protected void tratarEndOfTX() {
        if (this.isRX()) {
            this.setIdle();
            this.enviaEnq();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    protected void trataRequestSkip() {
        if (this.isTX()) {
            this.ultimaMensagemEnviada = null;
            this.tentativasEnvio = 0;
            this.enviaProximaMensagem();
        } else {
            this.handShakeNaoEsperado('\u0004');
        }
    }

    private void enviaHandShake(char c) {
        try {
            this.getPortaCOM().write(String.valueOf(c));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar Handshake 0x" + Integer.valueOf(c));
            ex.printStackTrace();
        }
    }

    private void enviaEnq() {
        if (!this.timerEnq.isRunning()) {
            this.timerEnq.start();
        }
    }

    private void enviaProximaMensagem() {
        if (this.mensagensParaEnviar.isEmpty()) {
            this.encerraTransmissao();
        } else {
            this.finalFrame = true;
            this.nextFrame();
            this.enviaMensagem(this.mensagensParaEnviar.remove());
        }
    }

    private void enviaMensagem(IMensagemEnvio mensagem) {
        try {
            this.ultimaMensagemEnviada = mensagem;
            this.getPortaCOM().write(mensagem.getTextoMensagem(this.frameNumber, this.finalFrame));
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao enviar mensagem " + mensagem);
            ex.printStackTrace();
        }
    }

    private void encerraTransmissao() {
        this.zeraEnvio();
        this.setIdle();
        this.enviaHandShake('\u0004');
    }

    private void zeraEnvio() {
        this.mensagensParaEnviar.clear();
        this.ultimaMensagemEnviada = null;
        this.tentativasEnvio = 0;
        this.frameNumber = 0;
    }

    private int nextFrame() {
        ++this.frameNumber;
        if (this.frameNumber > 7) {
            this.frameNumber = 0;
        }
        return this.frameNumber;
    }

    @Override
    public String parse(String mensagem) {
        BaseRecebimento baseRecebimento;
        try {
            baseRecebimento = new BaseRecebimento(mensagem);
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro no parse da mensagem");
            this.enviaHandShake('\u0015');
            return null;
        }
        if (baseRecebimento.isChecksumValido()) {
            switch (baseRecebimento.getTipo()) {
                case TEST_REQUEST: {
                    this.recebidoTestRequest(new MensagemTestRequest(baseRecebimento));
                    this.enviaHandShake('\u0006');
                    break;
                }
                case MEASUREMENT_DATA: {
                    this.recebidoMeasurementData(new MensagemMeasurementData(baseRecebimento, this.configuracao, this));
                    this.enviaHandShake('\u0006');
                    break;
                }
                default: {
                    this.fireExcecaoEncontrada("Mensagem de tipo desconhecido rebebida");
                    this.enviaHandShake('\u0015');
                    break;
                }
            }
        } else {
            this.fireExcecaoEncontrada("O checksum da mensagem " + (Object)((Object)baseRecebimento.getTipo()) + " recebida \u00e9 inv\u00e1lido");
            this.enviaHandShake('\u0015');
        }
        return null;
    }

    private RetornoAba buscaRequisicaoAbaNaoEnviados(String filCodigo, String reqCodigo, String recCodigo, boolean atualizarAba) throws SQLException {
        if (debug) {
            System.out.println("Pesquisando aba n\u00e3o enviados: " + atualizarAba);
        }
        if (atualizarAba) {
            this.getAba(0).reloadExames();
        }
        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        String intCodigo = "";
        if (req != null) {
            if (req[aba.getColIndice("Interface")] != null) {
                intCodigo = (String)req[aba.getColIndice("Interface")];
            }
        }
        String exames = "";
        ExameMaterial[] examesMaterial = null;
        if (req != null) {
            for (ExameMaterial exameMaterial : examesMaterial = BDUtil.getExamesReqLIS(filCodigo, intCodigo, reqCodigo, recCodigo)) {
                exames = exames + exameMaterial.getString();
                if (examesMaterial.length <= 1) continue;
                exames = exames + " ";
            }
            String examesAux = (String)req[aba.getColIndice("Exame")];
            if (!exames.contains(examesAux)) {
                if (!Funcoes.textoVazio(exames)) {
                    exames = exames + " ";
                }
                exames = exames + examesAux;
            }
        }
        RetornoAba r = new RetornoAba();
        r.requisicao = req;
        r.aba = aba;
        r.intCodigo = intCodigo;
        r.exames = exames;
        r.examesMaterial = examesMaterial;
        return r;
    }

    private RetornoAba buscaRequisicaoAbaPendentes(String filCodigo, String reqCodigo, String recCodigo, boolean atualizarAba) throws SQLException {
        if (debug) {
            System.out.println("Pesquisando aba pendentes: " + atualizarAba);
        }
        if (atualizarAba) {
            this.getAba(1).reloadExames();
        }
        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
        PanelAbaAbstrata aba = this.equipamento.getTab(1);
        String exames = "";
        Object examesMaterial = null;
        String intCodigo = "";
        if (req != null) {
            exames = exames + " ";
            List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
            for (Object[] r : reqs) {
                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
            }
            exames = exames.trim();
        }
        RetornoAba r = new RetornoAba();
        r.requisicao = req;
        r.aba = aba;
        r.exames = exames;
        r.examesMaterial = examesMaterial;
        return r;
    }

    private RetornoAba buscaRequisicaoAbaProntos(String filCodigo, String reqCodigo, String recCodigo, boolean atualizarAba) throws SQLException {
        if (debug) {
            System.out.println("Pesquisando aba prontos: " + atualizarAba);
        }
        if (atualizarAba) {
            this.getAba(2).reloadExames();
        }
        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
        PanelAbaAbstrata aba = this.equipamento.getTab(2);
        String intCodigo = "";
        String exames = "";
        ExameMaterial[] examesMaterial = null;
        if (req != null) {
            if (req[aba.getColIndice("Interface")] != null) {
                intCodigo = (String)req[aba.getColIndice("Interface")];
            }
            for (ExameMaterial exameMaterial : examesMaterial = BDUtil.getExamesReqLIS(filCodigo, intCodigo, reqCodigo, recCodigo)) {
                exames = exames + exameMaterial.getString();
                if (examesMaterial.length <= 1) continue;
                exames = exames + " ";
            }
            String examesAux = (String)req[aba.getColIndice("Exame")];
            if (!exames.contains(examesAux)) {
                if (!Funcoes.textoVazio(exames)) {
                    exames = exames + " ";
                }
                exames = exames + examesAux;
            }
        } else {
            List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
            for (Object[] r : reqs) {
                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
            }
            exames = exames.trim();
        }
        RetornoAba r = new RetornoAba();
        r.requisicao = req;
        r.aba = aba;
        r.intCodigo = intCodigo;
        r.exames = exames;
        r.examesMaterial = examesMaterial;
        return r;
    }

    private void recebidoTestRequest(MensagemTestRequest testRequest) {
        block36: {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            try {
                if (digitosCodigoTubo > 13) {
                    this.fireExcecaoEncontrada("O equipamento n\u00e3o suporta a identifica\u00e7\u00e3o do tubo com mais de 13 d\u00edgitos");
                }
                if (testRequest.getIdClassification() == IdClassification.BARCODE_OR_SEQUENTIAL) {
                    for (String sampleId : testRequest.getSampleIds()) {
                        if (!Funcoes.isNumeric(sampleId) || sampleId.length() != digitosCodigoTubo) continue;
                        String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                        String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        String intCodigo = "";
                        Object[] req = null;
                        PanelAbaAbstrata aba = null;
                        String exames = null;
                        ExameMaterial[] examesMaterial = null;
                        RetornoAba ra = this.buscaRequisicaoAbaNaoEnviados(filCodigo, reqCodigo, recCodigo, false);
                        if (ra == null || ra.requisicao == null) {
                            ra = this.buscaRequisicaoAbaPendentes(filCodigo, reqCodigo, recCodigo, false);
                        }
                        if (ra == null || ra.requisicao == null) {
                            ra = this.buscaRequisicaoAbaProntos(filCodigo, reqCodigo, recCodigo, false);
                        }
                        if (debug) {
                            System.out.println("Atualizando para pesquisar");
                        }
                        if (ra == null || ra.requisicao == null) {
                            ra = this.buscaRequisicaoAbaNaoEnviados(filCodigo, reqCodigo, recCodigo, true);
                        }
                        if (ra == null || ra.requisicao == null) {
                            ra = this.buscaRequisicaoAbaPendentes(filCodigo, reqCodigo, recCodigo, true);
                        }
                        if (ra == null || ra.requisicao == null) {
                            ra = this.buscaRequisicaoAbaProntos(filCodigo, reqCodigo, recCodigo, true);
                        }
                        if (ra == null || ra.requisicao == null) {
                            this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                            continue;
                        }
                        req = ra.requisicao;
                        aba = ra.aba;
                        exames = ra.exames;
                        examesMaterial = ra.examesMaterial;
                        intCodigo = ra.intCodigo;
                        String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        intCodigo = (String)req[aba.getColIndice("Interface")];
                        String pacNome = (String)req[aba.getColIndice("Paciente")];
                        String pacIdade = (String)req[aba.getColIndice("Ide")];
                        String pacSexo = (String)req[aba.getColIndice("S")];
                        String data = TempoUtil.getCurrentDateBr();
                        String hora = TempoUtil.getCurrentTime();
                        ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
                        if (examesMaterial != null) {
                            for (ExameMaterial exameMaterial : examesMaterial) {
                                if (Funcoes.textoVazio(exameMaterial.getString())) continue;
                                examesMateriais.add(new ExameMaterial(exameMaterial.getString(), new Integer(exameMaterial.getCodigo())));
                            }
                        }
                        MensagemTestSelection.SampleClassification sampleClassification = MensagemTestSelection.SampleClassification.BLOOD_SERUM;
                        if (examesMateriais.size() > 0) {
                            String codigoMaterial = BDUtil.getExmEquipamentoMaterial(filCodigo, ((ExameMaterial)examesMateriais.get(0)).getNomeExame(), ((ExameMaterial)examesMateriais.get(0)).getCodigoMaterial(), intCodigo);
                            if (!Funcoes.textoVazio(codigoMaterial) && codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.URINE.getId())) {
                                sampleClassification = MensagemTestSelection.SampleClassification.URINE;
                            } else if (!Funcoes.textoVazio(codigoMaterial) && !codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.BLOOD_SERUM.getId())) {
                                this.fireExcecaoEncontrada(String.format("C\u00f3digo do material do exame informado incorretamente: informe 1 para Sangue e 2 para Urina no cadastro est\u00e1 informado %s, amostra %s, exame %s", codigoMaterial, sampleId, ((ExameMaterial)examesMateriais.get(0)).getNomeExame()));
                            }
                        }
                        HashSet<Integer> testNumbers = new HashSet<Integer>();
                        ExameMaterial primeiroExame = null;
                        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                        for (ExameMaterial exame : examesMateriais) {
                            int situacao;
                            if (primeiroExame == null) {
                                primeiroExame = exame;
                            }
                            if ((situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo)) == -1 && ParametrosGerais.isAgruparGuiasInterface()) {
                                ArrayList<String> ms;
                                String multiguia = (String)req[aba.getColIndice("C\u00f3digo Temp.")];
                                if (!Funcoes.textoVazio(multiguia) && (situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, multiguia = multiguia.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()), exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo)) == -1 && (ms = BDUtil.getReqMultiGuias(filCodigo, multiguia)) != null && ms.size() > 1) {
                                    while (situacao == -1 && ms.size() > 0) {
                                        multiguia = ms.remove(0);
                                        situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, multiguia, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                                    }
                                }
                            }
                            if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), exame.getCodigo().toString())) {
                                List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), exame.getCodigo().toString()));
                                if (situacao == 0 || situacao == 1) {
                                    examesParaEnviar.addAll(examesFilhos);
                                    continue;
                                }
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 5 && sitFilho != 0) continue;
                                    String codigoMaterial = BDUtil.getExmEquipamentoMaterial(filCodigo, exameFilho.getString(), exameFilho.getCodigoMaterial(), intCodigo);
                                    if (!Funcoes.textoVazio(codigoMaterial) && codigoMaterial.equalsIgnoreCase(MensagemTestSelection.SampleClassification.URINE.getId())) {
                                        sampleClassification = MensagemTestSelection.SampleClassification.URINE;
                                    }
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            if (situacao != 0 && situacao != 1 && situacao != 5) continue;
                            examesParaEnviar.add(exame);
                        }
                        for (ExameMaterial exameFilho : examesParaEnviar) {
                            int testNumber = 0;
                            try {
                                testNumber = Integer.parseInt(BDUtil.getExmCodigoAlternativo(filCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), intCodigo));
                            }
                            catch (Exception examesFilhos) {
                                // empty catch block
                            }
                            if (testNumber > 0) {
                                testNumbers.add(testNumber);
                                continue;
                            }
                            this.fireExcecaoEncontrada(reqCodigo + " - Exame " + exameFilho.getNomeExame() + " requisitado, mas seu c\u00f3digo alternativo est\u00e1 incorreto ou n\u00e3o configurado");
                        }
                        if (testNumbers.isEmpty()) {
                            this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                            continue;
                        }
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        this.exameRequisicaoPorSampleId.put(sampleId, infoExameRequisicao);
                        Integer anos = null;
                        String[] idade = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
                        if (idade[0] != null && !idade[0].trim().isEmpty()) {
                            anos = idade[1].equalsIgnoreCase("A") ? Integer.valueOf(Integer.parseInt(idade[0])) : Integer.valueOf(0);
                        }
                        MensagemTestSelection testSelection = new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.TEST_ADDITION);
                        testSelection.setComment1(pacNome);
                        if (anos != null) {
                            testSelection.setAge(anos);
                        }
                        testSelection.setSex(pacSexo.equalsIgnoreCase("M") ? MensagemTestSelection.Sex.MALE : MensagemTestSelection.Sex.FEMALE);
                        testSelection.setBloodSamplingDate(BDUtil.getExmColeta(filCodigo, reqCodigo, primeiroExame.getNomeExame(), primeiroExame.getCodigoMaterial()));
                        testSelection.setSampleClassification(sampleClassification);
                        Iterator<ExameMaterial> iterator = testNumbers.iterator();
                        while (iterator.hasNext()) {
                            int testNumber = (Integer)((Object)iterator.next());
                            testSelection.addTest(testNumber, MensagemTestSelection.TestCondition.M_ANALYTICAL);
                        }
                        this.mensagensParaEnviar.add(testSelection);
                    }
                    break block36;
                }
                for (String sampleId : testRequest.getSampleIds()) {
                    this.mensagensParaEnviar.add(new MensagemTestSelection(sampleId, MensagemTestSelection.RegistrationData.NO_REQUEST));
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
                ex.printStackTrace();
            }
        }
    }

    public List<ExameMaterial> getListReqExame(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        ExameMaterial[] exames;
        ArrayList<ExameMaterial> listaExames = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : exames = BDUtil.getExamesLIS(fil_codigo, int_codigo, req_codigo)) {
            listaExames.add(exameMaterial);
        }
        return listaExames;
    }

    private void recebidoMeasurementData(MensagemMeasurementData measurementData) {
        if (this.threadRecebimentoMeasurementData != null && this.threadRecebimentoMeasurementData.isAlive()) {
            this.threadRecebimentoMeasurementData.add(measurementData);
        } else {
            this.threadRecebimentoMeasurementData = new ThreadRecebimentoMeasurementData();
            this.threadRecebimentoMeasurementData.add(measurementData);
            this.threadRecebimentoMeasurementData.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvaMeasurementData(MensagemMeasurementData measurementData) {
        Statement st;
        block20: {
            st = Conexao.getStatement();
            try {
                String sampleId = measurementData.getSampleId();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (!Funcoes.textoVazio(sampleId) && Funcoes.isNumeric(sampleId) && sampleId.trim().length() == digitosCodigoTubo) {
                    String filCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    for (Map.Entry<Integer, MensagemMeasurementData.TestResult> entryResult : measurementData.getTestsResultsByTestNumber().entrySet()) {
                        String emiAlternativo = String.valueOf(entryResult.getKey());
                        emiAlternativo = StringUtil.preencheString(emiAlternativo, 3, '0', 1);
                        MensagemMeasurementData.TestResult result = entryResult.getValue();
                        String int_codigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                        List<ExameMaterial> listasExame = this.getListReqExameLIS(filCodigo, int_codigo, reqCodigo, recCodigo, emiAlternativo);
                        for (ExameMaterial exame : listasExame) {
                            if (exame == null) {
                                this.fireExcecaoEncontrada("C\u00f3digo alternativo " + emiAlternativo + " n\u00e3o encontrado na requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                                continue;
                            }
                            int sit = BDUtil.getExmSituacao(filCodigo, int_codigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            if (sit < 0) {
                                sit = BDUtil.getExmSituacaoFilho(filCodigo, int_codigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            }
                            if (sit != 1 && sit != 3 && sit != 4 && 5 != sit && sit != -1) continue;
                            ArrayList<String> excecoes = new ArrayList<String>();
                            ArrayList<String> flags = new ArrayList<String>();
                            if (result.getMark().charAt(0) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoFirstByte(result.getMark().charAt(0)));
                            }
                            if (result.getMark().charAt(1) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoSecondByteElectrolyte(result.getMark().charAt(1)));
                            }
                            if (result.getMark().charAt(2) != ' ') {
                                flags.add(MarkSpecifications.getDescricaoThirdByte(result.getMark().charAt(2)));
                            }
                            if (result.isOverflow()) {
                                excecoes.add("Result overflow");
                                BDUtil.setExmSituacao(st, filCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), 6, int_codigo, recCodigo);
                            } else if (result.getResult() == null) {
                                excecoes.add("Sem resultado");
                            } else {
                                String campo = sit == 3 || sit == 4 || sit == 5 ? "repeticao_quantitativo" : "resultado_quantitativo";
                                HashMap<String, Object> dados = new HashMap<String, Object>();
                                String resultString = result.getResult() != null ? String.valueOf(result.getResult()).replace('.', ',') : "";
                                dados.put(campo, resultString);
                                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados, flags);
                            }
                            for (String descricaoExcecao : excecoes) {
                                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o " + filCodigo + reqCodigo + recCodigo + " exame " + emiAlternativo + ": " + descricaoExcecao);
                            }
                        }
                    }
                    Conexao.arquivaSQL();
                    this.fireAtualizarTabela();
                    break block20;
                }
                if (sampleId != null && Funcoes.isNumeric(sampleId.trim()) && sampleId.trim().length() != digitosCodigoTubo) {
                    this.fireExcecaoEncontrada(String.format("Resultado recebido com o c\u00f3digo de barras menor que a configura\u00e7\u00e3o do jalis, ID:%s, Tam:%s, Conf. Jalis: %s", sampleId.trim(), sampleId.trim().length(), digitosCodigoTubo));
                    break block20;
                }
                this.fireExcecaoEncontrada("Resultado recebido sem nenhum c\u00f3digo de barras ou mensagem com erro: " + sampleId);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public List<ExameMaterial> getListReqExameLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        ExameMaterial[] exames;
        ArrayList<ExameMaterial> listaExames = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : exames = BDUtil.getExamesLIS(fil_codigo, int_codigo, emi_alternativo)) {
            listaExames.add(exameMaterial);
        }
        return listaExames;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().getInputString();
        if (!message.trim().isEmpty() && message.contains(this.getMsgEnd())) {
            this.parse(this.getPortaCOM().removeInputString(this.getMsgEnd()));
        }
    }

    private String getFluxoString() {
        switch (this.getFluxo().getEstado()) {
            case 2: {
                return "Rx";
            }
            case 1: {
                return "Tx";
            }
            case 0: {
                return "Idle";
            }
        }
        return "";
    }

    private void alteraSituacaoParaPendente(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                int atual;
                String fil_codigo = exameRequisicao.getFilial();
                String req_codigo = exameRequisicao.getCodigo();
                String mco_codigo = exameRequisicao.getMaterial();
                String rec_codigo = exameRequisicao.getRecipiente();
                String int_codigo = exameRequisicao.getInterface();
                Integer tuboPai = null;
                if (Funcoes.textoVazio(int_codigo)) {
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, mco_codigo);
                }
                if ((atual = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo)) < 0) {
                    String codMaterial = BDUtil.getExmCodigoMaterialDesm(fil_codigo, int_codigo, req_codigo, rec_codigo, exame);
                    if (!Funcoes.textoVazio(codMaterial)) {
                        mco_codigo = codMaterial;
                    }
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame, mco_codigo)) {
                        String tb = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exame, mco_codigo);
                        if (!Funcoes.textoVazio(tb)) {
                            tuboPai = Integer.valueOf(tb);
                        }
                        if (tuboPai != null) {
                            atual = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.toString());
                        }
                    }
                }
                if (atual <= 2 && BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame, mco_codigo)) {
                    ExameMaterial[] exFilho;
                    if (tuboPai == null) {
                        tuboPai = Integer.valueOf(rec_codigo);
                    }
                    if ((exFilho = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exame, mco_codigo)) != null) {
                        for (ExameMaterial exameMaterial : exFilho) {
                            ArrayList<String> listaTubos = BDUtil.getExameDesmembradoTubosPorExame(fil_codigo, req_codigo, tuboPai.toString(), exameMaterial.getString(), exameMaterial.getCodigoMaterial(), int_codigo);
                            for (String tb : listaTubos) {
                                if (!Funcoes.preencheZero(tb, ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo)) continue;
                                BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, exameMaterial.getString(), exameMaterial.getCodigoMaterial(), tuboPai.toString(), atual < 2 ? 1 : (atual > 2 ? 3 : atual));
                            }
                        }
                    }
                    if (!BDUtil.getTodosFilhosConferidos(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo)) continue;
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, tuboPai.toString(), exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : (atual > 2 ? 3 : atual));
                    continue;
                }
                if (atual >= 2) continue;
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : (atual > 2 ? 3 : atual));
            }
            Conexao.arquivaSQL();
            this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010001154641");
            this.testeQuery(idAmostra);
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010001154641");
            this.testeResultado(idAmostra);
        } else if (op == 3) {
            this.getPortaCOM().read(String.valueOf('\u0004'), String.valueOf('\u0004').length());
        }
    }

    private void testeQuery(String idAmostra) {
        this.handShakeCharReceived('\u0005');
        this.parse(this.equipamento.arruma("[STX]1Q[SP]0101020010010856604[SP]010005895111[SP][SP][ETX][SP][SP][LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    private void testeResultado(String idAmostra) {
        StringBuilder builder = new StringBuilder();
        builder.delete(0, builder.length());
        builder.append(this.equipamento.arruma("[STX]1R[SP]010100820191004N0010010856604[SP][SP][SP][SP][SP][SP][SP][SP]EVANGELINA[SP]CORIM[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]F[SP]6320191031[SP]1.011103M[SP][SP][SP][SP][SP][SP]82[SP][SP][SP]104M[SP][SP][SP][SP][SP][SP]37h[SP][SP]105M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]106M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]107M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP]109M[SP][SP][SP][SP]24.5[SP][SP][SP]114M[SP][SP][SP][SP][SP][SP]30[SP][SP][SP]115M[SP][SP][SP][SP][SP][SP][SP][SP][SP]S[SP][SP][ETX][SP][SP][LINE]"));
        this.parse(this.equipamento.arruma(builder.toString()));
    }

    private class ThreadRecebimentoMeasurementData
    extends Thread {
        private Queue<MensagemMeasurementData> measurementDatas = new LinkedList<MensagemMeasurementData>();

        public void add(MensagemMeasurementData measurementData) {
            this.measurementDatas.add(measurementData);
        }

        @Override
        public void run() {
            InterfaceListener.this.addTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
            while (!this.measurementDatas.isEmpty()) {
                InterfaceListener.this.salvaMeasurementData(this.measurementDatas.remove());
                try {
                    ThreadRecebimentoMeasurementData.sleep(500L);
                }
                catch (Exception exception) {}
            }
            InterfaceListener.this.removeTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
        }
    }
}

