/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.recebimento;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.ChemistryResult;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.Especies;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.TubePosition;
import jalis.util.Funcoes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResultMensagem {
    private String sid;
    private TubePosition tubePosition;
    private Date aspirationDate;
    private Especies especie;
    private String abbreviatedSpeciesName;
    private Map<Integer, ChemistryResult> chemistryNumberResults;

    public ResultMensagem(String data) {
        int i = 0;
        this.sid = data.substring(++i, i += 14).trim();
        i += 7;
        this.especie = Especies.getEspeciesByCodigo(data.substring(i += 6, i += 4));
        this.abbreviatedSpeciesName = data.substring(i, i += 13).trim();
        this.aspirationDate = Funcoes.getData("MM/dd/yy HH:mm:ss", data.substring(++i, i += 17));
        this.chemistryNumberResults = new HashMap<Integer, ChemistryResult>();
        int iResultEnd = data.indexOf(AbstractInterfaceamento.LINE, i += 5);
        while (i < iResultEnd) {
            int chemistryNumber = Integer.parseInt(data.substring(i, i += 3).trim());
            String result = data.substring(i, i += 5);
            String flag = data.substring(i++, i);
            ChemistryResult chemistryResult = new ChemistryResult(result, flag);
            if (data.charAt(i) == '|') {
                int iFlagIni = ++i;
                int iFlagFim = data.indexOf(124, i);
                String sampleFlags = data.substring(iFlagIni, iFlagFim);
                for (String sampleFlag : sampleFlags.split(" ")) {
                    chemistryResult.addSampleFlag(sampleFlag);
                }
                i = iFlagFim + 1;
            }
            this.chemistryNumberResults.put(chemistryNumber, chemistryResult);
        }
    }

    public String getSid() {
        return this.sid;
    }

    public TubePosition getTubePosition() {
        return this.tubePosition;
    }

    public Date getAspirationDate() {
        return this.aspirationDate;
    }

    public ChemistryResult getChemistryResult(int chemistryNumber) {
        return this.chemistryNumberResults.get(chemistryNumber);
    }

    public Set<Integer> getChemistryNumbers() {
        return this.chemistryNumberResults.keySet();
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + "[sid: " + this.sid + "; chemistryNumberResults: " + this.chemistryNumberResults + "]";
        return string;
    }
}

