/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.advia120;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.advia120.Constantes;
import jalis.laboratorio.interfaceamento.interfaces.advia120.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.ChemistryResult;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.Tipos;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.envio.InitializationMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.envio.NoOrderMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.envio.ResultValidation;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.envio.TokenTransferMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.envio.WorkOrderMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.recebimento.QueryMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.recebimento.ResultMensagem;
import jalis.laboratorio.interfaceamento.interfaces.advia120.mensagens.recebimento.WorkOrderValidationMensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private final int MAX_TENTATIVAS_ENVIO = 2;
    private final int INTERVALO_TENTATIVA_INICIALIZACAO = 5;
    private final int TIME_OUT = 20;
    private char mt;
    private boolean aguardandoMt = false;
    private int connectionId = 0;
    private boolean master = true;
    private IMensagemEnvio ultimaMensagemEnviada;
    private int tentativasEnvio = 0;
    private Timer timerInicializacao;
    private Timer timerTimeOut;
    private Map<String, InfoExameRequisicao> exameRequisicaoPorSid;
    private String diretorioFtp;
    private String diretorioImagensNoFtp;
    private ThreadResultMensagem threadResultMensagem;
    private final TravaFechamento travaProcessandoResultados;

    public InterfaceListener() {
        this.carregaConfiguracoes();
        this.exameRequisicaoPorSid = new HashMap<String, InfoExameRequisicao>();
        this.travaProcessandoResultados = new TravaFechamento("Os resultados est\u00e3o sendo processados");
        this.timerInicializacao = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceListener.this.inicia();
            }
        });
        this.timerInicializacao.setInitialDelay(0);
        this.timerInicializacao.start();
        this.timerTimeOut = new Timer(20000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceListener.this.reinicia();
            }
        });
    }

    private void carregaConfiguracoes() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.diretorioFtp = configuracao.getDiretorioFtp().trim();
        this.diretorioImagensNoFtp = configuracao.getDiretorioImagensNoFtp().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                for (String exame : exames.split(" ")) {
                    int sitAtual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recCodigo);
                    int novaSit = sitAtual < 2 ? 1 : 3;
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, novaSit);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private void alteraSituacaoParaPendentes(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = exameRequisicao.getFilial();
                String req_codigo = exameRequisicao.getCodigo();
                String mco_codigo = exameRequisicao.getMaterial();
                int atual = BDUtil.getExmSituacao(fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = exameRequisicao.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo, atual < 2 ? 1 : 3);
                if (atual >= 2 && BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame, mco_codigo)) {
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo, atual < 2 ? 1 : 3);
                }
                this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        if (c == '\u0015') {
            this.restartTimeOut();
            this.mtRecebido(c);
        }
    }

    @Override
    public String parse(String message) {
        BaseRecebimento mensagem = new BaseRecebimento(message);
        this.mensagemRecebida(mensagem);
        return null;
    }

    @Override
    public void dataChanged() {
        String mensagemString = this.getPortaCOM().getInputString();
        if (mensagemString != null && !mensagemString.isEmpty()) {
            this.restartTimeOut();
            if (this.aguardandoMt) {
                this.mtRecebido(mensagemString.charAt(0));
                this.getPortaCOM().clearInputString();
            } else if (mensagemString.startsWith(this.getMsgStart()) && mensagemString.endsWith(this.getMsgEnd())) {
                BaseRecebimento mensagem = new BaseRecebimento(mensagemString);
                this.getPortaCOM().clearInputString();
                try {
                    this.nextMt();
                    if (mensagem.getMt() == this.mt) {
                        if (mensagem.isLrcValido()) {
                            this.getPortaCOM().write(String.valueOf(this.mt));
                            this.mensagemRecebida(mensagem);
                        } else {
                            this.getPortaCOM().write(String.valueOf('\u0015'));
                            this.fireExcecaoEncontrada("LRC inv\u00e1lido (" + mensagem + ")");
                        }
                    } else {
                        this.fireExcecaoEncontrada("Mensagem com MT fora de sequ\u00eancia (" + mensagem + ")");
                        this.reinicia();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
                }
            }
        }
    }

    private void mtRecebido(char mt) {
        if (this.ultimaMensagemEnviada != null) {
            if (mt == this.ultimaMensagemEnviada.getMt()) {
                this.aguardandoMt = false;
                this.tentativasEnvio = 0;
                this.mensagemEnviadaConfirmada(this.ultimaMensagemEnviada);
            } else if (mt == '\u0015') {
                if (this.tentativasEnvio <= 2) {
                    this.enviaMensagem(this.ultimaMensagemEnviada);
                } else {
                    String msg = "Esgotado o n\u00famero m\u00e1ximo de tentativas de envio (" + this.ultimaMensagemEnviada + ")";
                    this.fireExcecaoEncontrada(msg);
                    this.reinicia();
                }
            } else {
                String msg = "Confirma\u00e7\u00e3o de MT enviado pelo aparelho \u00e9 diferente do MT da \u00faltima mensagem enviada (" + this.ultimaMensagemEnviada + ")";
                this.fireExcecaoEncontrada(msg);
                this.reinicia();
            }
        }
    }

    private void mensagemRecebida(BaseRecebimento baseMensagem) {
        switch (baseMensagem.getTipo()) {
            case RESULT: {
                this.resultMensagemRecebida(new ResultMensagem(baseMensagem.getData()));
                break;
            }
            case WORK_ORDER_VALIDATION: {
                this.workOrderValidationMensagemRecebida(new WorkOrderValidationMensagem(baseMensagem.getData()));
                break;
            }
            case TOKEN_TRANSFER: {
                this.tokenTranferMensagemRecebida();
                break;
            }
            case QUERY: {
                this.queryMensagemRecebida(new QueryMensagem(baseMensagem.getData()));
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void mensagemEnviadaConfirmada(IMensagemEnvio mensagem) {
        switch (mensagem.getTipo()) {
            case INITIALIZATION: {
                this.initializationMensagemConfirmada();
                break;
            }
            case RESULT_VALIDATION: {
                this.resultValidationMensagemConfirmada((ResultValidation)mensagem);
                break;
            }
            case TOKEN_TRANSFER: {
                this.tokenTranferMensagemConfirmada();
                break;
            }
            case WORK_ORDER: {
                this.workOrderMensagemConfirmada();
                break;
            }
            case NO_ORDER: {
                this.noOrderMensagemConfirmada();
            }
        }
    }

    private void enviaMensagem(IMensagemEnvio mensagem) {
        try {
            this.ultimaMensagemEnviada = mensagem;
            this.aguardandoMt = true;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(mensagem.getTextoMensagem(this.nextMt()));
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    private void inicia() {
        this.zeraMt();
        this.enviaMensagem(new InitializationMensagem(this.connectionId, this.diretorioImagensNoFtp));
        this.fireMensagemEnviada("Pedido de inicializa\u00e7\u00e3o enviado", 0, 10000);
    }

    private void reinicia() {
        this.zeraMt();
        this.aguardandoMt = false;
        this.ultimaMensagemEnviada = null;
        this.tentativasEnvio = 0;
        this.master = true;
        this.nextConnectionId();
        this.getPortaCOM().clearInputString();
        this.timerTimeOut.stop();
        this.timerInicializacao.start();
    }

    private void restartTimeOut() {
        this.timerTimeOut.restart();
    }

    private char nextMt() {
        this.mt = (char)(this.mt + '\u0001');
        if (this.mt > 'Z') {
            this.zeraMt();
        }
        return this.mt;
    }

    private char zeraMt() {
        this.mt = (char)48;
        return this.mt;
    }

    private int nextConnectionId() {
        ++this.connectionId;
        if (this.connectionId > 999) {
            this.connectionId = 0;
        }
        return this.connectionId;
    }

    private String getImagem64(File diretorio, int connectionId, String imageId) {
        String connectionIdString = String.valueOf(connectionId);
        connectionIdString = StringUtil.preencheString(connectionIdString, 3, '0', 1);
        imageId = StringUtil.preencheString(imageId, 4, '0', 1);
        File imageFile = new File(diretorio, "w" + connectionIdString + imageId + ".bmp");
        if (imageFile != null) {
            for (int count = 0; !imageFile.getAbsoluteFile().exists() && count < 10; ++count) {
                try {
                    Thread.sleep(1000L);
                    imageFile = new File(diretorio, "w" + connectionIdString + imageId + ".bmp");
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                BufferedImage image = ImageIO.read(imageFile);
                ImageIcon ib = new ImageIcon(image);
                return new Base64().encodeAsString(ImagemUtils.imageToByte(ib.getImage()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initializationMensagemConfirmada() {
        this.timerInicializacao.stop();
        this.fireMensagemEnviada("Comunica\u00e7\u00e3o iniciada", 0, 10000);
        this.timerTimeOut.start();
        this.enviaMensagem(new TokenTransferMensagem());
    }

    private void resultValidationMensagemConfirmada(ResultValidation resultValidation) {
        switch (resultValidation.getFlag()) {
            case NOT_ACCEPT_AND_HOST_IS_MASTER: 
            case VALID_AND_HOST_IS_MASTER: {
                this.master = true;
                this.enviaMensagem(new TokenTransferMensagem());
                break;
            }
        }
    }

    private void tokenTranferMensagemConfirmada() {
        this.master = false;
    }

    private void workOrderMensagemConfirmada() {
    }

    private void noOrderMensagemConfirmada() {
    }

    private void resultMensagemRecebida(ResultMensagem mensagem) {
        ResultValidation.Flags flagResultado = ResultValidation.Flags.VALID_AND_SEND_NEXT;
        try {
            if (this.threadResultMensagem != null && this.threadResultMensagem.isAlive()) {
                this.threadResultMensagem.add(mensagem);
            } else {
                this.threadResultMensagem = new ThreadResultMensagem();
                this.threadResultMensagem.add(mensagem);
                this.threadResultMensagem.start();
            }
        }
        catch (Exception e) {
            flagResultado = ResultValidation.Flags.NOT_ACCEPT_AND_HOST_IS_MASTER;
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
        this.enviaMensagem(new ResultValidation(flagResultado));
    }

    private void salvaResultMensagem(ResultMensagem mensagem) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String sid = mensagem.getSid();
            if (!sid.isEmpty() && sid.length() >= digitosCodigoTubo && Funcoes.isNumeric(sid)) {
                Statement st = Conexao.getStatement();
                String tuboId = sid.substring(14 - digitosCodigoTubo);
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                List<String> groups = this.getGroups(mensagem.getChemistryNumbers());
                if (groups.isEmpty()) {
                    this.fireExcecaoEncontrada("Nenhum grupo encontrado para a requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                } else {
                    Iterator<String> iterator = groups.iterator();
                    while (iterator.hasNext()) {
                        String group;
                        String emiAlternativo = group = iterator.next();
                        Set<Integer> chemistryNumbersDoGrupo = Constantes.getChemistryNumbersByGroup().get(group);
                        chemistryNumbersDoGrupo.add(250);
                        String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                        ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                        if (exame == null) continue;
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        for (int chemistryNumber : chemistryNumbersDoGrupo) {
                            ChemistryResult result = mensagem.getChemistryResult(chemistryNumber);
                            String resultado = "";
                            if (chemistryNumber == 250) {
                                if (result == null || Funcoes.textoVazio(result.getResult())) continue;
                                File diretorio = new File(this.diretorioFtp, this.diretorioImagensNoFtp);
                                resultado = this.getImagem64(diretorio, this.connectionId, result.getResult().trim());
                                String campo = Constantes.getExamesByChemistryNumber().get(chemistryNumber);
                                dados.put(campo, resultado);
                                continue;
                            }
                            if (result == null || result.getResult() == null) continue;
                            resultado = result.getResult().replace('.', ',').trim();
                            if (Constantes.getFlagsByChemistryNumber().containsKey(chemistryNumber)) {
                                if (result.getResult().trim().isEmpty()) continue;
                                String flagDescr = Constantes.getFlagsByChemistryNumber().get(chemistryNumber);
                                flags.add(flagDescr + ": " + resultado);
                                continue;
                            }
                            String campo = Constantes.getExamesByChemistryNumber().get(chemistryNumber);
                            if (campo == null || campo.trim().isEmpty()) continue;
                            dados.put(campo, resultado);
                        }
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                    }
                    Conexao.arquivaSQL();
                    this.fireAtualizarTabela();
                }
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
    }

    private List<String> getGroups(Collection<Integer> chemistryNumbers) {
        ArrayList<String> groups = new ArrayList<String>();
        if (chemistryNumbers.contains(2)) {
            groups.add("CBC");
            if (chemistryNumbers.contains(20)) {
                groups.add("CBC-DIF");
                if (chemistryNumbers.contains(911)) {
                    groups.add("CBC-DIF-RET");
                }
            }
        }
        if (chemistryNumbers.contains(20)) {
            groups.add("DIF");
        }
        if (chemistryNumbers.contains(911)) {
            groups.add("RETIC");
        }
        return groups;
    }

    private int getSituacao(String filCodigo, String intCodigo, String reqCodigo, String recCodigo, ExameMaterial exame) throws SQLException {
        int sit = -1;
        if (BDUtil.existeDesmembramento(filCodigo, intCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
            ExameMaterial[] examesPais;
            for (ExameMaterial examePai : examesPais = BDUtil.getDesmExamesPai(filCodigo, intCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                sit = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, examePai.getNomeExame(), examePai.getCodigoMaterial(), recCodigo, exame.getNomeExame(), exame.getCodigoMaterial());
            }
        } else {
            sit = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
        }
        return sit;
    }

    private void workOrderValidationMensagemRecebida(WorkOrderValidationMensagem mensagem) {
        if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada.getTipo() == Tipos.WORK_ORDER) {
            WorkOrderMensagem workOrderMensagem = (WorkOrderMensagem)this.ultimaMensagemEnviada;
            switch (mensagem.getFlag()) {
                case VALID: {
                    this.alteraSituacaoParaPendentes(this.exameRequisicaoPorSid.get(workOrderMensagem.getSid()));
                    this.exameRequisicaoPorSid.remove(workOrderMensagem.getSid());
                    break;
                }
                case INVALID_CHEMISTRY_NUMBER: {
                    String msg = "A seguinte ordem de trabalho cont\u00e9m exames com c\u00f3digos alternativos inv\u00e1lidos: " + workOrderMensagem;
                    this.fireExcecaoEncontrada(msg);
                }
            }
        } else {
            String msg = "WorkOrderValidationMensagem recebida, por\u00e9m a \u00faltima mensagem enviada n\u00e3o \u00e9 um WorkOrder (" + this.ultimaMensagemEnviada + ")";
            this.fireExcecaoEncontrada(msg);
            this.reinicia();
        }
    }

    private void tokenTranferMensagemRecebida() {
        this.master = true;
        this.enviaMensagem(new TokenTransferMensagem());
    }

    private void queryMensagemRecebida(QueryMensagem mensagem) {
        block19: {
            try {
                String sid = mensagem.getSid();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (digitosCodigoTubo > 14) {
                    this.enviaMensagem(new NoOrderMensagem(sid));
                    throw new Exception("O equipamento n\u00e3o suporta a identifica\u00e7\u00e3o do tubo com mais de 14 d\u00edgitos");
                }
                if (sid.isEmpty() || !Funcoes.isNumeric(sid)) {
                    this.enviaMensagem(new NoOrderMensagem(sid));
                    break block19;
                }
                String tuboId = sid.substring(14 - digitosCodigoTubo);
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req == null) {
                    req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                    aba = this.equipamento.getTab(1);
                }
                if (req == null) {
                    req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                    aba = this.equipamento.getTab(2);
                }
                if (req == null) {
                    this.enviaMensagem(new NoOrderMensagem(sid));
                    return;
                }
                String exames = (String)req[aba.getColIndice("Exame")];
                String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                String intCodigo = (String)req[aba.getColIndice("Interface")];
                String pacNome = (String)req[aba.getColIndice("Paciente")];
                String pacIdade = (String)req[aba.getColIndice("Ide")];
                String pacSexo = (String)req[aba.getColIndice("S")];
                String data = TempoUtil.getCurrentDateBr();
                String hora = TempoUtil.getCurrentTime();
                Statement st = Conexao.getStatement();
                String sql = "select b.pac_codigo, b.pac_datanasc from requisicao a left join paciente b on b.pac_codigo = a.pac_codigo and b.fil_codigo = a.fil_codigo where a.fil_codigo = " + filCodigo + " and req_codigo = " + reqCodigo;
                ResultSet rs = st.executeQuery(sql);
                rs.next();
                String pacCodigo = rs.getString("pac_codigo");
                Date pacNascimento = rs.getDate("pac_datanasc");
                ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                for (String string : exames.split(" ", 0)) {
                    examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                }
                java.util.Date dataColeta = null;
                ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                for (ExameMaterial exameMaterial : examesDaRequisicao) {
                    if (dataColeta == null) {
                        dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                    }
                    int n = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                        List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                        if (n == 0 || n == 1) {
                            examesParaEnviar.addAll(examesFilhos);
                            continue;
                        }
                        for (ExameMaterial exameFilho : examesFilhos) {
                            int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            if (sitFilho != 3) continue;
                            examesParaEnviar.add(exameFilho);
                        }
                        continue;
                    }
                    if (n != 0 && n != 1 && n != 3) continue;
                    examesParaEnviar.add(exameMaterial);
                }
                HashSet<Integer> chemistryNumbers = new HashSet<Integer>();
                for (ExameMaterial exameMaterial : examesParaEnviar) {
                    String group = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                    if (group != null && !group.trim().isEmpty() && Constantes.getChemistryNumbersByGroup().containsKey(group)) {
                        Iterator<Object> iterator = Constantes.getChemistryNumbersByGroup().get(group).iterator();
                        while (iterator.hasNext()) {
                            int chemistryNumber = (Integer)iterator.next();
                            chemistryNumbers.add(chemistryNumber);
                        }
                        continue;
                    }
                    this.fireExcecaoEncontrada(tuboId + " - Exame " + exameMaterial.getNomeExame() + " com c\u00f3digo alternativo incorreto ou n\u00e3o configurado");
                    return;
                }
                if (chemistryNumbers.isEmpty()) {
                    this.enviaMensagem(new NoOrderMensagem(sid));
                    this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                } else {
                    this.exameRequisicaoPorSid.put(sid, new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames));
                    WorkOrderMensagem workOrderMensagem = new WorkOrderMensagem(sid);
                    workOrderMensagem.setUpdateIndicator(WorkOrderMensagem.UpdateIndicators.NO_UPDATE);
                    workOrderMensagem.setPacienteNome(StringUtil.removerAcentos(pacNome));
                    workOrderMensagem.setPacienteSexo(pacSexo.equalsIgnoreCase("M") ? WorkOrderMensagem.Sexos.MASCULINO : WorkOrderMensagem.Sexos.FEMININO);
                    workOrderMensagem.setPacienteId(pacCodigo);
                    workOrderMensagem.setPacienteNascimento(pacNascimento);
                    workOrderMensagem.setColeta(dataColeta);
                    Iterator iterator = chemistryNumbers.iterator();
                    while (iterator.hasNext()) {
                        int chemistryNumber = (Integer)iterator.next();
                        workOrderMensagem.addChemistryNumber(chemistryNumber);
                    }
                    this.enviaMensagem(workOrderMensagem);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    protected void encerrar() {
        this.timerInicializacao.stop();
        this.timerTimeOut.stop();
        this.threadResultMensagem = null;
        super.encerrar();
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String req = "010001554201";
        buf.append("[STX]7R[SP]00" + req + "[SP]001-02[SP][SP][SP][SP][SP][SP][SP][SP][SP]0Human[SP][SP][SP][SP][SP][SP][SP][SP][SP]05/25/16[SP]08:25:15[SP][SP][SP][LINE]");
        buf.append("[SP][SP]1[SP]8.13[SP][SP][SP]2[SP]5.10[SP][SP][SP]3[SP]15.8[SP][SP][SP]4[SP]48.5[SP][SP][SP]5[SP]95.1[SP][SP][SP]6[SP]30.9[SP][SP][SP]7[SP]32.5[SP][SP]51[SP]32.8[SP][SP]72[SP]31.0[SP][SP][SP]8[SP]14.1[SP][SP][SP]9[SP]2.75[SP][SP]10[SP][SP]170[SP][SP]11[SP][SP]7.9[SP][SP]20[SP]50.7[SP][SP]21[SP]33.5[SP][SP]22[SP][SP]5.4[SP][SP]23[SP][SP]7.3[SP][SP]24[SP][SP]1.1[SP][SP]25[SP][SP]1.9[SP][SP]14[SP]4.12[SP][SP]15[SP]2.72[SP][SP]16[SP]0.44[SP][SP]17[SP]0.59[SP][SP]18[SP]0.09[SP][SP]19[SP]0.15[SP][SP]50[SP]8.09[SP][SP]52[SP]8.13[SP]19161.69[SP]19275.40[SP][SP]83[SP]42.5[SP][SP]84[SP]20.3[SP][SP]38[SP][SP][SP][SP]+[SP][SP]12[SP]50.6[SP][SP]13[SP]0.13[SP][SP]26[SP]1.93[SP][SP]27[SP]-2.4[SP][SP]73[SP]3.82[SP][LINE]");
        buf.append("[SOH][ETX]");
        this.parse(TestesInterface.arruma(buf.toString()));
    }

    private class ThreadResultMensagem
    extends Thread {
        private Queue<ResultMensagem> results = new LinkedList<ResultMensagem>();

        public void add(ResultMensagem mensagem) {
            this.results.add(mensagem);
        }

        @Override
        public void run() {
            InterfaceListener.this.addTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
            while (!this.results.isEmpty()) {
                InterfaceListener.this.salvaResultMensagem(this.results.remove());
                try {
                    ThreadResultMensagem.sleep(500L);
                }
                catch (Exception exception) {}
            }
            InterfaceListener.this.removeTravaFechamento(InterfaceListener.this.travaProcessandoResultados);
        }
    }
}

